/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AnsiCast;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.datasources.DataSourceAnalysis$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00114AAC\u0006\u0001-!)\u0011\u0006\u0001C\u0001U!IQ\u0006\u0001a\u0001\u0002\u0004%IA\f\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011b\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u0018\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%9\u0006\u00011A\u0001B\u0003&a\nC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003[\u0001\u0011%1LA\fECR\f7k\\;sG\u0016\fe.\u00197zg&\u001c8+^5uK*\u0011A\"D\u0001\bg>,(oY3t\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\u0011\u0001qcG\u0011\u0011\u0005aIR\"A\b\n\u0005iy!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f'\u0005I1oY1mCR,7\u000f^\u0005\u0003Au\u0011\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m!\t\u0011s%D\u0001$\u0015\t!S%A\u0003qY\u0006t7O\u0003\u0002'\u001b\u0005A1-\u0019;bYf\u001cH/\u0003\u0002)G\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"\u0001\f\u0001\u000e\u0003-\t\u0001\u0003^1sO\u0016$\u0018\t\u001e;sS\n,H/Z:\u0016\u0003=\u00022\u0001\r\u001e>\u001d\t\ttG\u0004\u00023k5\t1G\u0003\u00025+\u00051AH]8pizJ\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qe\nq\u0001]1dW\u0006<WMC\u00017\u0013\tYDHA\u0002TKFT!\u0001O\u001d\u0011\u0005y\nU\"A \u000b\u0005\u0001+\u0013aC3yaJ,7o]5p]NL!AQ \u0003\u0013\u0005#HO]5ckR,\u0017\u0001\u0006;be\u001e,G/\u0011;ue&\u0014W\u000f^3t?\u0012*\u0017\u000f\u0006\u0002F\u0013B\u0011aiR\u0007\u0002s%\u0011\u0001*\u000f\u0002\u0005+:LG\u000fC\u0004K\u0007\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0013'A\tuCJ<W\r^!uiJL'-\u001e;fg\u0002\nQ\u0003^1sO\u0016$\b+\u0019:uSRLwN\\*dQ\u0016l\u0017-F\u0001O!\ty%+D\u0001Q\u0015\t\tV\"A\u0003usB,7/\u0003\u0002T!\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u00023Q\f'oZ3u!\u0006\u0014H/\u001b;j_:\u001c6\r[3nC~#S-\u001d\u000b\u0003\u000bZCqA\u0013\u0004\u0002\u0002\u0003\u0007a*\u0001\fuCJ<W\r\u001e)beRLG/[8o'\u000eDW-\\1!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001F\u0003A\u0019\u0007.Z2l!J|'.Z2u\u0019&\u001cH\u000fF\u0002F9\nDQ!X\u0005A\u0002y\u000ba!Y2uk\u0006d\u0007c\u0001\u0019;?B\u0011a\bY\u0005\u0003C~\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015\u0019\u0017\u00021\u0001_\u0003!)\u0007\u0010]3di\u0016$\u0007")
public class DataSourceAnalysisSuite
extends SparkFunSuite
implements SQLHelper {
    private Seq<Attribute> targetAttributes;
    private StructType targetPartitionSchema;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        DataSourceAnalysisSuite dataSourceAnalysisSuite = this;
        synchronized (dataSourceAnalysisSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Seq<Attribute> targetAttributes() {
        return this.targetAttributes;
    }

    private void targetAttributes_$eq(Seq<Attribute> x$1) {
        this.targetAttributes = x$1;
    }

    private StructType targetPartitionSchema() {
        return this.targetPartitionSchema;
    }

    private void targetPartitionSchema_$eq(StructType x$1) {
        this.targetPartitionSchema = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.targetAttributes_$eq((Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))));
        this.targetPartitionSchema_$eq(new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$));
    }

    private void checkProjectList(Seq<Expression> actual, Seq<Expression> expected) {
        Seq withoutAliases = (Seq)actual.map((Function1 & Serializable)x0$1 -> {
            Expression expression;
            Expression expression2 = x0$1;
            if (expression2 instanceof Alias) {
                Alias alias = (Alias)expression2;
                expression = alias.child();
            } else {
                expression = expression2;
            }
            return expression;
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(withoutAliases);
        Seq<Expression> $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    private final void testRule$1(String testName, boolean caseSensitive, Function0 func) {
        this.test(new StringBuilder(18).append(testName).append(" (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)func), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }

    private static final Expression cast$1(Expression e, DataType dt) {
        boolean bl;
        Enumeration.Value value = SQLConf$.MODULE$.get().storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        Object object = bl ? new AnsiCast(e, dt, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone())) : new Cast(e, dt, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
        return object;
    }

    public static final /* synthetic */ void $anonfun$new$1(DataSourceAnalysisSuite $this, boolean caseSensitive) {
        DataSourceAnalysis$ rule = DataSourceAnalysis$.MODULE$;
        $this.testRule$1("convertStaticPartitions only handle INSERT having at least static partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75)));
        $this.testRule$1("Missing columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
        $this.testRule$1("Missing partitioning columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        });
        $this.testRule$1("Wrong partitioning columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                if (!caseSensitive) break block0;
                $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }
        });
        $this.testRule$1("Static partitions need to appear before dynamic partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.intercept((Function0 & Serializable)() -> rule.convertStaticPartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157)));
        $this.testRule$1("All static partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (!caseSensitive) {
                Seq nonPartitionedAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
                Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$)})));
                Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
                $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            }
            Seq nonPartitionedAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$)})));
            Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            Seq nonPartitionedAttributes2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected2 = (Seq)nonPartitionedAttributes2.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$)})));
            Seq actual2 = rule.convertStaticPartitions(nonPartitionedAttributes2, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()})), new StructType().add("b", (DataType)IntegerType$.MODULE$));
            $this.checkProjectList((Seq<Expression>)actual2, (Seq<Expression>)expected2);
        });
        $this.testRule$1("Static partition and dynamic partition", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq nonPartitionedAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq dynamicPartitionAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()}));
            Seq expected = (Seq)((IterableOps)nonPartitionedAttributes.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$)})))).$plus$plus((IterableOnce)dynamicPartitionAttributes);
            Seq actual = rule.convertStaticPartitions((Seq)nonPartitionedAttributes.$plus$plus((IterableOnce)dynamicPartitionAttributes), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
        });
    }

    public DataSourceAnalysisSuite() {
        SQLHelper.$init$((SQLHelper)this);
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)caseSensitive -> {
            DataSourceAnalysisSuite.$anonfun$new$1(this, BoxesRunTime.unboxToBoolean((Object)caseSensitive));
            return BoxedUnit.UNIT;
        });
    }
}

