/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Q3q!\u0002\u0004\u0011\u0002\u0007\u00051\u0003C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003'\u0001\u0019\u0005q\u0005C\u00034\u0001\u0011\u0005A\u0007C\u0003C\u0001\u0011\u00051I\u0001\fDQ\u0006\u0014h+\u0019:dQ\u0006\u0014H\t\u0012'UKN$()Y:f\u0015\t9\u0001\"A\u0004d_6l\u0017M\u001c3\u000b\u0005%Q\u0011!C3yK\u000e,H/[8o\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0003\u0007\t\u0003+Yi\u0011AC\u0005\u0003/)\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mQ\u0011\u0001\u0002;fgRL!!\b\u000e\u0003\u0019M\u000bF\nV3tiV#\u0018\u000e\\:\u0002\r\u0011Jg.\u001b;%)\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSR\faAZ8s[\u0006$X#\u0001\u0015\u0011\u0005%\u0002dB\u0001\u0016/!\tY#%D\u0001-\u0015\ti##\u0001\u0004=e>|GOP\u0005\u0003_\t\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qFI\u0001\rG\",7m[\"pYRK\b/\u001a\u000b\u0004AUj\u0004\"\u0002\u001c\u0004\u0001\u00049\u0014!\u00014\u0011\u0005aZT\"A\u001d\u000b\u0005iR\u0011!\u0002;za\u0016\u001c\u0018B\u0001\u001f:\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000by\u001a\u0001\u0019A \u0002\u0005\u0011$\bC\u0001\u001dA\u0013\t\t\u0015H\u0001\u0005ECR\fG+\u001f9f\u0003]\u0019\u0007.Z2l)\u0006\u0014G.Z*dQ\u0016l\u0017\rV=qKN#(\u000fF\u0002!\t\u001aCQ!\u0012\u0003A\u0002!\nQ\u0001^1cY\u0016DQa\u0012\u0003A\u0002!\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0004\u0013:\u000bfB\u0001&M\u001d\tY3*C\u0001$\u0013\ti%%A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&aA*fc*\u0011QJ\t\t\u0003+IK!a\u0015\u0006\u0003\u0007I{w\u000f")
public interface CharVarcharDDLTestBase
extends SQLTestUtils {
    public String format();

    public static /* synthetic */ void checkColType$(CharVarcharDDLTestBase $this, StructField f, DataType dt) {
        $this.checkColType(f, dt);
    }

    default public void checkColType(StructField f, DataType dt) {
        DataType $org_scalatest_assert_macro_left = f.dataType();
        DataType $org_scalatest_assert_macro_right = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dt);
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        Option $org_scalatest_assert_macro_left2 = CharVarcharUtils$.MODULE$.getRawType(f.metadata());
        DataType $org_scalatest_assert_macro_right2 = dt;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    public static /* synthetic */ void checkTableSchemaTypeStr$(CharVarcharDDLTestBase $this, String table, Seq expected) {
        $this.checkTableSchemaTypeStr(table, (Seq<Row>)expected);
    }

    default public void checkTableSchemaTypeStr(String table, Seq<Row> expected) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)this.sql().apply((Object)new StringBuilder(5).append("desc ").append(table).toString())).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("data_type like '%char%'"), expected);
    }

    public static void $init$(CharVarcharDDLTestBase $this) {
        $this.test("allow to change column for char(x) to char(y), x == y", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(i STRING, c CHAR(4)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN c TYPE CHAR(4)");
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new CharType(4));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        $this.test("not allow to change column for char(x) to char(y), x != y", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(i STRING, c CHAR(4)) USING ").append($this.format()).toString());
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN c TYPE CHAR(5)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            boolean v1 = e.getMessage().contains("'CharType(4)' to 'c' with type 'CharType(5)'");
            boolean v2 = e.getMessage().contains("char(4) cannot be cast to char(5)");
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(v1, "v1", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(v2, "v2", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        $this.test("not allow to change column from string to char type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE t(i STRING, c STRING) USING ").append($this.format()).toString());
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN c TYPE CHAR(5)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            boolean v1 = e.getMessage().contains("'StringType' to 'c' with type 'CharType(5)'");
            boolean v2 = e.getMessage().contains("string cannot be cast to char(5)");
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(v1, "v1", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(v2, "v2", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        $this.test("not allow to change column from int to char type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(39).append("CREATE TABLE t(i int, c CHAR(4)) USING ").append($this.format()).toString());
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN i TYPE CHAR(5)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            boolean v1 = e.getMessage().contains("'IntegerType' to 'i' with type 'CharType(5)'");
            boolean v2 = e.getMessage().contains("int cannot be cast to char(5)");
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(v1, "v1", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(v2, "v2", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        $this.test("allow to change column for varchar(x) to varchar(y), x == y", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE t(i STRING, c VARCHAR(4)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN c TYPE VARCHAR(4)");
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new VarcharType(4));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        $this.test("not allow to change column for varchar(x) to varchar(y), x > y", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE t(i STRING, c VARCHAR(4)) USING ").append($this.format()).toString());
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t CHANGE COLUMN c TYPE VARCHAR(3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            boolean v1 = e.getMessage().contains("'VarcharType(4)' to 'c' with type 'VarcharType(3)'");
            boolean v2 = e.getMessage().contains("varchar(4) cannot be cast to varchar(3)");
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(v1, "v1", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(v2, "v2", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        $this.test("SPARK-33901: alter table add columns should not change original table's schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(i CHAR(5), c VARCHAR(4)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"ALTER TABLE t ADD COLUMNS (d VARCHAR(5))");
            $this.checkTableSchemaTypeStr("t", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(4)"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(5)"}))}))));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        $this.test("SPARK-33901: ctas should should not change table's schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE t1(i CHAR(5), c VARCHAR(4)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t2 USING ").append($this.format()).append(" AS SELECT * FROM t1").toString());
            $this.checkTableSchemaTypeStr("t2", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(4)"}))}))));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        $this.test("SPARK-37160: CREATE TABLE with CHAR_AS_VARCHAR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CHAR_AS_VARCHAR().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(34).append("CREATE TABLE t(col CHAR(5)) USING ").append($this.format()).toString());
            $this.checkTableSchemaTypeStr("t", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(5)"}))}))));
        })), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        $this.test("SPARK-37160: CREATE TABLE AS SELECT with CHAR_AS_VARCHAR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t1(col CHAR(5)) USING ").append($this.format()).toString());
            $this.checkTableSchemaTypeStr("t1", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"}))}))));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CHAR_AS_VARCHAR().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t2 USING ").append($this.format()).append(" AS SELECT * FROM t1").toString());
                $this.checkTableSchemaTypeStr("t2", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(5)"}))}))));
            });
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        $this.test("SPARK-37160: ALTER TABLE ADD COLUMN with CHAR_AS_VARCHAR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(34).append("CREATE TABLE t(col CHAR(5)) USING ").append($this.format()).toString());
            $this.checkTableSchemaTypeStr("t", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"}))}))));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CHAR_AS_VARCHAR().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"ALTER TABLE t ADD COLUMN c2 CHAR(10)");
                $this.checkTableSchemaTypeStr("t", (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(10)"}))}))));
            });
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        $this.test("SPARK-33892: DESCRIBE COLUMN w/ char/varchar", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t v")).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"info_value"})).where("info_value like '%char%'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(3)"})));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t c")).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"info_value"})).where("info_value like '%char%'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        $this.test("SPARK-33892: SHOW CREATE TABLE w/ char/varchar", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String rest;
            $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            String $org_scalatest_assert_macro_left = rest = ((Row)((Dataset)$this.sql().apply((Object)"SHOW CREATE TABLE t")).head()).getString(0);
            String $org_scalatest_assert_macro_right = "VARCHAR(3)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            String $org_scalatest_assert_macro_left2 = rest;
            String $org_scalatest_assert_macro_right2 = "CHAR(5)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }), new Position("CharVarcharDDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }
}

