/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.columnar.CachedBatch;
import org.apache.spark.sql.execution.columnar.DefaultCachedBatch;
import org.apache.spark.sql.execution.columnar.DefaultCachedBatchSerializer;
import org.apache.spark.sql.execution.columnar.RefCountedCachedBatch;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4AAB\u0004\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C!;!)\u0001\f\u0001C!3\")\u0001\r\u0001C!C\")Q\u000e\u0001C!]\n\u0019#+\u001a4D_VtG/\u001a3UKN$8)Y2iK\u0012\u0014\u0015\r^2i'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0005\n\u0003!\u0019w\u000e\\;n]\u0006\u0014(B\u0001\u0006\f\u0003%)\u00070Z2vi&|gN\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u000f%\u0011\u0001d\u0002\u0002\u001d\t\u00164\u0017-\u001e7u\u0007\u0006\u001c\u0007.\u001a3CCR\u001c\u0007nU3sS\u0006d\u0017N_3s\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0017\u0001\u0005y2m\u001c8wKJ$\u0018J\u001c;fe:\fGNU8x)>\u001c\u0015m\u00195fI\n\u000bGo\u00195\u0015\u000byI#\u0007\u0013)\u0011\u0007}\u0011C%D\u0001!\u0015\t\tS\"A\u0002sI\u0012L!a\t\u0011\u0003\u0007I#E\t\u0005\u0002&O5\taE\u0003\u0002\t\u0017%\u0011\u0001F\n\u0002\f\u0007\u0006\u001c\u0007.\u001a3CCR\u001c\u0007\u000eC\u0003+\u0005\u0001\u00071&A\u0003j]B,H\u000fE\u0002 E1\u0002\"!\f\u0019\u000e\u00039R!aL\u0006\u0002\u0011\r\fG/\u00197zgRL!!\r\u0018\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006g\t\u0001\r\u0001N\u0001\u0007g\u000eDW-\\1\u0011\u0007Uz$I\u0004\u00027y9\u0011qGO\u0007\u0002q)\u0011\u0011hE\u0001\u0007yI|w\u000e\u001e \n\u0003m\nQa]2bY\u0006L!!\u0010 \u0002\u000fA\f7m[1hK*\t1(\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005ur\u0004CA\"G\u001b\u0005!%BA#/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\u001d#%!C!uiJL'-\u001e;f\u0011\u0015I%\u00011\u0001K\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\tYe*D\u0001M\u0015\tiU\"A\u0004ti>\u0014\u0018mZ3\n\u0005=c%\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"B)\u0003\u0001\u0004\u0011\u0016\u0001B2p]\u001a\u0004\"a\u0015,\u000e\u0003QS!!V\u0006\u0002\u0011%tG/\u001a:oC2L!a\u0016+\u0003\u000fM\u000bFjQ8oM\u0006y2m\u001c8wKJ$8)Y2iK\u0012\u0014\u0015\r^2i)>Le\u000e^3s]\u0006d'k\\<\u0015\u000b-R6,X0\t\u000b)\u001a\u0001\u0019\u0001\u0010\t\u000bq\u001b\u0001\u0019\u0001\u001b\u0002\u001f\r\f7\r[3BiR\u0014\u0018NY;uKNDQAX\u0002A\u0002Q\n!c]3mK\u000e$X\rZ!uiJL'-\u001e;fg\")\u0011k\u0001a\u0001%\u000612/\u001e9q_J$8oQ8mk6t\u0017M](viB,H\u000f\u0006\u0002cMB\u00111\rZ\u0007\u0002}%\u0011QM\u0010\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019D\u00011\u0001h!\tA7.D\u0001j\u0015\tQ7\"A\u0003usB,7/\u0003\u0002mS\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002+M,\b\u000f]8siN\u001cu\u000e\\;n]\u0006\u0014\u0018J\u001c9viR\u0011!m\u001c\u0005\u0006g\u0015\u0001\r\u0001\u000e")
public class RefCountedTestCachedBatchSerializer
extends DefaultCachedBatchSerializer {
    public RDD<CachedBatch> convertInternalRowToCachedBatch(RDD<InternalRow> input, Seq<Attribute> schema, StorageLevel storageLevel, SQLConf conf) {
        int batchSize = conf.columnBatchSize();
        boolean useCompression = conf.useCompression();
        RDD cachedBatchRdd = this.convertForCacheInternal(input, schema, batchSize, useCompression);
        return cachedBatchRdd.mapPartitionsInternal((Function1 & Serializable)cachedBatchIter -> cachedBatchIter.map((Function1 & Serializable)cachedBatch -> {
            DefaultCachedBatch actualCachedBatch = (DefaultCachedBatch)cachedBatch;
            return new RefCountedCachedBatch(actualCachedBatch.numRows(), actualCachedBatch.stats(), 100L, (CachedBatch)cachedBatch);
        }), cachedBatchRdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(CachedBatch.class));
    }

    public RDD<InternalRow> convertCachedBatchToInternalRow(RDD<CachedBatch> input, Seq<Attribute> cacheAttributes, Seq<Attribute> selectedAttributes, SQLConf conf) {
        RDD actualCachedBatchIter = input.mapPartitionsInternal((Function1 & Serializable)cachedBatchIter -> cachedBatchIter.map((Function1 & Serializable)x$1 -> ((RefCountedCachedBatch)x$1).cachedBatch()), input.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(CachedBatch.class));
        return super.convertCachedBatchToInternalRow(actualCachedBatchIter, cacheAttributes, selectedAttributes, conf);
    }

    public boolean supportsColumnarOutput(StructType schema) {
        return false;
    }

    public boolean supportsColumnarInput(Seq<Attribute> schema) {
        return false;
    }
}

