/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.benchmark.UnsafeArrayDataBenchmark$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class UnsafeArrayDataBenchmark$
extends BenchmarkBase {
    public static final UnsafeArrayDataBenchmark$ MODULE$ = new UnsafeArrayDataBenchmark$();
    private static ExpressionEncoder<int[]> intEncoder;
    private static ExpressionEncoder<double[]> doubleEncoder;
    private static volatile byte bitmap$0;

    public int calculateHeaderPortionInBytes(int count) {
        return UnsafeArrayData.calculateHeaderPortionInBytes((int)count);
    }

    private ExpressionEncoder<int[]> intEncoder$lzycompute() {
        UnsafeArrayDataBenchmark$ unsafeArrayDataBenchmark$ = this;
        synchronized (unsafeArrayDataBenchmark$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1() {
                    }
                }
                ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1()));
                Seq x$1 = qual$1.resolveAndBind$default$1();
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                intEncoder = qual$1.resolveAndBind(x$1, x$2);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return intEncoder;
    }

    private ExpressionEncoder<int[]> intEncoder() {
        return (byte)(bitmap$0 & 1) == 0 ? this.intEncoder$lzycompute() : intEncoder;
    }

    private ExpressionEncoder<double[]> doubleEncoder$lzycompute() {
        UnsafeArrayDataBenchmark$ unsafeArrayDataBenchmark$ = this;
        synchronized (unsafeArrayDataBenchmark$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2() {
                    }
                }
                ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2()));
                Seq x$1 = qual$1.resolveAndBind$default$1();
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                doubleEncoder = qual$1.resolveAndBind(x$1, x$2);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return doubleEncoder;
    }

    private ExpressionEncoder<double[]> doubleEncoder() {
        return (byte)(bitmap$0 & 2) == 0 ? this.doubleEncoder$lzycompute() : doubleEncoder;
    }

    public void readUnsafeArray(int iters) {
        int count = 0x1000000;
        Random rand = new Random(42);
        ExpressionEncoder.Serializer intArrayToRow = this.intEncoder().createSerializer();
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable)() -> rand.nextInt(), (ClassTag)ClassTag$.MODULE$.Int());
        ArrayData intUnsafeArray = intArrayToRow.apply((Object)intPrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable readIntArray = (JFunction1.mcVI.sp & Serializable)i -> {
            for (int n = 0; n < iters; ++n) {
                int len = intUnsafeArray.numElements();
                int sum = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    sum += intUnsafeArray.getInt(i2);
                }
            }
        };
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable)() -> rand.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        ExpressionEncoder.Serializer doubleArrayToRow = this.doubleEncoder().createSerializer();
        ArrayData doubleUnsafeArray = doubleArrayToRow.apply((Object)doublePrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable readDoubleArray = (JFunction1.mcVI.sp & Serializable)i -> {
            for (int n = 0; n < iters; ++n) {
                int len = doubleUnsafeArray.numElements();
                double sum = 0.0;
                for (int i2 = 0; i2 < len; ++i2) {
                    sum += doubleUnsafeArray.getDouble(i2);
                }
            }
        };
        String x$1 = "Read UnsafeArrayData";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Read UnsafeArrayData", x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)readIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)readDoubleArray);
        benchmark.run();
    }

    public void writeUnsafeArray(int iters) {
        int count = 0x200000;
        Random rand = new Random(42);
        IntRef intTotalLength = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable)() -> rand.nextInt(), (ClassTag)ClassTag$.MODULE$.Int());
        ExpressionEncoder.Serializer intArrayToRow = this.intEncoder().createSerializer();
        JFunction1.mcVI.sp & Serializable writeIntArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += intArrayToRow.apply((Object)intPrimitiveArray).getArray(0).numElements();
            }
            intTotalLength$1.elem = len;
        };
        IntRef doubleTotalLength = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable)() -> rand.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        ExpressionEncoder.Serializer doubleArrayToRow = this.doubleEncoder().createSerializer();
        JFunction1.mcVI.sp & Serializable writeDoubleArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += doubleArrayToRow.apply((Object)doublePrimitiveArray).getArray(0).numElements();
            }
            doubleTotalLength$1.elem = len;
        };
        String x$1 = "Write UnsafeArrayData";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Write UnsafeArrayData", x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)writeIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)writeDoubleArray);
        benchmark.run();
    }

    public void getPrimitiveArray(int iters) {
        int count = 0xC00000;
        Random rand = new Random(42);
        IntRef intTotalLength = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable)() -> rand.nextInt(), (ClassTag)ClassTag$.MODULE$.Int());
        ExpressionEncoder.Serializer intArrayToRow = this.intEncoder().createSerializer();
        ArrayData intUnsafeArray = intArrayToRow.apply((Object)intPrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable readIntArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += intUnsafeArray.toIntArray().length;
            }
            intTotalLength$2.elem = len;
        };
        IntRef doubleTotalLength = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable)() -> rand.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        ExpressionEncoder.Serializer doubleArrayToRow = this.doubleEncoder().createSerializer();
        ArrayData doubleUnsafeArray = doubleArrayToRow.apply((Object)doublePrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable readDoubleArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += doubleUnsafeArray.toDoubleArray().length;
            }
            doubleTotalLength$2.elem = len;
        };
        String x$1 = "Get primitive array from UnsafeArrayData";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Get primitive array from UnsafeArrayData", x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)readIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)readDoubleArray);
        benchmark.run();
    }

    public void putPrimitiveArray(int iters) {
        int count = 0xC00000;
        Random rand = new Random(42);
        IntRef intTotalLen = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable)() -> rand.nextInt(), (ClassTag)ClassTag$.MODULE$.Int());
        JFunction1.mcVI.sp & Serializable createIntArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += UnsafeArrayData.fromPrimitiveArray((int[])intPrimitiveArray).numElements();
            }
            intTotalLen$1.elem = len;
        };
        IntRef doubleTotalLen = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable)() -> rand.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        JFunction1.mcVI.sp & Serializable createDoubleArray = (JFunction1.mcVI.sp & Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += UnsafeArrayData.fromPrimitiveArray((double[])doublePrimitiveArray).numElements();
            }
            doubleTotalLen$1.elem = len;
        };
        String x$1 = "Create UnsafeArrayData from primitive array";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Create UnsafeArrayData from primitive array", x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)createIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)createDoubleArray);
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Benchmark UnsafeArrayData", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.readUnsafeArray(10);
            MODULE$.writeUnsafeArray(10);
            MODULE$.getPrimitiveArray(5);
            MODULE$.putPrimitiveArray(5);
        });
    }

    private UnsafeArrayDataBenchmark$() {
    }
}

