/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InExpressionBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final InExpressionBenchmark$ MODULE$ = new InExpressionBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        InExpressionBenchmark$ inExpressionBenchmark$ = this;
        synchronized (inExpressionBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    private void runByteBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(6).append(numItems).append(" bytes").toString();
        IndexedSeq values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(-128), -128 + numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runByteBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)ByteType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runShortBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(7).append(numItems).append(" shorts").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runShortBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)ShortType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runNonCompactShortBenchmark(int numItems, long numRows, int minNumIters) {
        int step = (Short.MAX_VALUE - Short.MIN_VALUE) / numItems;
        int maxValue = Short.MIN_VALUE + numItems * step;
        int rangeSize = maxValue - Short.MIN_VALUE;
        Predef$.MODULE$.require(this.isLookupSwitch(rangeSize, numItems));
        String name = new StringBuilder(21).append(numItems).append(" shorts (non-compact)").toString();
        IndexedSeq values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(Short.MIN_VALUE), maxValue).by(step).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runNonCompactShortBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)ShortType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runIntBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(5).append(numItems).append(" ints").toString();
        Range.Inclusive values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems);
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)IntegerType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runNonCompactIntBenchmark(int numItems, long numRows, int minNumIters) {
        long step = ((long)Integer.MAX_VALUE - (long)Integer.MIN_VALUE) / (long)numItems;
        long maxValue = Integer.MIN_VALUE + (long)numItems * step;
        long rangeSize = maxValue - Integer.MIN_VALUE;
        Predef$.MODULE$.require(this.isLookupSwitch(rangeSize, numItems));
        String name = new StringBuilder(19).append(numItems).append(" ints (non-compact)").toString();
        Range values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(Integer.MIN_VALUE), (int)maxValue).by((int)step);
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)IntegerType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runLongBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(6).append(numItems).append(" longs").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runLongBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runFloatBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(7).append(numItems).append(" floats").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runFloatBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)FloatType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runDoubleBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(8).append(numItems).append(" doubles").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runDoubleBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)DoubleType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runSmallDecimalBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(15).append(numItems).append(" small decimals").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runSmallDecimalBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)new DecimalType(12, 1))}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runLargeDecimalBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(15).append(numItems).append(" large decimals").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)v -> InExpressionBenchmark$.$anonfun$runLargeDecimalBenchmark$1(BoxesRunTime.unboxToInt((Object)v)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)new DecimalType(30, 7))}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runStringBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(8).append(numItems).append(" strings").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)n -> InExpressionBenchmark$.$anonfun$runStringBenchmark$1(BoxesRunTime.unboxToInt((Object)n)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$)}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runTimestampBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(11).append(numItems).append(" timestamps").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)m -> InExpressionBenchmark$.$anonfun$runTimestampBenchmark$1(BoxesRunTime.unboxToInt((Object)m)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.timestamp_seconds((Column)this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).as("id")}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runDateBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(6).append(numItems).append(" dates").toString();
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1)(JFunction1.mcII.sp & Serializable)n -> 1970 + n).map((Function1 & Serializable)y -> InExpressionBenchmark$.$anonfun$runDateBenchmark$2(BoxesRunTime.unboxToInt((Object)y)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.timestamp_seconds((Column)this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).cast((DataType)DateType$.MODULE$).as("id")}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runArrayBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(7).append(numItems).append(" arrays").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)i -> InExpressionBenchmark$.$anonfun$runArrayBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)})).as("id")}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runStructBenchmark(int numItems, long numRows, int minNumIters) {
        String name = new StringBuilder(8).append(numItems).append(" structs").toString();
        IndexedSeq values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numItems).map((Function1 & Serializable)i -> InExpressionBenchmark$.$anonfun$runStructBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        Dataset df = this.spark().range(0L, numRows).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as("col1")})).as("id")}));
        this.runBenchmark(name, (Dataset<Row>)df, (Seq<Object>)values, numRows, minNumIters);
    }

    private void runBenchmark(String name, Dataset<Row> df, Seq<Object> values, long numRows, int minNumIters) {
        String x$12 = name;
        long x$22 = numRows;
        int x$3 = minNumIters;
        Option x$4 = this.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$22, x$3, x$5, x$6, x$7, x$4);
        df.createOrReplaceTempView("t");
        benchmark.addCase("In expression", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OPTIMIZER_INSET_CONVERSION_THRESHOLD().key()), (Object)Integer.toString(values.size()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testClosure$1(values)));
        benchmark.addCase("InSet expression", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OPTIMIZER_INSET_CONVERSION_THRESHOLD().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testClosure$1(values)));
        benchmark.run();
    }

    private boolean isLookupSwitch(long rangeSize, int numLabels) {
        int lookupSpaceCost = 3 + 2 * numLabels;
        int lookupTimeCost = numLabels;
        long tableSpaceCost = 4L + rangeSize;
        int tableTimeCost = 3;
        return (long)(lookupSpaceCost + 3 * lookupTimeCost) < tableSpaceCost + (long)(3 * tableTimeCost);
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        Seq smallNumItemsSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 10, 25, 50, 100, 200}));
        Seq largeNumItemsSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{300, 400, 500}));
        int largeNumRows = 10000000;
        int smallNumRows = 1000000;
        int minNumIters = 5;
        this.runBenchmark("In Expression Benchmark", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runByteBenchmark(numItems, largeNumRows, minNumIters));
            ((IterableOnceOps)smallNumItemsSeq.$plus$plus((IterableOnce)largeNumItemsSeq)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runShortBenchmark(numItems, largeNumRows, minNumIters));
            ((IterableOnceOps)smallNumItemsSeq.$plus$plus((IterableOnce)largeNumItemsSeq)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runNonCompactShortBenchmark(numItems, largeNumRows, minNumIters));
            ((IterableOnceOps)smallNumItemsSeq.$plus$plus((IterableOnce)largeNumItemsSeq)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runIntBenchmark(numItems, largeNumRows, minNumIters));
            ((IterableOnceOps)smallNumItemsSeq.$plus$plus((IterableOnce)largeNumItemsSeq)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runNonCompactIntBenchmark(numItems, largeNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runLongBenchmark(numItems, largeNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runFloatBenchmark(numItems, largeNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runDoubleBenchmark(numItems, largeNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runSmallDecimalBenchmark(numItems, smallNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runLargeDecimalBenchmark(numItems, smallNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runStringBenchmark(numItems, smallNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runTimestampBenchmark(numItems, largeNumRows, minNumIters));
            ((IterableOnceOps)smallNumItemsSeq.$plus$plus((IterableOnce)largeNumItemsSeq)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runDateBenchmark(numItems, largeNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runArrayBenchmark(numItems, smallNumRows, minNumIters));
            smallNumItemsSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numItems -> MODULE$.runStructBenchmark(numItems, smallNumRows, minNumIters));
        });
    }

    public static final /* synthetic */ String $anonfun$runByteBenchmark$1(int v) {
        return new StringBuilder(1).append(v).append("Y").toString();
    }

    public static final /* synthetic */ String $anonfun$runShortBenchmark$1(int v) {
        return new StringBuilder(1).append(v).append("S").toString();
    }

    public static final /* synthetic */ String $anonfun$runNonCompactShortBenchmark$1(int v) {
        return new StringBuilder(1).append(v).append("S").toString();
    }

    public static final /* synthetic */ String $anonfun$runLongBenchmark$1(int v) {
        return new StringBuilder(1).append(v).append("L").toString();
    }

    public static final /* synthetic */ String $anonfun$runFloatBenchmark$1(int v) {
        return new StringBuilder(15).append("CAST(").append(v).append(" AS float)").toString();
    }

    public static final /* synthetic */ String $anonfun$runDoubleBenchmark$1(int v) {
        return new StringBuilder(3).append(v).append(".0D").toString();
    }

    public static final /* synthetic */ String $anonfun$runSmallDecimalBenchmark$1(int v) {
        return new StringBuilder(24).append("CAST(").append(v).append(" AS decimal(12, 1))").toString();
    }

    public static final /* synthetic */ String $anonfun$runLargeDecimalBenchmark$1(int v) {
        return new StringBuilder(25).append("9223372036854775812.10539").append(v).toString();
    }

    public static final /* synthetic */ String $anonfun$runStringBenchmark$1(int n) {
        return new StringBuilder(2).append("'").append(n).append("'").toString();
    }

    public static final /* synthetic */ String $anonfun$runTimestampBenchmark$1(int m) {
        return new StringBuilder(31).append("timestamp'1970-01-01 01:00:00.").append(m).append("'").toString();
    }

    public static final /* synthetic */ String $anonfun$runDateBenchmark$2(int y) {
        return new StringBuilder(12).append("date'").append(y).append("-01-01'").toString();
    }

    public static final /* synthetic */ String $anonfun$runArrayBenchmark$1(int i) {
        return new StringBuilder(7).append("array(").append(i).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$runStructBenchmark$1(int i) {
        return new StringBuilder(8).append("struct(").append(i).append(")").toString();
    }

    private final void testClosure$1(Seq values$1) {
        Dataset df = this.spark().sql(new StringBuilder(30).append("SELECT * FROM t WHERE id IN (").append(values$1.mkString(",")).append(")").toString());
        this.DatasetToBenchmark(df).noop();
    }

    private InExpressionBenchmark$() {
    }
}

