/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000554q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003&\u0001\u0019\u0005a\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003B\u0001\u0011\u0005!\tC\u0003P\u0001\u0011%\u0001\u000bC\u0003V\u0001\u0011%a\u000bC\u0003i\u0001\u0011%\u0011N\u0001\u000bDQ\u0006\u0014h+\u0019:dQ\u0006\u0014H+Z:u'VLG/\u001a\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005I\u0011B\u0001\f\n\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0013\u0005!A/Z:u\u0013\ta\u0012D\u0001\u0007T#2#Vm\u001d;Vi&d7/\u0001\u0004%S:LG\u000f\n\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5u\u0003\u00191wN]7biV\tq\u0005\u0005\u0002)_9\u0011\u0011&\f\t\u0003U\u0005j\u0011a\u000b\u0006\u0003YE\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\n\u0013\u0001D2iK\u000e\\7i\u001c7UsB,GcA\u00105y!)Qg\u0001a\u0001m\u0005\ta\r\u0005\u00028u5\t\u0001H\u0003\u0002:\u0013\u0005)A/\u001f9fg&\u00111\b\u000f\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0003>\u0007\u0001\u0007a(\u0001\u0002eiB\u0011qgP\u0005\u0003\u0001b\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0011G\",7m\u001b)mC&t'+Z:vYR$BaH\"M\u001b\")A\t\u0002a\u0001\u000b\u0006\u0011AM\u001a\t\u0003\r&s!\u0001F$\n\u0005!K\u0011a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005!K\u0001\"B\u001f\u0005\u0001\u00049\u0003\"\u0002(\u0005\u0001\u00049\u0013!C5og\u0016\u0014HOV1m\u00039!Xm\u001d;UC\ndWm\u0016:ji\u0016$\"aH)\t\u000bU*\u0001\u0019\u0001*\u0011\t\u0001\u001aveH\u0005\u0003)\u0006\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001dQ,7\u000f^\"p]\u0012LG/[8ogR\u0019qd\u0016-\t\u000b\u00113\u0001\u0019A#\t\u000be3\u0001\u0019\u0001.\u0002\u0015\r|g\u000eZ5uS>t7\u000fE\u0002\\?\nt!\u0001\u00180\u000f\u0005)j\u0016\"\u0001\u0012\n\u0005!\u000b\u0013B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003\u0011\u0006\u0002B\u0001I2(K&\u0011A-\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u00012\u0017BA4\"\u0005\u001d\u0011un\u001c7fC:\f!\u0003^3ti:+H\u000e\\\"p]\u0012LG/[8ogR\u0019qD[6\t\u000b\u0011;\u0001\u0019A#\t\u000be;\u0001\u0019\u00017\u0011\u0007m{v\u0005")
public interface CharVarcharTestSuite
extends SQLTestUtils {
    public String format();

    public static /* synthetic */ void checkColType$(CharVarcharTestSuite $this, StructField f, DataType dt) {
        $this.checkColType(f, dt);
    }

    default public void checkColType(StructField f, DataType dt) {
        DataType $org_scalatest_assert_macro_left = f.dataType();
        DataType $org_scalatest_assert_macro_right = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dt);
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        Option $org_scalatest_assert_macro_left2 = CharVarcharUtils$.MODULE$.getRawType(f.metadata());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)dt);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
    }

    public static /* synthetic */ void checkPlainResult$(CharVarcharTestSuite $this, Dataset df, String dt, String insertVal) {
        $this.checkPlainResult((Dataset<Row>)df, dt, insertVal);
    }

    default public void checkPlainResult(Dataset<Row> df, String dt, String insertVal) {
        DataType dataType = CatalystSqlParser$.MODULE$.parseDataType(dt);
        this.checkColType(df.schema().apply(1), dataType);
        DataType dataType2 = dataType;
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            int len = charType.length();
            String fixLenStr = insertVal != null ? StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len)), len, (Object)" ").mkString() : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", fixLenStr})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            int len = varcharType.length();
            String varLenStrWithUpperBound = insertVal != null ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len) : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", varLenStrWithUpperBound})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dataType2);
        }
    }

    private void testTableWrite(Function1<String, BoxedUnit> f) {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"char"));
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"varchar"));
    }

    private void testConditions(Dataset<Row> df, Seq<Tuple2<String, Object>> conditions) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.selectExpr((Seq)conditions.map((Function1 & Serializable)x$1 -> (String)x$1._1())), Row$.MODULE$.fromSeq((Seq)conditions.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._2$mcZ$sp()))));
    }

    private void testNullConditions(Dataset<Row> df, Seq<String> conditions) {
        conditions.foreach((Function1 & Serializable)cond -> {
            CharVarcharTestSuite.$anonfun$testNullConditions$1(this, df, cond);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ String $anonfun$$init$$4(int n) {
        return new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$5(CharVarcharTestSuite $this, String typ$1, String v) {
        $this.sql().apply((Object)new StringBuilder(35).append("INSERT OVERWRITE t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ$1, v);
    }

    public static /* synthetic */ String $anonfun$$init$$8(int n) {
        return new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$9(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)new StringBuilder(35).append("INSERT OVERWRITE t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
    }

    public static /* synthetic */ String $anonfun$$init$$11(int n) {
        return new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$12(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
        $this.sql().apply((Object)new StringBuilder(44).append("INSERT INTO t PARTITION (c ='").append(v).append("') VALUES ('1')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
    }

    public static /* synthetic */ void $anonfun$$init$$87(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE TABLE t(c ").append(typeName).append("(5)) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES ('123456')"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
    }

    public static /* synthetic */ void $anonfun$$init$$91(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i INT, c ").append(typeName).append("(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (1, null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (1, '123456')"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
    }

    public static /* synthetic */ void $anonfun$$init$$95(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(39).append("CREATE TABLE t(c STRUCT<c: ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        RuntimeException e = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct('123456')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
    }

    public static /* synthetic */ void $anonfun$$init$$99(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(c ARRAY<").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
    }

    public static /* synthetic */ void $anonfun$$init$$103(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE t(c MAP<").append(typeName).append("(5), STRING>) USING ").append($this.format()).toString());
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
    }

    public static /* synthetic */ void $anonfun$$init$$106(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE t(c MAP<STRING, ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (map('a', null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
    }

    public static /* synthetic */ void $anonfun$$init$$110(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE t(c MAP<").append(typeName).append("(5), ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        SparkException e1 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384)));
        String $org_scalatest_assert_macro_left = e1.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        SparkException e2 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386)));
        String $org_scalatest_assert_macro_left2 = e2.getCause().getMessage();
        String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
    }

    public static /* synthetic */ void $anonfun$$init$$114(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(c STRUCT<c: ARRAY<").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct(array('123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
    }

    public static /* synthetic */ void $anonfun$$init$$118(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(c ARRAY<STRUCT<c: ").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
    }

    public static /* synthetic */ void $anonfun$$init$$122(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(c ARRAY<ARRAY<").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(array(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(array('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
    }

    public static /* synthetic */ void $anonfun$testNullConditions$1(CharVarcharTestSuite $this, Dataset df$3, String cond) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df$3.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{cond})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
    }

    public static /* synthetic */ void $anonfun$$init$$142(CharVarcharTestSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String con = (String)tuple2._1();
        boolean res = tuple2._2$mcZ$sp();
        Dataset df = $this.spark().table("t");
        BoxedUnit boxedUnit = (BoxedUnit)((Assertions)$this).withClue((Object)con, (Function0)(JFunction0.mcV.sp & Serializable)() -> ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.where(con), (Dataset<Row>)df.where(Boolean.toString(res))));
    }

    public static /* synthetic */ void $anonfun$$init$$176(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n             |SELECT v FROM t1\n             |WHERE 'a' IN (SELECT v FROM t2 WHERE ").append(predicate).append(")\n           ").toString()))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c"})));
    }

    public static /* synthetic */ void $anonfun$$init$$180(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n             |SELECT c0 FROM t t1\n             |WHERE (\n             |  SELECT count(*) AS c\n             |  FROM t\n             |  WHERE c0 = t1.c0 AND ").append(predicate).append("\n             |) > 0\n         ").toString()))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
    }

    public static void $init$(CharVarcharTestSuite $this) {
        $this.test("apply char padding/trimming and varchar trimming: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(5)", "VARCHAR(5)"})).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).toString());
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$4(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$5($this, typ, v);
                    return BoxedUnit.UNIT;
                });
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        $this.test("char type values should be padded or trimmed: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE t(i STRING, c CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$8(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$9($this, v);
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE t(i STRING, c CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$11(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$12($this, v);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        $this.test("char type values should not be padded when charVarcharAsString is true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(72).append("CREATE TABLE t(a STRING, b CHAR(5), c CHAR(5)) USING ").append($this.format()).append(" partitioned by (c)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('abc', 'abc', 'abc')");
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        $this.test("varchar type values length check and trim: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)n -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE t(i STRING, c VARCHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
            String v = new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).toString();
            $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO t VALUES ('1', '").append(v).append("')").toString());
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE t DROP PARTITION(c='").append(v).append("')").toString());
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
            $this.sql().apply((Object)new StringBuilder(43).append("INSERT INTO t PARTITION (c='").append(v).append("') VALUES ('1')").toString());
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE t DROP PARTITION(c='").append(v).append("')").toString());
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        $this.test("oversize char/varchar values for alter table partition operations", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(5)", "VARCHAR(5)"})).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ADD", "DROP"})).foreach((Function1 & Serializable)op -> {
                    RuntimeException e = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(36).append("ALTER TABLE t ").append((String)op).append(" PARTITION(c='abcdef')").toString()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                });
                RuntimeException e1 = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='abcdef') RENAME TO PARTITION (c='2')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                RuntimeException e2 = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='1') RENAME TO PARTITION (c='abcdef')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        $this.test("SPARK-34233: char/varchar with null value for partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(5)", "VARCHAR(5)"})).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c=null)");
                ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        $this.test("char/varchar type values length check: partitioned columns of other types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(5)", "VARCHAR(5)"})).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 10, 100, 1000, 10000})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)v -> {
                    $this.sql().apply((Object)new StringBuilder(33).append("INSERT OVERWRITE t VALUES ('1', ").append(v).append(")").toString());
                    $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, Integer.toString(v));
                    $this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE t DROP PARTITION(c=").append(v).append(")").toString());
                    ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)package$.MODULE$.Nil());
                });
                SparkException e1 = (SparkException)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', 100000)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190))));
                String $org_scalatest_assert_macro_left = e1.getCause().getMessage();
                String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
                RuntimeException e2 = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c=100000)"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        $this.test("char type values should be padded: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(53).append("CREATE TABLE t(i STRING, c STRUCT<c: CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct('a'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString()}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        $this.test("char type values should be padded: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE t(i STRING, c ARRAY<CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString(), new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString()}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        $this.test("char type values should be padded: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE t(i STRING, c MAP<CHAR(5), STRING>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString(), (Object)"ab")}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        $this.test("char type values should be padded: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE t(i STRING, c MAP<STRING, CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString())}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', map('a', null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        $this.test("char type values should be padded: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(57).append("CREATE TABLE t(i STRING, c MAP<CHAR(5), CHAR(10)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString(), (Object)new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 8)).toString())}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)new CharType(10)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        $this.test("char type values should be padded: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE t(i STRING, c STRUCT<c: ARRAY<CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString(), new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString()}))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        $this.test("char type values should be padded: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE t(i STRING, c ARRAY<STRUCT<c: CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(struct('a'), struct('ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString()})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString()}))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", (DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(struct(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        $this.test("char type values should be padded: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(56).append("CREATE TABLE t(i STRING, c ARRAY<ARRAY<CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append("a").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)).toString(), new StringBuilder(2).append("ab").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString()}))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        $this.test("length check for input string values: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$87($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        $this.test("length check for input string values: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!$this.conf().contains(SQLConf$.MODULE$.DEFAULT_CATALOG().key())) {
                $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
                    CharVarcharTestSuite.$anonfun$$init$$91($this, typeName);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        $this.test("length check for input string values: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$95($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        $this.test("length check for input string values: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$99($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        $this.test("length check for input string values: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$103($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        $this.test("length check for input string values: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$106($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        $this.test("length check for input string values: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$110($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        $this.test("length check for input string values: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$114($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        $this.test("length check for input string values: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$118($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        $this.test("length check for input string values: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$122($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        $this.test("length check for input string values: with trailing spaces", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('12 ', '12 ')");
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1234  ', '1234  ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(2).append("12").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)).toString(), "12 "})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234 "}))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        $this.test("length check for input string values: with implicit cast", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1234, 1234)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234"})));
            SparkException e1 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (123456, 1)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437)))));
            String $org_scalatest_assert_macro_left = e1.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            SparkException e2 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (1, 123456)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439)))));
            String $org_scalatest_assert_macro_left2 = e2.getCause().getMessage();
            String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        $this.test("char type comparison: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE t(c1 CHAR(2), c2 CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        $this.test("char type comparison: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(76).append("CREATE TABLE t(i INT, c1 CHAR(2), c2 CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c1, c2)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        $this.test("SPARK-34233: char type comparison with null values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq conditions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c = null", "c IN ('e', null)", "c IN (null)"}));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE t(c CHAR(2)) USING ").append($this.format()).toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES ('a')");
                $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions);
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(58).append("CREATE TABLE t(i INT, c CHAR(2)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a')");
                $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions);
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        $this.test("char type comparison: partition pruning", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE t(i INT, c1 CHAR(2), c2 VARCHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c1, c2)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c2 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true))})).foreach((Function1 & Serializable)x0$1 -> {
                CharVarcharTestSuite.$anonfun$$init$$142($this, x0$1);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        $this.test("char type comparison: join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(33).append("CREATE TABLE t1(c CHAR(2)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)new StringBuilder(33).append("CREATE TABLE t2(c CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('a')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT t1.c FROM t1 JOIN t2 ON t1.c = t2.c"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        $this.test("char type comparison: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE t(c1 STRUCT<c: CHAR(2)>, c2 STRUCT<c: CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct('a'), struct('a'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        $this.test("char type comparison: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(59).append("CREATE TABLE t(c1 ARRAY<CHAR(2)>, c2 ARRAY<CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array('a', 'b'), array('a', 'b'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        $this.test("char type comparison: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(75).append("CREATE TABLE t(c1 STRUCT<a: ARRAY<CHAR(2)>>, c2 STRUCT<a: ARRAY<CHAR(5)>>) ").append(new StringBuilder(6).append("USING ").append($this.format()).toString()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct(array('a', 'b')), struct(array('a', 'b')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        $this.test("char type comparison: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(75).append("CREATE TABLE t(c1 ARRAY<STRUCT<c: CHAR(2)>>, c2 ARRAY<STRUCT<c: CHAR(5)>>) ").append(new StringBuilder(6).append("USING ").append($this.format()).toString()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('a')), array(struct('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        $this.test("char type comparison: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE t(c1 ARRAY<ARRAY<CHAR(2)>>, c2 ARRAY<ARRAY<CHAR(5)>>) ").append(new StringBuilder(6).append("USING ").append($this.format()).toString()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(array('a')), array(array('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        $this.test("SPARK-33892: DESCRIBE TABLE w/ char/varchar", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t")).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("data_type like '%char%'"), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(3)"}))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        $this.test("SPARK-34003: fix char/varchar fails w/ both group by and order by ", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(v VARCHAR(3), i INT) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT v, sum(i) FROM t GROUP BY v ORDER BY v"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        $this.test("SPARK-34003: fix char/varchar fails w/ order by functions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(v VARCHAR(3), i INT) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT substr(v, 1, 2), sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        $this.test("SPARK-34114: varchar type will strip tailing spaces to certain length at write time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(v VARCHAR(3)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c      ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c  "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
        $this.test("SPARK-34114: varchar type will remain the value length with spaces at read time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(v VARCHAR(3)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - join keys", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE t1(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE t2(v VARCHAR(5), c CHAR(8)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('c', 'b')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a', 'b')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1.c = t2.c", "t2.c = t1.c", "t1.c = 'b'", "'b' = t1.c", "t1.c = 'b    '", "'b    ' = t1.c", "t1.c = 'b      '", "'b      ' = t1.c"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$176($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - other preds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(53).append("CREATE TABLE t(c0 INT, c1 CHAR(5), c2 CHAR(7)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'abc', 'abc')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1 = 'abc'", "'abc' = c1", "c1 = 'abc  '", "'abc  ' = c1", "c1 = 'abc    '", "'abc    ' = c1", "c1 = c2", "c2 = c1", "c1 IN ('xxx', 'abc', 'xxxxx')", "c1 IN ('xxx', 'abc  ', 'xxxxx')", "c1 IN ('xxx', 'abc    ', 'xxxxx')", "c1 IN (c2)", "c2 IN (c1)"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$180($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
    }
}

