/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\u0010!\u0005-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0007{\u0001!\tA\t \t\u000b\t\u0003A\u0011A\"\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011\u0001.\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011A2\t\u000bu\u0003A\u0011A5\t\u000bu\u0003A\u0011A8\t\u000bU\u0004A\u0011\u0001<\t\u000bU\u0004A\u0011\u0001@\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\b\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\t\u000b\u0002\u0001\r\u0011\"\u0003\u0002v!I\u0011q\u000f\u0001A\u0002\u0013%\u0011\u0011\u0010\u0005\b\u0003\u000b\u0003\u0001\u0015)\u0003G\u0011%\t9\t\u0001a\u0001\n\u0013\tI\tC\u0005\u0002\u000e\u0002\u0001\r\u0011\"\u0003\u0002\u0010\"A\u00111\u0013\u0001!B\u0013\tY\tC\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"I\u0011q\u0015\u0001A\u0002\u0013%\u0011\u0011\u0016\u0005\t\u0003[\u0003\u0001\u0015)\u0003\u0002\u001a\n\u0001B)\u0019;b'R\u0014X-Y7SK\u0006$WM\u001d\u0006\u0003C\t\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a#\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0011\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002;w5\t!%\u0003\u0002=E\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"aP!\u0011\u0005\u0001\u0003Q\"\u0001\u0011\t\u000ba\u0012\u0001\u0019A\u001d\u0002\r\u0019|'/\\1u)\tyD\tC\u0003F\u0007\u0001\u0007a)\u0001\u0004t_V\u00148-\u001a\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%sS\"\u0001&\u000b\u0005-S\u0013A\u0002\u001fs_>$h(\u0003\u0002N]\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tie&\u0001\u0004tG\",W.\u0019\u000b\u0003\u007fMCQ!\u0015\u0003A\u0002Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0012\u0002\u000bQL\b/Z:\n\u0005e3&AC*ueV\u001cG\u000fV=qKR\u0011qh\u0017\u0005\u00069\u0016\u0001\rAR\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\u0007_B$\u0018n\u001c8\u0015\u0007}z\u0016\rC\u0003a\r\u0001\u0007a)A\u0002lKfDQA\u0019\u0004A\u0002\u0019\u000bQA^1mk\u0016$2a\u00103f\u0011\u0015\u0001w\u00011\u0001G\u0011\u0015\u0011w\u00011\u0001g!\tis-\u0003\u0002i]\t9!i\\8mK\u0006tGcA kW\")\u0001\r\u0003a\u0001\r\")!\r\u0003a\u0001YB\u0011Q&\\\u0005\u0003]:\u0012A\u0001T8oOR\u0019q\b]9\t\u000b\u0001L\u0001\u0019\u0001$\t\u000b\tL\u0001\u0019\u0001:\u0011\u00055\u001a\u0018B\u0001;/\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHCA x\u0011\u0015)(\u00021\u0001y!\u0011IHP\u0012$\u000e\u0003iT!a\u001f\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~u\n\u0019Q*\u00199\u0015\u0005}z\bBB;\f\u0001\u0004\t\t\u0001\u0005\u0004\u0002\u0004\u00055aIR\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!Q\u000f^5m\u0015\t\tY!\u0001\u0003kCZ\f\u0017bA?\u0002\u0006\u0005!An\\1e)\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005-b\u0002BA\f\u0003OqA!!\u0007\u0002&9!\u00111DA\u0012\u001d\u0011\ti\"!\t\u000f\u0007%\u000by\"C\u0001*\u0013\t9\u0003&\u0003\u0002&M%\u00111\u0005J\u0005\u0004\u0003S\u0011\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyCA\u0005ECR\fgI]1nK*\u0019\u0011\u0011\u0006\u0012\u0002\u00191|\u0017\rZ%oi\u0016\u0014h.\u00197\u0015\t\u0005M\u0011Q\u0007\u0005\b\u0003oi\u0001\u0019AA\u001d\u0003\u0011\u0001\u0018\r\u001e5\u0011\t5\nYDR\u0005\u0004\u0003{q#AB(qi&|g\u000e\u0006\u0003\u0002\u0014\u0005\u0005\u0003BBA\u001c\u001d\u0001\u0007a)\u0001\u0003kg>tG\u0003BA\n\u0003\u000fBa!a\u000e\u0010\u0001\u00041\u0015aA2tmR!\u00111CA'\u0011\u0019\t9\u0004\u0005a\u0001\r\u0006\u0019qN]2\u0015\t\u0005M\u00111\u000b\u0005\u0007\u0003o\t\u0002\u0019\u0001$\u0002\u000fA\f'/];fiR!\u00111CA-\u0011\u0019\t9D\u0005a\u0001\r\u0006)A/\u00192mKR!\u00111CA0\u0011\u0019\t\tg\u0005a\u0001\r\u0006IA/\u00192mK:\u000bW.Z\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002\u0014\u0005\u001d\u0004BBA\u001c)\u0001\u0007a)\u0001\u0005uKb$h)\u001b7f)\u0011\ti'a\u001d\u0011\ti\nyGR\u0005\u0004\u0003c\u0012#a\u0002#bi\u0006\u001cX\r\u001e\u0005\u0007\u0003o)\u0002\u0019\u0001$\u0016\u0003\u0019\u000b!b]8ve\u000e,w\fJ3r)\u0011\tY(!!\u0011\u00075\ni(C\u0002\u0002\u00009\u0012A!\u00168ji\"A\u00111Q\f\u0002\u0002\u0003\u0007a)A\u0002yIE\nqa]8ve\u000e,\u0007%A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002\fB!Q&a\u000fU\u0003])8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005E\u0005\"CAB5\u0005\u0005\t\u0019AAF\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011\u0011\u0011\u0014\t\u0006\u00037\u000b\u0019KR\u0007\u0003\u0003;SA!a\u0002\u0002 *\u0019\u0011\u0011\u0015\u0012\u0002\u0011\r\fG/\u00197zgRLA!!*\u0002\u001e\n\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u0003A)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005-\u0006\"CAB;\u0005\u0005\t\u0019AAM\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA!\u001a\u0001!!-\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.%\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\u000b)L\u0001\u0005Fm>dg/\u001b8h\u0001")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.loadInternal((Option<String>)None$.MODULE$);
    }

    private Dataset<Row> loadInternal(Option<String> path) {
        Dataset<Row> dataset;
        TableProvider tableProvider;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        CaseInsensitiveMap optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        Object ds = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sqlContext().conf()).getConstructor(new Class[0]).newInstance(new Object[0]);
        SparkSession x$12 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource v1DataSource = new DataSource(x$12, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8);
        Object obj = ds;
        Object object = obj instanceof StreamSourceProvider ? new Some((Object)StreamingRelation$.MODULE$.apply(v1DataSource)) : None$.MODULE$;
        None$ v1Relation = object;
        Object obj2 = ds;
        if (obj2 instanceof TableProvider && !((tableProvider = (TableProvider)obj2) instanceof FileDataSourceV2)) {
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(tableProvider, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)sessionOptions.filterKeys((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataStreamReader.$anonfun$loadInternal$1(optionsWithPath, x$1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            Table table = DataSourceV2Utils$.MODULE$.getTableFromProvider(tableProvider, dsOptions, this.userSpecifiedSchema());
            Table table2 = table;
            Dataset<Row> dataset2 = table2 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table).supportsAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.MICRO_BATCH_READ, TableCapability.CONTINUOUS_READ})) ? Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2((Option)new Some((Object)tableProvider), this.source(), table, dsOptions, table.schema().toAttributes(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)v1Relation)) : Dataset$.MODULE$.ofRows(this.sparkSession, StreamingRelation$.MODULE$.apply(v1DataSource));
            dataset = dataset2;
        } else {
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, StreamingRelation$.MODULE$.apply(v1DataSource));
        }
        return dataset;
    }

    public Dataset<Row> load(String path) {
        if (!this.sparkSession.sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("load");
        }
        return this.loadInternal((Option<String>)new Some((Object)path));
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        Seq identifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(identifier, new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.extraOptions().toMap()).asJava()), true));
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError("textFile");
        }
        return this.text(path).select("value", (Seq<String>)Nil$.MODULE$).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

