/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.AccumulatorV2;
import scala.Option;

public abstract class SpecificParquetRecordReaderBase<T>
extends RecordReader<Void, T> {
    protected Path file;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    protected StructType sparkSchema;
    protected long totalRowCount;
    protected ParquetFileReader reader;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Option accu;
        Configuration configuration = taskAttemptContext.getConfiguration();
        FileSplit split = (FileSplit)inputSplit;
        this.file = split.getPath();
        ParquetReadOptions options = HadoopReadOptions.builder((Configuration)configuration, (Path)this.file).withRange(split.getStart(), split.getStart() + split.getLength()).build();
        this.reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)configuration), options);
        this.fileSchema = this.reader.getFileMetaData().getSchema();
        Map fileMetadata = this.reader.getFileMetaData().getKeyValueMetaData();
        ReadSupport<T> readSupport = SpecificParquetRecordReaderBase.getReadSupportInstance(this.getReadSupportClass(configuration));
        ReadSupport.ReadContext readContext = readSupport.init(new InitContext(taskAttemptContext.getConfiguration(), SpecificParquetRecordReaderBase.toSetMultiMap(fileMetadata), this.fileSchema));
        this.requestedSchema = readContext.getRequestedSchema();
        this.reader.setRequestedSchema(this.requestedSchema);
        String sparkRequestedSchemaString = configuration.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        this.sparkSchema = StructType$.MODULE$.fromString(sparkRequestedSchemaString);
        this.totalRowCount = this.reader.getFilteredRecordCount();
        TaskContext taskContext = TaskContext$.MODULE$.get();
        if (taskContext != null && (accu = taskContext.taskMetrics().externalAccums().lastOption()).isDefined() && ((AccumulatorV2)accu.get()).getClass().getSimpleName().equals("NumRowGroupsAcc")) {
            AccumulatorV2 intAccum = (AccumulatorV2)accu.get();
            intAccum.add((Object)this.reader.getRowGroups().size());
        }
    }

    public static List<String> listDirectory(File path) {
        ArrayList<String> result = new ArrayList<String>();
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                result.addAll(SpecificParquetRecordReaderBase.listDirectory(f));
            }
        } else {
            char c = path.getName().charAt(0);
            if (c != '.' && c != '_') {
                result.add(path.getAbsolutePath());
            }
        }
        return result;
    }

    protected void initialize(String path, List<String> columns) throws IOException {
        Configuration config = new Configuration();
        config.setBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), false);
        config.setBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), false);
        this.file = new Path(path);
        long length = this.file.getFileSystem(config).getFileStatus(this.file).getLen();
        ParquetReadOptions options = HadoopReadOptions.builder((Configuration)config, (Path)this.file).withRange(0L, length).build();
        this.reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)config), (ParquetReadOptions)options);
        this.fileSchema = this.reader.getFooter().getFileMetaData().getSchema();
        if (columns == null) {
            this.requestedSchema = this.fileSchema;
        } else if (columns.size() > 0) {
            Types.MessageTypeBuilder builder = Types.buildMessage();
            for (String s : columns) {
                if (!this.fileSchema.containsField(s)) {
                    throw new IOException("Can only project existing columns. Unknown field: " + s + " File schema:\n" + this.fileSchema);
                }
                builder.addFields(new Type[]{this.fileSchema.getType(s)});
            }
            this.requestedSchema = builder.named(ParquetSchemaConverter.SPARK_PARQUET_SCHEMA_NAME());
        } else {
            this.requestedSchema = ParquetSchemaConverter.EMPTY_MESSAGE();
        }
        this.reader.setRequestedSchema(this.requestedSchema);
        this.sparkSchema = new ParquetToSparkSchemaConverter(config).convert(this.requestedSchema);
        this.totalRowCount = this.reader.getFilteredRecordCount();
    }

    public Void getCurrentKey() {
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashSet<V> set = new HashSet<V>();
            set.add(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }

    private Class<? extends ReadSupport<T>> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig((Configuration)configuration, (String)"parquet.read.support.class", ReadSupport.class);
    }

    private static <T> ReadSupport<T> getReadSupportInstance(Class<? extends ReadSupport<T>> readSupportClass) {
        try {
            return readSupportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadConfigurationException("could not instantiate read support class", (Throwable)e);
        }
    }
}

