/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.security.auth.login.Configuration;
import org.apache.spark.internal.Logging;
import org.apache.spark.security.SecurityConfigurationLock$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcConnectionProvider;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConnectionProvider$
implements Logging {
    public static final ConnectionProvider$ MODULE$ = new ConnectionProvider$();
    private static final Seq<JdbcConnectionProvider> providers;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        providers = MODULE$.loadProviders();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<JdbcConnectionProvider> providers() {
        return providers;
    }

    public Seq<JdbcConnectionProvider> loadProviders() {
        ServiceLoader<JdbcConnectionProvider> loader = ServiceLoader.load(JdbcConnectionProvider.class, Utils$.MODULE$.getContextOrSparkClassLoader());
        ArrayBuffer providers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterator<JdbcConnectionProvider> iterator = loader.iterator();
        while (iterator.hasNext()) {
            BoxedUnit boxedUnit;
            try {
                JdbcConnectionProvider provider = iterator.next();
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Loaded built-in provider: ").append(provider).toString());
                boxedUnit = providers.$plus$eq((Object)provider);
            }
            catch (Throwable t) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to load built-in provider.");
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Loading of the provider failed with the exception:", t);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        Seq disabledProviders = Utils$.MODULE$.stringToSeq(SQLConf$.MODULE$.get().disabledJdbcConnectionProviders());
        return ((IterableOnceOps)providers.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)disabledProviders.contains((Object)p.name())))).toSeq();
    }

    public Connection create(Driver driver, Map<String, String> options) {
        Connection connection;
        Seq filteredProviders = (Seq)this.providers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(driver, (Map<String, String>)options)));
        Predef$.MODULE$.require(filteredProviders.size() == 1, (Function0 & Serializable)() -> new StringBuilder(89).append("JDBC connection initiated but not exactly one connection provider found which can handle ").append(new StringBuilder(28).append("it. Found active providers: ").append(filteredProviders.mkString(", ")).toString()).toString());
        JdbcConnectionProvider selectedProvider = (JdbcConnectionProvider)filteredProviders.head();
        if (selectedProvider.modifiesSecurityContext(driver, options)) {
            SecurityConfigurationLock$ securityConfigurationLock$ = SecurityConfigurationLock$.MODULE$;
            synchronized (securityConfigurationLock$) {
                Connection connection2;
                Configuration parent = Configuration.getConfiguration();
                try {
                    connection2 = selectedProvider.getConnection(driver, options);
                }
                finally {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Restoring original security configuration");
                    Configuration.setConfiguration(parent);
                }
                Connection connection3 = connection2;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var5_5
                connection = connection3;
            }
        }
        connection = selectedProvider.getConnection(driver, options);
        return connection;
    }

    private ConnectionProvider$() {
    }
}

