/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AnsiCast;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CreateDataSourceTableAsSelectCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.InsertIntoDataSourceDirCommand;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSourceAnalysis$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InsertIntoDataSourceCommand;
import org.apache.spark.sql.execution.datasources.InsertIntoHadoopFsRelationCommand;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class DataSourceAnalysis$
extends Rule<LogicalPlan>
implements CastSupport {
    public static final DataSourceAnalysis$ MODULE$ = new DataSourceAnalysis$();

    static {
        CastSupport.$init$((CastSupport)MODULE$);
    }

    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$((CastSupport)this, (Expression)child, (DataType)dataType);
    }

    public Function2<String, String, Object> resolver() {
        return this.conf().resolver();
    }

    public Seq<NamedExpression> convertStaticPartitions(Seq<Attribute> sourceAttributes, Map<String, Option<String>> providedPartitions, Seq<Attribute> targetAttributes, StructType targetPartitionSchema) {
        Predef$.MODULE$.assert(providedPartitions.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataSourceAnalysis$.$anonfun$convertStaticPartitions$1(x$1))));
        Map staticPartitions = (Map)providedPartitions.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String partKey = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String partValue = (String)some.value();
                    Tuple2 tuple22 = new Tuple2((Object)partKey, (Object)partValue);
                    return package$.MODULE$.Nil().$colon$colon((Object)tuple22);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option option = (Option)tuple2._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            return package$.MODULE$.Nil();
        });
        if (staticPartitions.size() + sourceAttributes.size() != targetAttributes.size()) {
            throw QueryCompilationErrors$.MODULE$.insertMismatchedColumnNumberError(targetAttributes, sourceAttributes, staticPartitions.size());
        }
        if (providedPartitions.size() != ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields()))) {
            throw QueryCompilationErrors$.MODULE$.insertMismatchedPartitionNumberError(targetPartitionSchema, providedPartitions.size());
        }
        staticPartitions.foreach((Function1 & Serializable)x0$2 -> {
            DataSourceAnalysis$.$anonfun$convertStaticPartitions$3(targetPartitionSchema, x0$2);
            return BoxedUnit.UNIT;
        });
        Option[] partitionList = (Option[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields()), (Function1 & Serializable)field -> {
            None$ none$;
            Map potentialSpecs = (Map)staticPartitions.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)DataSourceAnalysis$.$anonfun$convertStaticPartitions$6(field, x0$3)));
            if (potentialSpecs.isEmpty()) {
                none$ = None$.MODULE$;
            } else if (potentialSpecs.size() == 1) {
                Some some;
                boolean bl;
                String partValue = (String)((Tuple2)potentialSpecs.head())._2();
                Enumeration.Value value = MODULE$.conf().storeAssignmentPolicy();
                Enumeration.Value value2 = SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value4 = SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
                    Enumeration.Value value5 = value;
                    bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
                }
                if (bl) {
                    AnsiCast x$1 = new AnsiCast((Expression)Literal$.MODULE$.apply((Object)partValue), field.dataType(), Option$.MODULE$.apply((Object)MODULE$.conf().sessionLocalTimeZone()));
                    String x$2 = field.name();
                    ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                    Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                    Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                    Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                    some = new Some((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6));
                } else {
                    Cast x$7 = MODULE$.cast((Expression)Literal$.MODULE$.apply((Object)partValue), field.dataType());
                    String x$8 = field.name();
                    ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
                    Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
                    Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
                    Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
                    some = new Some((Object)new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12));
                }
                none$ = some;
            } else {
                throw QueryCompilationErrors$.MODULE$.multiplePartitionColumnValuesSpecifiedError(field, potentialSpecs);
            }
            return none$;
        }, ClassTag$.MODULE$.apply(Option.class));
        ArrayOps$.MODULE$.collectFirst$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.refArrayOps((Object[])partitionList), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDefined()))), (PartialFunction)new Serializable(targetPartitionSchema){
            private static final long serialVersionUID = 0L;
            private final StructType targetPartitionSchema$1;

            public final <A1 extends Option<Alias>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    throw QueryCompilationErrors$.MODULE$.invalidOrderingForConstantValuePartitionColumnError(this.targetPartitionSchema$1);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Alias> x1) {
                Option<Alias> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
            {
                this.targetPartitionSchema$1 = targetPartitionSchema$1;
            }
        });
        Predef$.MODULE$.assert(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])partitionList), staticPartitions.size())), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDefined())));
        Seq projectList = (Seq)((IterableOps)((IterableOps)sourceAttributes.take(targetAttributes.size() - ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])partitionList), staticPartitions.size())), (Function1 & Serializable)x$4 -> (Alias)x$4.get(), ClassTag$.MODULE$.apply(Alias.class))))).$plus$plus((IterableOnce)sourceAttributes.takeRight(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())) - staticPartitions.size()));
        return projectList;
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                CreateTable createTable = null;
                boolean bl2 = false;
                InsertIntoStatement insertIntoStatement = null;
                A1 A1 = x1;
                if (A1 instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)A1;
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option<LogicalPlan> option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isDatasourceTable(tableDesc)) {
                        SaveMode saveMode = mode;
                        SaveMode saveMode2 = SaveMode.Ignore;
                        object = new CreateDataSourceTableCommand(tableDesc, !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)((Object)saveMode2)) : saveMode2 != null));
                        return (B1)object;
                    }
                }
                if (bl) {
                    Some some;
                    LogicalPlan query;
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option<LogicalPlan> option = createTable.query();
                    if (option instanceof Some && (query = (LogicalPlan)(some = (Some)option).value()).resolved() && DDLUtils$.MODULE$.isDatasourceTable(tableDesc)) {
                        object = new CreateDataSourceTableAsSelectCommand(tableDesc, mode, query, (Seq<String>)((Seq)query.output().map((Function1 & Serializable)x$5 -> x$5.name())));
                        return (B1)object;
                    }
                }
                if (A1 instanceof InsertIntoStatement) {
                    LogicalRelation logicalRelation;
                    bl2 = true;
                    insertIntoStatement = (InsertIntoStatement)A1;
                    LogicalPlan l = insertIntoStatement.table();
                    Map parts = insertIntoStatement.partitionSpec();
                    LogicalPlan query = insertIntoStatement.query();
                    boolean overwrite = insertIntoStatement.overwrite();
                    boolean bl3 = insertIntoStatement.ifPartitionNotExists();
                    if (l instanceof LogicalRelation && (logicalRelation = (LogicalRelation)l).relation() instanceof InsertableRelation && !bl3 && parts.isEmpty()) {
                        object = new InsertIntoDataSourceCommand(logicalRelation, query, overwrite);
                        return (B1)object;
                    }
                }
                if (A1 instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)A1;
                    CatalogStorageFormat storage = insertIntoDir.storage();
                    Option provider = insertIntoDir.provider();
                    LogicalPlan query = insertIntoDir.child();
                    boolean overwrite = insertIntoDir.overwrite();
                    if (query.resolved() && provider.isDefined()) {
                        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
                        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            Path outputPath = new Path((URI)storage.locationUri().get());
                            if (overwrite) {
                                DDLUtils$.MODULE$.verifyNotReadPath(query, outputPath);
                            }
                            object = new InsertIntoDataSourceDirCommand(storage, (String)provider.get(), query, overwrite);
                            return (B1)object;
                        }
                    }
                }
                if (bl2) {
                    LogicalPlan l = insertIntoStatement.table();
                    Map parts = insertIntoStatement.partitionSpec();
                    LogicalPlan query = insertIntoStatement.query();
                    boolean overwrite = insertIntoStatement.overwrite();
                    if (l instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)l;
                        BaseRelation t = logicalRelation.relation();
                        Option<CatalogTable> table = logicalRelation.catalogTable();
                        if (t instanceof HadoopFsRelation) {
                            LogicalPlan actualQuery;
                            LogicalPlan logicalPlan2;
                            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)t;
                            if (parts.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.1.$anonfun$applyOrElse$2(x$6)))) {
                                Seq<NamedExpression> projectList = DataSourceAnalysis$.MODULE$.convertStaticPartitions((Seq<Attribute>)query.output(), (Map<String, Option<String>>)parts, logicalRelation.output(), hadoopFsRelation.partitionSchema());
                                logicalPlan2 = new Project(projectList, query);
                            } else {
                                logicalPlan2 = actualQuery = query;
                            }
                            if (hadoopFsRelation.location().rootPaths().size() != 1) {
                                throw QueryCompilationErrors$.MODULE$.cannotWriteDataToRelationsWithMultiplePathsError();
                            }
                            Path outputPath = (Path)hadoopFsRelation.location().rootPaths().head();
                            SaveMode mode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
                            Seq partitionSchema = actualQuery.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
                            Map staticPartitions = (Map)((MapOps)parts.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.1.$anonfun$applyOrElse$3(x$7)))).map((Function1 & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                String k = (String)tuple2._1();
                                Option v = (Option)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.get());
                                return tuple22;
                            });
                            InsertIntoHadoopFsRelationCommand insertCommand = new InsertIntoHadoopFsRelationCommand(outputPath, (Map<String, String>)staticPartitions, insertIntoStatement.ifPartitionNotExists(), (Seq<Attribute>)partitionSchema, hadoopFsRelation.bucketSpec(), hadoopFsRelation.fileFormat(), hadoopFsRelation.options(), actualQuery, mode, table, (Option<FileIndex>)new Some((Object)hadoopFsRelation.location()), (Seq<String>)((Seq)actualQuery.output().map((Function1 & Serializable)x$8 -> x$8.name())));
                            if (overwrite && !insertCommand.dynamicPartitionOverwrite()) {
                                DDLUtils$.MODULE$.verifyNotReadPath(actualQuery, outputPath);
                            }
                            object = insertCommand;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                boolean bl = false;
                CreateTable createTable = null;
                boolean bl2 = false;
                InsertIntoStatement insertIntoStatement = null;
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)logicalPlan2;
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option<LogicalPlan> option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isDatasourceTable(tableDesc)) {
                        return true;
                    }
                }
                if (bl) {
                    Some some;
                    LogicalPlan query;
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option<LogicalPlan> option = createTable.query();
                    if (option instanceof Some && (query = (LogicalPlan)(some = (Some)option).value()).resolved() && DDLUtils$.MODULE$.isDatasourceTable(tableDesc)) {
                        return true;
                    }
                }
                if (logicalPlan2 instanceof InsertIntoStatement) {
                    LogicalRelation logicalRelation;
                    bl2 = true;
                    insertIntoStatement = (InsertIntoStatement)logicalPlan2;
                    LogicalPlan l = insertIntoStatement.table();
                    Map parts = insertIntoStatement.partitionSpec();
                    boolean bl3 = insertIntoStatement.ifPartitionNotExists();
                    if (l instanceof LogicalRelation && (logicalRelation = (LogicalRelation)l).relation() instanceof InsertableRelation && !bl3 && parts.isEmpty()) {
                        return true;
                    }
                }
                if (logicalPlan2 instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)logicalPlan2;
                    Option provider = insertIntoDir.provider();
                    LogicalPlan query = insertIntoDir.child();
                    if (query.resolved() && provider.isDefined()) {
                        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
                        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            return true;
                        }
                    }
                }
                if (!bl2) return false;
                LogicalPlan l = insertIntoStatement.table();
                if (!(l instanceof LogicalRelation)) return false;
                LogicalRelation logicalRelation = (LogicalRelation)l;
                BaseRelation t = logicalRelation.relation();
                if (!(t instanceof HadoopFsRelation)) return false;
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(Tuple2 x$6) {
                return ((Option)x$6._2()).isDefined();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(Tuple2 x$7) {
                return ((Option)x$7._2()).nonEmpty();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$2$adapted(scala.Tuple2 ), $anonfun$applyOrElse$3$adapted(scala.Tuple2 ), $anonfun$applyOrElse$4(scala.Tuple2 ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$convertStaticPartitions$1(Tuple2 x$1) {
        return ((Option)x$1._2()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$convertStaticPartitions$4(String partKey$1, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.resolver().apply((Object)field.name(), (Object)partKey$1));
    }

    public static final /* synthetic */ void $anonfun$convertStaticPartitions$3(StructType targetPartitionSchema$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String partKey = (String)tuple2._1();
            if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema$1.fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)DataSourceAnalysis$.$anonfun$convertStaticPartitions$4(partKey, field)))) {
                throw QueryCompilationErrors$.MODULE$.invalidPartitionColumnError(partKey, targetPartitionSchema$1);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$convertStaticPartitions$6(StructField field$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String partKey = (String)tuple2._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)MODULE$.resolver().apply((Object)field$1.name(), (Object)partKey));
        return bl;
    }

    private DataSourceAnalysis$() {
    }
}

