/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RepairTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001B\u0016-\u0001fB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00059\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\tI\u0001\u0001Q\u0001\nuD\u0001\"a\u0003\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003~\u0011!\ty\u0001\u0001b\u0001\n\u0003a\bbBA\t\u0001\u0001\u0006I! \u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002n\u0002!I!a<\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!\u0011\u0006\u0001\u0005\n\t-\u0002\"\u0003B\u001c\u0001\u0005\u0005I\u0011\u0001B\u001d\u0011%\u0011\u0019\u0005AI\u0001\n\u0003\u0011)\u0005C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^!I!\u0011\r\u0001\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005KB\u0001B!\u001b\u0001\u0003\u0003%\t\u0005 \u0005\n\u0005W\u0002\u0011\u0011!C\u0001\u0005[B\u0011Ba\u001c\u0001\u0003\u0003%\tA!\u001d\t\u0013\tu\u0004!!A\u0005B\t}\u0004\"\u0003BE\u0001\u0005\u0005I\u0011\u0001BF\u0011%\u0011y\tAA\u0001\n\u0003\u0012\t\nC\u0005\u0003\u0016\u0002\t\t\u0011\"\u0011\u0003\u0018\u001eI!1\u0014\u0017\u0002\u0002#\u0005!Q\u0014\u0004\tW1\n\t\u0011#\u0001\u0003 \"1Ao\tC\u0001\u0005oC\u0011B!/$\u0003\u0003%)Ea/\t\u0013\tu6%!A\u0005\u0002\n}\u0006\"\u0003BeGE\u0005I\u0011\u0001B3\u0011%\u0011YmIA\u0001\n\u0003\u0013i\rC\u0005\u0003`\u000e\n\n\u0011\"\u0001\u0003f!I!\u0011]\u0012\u0002\u0002\u0013%!1\u001d\u0002\u0013%\u0016\u0004\u0018-\u001b:UC\ndWmQ8n[\u0006tGM\u0003\u0002.]\u000591m\\7nC:$'BA\u00181\u0003%)\u00070Z2vi&|gN\u0003\u00022e\u0005\u00191/\u001d7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001u\u0011Ce\n\u0005\u0002<\u00056\tAH\u0003\u0002>}\u00059An\\4jG\u0006d'BA A\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0005'\u0001\u0005dCR\fG._:u\u0013\t\u0019EHA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA#G\u001b\u0005a\u0013BA$-\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u001d\u0001&o\u001c3vGR\u0004\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*9\u0003\u0019a$o\\8u}%\t1*\u0003\u0002W\u0015\u00069\u0001/Y2lC\u001e,\u0017B\u0001-Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t1&*A\u0005uC\ndWMT1nKV\tA\f\u0005\u0002^=6\t\u0001)\u0003\u0002`\u0001\nyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\n1#\u001a8bE2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N,\u0012a\u0019\t\u0003\u0013\u0012L!!\u001a&\u0003\u000f\t{w\u000e\\3b]\u0006!RM\\1cY\u0016\fE\r\u001a)beRLG/[8og\u0002\nA#\u001a8bE2,GI]8q!\u0006\u0014H/\u001b;j_:\u001c\u0018!F3oC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7\u000fI\u0001\u0004G6$W#A6\u0011\u00051\u0004hBA7o!\t\t&*\u0003\u0002p\u0015\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty'*\u0001\u0003d[\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003wobL(\u0010\u0005\u0002F\u0001!)!,\u0003a\u00019\")\u0011-\u0003a\u0001G\")q-\u0003a\u0001G\"9\u0011.\u0003I\u0001\u0002\u0004Y\u0017!\u0003(V\u001b~3\u0015\nT#T+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0003c~\f!BT+N?\u001aKE*R*!\u0003)!v\nV!M?NK%,R\u0001\f)>#\u0016\tT0T\u0013j+\u0005%\u0001\u0005E\t2{F+S'F\u0003%!E\tT0U\u00136+\u0005%A\u0007hKR\u0004\u0016\r\u001e5GS2$XM\u001d\u000b\u0005\u0003/\t9\u0003\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005\u0019\u001c(bAA\u0011i\u00051\u0001.\u00193p_BLA!!\n\u0002\u001c\tQ\u0001+\u0019;i\r&dG/\u001a:\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002 \u0005!1m\u001c8g\u0013\u0011\t)$a\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\r\u0011XO\u001c\u000b\u0005\u0003w\tI\u0005E\u0003P\u0003{\t\t%C\u0002\u0002@e\u00131aU3r!\u0011\t\u0019%!\u0012\u000e\u0003AJ1!a\u00121\u0005\r\u0011vn\u001e\u0005\u0007gE\u0001\r!a\u0013\u0011\t\u0005\r\u0013QJ\u0005\u0004\u0003\u001f\u0002$\u0001D*qCJ\\7+Z:tS>t\u0017AD:dC:\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u0003+\ny*!)\u0002*\u00065\u0016\u0011WA[\u0003w\u000b)-!8\u0011\r\u0005]\u00131MA5\u001d\u0011\tI&a\u0018\u000f\u0007A\u000bY&C\u0002\u0002^)\u000b!bY8mY\u0016\u001cG/[8o\u0013\r1\u0016\u0011\r\u0006\u0004\u0003;R\u0015\u0002BA3\u0003O\u0012aaR3o'\u0016\f(b\u0001,\u0002bA9\u0011*a\u001b\u0002p\u0005e\u0015bAA7\u0015\n1A+\u001e9mKJ\u0002B!!\u001d\u0002\u0014:!\u00111OAG\u001d\u0011\t)(!#\u000f\t\u0005]\u0014q\u0011\b\u0005\u0003s\n)I\u0004\u0003\u0002|\u0005\re\u0002BA?\u0003\u0003s1!UA@\u0013\u00059\u0014BA\u001b7\u0013\t\u0019D'\u0003\u00022e%\u0011\u0011\tM\u0005\u0004\u0003\u0017\u0003\u0015aB2bi\u0006dwnZ\u0005\u0005\u0003\u001f\u000b\t*\u0001\u0007DCR\fGn\\4UsB,7OC\u0002\u0002\f\u0002KA!!&\u0002\u0018\n\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\u0011\ty)!%\u0011\t\u0005e\u00111T\u0005\u0005\u0003;\u000bYB\u0001\u0003QCRD\u0007BB\u001a\u0013\u0001\u0004\tY\u0005C\u0004\u0002\u001eI\u0001\r!a)\u0011\t\u0005e\u0011QU\u0005\u0005\u0003O\u000bYB\u0001\u0006GS2,7+_:uK6Dq!a+\u0013\u0001\u0004\t9\"\u0001\u0004gS2$XM\u001d\u0005\b\u0003_\u0013\u0002\u0019AAM\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005M&\u00031\u0001\u0002p\u0005!1\u000f]3d\u0011\u001d\t9L\u0005a\u0001\u0003s\u000ba\u0002]1si&$\u0018n\u001c8OC6,7\u000f\u0005\u0003P\u0003{Y\u0007bBA_%\u0001\u0007\u0011qX\u0001\ni\"\u0014Xm\u001d5pY\u0012\u00042!SAa\u0013\r\t\u0019M\u0013\u0002\u0004\u0013:$\bbBAd%\u0001\u0007\u0011\u0011Z\u0001\te\u0016\u001cx\u000e\u001c<feB!\u00111ZAl\u001d\u0011\ti-a5\u000f\t\u0005U\u0014qZ\u0005\u0004\u0003#\u0004\u0015\u0001C1oC2L8/[:\n\u0007Y\u000b)NC\u0002\u0002R\u0002KA!!7\u0002\\\nA!+Z:pYZ,'OC\u0002W\u0003+Dq!a8\u0013\u0001\u0004\t\t/A\bfm\u0006dG+Y:l'V\u0004\bo\u001c:u!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(\u0002BAt\u0003C\n\u0001\u0002]1sC2dW\r\\\u0005\u0005\u0003W\f)OA\nG_J\\'j\\5o)\u0006\u001c8nU;qa>\u0014H/\u0001\u000bhCRDWM\u001d)beRLG/[8o'R\fGo\u001d\u000b\r\u0003c\fi0a@\u0003\u0004\t\u0015!\u0011\u0002\t\b\u0003/\n\u0019p[A|\u0013\u0011\t)0a\u001a\u0003\r\u001d+g.T1q!\r)\u0015\u0011`\u0005\u0004\u0003wd#a\u0005)beRLG/[8o'R\fG/[:uS\u000e\u001c\bBB\u001a\u0014\u0001\u0004\tY\u0005C\u0004\u0003\u0002M\u0001\r!!\u0016\u0002+A\f'\u000f^5uS>t7\u000b]3dg\u0006sG\rT8dg\"9\u0011QD\nA\u0002\u0005\r\u0006b\u0002B\u0004'\u0001\u0007\u0011qC\u0001\u000ba\u0006$\bNR5mi\u0016\u0014\bbBA_'\u0001\u0007\u0011qX\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u0015\t=!Q\u0003B\f\u0005G\u0011)\u0003E\u0002J\u0005#I1Aa\u0005K\u0005\u0011)f.\u001b;\t\rM\"\u0002\u0019AA&\u0011\u001d\u0011I\u0002\u0006a\u0001\u00057\tQ\u0001^1cY\u0016\u0004BA!\b\u0003 5\u0011\u0011\u0011S\u0005\u0005\u0005C\t\tJ\u0001\u0007DCR\fGn\\4UC\ndW\rC\u0004\u0003\u0002Q\u0001\r!!\u0016\t\u000f\t\u001dB\u00031\u0001\u0002r\u0006q\u0001/\u0019:uSRLwN\\*uCR\u001c\u0018A\u00043s_B\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003\u007f\u0013iC!\u000e\t\u000f\u0005-U\u00031\u0001\u00030A!!Q\u0004B\u0019\u0013\u0011\u0011\u0019$!%\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\"9\u0011QD\u000bA\u0002\u0005\r\u0016\u0001B2paf$\u0012B\u001eB\u001e\u0005{\u0011yD!\u0011\t\u000fi3\u0002\u0013!a\u00019\"9\u0011M\u0006I\u0001\u0002\u0004\u0019\u0007bB4\u0017!\u0003\u0005\ra\u0019\u0005\bSZ\u0001\n\u00111\u0001l\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0012+\u0007q\u0013Ie\u000b\u0002\u0003LA!!Q\nB,\u001b\t\u0011yE\u0003\u0003\u0003R\tM\u0013!C;oG\",7m[3e\u0015\r\u0011)FS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B-\u0005\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0018+\u0007\r\u0014I%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\r\u0016\u0004W\n%\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002@\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B:\u0005s\u00022!\u0013B;\u0013\r\u00119H\u0013\u0002\u0004\u0003:L\b\"\u0003B>;\u0005\u0005\t\u0019AA`\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0011\t\u0007\u0005\u0007\u0013)Ia\u001d\u000e\u0005\u0005\u0005\u0014\u0002\u0002BD\u0003C\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191M!$\t\u0013\tmt$!AA\u0002\tM\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2! BJ\u0011%\u0011Y\bIA\u0001\u0002\u0004\ty,\u0001\u0004fcV\fGn\u001d\u000b\u0004G\ne\u0005\"\u0003B>C\u0005\u0005\t\u0019\u0001B:\u0003I\u0011V\r]1jeR\u000b'\r\\3D_6l\u0017M\u001c3\u0011\u0005\u0015\u001b3#B\u0012\u0003\"\n5\u0006#\u0003BR\u0005Sc6mY6w\u001b\t\u0011)KC\u0002\u0003(*\u000bqA];oi&lW-\u0003\u0003\u0003,\n\u0015&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!q\u0016B[\u001b\t\u0011\tL\u0003\u0003\u00034\u0006\r\u0011AA5p\u0013\rA&\u0011\u0017\u000b\u0003\u0005;\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002{\u0006)\u0011\r\u001d9msRIaO!1\u0003D\n\u0015'q\u0019\u0005\u00065\u001a\u0002\r\u0001\u0018\u0005\u0006C\u001a\u0002\ra\u0019\u0005\u0006O\u001a\u0002\ra\u0019\u0005\bS\u001a\u0002\n\u00111\u0001l\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001f\u0014Y\u000eE\u0003J\u0005#\u0014).C\u0002\u0003T*\u0013aa\u00149uS>t\u0007cB%\u0003Xr\u001b7m[\u0005\u0004\u00053T%A\u0002+va2,G\u0007\u0003\u0005\u0003^\"\n\t\u00111\u0001w\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0015\bc\u0001@\u0003h&\u0019!\u0011^@\u0003\r=\u0013'.Z2u\u0001")
public class RepairTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private scala.collection.immutable.Map<String, SQLMetric> metrics;
    private scala.collection.immutable.Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RepairTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairTableCommand repairTableCommand) {
        return RepairTableCommand$.MODULE$.unapply(repairTableCommand);
    }

    public static String apply$default$4() {
        return RepairTableCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairTableCommand> tupled() {
        return RepairTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairTableCommand>>>> curried() {
        return RepairTableCommand$.MODULE$.curried();
    }

    @Override
    public final scala.collection.immutable.Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public scala.collection.immutable.Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private scala.collection.immutable.Map<String, SQLMetric> metrics$lzycompute() {
        RepairTableCommand repairTableCommand = this;
        synchronized (repairTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public scala.collection.immutable.Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final scala.collection.immutable.Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(scala.collection.immutable.Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return path -> {
            String name;
            String string = name = path.getName();
            String string2 = "_SUCCESS";
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = name;
            String string4 = "_temporary";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (name.startsWith(".")) return false;
            if (pathFilter == null) return true;
            if (!pathFilter.accept(path)) return false;
            return true;
        };
    }

    @Override
    public scala.collection.immutable.Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnPartitionedTablesError(this.cmd(), tableIdentWithDB);
        }
        if (table.storage().locationUri().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnTableWithLocationError(this.cmd(), tableIdentWithDB);
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, fs) : 0;
        if (this.enableAddPartitions()) {
            Seq seq;
            int threshold = BoxesRunTime.unboxToInt((Object)spark.sparkContext().conf().get(org.apache.spark.internal.config.package$.MODULE$.RDD_PARALLEL_LISTING_THRESHOLD()));
            PathFilter pathFilter = this.getPathFilter(hadoopConf);
            ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("RepairTableCommand", 8);
            try {
                seq = (Seq)this.scanPartitions(spark, fs, pathFilter, root, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
            }
            finally {
                evalPool.shutdown();
            }
            Seq partitionSpecsAndLocs = seq;
            int total = partitionSpecsAndLocs.length();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(21).append("Found ").append(total).append(" partitions in ").append(root).toString());
            Map<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : (Map<String, PartitionStatistics>)scala.collection.package$.MODULE$.GenMap().empty();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
            this.addPartitions(spark, table, (Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$1 = true;
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        scala.collection.immutable.Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        scala.collection.immutable.Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        scala.collection.immutable.Seq x$17 = table.copy$default$16();
        boolean x$18 = table.copy$default$18();
        scala.collection.immutable.Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        spark.sessionState().catalog().alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, true, x$18, x$19, x$20));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0 & Serializable)() -> new StringBuilder(183).append(new StringBuilder(50).append("Cannot refresh the table '").append(tableIdentWithDB).append("'. A query of the table ").toString()).append("might return wrong result if the table was cached. To avoid such issue, you should ").append("uncache the table manually via the UNCACHE TABLE command after table recovering will ").append("complete fully.").toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(47).append("Recovered all partitions: added (").append(addedAmount).append("), dropped (").append(droppedAmount).append(").").toString());
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, scala.collection.immutable.Map<String, String> spec, scala.collection.immutable.Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        ArraySeq.ofRef ofRef2;
        if (partitionNames.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParVector parArray = new ParVector(Predef$.MODULE$.wrapRefArray((Object[])statuses).toVector());
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            ofRef2 = parArray.seq();
        } else {
            ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        ArraySeq.ofRef statusPar = ofRef2;
        return (Seq)statusPar.flatMap((Function1 & Serializable)st -> {
            Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>> seq;
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    seq = this.scanPartitions(spark, fs, filter, st.getPath(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)spec.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)})))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                } else {
                    this.logWarning((Function0 & Serializable)() -> new StringBuilder(49).append("expected partition column ").append(partitionNames.head()).append(", but got ").append(ps[0]).append(", ignoring it").toString());
                    seq = package$.MODULE$.Seq().empty();
                }
            } else {
                this.logWarning((Function0 & Serializable)() -> new StringBuilder(7).append("ignore ").append(new Path(path, name)).toString());
                seq = package$.MODULE$.Seq().empty();
            }
            return seq;
        });
    }

    private Map<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        scala.collection.immutable.Map map;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((IterableOnceOps)partitionSpecsAndLocs.map((Function1 & Serializable)x$2 -> ((Path)x$2._2()).toString())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(47).append("Gather the fast stats in parallel using ").append(numParallelism).append(" tasks.").toString());
            RDD qual$1 = spark.sparkContext().parallelize((scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable x$1 = (Function1 & Serializable)paths -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return paths.map((Function1 & Serializable)x$3 -> new Path(x$3)).map((Function1 & Serializable)path -> {
                    FileSystem fs = path.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(path, pathFilter);
                    return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$22 = qual$1.mapPartitions$default$2();
            map = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$1, x$22, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            map = ((IterableOnceOps)partitionSpecsAndLocs.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                return tuple22;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return map;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, Seq<Tuple2<scala.collection.immutable.Map<String, String>, Path>> partitionSpecsAndLocs, Map<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = BoxesRunTime.unboxToInt(spark.conf().get(SQLConf$.MODULE$.ADD_PARTITION_BATCH_SIZE()));
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1 & Serializable)batch -> {
            RepairTableCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    private int dropPartitions(SessionCatalog catalog, FileSystem fs) {
        scala.collection.immutable.Seq dropPartSpecs = (scala.collection.immutable.Seq)ThreadUtils$.MODULE$.parmap(catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1 & Serializable)partition -> partition.storage().locationUri().flatMap((Function1 & Serializable)uri -> fs.exists(new Path(uri)) ? None$.MODULE$ : new Some((Object)partition.spec()))).flatten(Predef$.MODULE$.$conforms());
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
                break;
            }
            case 3: {
                object = this.cmd();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "enableAddPartitions";
                break;
            }
            case 2: {
                string = "enableDropPartitions";
                break;
            }
            case 3: {
                string = "cmd";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairTableCommand repairTableCommand = (RepairTableCommand)x$1;
        if (this.enableAddPartitions() != repairTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairTableCommand.enableDropPartitions()) return false;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = repairTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(RepairTableCommand $this, Map partitionStats$1, CatalogTable table$6, SparkSession spark$2, LongRef done$1, int total$2, scala.collection.immutable.Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        scala.collection.immutable.Seq parts = (scala.collection.immutable.Seq)batch.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map spec = (scala.collection.immutable.Map)tuple2._1();
            Path location = (Path)tuple2._2();
            scala.collection.immutable.Map params = (scala.collection.immutable.Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable)x0$2 -> {
                PartitionStatistics partitionStatistics = x0$2;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)Integer.toString(numFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)Long.toString(totalSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)Long.toString(now))}));
                return map;
            }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$6.storage().copy((Option)new Some((Object)location.toUri()), table$6.storage().copy$default$2(), table$6.storage().copy$default$3(), table$6.storage().copy$default$4(), table$6.storage().copy$default$5(), table$6.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        });
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public RepairTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
        Statics.releaseFence();
    }
}

