/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class DDLUtils$
implements Logging {
    public static final DDLUtils$ MODULE$ = new DDLUtils$();
    private static final String HIVE_PROVIDER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        HIVE_PROVIDER = "hive";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String HIVE_PROVIDER() {
        return HIVE_PROVIDER;
    }

    public boolean isHiveTable(CatalogTable table) {
        return this.isHiveTable((Option<String>)table.provider());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHiveTable(Option<String> provider) {
        if (!provider.isDefined()) return false;
        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        if (!table.provider().isDefined()) return false;
        String string = ((String)table.provider().get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public HiveTableRelation readHiveTable(CatalogTable table) {
        return new HiveTableRelation(table, table.dataSchema().asNullable().toAttributes(), table.partitionSchema().asNullable().toAttributes(), HiveTableRelation$.MODULE$.apply$default$4(), HiveTableRelation$.MODULE$.apply$default$5());
    }

    public void verifyPartitionProviderIsHive(SparkSession spark, CatalogTable table, String action) {
        String tableName = table.identifier().table();
        if (!spark.sqlContext().conf().manageFilesourcePartitions() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableWithFilesourcePartitionManagementDisabledError(action, tableName);
        }
        if (!table.tracksPartitionsInCatalog() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableSincePartitionMetadataNotStoredError(action, tableName);
        }
    }

    public void verifyAlterTableType(SessionCatalog catalog, CatalogTable tableMetadata, boolean isView) {
        block2: {
            if (catalog.isTempView(tableMetadata.identifier())) break block2;
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterViewWithAlterTableError();
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterTableWithAlterViewError();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkDataColNames(CatalogTable table) {
        this.checkDataColNames(table, table.dataSchema());
    }

    public void checkDataColNames(CatalogTable table, StructType schema) {
        table.provider().foreach((Function1 & Serializable)x$6 -> {
            DDLUtils$.$anonfun$checkDataColNames$1(table, schema, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void checkDataColNames(String provider, StructType schema) {
        Object source;
        Object obj;
        try {
            obj = DataSource$.MODULE$.lookupDataSource(provider, SQLConf$.MODULE$.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Failed to find data source: ").append(provider).append(" when check data column names.").toString(), e);
            return;
        }
        Object obj2 = source = obj;
        if (obj2 instanceof FileFormat) {
            FileFormat fileFormat = (FileFormat)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileFormat, schema);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (obj2 instanceof FileDataSourceV2) {
            FileDataSourceV2 fileDataSourceV2 = (FileDataSourceV2)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileDataSourceV2.fallbackFileFormat().newInstance(), schema);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void verifyNotReadPath(LogicalPlan query, Path outputPath) {
        Seq inputPaths = (Seq)query.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Seq<Path> seq;
                LogicalRelation logicalRelation;
                BaseRelation r;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)r;
                    seq = hadoopFsRelation.location().rootPaths();
                } else {
                    seq = function1.apply(x1);
                }
                return (B1)seq;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof HadoopFsRelation;
                return bl;
            }
        }).flatten(Predef$.MODULE$.$conforms());
        if (inputPaths.contains((Object)outputPath)) {
            throw QueryCompilationErrors$.MODULE$.cannotOverwritePathBeingReadFromError();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$checkDataColNames$1(CatalogTable table$7, StructType schema$2, String x$6) {
        block13: {
            block10: {
                block12: {
                    block11: {
                        var4_3 = x$6.toLowerCase(Locale.ROOT);
                        v0 = DDLUtils$.MODULE$.HIVE_PROVIDER();
                        var5_4 = var4_3;
                        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) break block10;
                        v1 = serde = table$7.storage().serde();
                        var7_6 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("orc").get()).serde();
                        if (v1 != null ? v1.equals(var7_6) == false : var7_6 != null) break block11;
                        DDLUtils$.MODULE$.checkDataColNames("orc", schema$2);
                        v2 = BoxedUnit.UNIT;
                        break block12;
                    }
                    v3 = serde;
                    var8_7 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("parquet").get()).serde();
                    if (!(v3 == null ? var8_7 != null : v3.equals(var8_7) == false)) ** GOTO lbl-1000
                    v4 = serde;
                    var9_8 = new Some((Object)"parquet.hive.serde.ParquetHiveSerDe");
                    if (!(v4 == null ? var9_8 != null : v4.equals(var9_8) == false)) ** GOTO lbl-1000
                    v5 = serde;
                    var10_9 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                    if (!(v5 != null ? v5.equals(var10_9) == false : var10_9 != null)) lbl-1000:
                    // 3 sources

                    {
                        DDLUtils$.MODULE$.checkDataColNames("parquet", schema$2);
                        v2 = BoxedUnit.UNIT;
                    } else {
                        v6 = serde;
                        var11_10 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("avro").get()).serde();
                        if (!(v6 != null ? v6.equals(var11_10) == false : var11_10 != null)) {
                            DDLUtils$.MODULE$.checkDataColNames("avro", schema$2);
                            v2 = BoxedUnit.UNIT;
                        } else {
                            v2 = BoxedUnit.UNIT;
                        }
                    }
                }
                var3_11 = v2;
                break block13;
            }
            if ("parquet".equals(var4_3)) {
                DDLUtils$.MODULE$.checkDataColNames("parquet", schema$2);
                var3_12 = BoxedUnit.UNIT;
            } else if ("orc".equals(var4_3)) {
                DDLUtils$.MODULE$.checkDataColNames("orc", schema$2);
                var3_13 = BoxedUnit.UNIT;
            } else if ("avro".equals(var4_3)) {
                DDLUtils$.MODULE$.checkDataColNames("avro", schema$2);
                var3_14 = BoxedUnit.UNIT;
            } else {
                var3_15 = BoxedUnit.UNIT;
            }
        }
    }

    private DDLUtils$() {
    }
}

