/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}wAB\u001f?\u0011\u0003\u0003EJ\u0002\u0004O}!\u0005\u0005i\u0014\u0005\u0006S\u0006!\tA\u001b\u0005\bW\u0006\u0011\r\u0011\"\u0011m\u0011\u0019\u0001\u0018\u0001)A\u0005[\")\u0011/\u0001C!e\"9\u00111T\u0001\u0005B\u0005u\u0005b\u0002BB\u0003\u0011\u0005#Q\u0011\u0004\u0005m\u0006\u0001q\u000f\u0003\u0006\u0002\u0014!\u0011\t\u0011)A\u0005\u0003+Aa!\u001b\u0005\u0005\u0002\u0005u\u0001\u0002CA\u0012\u0011\u0001\u0007I\u0011\u00027\t\u0013\u0005\u0015\u0002\u00021A\u0005\n\u0005\u001d\u0002bBA\u001a\u0011\u0001\u0006K!\u001c\u0005\t\u0003kA\u0001\u0019!C\u0005Y\"I\u0011q\u0007\u0005A\u0002\u0013%\u0011\u0011\b\u0005\b\u0003{A\u0001\u0015)\u0003n\u0011-\ty\u0004\u0003a\u0001\u0002\u0004%I!!\u0011\t\u0017\u0005%\u0003\u00021AA\u0002\u0013%\u00111\n\u0005\f\u0003\u001fB\u0001\u0019!A!B\u0013\t\u0019\u0005\u0003\u0005\u0002R!\u0001\r\u0011\"\u0003m\u0011%\t\u0019\u0006\u0003a\u0001\n\u0013\t)\u0006C\u0004\u0002Z!\u0001\u000b\u0015B7\t\r\u0005m\u0003\u0002\"\u0011m\u0011\u0019\ti\u0006\u0003C!Y\"9\u0011q\f\u0005\u0005B\u0005\u0005\u0004bBA<\u0011\u0011\u0005\u0013\u0011\u0010\u0004\u0007\u0003G\u000b\u0001!!*\t\u0015\u0005E6D!A!\u0002\u0013\tY\b\u0003\u0006\u0002\u0014m\u0011\t\u0011)A\u0005\u0003gCa![\u000e\u0005\u0002\u0005U\u0006\u0002CA_7\u0001\u0007I\u0011\u00027\t\u0013\u0005}6\u00041A\u0005\n\u0005\u0005\u0007bBAc7\u0001\u0006K!\u001c\u0005\t\u0003\u000f\\\u0002\u0019!C\u0005Y\"I\u0011\u0011Z\u000eA\u0002\u0013%\u00111\u001a\u0005\b\u0003\u001f\\\u0002\u0015)\u0003n\u0011-\t\tn\u0007a\u0001\u0002\u0004%I!a5\t\u0017\u0005]7\u00041AA\u0002\u0013%\u0011\u0011\u001c\u0005\f\u0003;\\\u0002\u0019!A!B\u0013\t)\u000eC\u0004\u0002`n!\t%!9\t\u000f\u0005\u001d8\u0004\"\u0011\u0002j\"9\u0011\u0011_\u000e\u0005\n\u0005M\bb\u0002B\n7\u0011%!Q\u0003\u0005\b\u00053YB\u0011\u0002B\u000e\u0011\u001d\u0011\u0019c\u0007C\u0005\u0005KAqA!\u000b\u001c\t\u0013\u0011Y\u0003C\u0004\u00034m!IA!\u000e\t\u000f\te2\u0004\"\u0003\u0003<!9!1I\u000e\u0005\n\t\u0015\u0003b\u0002B%7\u0011%!1\n\u0005\b\u0005'ZB\u0011\u0002B+\u0011\u001d\u0011\th\u0007C!\u0005gB\u0011Ba(\u0002\u0003\u0003%\tE!)\t\u0011\t=\u0016!!A\u0005\u00021D\u0011B!-\u0002\u0003\u0003%\tAa-\t\u0013\t]\u0016!!A\u0005B\te\u0006\"\u0003Bd\u0003\u0005\u0005I\u0011\u0001Be\u0011%\u0011i-AA\u0001\n\u0003\u0012y\rC\u0005\u0003R\u0006\t\t\u0011\"\u0011\u0003T\"I!Q[\u0001\u0002\u0002\u0013%!q[\u0001\u0012%VtG*\u001a8hi\",enY8eS:<'BA A\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005\u0005\u0013\u0015\u0001C2pYVlg.\u0019:\u000b\u0005\r#\u0015!C3yK\u000e,H/[8o\u0015\t)e)A\u0002tc2T!a\u0012%\u0002\u000bM\u0004\u0018M]6\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'o\u001a\t\u0003\u001b\u0006i\u0011A\u0010\u0002\u0012%VtG*\u001a8hi\",enY8eS:<7#B\u0001Q-fc\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g\r\u0005\u0002N/&\u0011\u0001L\u0010\u0002\u0012\u0007>l\u0007O]3tg&|gnU2iK6,\u0007CA)[\u0013\tY&KA\u0004Qe>$Wo\u0019;\u0011\u0005u3gB\u00010e\u001d\ty6-D\u0001a\u0015\t\t'-\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005\u0019\u0016BA3S\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001a5\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0015\u0014\u0016A\u0002\u001fj]&$h\bF\u0001M\u0003\u0019!\u0018\u0010]3JIV\tQ\u000e\u0005\u0002R]&\u0011qN\u0015\u0002\u0004\u0013:$\u0018a\u0002;za\u0016LE\rI\u0001\bK:\u001cw\u000eZ3s+\r\u0019\u0018Q\u0013\u000b\u0004i\u0006]\u0005\u0003B;\t\u0003'k\u0011!\u0001\u0002\b\u000b:\u001cw\u000eZ3s+\tAXpE\u0002\t!f\u00042!\u0014>|\u0013\t1h\b\u0005\u0002}{2\u0001A!\u0002@\t\u0005\u0004y(!\u0001+\u0012\t\u0005\u0005\u0011q\u0001\t\u0004#\u0006\r\u0011bAA\u0003%\n9aj\u001c;iS:<\u0007\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A)A\u0003usB,7/\u0003\u0003\u0002\u0012\u0005-!AC!u_6L7\rV=qK\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u000b\u0005]\u0011\u0011D>\u000e\u0003\u0001K1!a\u0007A\u0005Aq\u0015\r^5wK\u000e{G.^7o)f\u0004X\r\u0006\u0003\u0002 \u0005\u0005\u0002cA;\tw\"9\u00111\u0003\u0006A\u0002\u0005U\u0011!E0v]\u000e|W\u000e\u001d:fgN,GmU5{K\u0006)r,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3`I\u0015\fH\u0003BA\u0015\u0003_\u00012!UA\u0016\u0013\r\tiC\u0015\u0002\u0005+:LG\u000f\u0003\u0005\u000221\t\t\u00111\u0001n\u0003\rAH%M\u0001\u0013?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,\u0007%A\b`G>l\u0007O]3tg\u0016$7+\u001b>f\u0003My6m\\7qe\u0016\u001c8/\u001a3TSj,w\fJ3r)\u0011\tI#a\u000f\t\u0011\u0005Er\"!AA\u00025\f\u0001cX2p[B\u0014Xm]:fINK'0\u001a\u0011\u0002\u00131\f7\u000f\u001e,bYV,WCAA\"!\rY\u0018QI\u0005\u0005\u0003\u000f\nyA\u0001\u0007J]R,'O\\1m)f\u0004X-A\u0007mCN$h+\u00197vK~#S-\u001d\u000b\u0005\u0003S\ti\u0005C\u0005\u00022I\t\t\u00111\u0001\u0002D\u0005QA.Y:u-\u0006dW/\u001a\u0011\u0002\u000f1\f7\u000f\u001e*v]\u0006YA.Y:u%Vtw\fJ3r)\u0011\tI#a\u0016\t\u0011\u0005ER#!AA\u00025\f\u0001\u0002\\1tiJ+h\u000eI\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fabY8naJ,7o]3e'&TX-\u0001\u000ehCRDWM]\"p[B\u0014Xm]:jE&d\u0017\u000e^=Ti\u0006$8\u000f\u0006\u0004\u0002*\u0005\r\u00141\u000f\u0005\b\u0003KJ\u0002\u0019AA4\u0003\r\u0011xn\u001e\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e#\u0002\u0011\r\fG/\u00197zgRLA!!\u001d\u0002l\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\t)(\u0007a\u0001[\u00069qN\u001d3j]\u0006d\u0017\u0001C2p[B\u0014Xm]:\u0015\r\u0005m\u00141RAH!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b1A\\5p\u0015\t\t))\u0001\u0003kCZ\f\u0017\u0002BAE\u0003\u007f\u0012!BQ=uK\n+hMZ3s\u0011\u001d\tiI\u0007a\u0001\u0003w\nAA\u001a:p[\"9\u0011\u0011\u0013\u000eA\u0002\u0005m\u0014A\u0001;p!\ra\u0018Q\u0013\u0003\u0006}\u0016\u0011\ra \u0005\b\u0003')\u0001\u0019AAM!\u0019\t9\"!\u0007\u0002\u0014\u00069A-Z2pI\u0016\u0014X\u0003BAP\u0005w\"b!!)\u0003~\t}\u0004\u0003B;\u001c\u0005s\u0012q\u0001R3d_\u0012,'/\u0006\u0003\u0002(\u0006=6\u0003B\u000eQ\u0003S\u0003R!TAV\u0003[K1!a)?!\ra\u0018q\u0016\u0003\u0006}n\u0011\ra`\u0001\u0007EV4g-\u001a:\u0011\r\u0005]\u0011\u0011DAW)\u0019\t9,!/\u0002<B!QoGAW\u0011\u001d\t\tL\ba\u0001\u0003wBq!a\u0005\u001f\u0001\u0004\t\u0019,A\u0002sk:\fqA];o?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005\r\u0007\u0002CA\u0019A\u0005\u0005\t\u0019A7\u0002\tI,h\u000eI\u0001\u000bm\u0006dW/Z\"pk:$\u0018A\u0004<bYV,7i\\;oi~#S-\u001d\u000b\u0005\u0003S\ti\r\u0003\u0005\u00022\r\n\t\u00111\u0001n\u0003-1\u0018\r\\;f\u0007>,h\u000e\u001e\u0011\u0002\u0019\r,(O]3oiZ\u000bG.^3\u0016\u0005\u0005U\u0007\u0003BAW\u0003\u000b\n\u0001cY;se\u0016tGOV1mk\u0016|F%Z9\u0015\t\u0005%\u00121\u001c\u0005\n\u0003c1\u0013\u0011!a\u0001\u0003+\fQbY;se\u0016tGOV1mk\u0016\u0004\u0013\u0001\u00028fqR$b!!\u000b\u0002d\u0006\u0015\bbBA3Q\u0001\u0007\u0011q\r\u0005\u0007\u0003kB\u0003\u0019A7\u0002\u000f!\f7OT3yiV\u0011\u00111\u001e\t\u0004#\u00065\u0018bAAx%\n9!i\\8mK\u0006t\u0017A\u00039vi\n{w\u000e\\3b]RA\u0011\u0011FA{\u0005\u000b\u0011I\u0001C\u0004\u0002x*\u0002\r!!?\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@C\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u0005\u0007\tiP\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\u0007\u0005\u000fQ\u0003\u0019A7\u0002\u0007A|7\u000fC\u0004\u0003\f)\u0002\rA!\u0004\u0002\u000bY\fG.^3\u0011\u0007E\u0013y!C\u0002\u0003\u0012I\u0013A\u0001T8oO\u00069q-\u001a;CsR,G\u0003\u0002B\u0007\u0005/Aq!!-,\u0001\u0004\tY(A\u0004qkR\u0014\u0015\u0010^3\u0015\u0011\u0005%\"Q\u0004B\u0010\u0005CAq!a>-\u0001\u0004\tI\u0010\u0003\u0004\u0003\b1\u0002\r!\u001c\u0005\b\u0005\u0017a\u0003\u0019\u0001B\u0007\u0003!9W\r^*i_J$H\u0003\u0002B\u0007\u0005OAq!!-.\u0001\u0004\tY(\u0001\u0005qkR\u001c\u0006n\u001c:u)!\tIC!\f\u00030\tE\u0002bBA|]\u0001\u0007\u0011\u0011 \u0005\u0007\u0005\u000fq\u0003\u0019A7\t\u000f\t-a\u00061\u0001\u0003\u000e\u00051q-\u001a;J]R$BA!\u0004\u00038!9\u0011\u0011W\u0018A\u0002\u0005m\u0014A\u00029vi&sG\u000f\u0006\u0005\u0002*\tu\"q\bB!\u0011\u001d\t9\u0010\ra\u0001\u0003sDaAa\u00021\u0001\u0004i\u0007b\u0002B\u0006a\u0001\u0007!QB\u0001\bO\u0016$Hj\u001c8h)\u0011\u0011iAa\u0012\t\u000f\u0005E\u0016\u00071\u0001\u0002|\u00059\u0001/\u001e;M_:<G\u0003CA\u0015\u0005\u001b\u0012yE!\u0015\t\u000f\u0005](\u00071\u0001\u0002z\"1!q\u0001\u001aA\u00025DqAa\u00033\u0001\u0004\u0011i!A\u0006eK\u000e|W\u000e\u001d:fgN\u0004DCCA\u0015\u0005/\u0012IF!\u0018\u0003h!9\u0011q_\u001aA\u0002\u0005e\bB\u0002B.g\u0001\u0007Q.\u0001\u0005dCB\f7-\u001b;z\u0011\u001d\u0011yf\ra\u0001\u0005C\n1bZ3u\rVt7\r^5p]B9\u0011Ka\u0019\u0002|\t5\u0011b\u0001B3%\nIa)\u001e8di&|g.\r\u0005\b\u0005S\u001a\u0004\u0019\u0001B6\u0003-\u0001X\u000f\u001e$v]\u000e$\u0018n\u001c8\u0011\u0015E\u0013i'!?n\u0005\u001b\tI#C\u0002\u0003pI\u0013\u0011BR;oGRLwN\\\u001a\u0002\u0015\u0011,7m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0002*\tU$q\u000f\u0005\b\u0003o$\u0004\u0019AA}\u0011\u0019\u0011Y\u0006\u000ea\u0001[B\u0019APa\u001f\u0005\u000by4!\u0019A@\t\u000f\u0005Ef\u00011\u0001\u0002|!9\u00111\u0003\u0004A\u0002\t\u0005\u0005CBA\f\u00033\u0011I(\u0001\u0005tkB\u0004xN\u001d;t)\u0011\tYOa\"\t\u000f\u0005Mq\u00011\u0001\u0003\nB\"!1\u0012BJ!\u0019\t9B!$\u0003\u0012&\u0019!q\u0012!\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002}\u0005'#AB!&\u0003\b\u0006\u0005\t\u0011!B\u0001\u0005/\u00131a\u0018\u00133#\u0011\t\tA!'\u0011\u0007E\u0013Y*C\u0002\u0003\u001eJ\u00131!\u00118z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0015\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*!!\u0011VAB\u0003\u0011a\u0017M\\4\n\t\t5&q\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0014B[\u0011!\t\tdNA\u0001\u0002\u0004i\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0006C\u0002B_\u0005\u0007\u0014I*\u0004\u0002\u0003@*\u0019!\u0011\u0019*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003F\n}&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a;\u0003L\"I\u0011\u0011G\u001d\u0002\u0002\u0003\u0007!\u0011T\u0001\tQ\u0006\u001c\bnQ8eKR\tQ.\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019+\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003ZB!!Q\u0015Bn\u0013\u0011\u0011iNa*\u0003\r=\u0013'.Z2u\u0001")
public final class RunLengthEncoding {
    public static String toString() {
        return RunLengthEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RunLengthEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RunLengthEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RunLengthEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RunLengthEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RunLengthEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RunLengthEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return RunLengthEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static int typeId() {
        return RunLengthEncoding$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return RunLengthEncoding$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return RunLengthEncoding$.MODULE$.productElementName(n);
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private int run;
        private int valueCount;
        private Object currentValue;

        private int run() {
            return this.run;
        }

        private void run_$eq(int x$1) {
            this.run = x$1;
        }

        private int valueCount() {
            return this.valueCount;
        }

        private void valueCount_$eq(int x$1) {
            this.valueCount = x$1;
        }

        private Object currentValue() {
            return this.currentValue;
        }

        private void currentValue_$eq(Object x$1) {
            this.currentValue = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            if (this.valueCount() == this.run()) {
                this.currentValue_$eq(this.columnType.extract(this.buffer));
                this.run_$eq(ByteBufferHelper$.MODULE$.getInt(this.buffer));
                this.valueCount_$eq(1);
            } else {
                this.valueCount_$eq(this.valueCount() + 1);
            }
            this.columnType.setField(row, ordinal, this.currentValue());
        }

        @Override
        public boolean hasNext() {
            return this.valueCount() < this.run() || this.buffer.hasRemaining();
        }

        private void putBoolean(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putBoolean(pos, value == 1L);
        }

        private long getByte(ByteBuffer buffer) {
            return buffer.get();
        }

        private void putByte(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putByte(pos, (byte)value);
        }

        private long getShort(ByteBuffer buffer) {
            return buffer.getShort();
        }

        private void putShort(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putShort(pos, (short)value);
        }

        private long getInt(ByteBuffer buffer) {
            return buffer.getInt();
        }

        private void putInt(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putInt(pos, (int)value);
        }

        private long getLong(ByteBuffer buffer) {
            return buffer.getLong();
        }

        private void putLong(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putLong(pos, value);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, Function1<ByteBuffer, Object> getFunction, Function3<WritableColumnVector, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            int runLocal = 0;
            int valueCountLocal = 0;
            long currentValueLocal = 0L;
            for (int pos = 0; pos < capacity; ++pos) {
                Object object;
                Predef$.MODULE$.assert(valueCountLocal <= runLocal);
                if (pos != nextNullIndex) {
                    if (valueCountLocal == runLocal) {
                        currentValueLocal = BoxesRunTime.unboxToLong((Object)getFunction.apply((Object)this.buffer));
                        runLocal = ByteBufferHelper$.MODULE$.getInt(this.buffer);
                        valueCountLocal = 1;
                    } else {
                        ++valueCountLocal;
                    }
                    object = putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToLong((long)currentValueLocal));
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
                object = BoxedUnit.UNIT;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable)(columnVector, pos, value) -> {
                    this.putBoolean(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ByteType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable)(columnVector, pos, value) -> {
                    this.putByte(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ShortType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getShort(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable)(columnVector, pos, value) -> {
                    this.putShort(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof IntegerType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getInt(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable)(columnVector, pos, value) -> {
                    this.putInt(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getLong(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable)(columnVector, pos, value) -> {
                    this.putLong(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in RunLengthEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.run = 0;
            this.valueCount = 0;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private int _compressedSize;
        private Object lastValue;
        private int lastRun;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private int _compressedSize() {
            return this._compressedSize;
        }

        private void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        private Object lastValue() {
            return this.lastValue;
        }

        private void lastValue_$eq(Object x$1) {
            this.lastValue = x$1;
        }

        private int lastRun() {
            return this.lastRun;
        }

        private void lastRun_$eq(int x$1) {
            this.lastRun = x$1;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            int actualSize = this.columnType.actualSize(row, ordinal);
            this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
            if (this.lastValue() == null) {
                this.lastValue_$eq(this.columnType.clone(value));
                this.lastRun_$eq(1);
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
            } else if (BoxesRunTime.equals((Object)this.lastValue(), value)) {
                this.lastRun_$eq(this.lastRun() + 1);
            } else {
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
                this.lastValue_$eq(this.columnType.clone(value));
                this.lastRun_$eq(1);
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(RunLengthEncoding$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int currentRun = 1;
                Object currentValue = this.columnType.extract(from);
                while (from.hasRemaining()) {
                    Object value = this.columnType.extract(from);
                    if (BoxesRunTime.equals(value, currentValue)) {
                        ++currentRun;
                        continue;
                    }
                    this.columnType.append(currentValue, to);
                    to.putInt(currentRun);
                    currentValue = value;
                    currentRun = 1;
                }
                this.columnType.append(currentValue, to);
                object = to.putInt(currentRun);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this._compressedSize = 0;
            this.lastRun = 0;
        }
    }
}

