/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.annotation.Stable;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.SparkSessionExtensionsProvider;
import org.apache.spark.sql.internal.BaseSessionStateBuilder;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateBuilder;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

@Stable
public final class SparkSession$
implements Logging,
Serializable {
    public static final SparkSession$ MODULE$ = new SparkSession$();
    private static final AtomicBoolean org$apache$spark$sql$SparkSession$$listenerRegistered;
    private static final InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession;
    private static final AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession;
    private static final String HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        org$apache$spark$sql$SparkSession$$listenerRegistered = new AtomicBoolean(false);
        org$apache$spark$sql$SparkSession$$activeThreadSession = new InheritableThreadLocal();
        org$apache$spark$sql$SparkSession$$defaultSession = new AtomicReference();
        HIVE_SESSION_STATE_BUILDER_CLASS_NAME = "org.apache.spark.sql.hive.HiveSessionStateBuilder";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession.Builder builder() {
        return new SparkSession.Builder();
    }

    public void setActiveSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().set(session);
    }

    public void clearActiveSession() {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().remove();
    }

    public void setDefaultSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(session);
    }

    public void clearDefaultSession() {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(null);
    }

    public Option<SparkSession> getActiveSession() {
        return TaskContext$.MODULE$.get() != null ? None$.MODULE$ : Option$.MODULE$.apply(this.org$apache$spark$sql$SparkSession$$activeThreadSession().get());
    }

    public Option<SparkSession> getDefaultSession() {
        return TaskContext$.MODULE$.get() != null ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.org$apache$spark$sql$SparkSession$$defaultSession().get());
    }

    public SparkSession active() {
        return (SparkSession)this.getActiveSession().getOrElse((Function0 & Serializable)() -> (SparkSession)MODULE$.getDefaultSession().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No active or default Spark session found");
        }));
    }

    public SparkSession getOrCloneSessionWithConfigsOff(SparkSession session, Seq<ConfigEntry<Object>> configurations) {
        SparkSession sparkSession;
        Seq configsEnabled = (Seq)configurations.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkSession$.$anonfun$getOrCloneSessionWithConfigsOff$1(session, x$5)));
        if (configsEnabled.isEmpty()) {
            sparkSession = session;
        } else {
            SparkSession newSession = session.cloneSession();
            configsEnabled.foreach((Function1 & Serializable)conf -> {
                SparkSession$.$anonfun$getOrCloneSessionWithConfigsOff$2(newSession, conf);
                return BoxedUnit.UNIT;
            });
            sparkSession = newSession;
        }
        return sparkSession;
    }

    public AtomicBoolean org$apache$spark$sql$SparkSession$$listenerRegistered() {
        return org$apache$spark$sql$SparkSession$$listenerRegistered;
    }

    public void org$apache$spark$sql$SparkSession$$registerContextListener(SparkContext sparkContext) {
        block0: {
            if (this.org$apache$spark$sql$SparkSession$$listenerRegistered().get()) break block0;
            sparkContext.addSparkListener((SparkListenerInterface)new SparkListener(){

                public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
                    SparkSession$.MODULE$.org$apache$spark$sql$SparkSession$$defaultSession().set(null);
                    SparkSession$.MODULE$.org$apache$spark$sql$SparkSession$$listenerRegistered().set(false);
                }
            });
            this.org$apache$spark$sql$SparkSession$$listenerRegistered().set(true);
        }
    }

    public InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession() {
        return org$apache$spark$sql$SparkSession$$activeThreadSession;
    }

    public AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession() {
        return org$apache$spark$sql$SparkSession$$defaultSession;
    }

    private String HIVE_SESSION_STATE_BUILDER_CLASS_NAME() {
        return HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    }

    public String org$apache$spark$sql$SparkSession$$sessionStateClassName(SparkConf conf) {
        String string;
        block7: {
            String string2;
            block5: {
                block6: {
                    string2 = (String)conf.get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 3202928: {
                            if ("hive".equals(string2)) {
                                break;
                            }
                            break block5;
                        }
                        case 2131621545: {
                            if (!"in-memory".equals(string2)) break block5;
                            break block6;
                        }
                        default: {
                            break block5;
                        }
                    }
                    string = this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME();
                    break block7;
                }
                string = SessionStateBuilder.class.getCanonicalName();
                break block7;
            }
            throw new MatchError((Object)string2);
        }
        return string;
    }

    public void org$apache$spark$sql$SparkSession$$assertOnDriver() {
        if (TaskContext$.MODULE$.get() != null) {
            throw new IllegalStateException("SparkSession should only be created and accessed on the driver.");
        }
    }

    public SessionState org$apache$spark$sql$SparkSession$$instantiateSessionState(String className, SparkSession sparkSession) {
        SessionState sessionState;
        try {
            Class clazz = Utils$.MODULE$.classForName(className, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            Constructor ctor = (Constructor)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])clazz.getConstructors()));
            sessionState = ((BaseSessionStateBuilder)ctor.newInstance(sparkSession, None$.MODULE$)).build();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(29).append("Error while instantiating '").append(className).append("':").toString(), e);
            }
            throw throwable;
        }
        return sessionState;
    }

    public boolean hiveClassesArePresent() {
        boolean bl;
        try {
            Utils$.MODULE$.classForName(this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            Utils$.MODULE$.classForName("org.apache.hadoop.hive.conf.HiveConf", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    public void cleanupAnyExistingSession() {
        block0: {
            Option session = this.getActiveSession().orElse((Function0 & Serializable)() -> MODULE$.getDefaultSession());
            if (!session.isDefined()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(269).append("An existing Spark session exists as the active or default session.\n           |This probably means another suite leaked it. Attempting to stop it before continuing.\n           |This existing Spark session was created at:\n           |\n           |").append(((SparkSession)session.get()).org$apache$spark$sql$SparkSession$$creationSite().longForm()).append("\n           |\n         ").toString())));
            ((SparkSession)session.get()).stop();
            this.clearActiveSession();
            this.clearDefaultSession();
        }
    }

    public SparkSessionExtensions org$apache$spark$sql$SparkSession$$applyExtensions(Seq<String> extensionConfClassNames, SparkSessionExtensions extensions) {
        extensionConfClassNames.foreach((Function1 & Serializable)extensionConfClassName -> {
            SparkSession$.$anonfun$applyExtensions$1(extensions, extensionConfClassName);
            return BoxedUnit.UNIT;
        });
        return extensions;
    }

    public void org$apache$spark$sql$SparkSession$$loadExtensions(SparkSessionExtensions extensions) {
        ServiceLoader<SparkSessionExtensionsProvider> loader = ServiceLoader.load(SparkSessionExtensionsProvider.class, Utils$.MODULE$.getContextOrSparkClassLoader());
        Iterator<SparkSessionExtensionsProvider> loadedExts = loader.iterator();
        while (loadedExts.hasNext()) {
            Object object;
            try {
                SparkSessionExtensionsProvider ext = loadedExts.next();
                object = ext.apply(extensions);
            }
            catch (Throwable e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to load session extension", e);
                object = BoxedUnit.UNIT;
            }
        }
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SparkSession$.class);
    }

    public static final /* synthetic */ boolean $anonfun$getOrCloneSessionWithConfigsOff$1(SparkSession session$2, ConfigEntry x$5) {
        return BoxesRunTime.unboxToBoolean((Object)session$2.sessionState().conf().getConf(x$5));
    }

    public static final /* synthetic */ void $anonfun$getOrCloneSessionWithConfigsOff$2(SparkSession newSession$1, ConfigEntry conf) {
        newSession$1.sessionState().conf().setConf(conf, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ void $anonfun$applyExtensions$1(SparkSessionExtensions extensions$1, String extensionConfClassName) {
        try {
            Class extensionConfClass = Utils$.MODULE$.classForName(extensionConfClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            Function1 extensionConf = (Function1)extensionConfClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            extensionConf.apply((Object)extensions$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ClassCastException ? true : (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError);
            if (bl) {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Cannot use ").append(extensionConfClassName).append(" to configure session extensions.").toString(), throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private SparkSession$() {
    }
}

