/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.util.Locale;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class DB2Dialect$
extends JdbcDialect {
    public static DB2Dialect$ MODULE$;

    static {
        new DB2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        None$ none$;
        int n = sqlType;
        switch (n) {
            case 7: {
                none$ = Option$.MODULE$.apply((Object)FloatType$.MODULE$);
                break;
            }
            case 1111: {
                String string = typeName;
                Object object = "DECFLOAT".equals(string) ? Option$.MODULE$.apply((Object)new DecimalType(38, 18)) : ("XML".equals(string) ? Option$.MODULE$.apply((Object)StringType$.MODULE$) : (string.startsWith("TIMESTAMP") ? Option$.MODULE$.apply((Object)TimestampType$.MODULE$) : None$.MODULE$));
                none$ = object;
                break;
            }
            default: {
                none$ = None$.MODULE$;
                break;
            }
        }
        return none$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        boolean bl;
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005)) : (BooleanType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1)) : ((bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) ? new Some((Object)new JdbcType("SMALLINT", 5)) : None$.MODULE$));
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(41).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET DATA TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DB2Dialect$() {
        MODULE$ = this;
    }
}

