/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.PrimitiveIterator;

final class ParquetReadState {
    private static final RowRange MAX_ROW_RANGE = new RowRange(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final RowRange END_ROW_RANGE = new RowRange(Long.MAX_VALUE, Long.MIN_VALUE);
    private final Iterator<RowRange> rowRanges;
    private RowRange currentRange;
    final int maxDefinitionLevel;
    long rowId;
    int offset;
    int valuesToReadInPage;
    int valuesToReadInBatch;

    ParquetReadState(int maxDefinitionLevel, PrimitiveIterator.OfLong rowIndexes) {
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.rowRanges = this.constructRanges(rowIndexes);
        this.nextRange();
    }

    private Iterator<RowRange> constructRanges(PrimitiveIterator.OfLong rowIndexes) {
        if (rowIndexes == null) {
            return null;
        }
        ArrayList<RowRange> rowRanges = new ArrayList<RowRange>();
        long currentStart = Long.MIN_VALUE;
        long previous = Long.MIN_VALUE;
        while (rowIndexes.hasNext()) {
            long idx = rowIndexes.nextLong();
            if (currentStart == Long.MIN_VALUE) {
                currentStart = idx;
            } else if (previous + 1L != idx) {
                RowRange range = new RowRange(currentStart, previous);
                rowRanges.add(range);
                currentStart = idx;
            }
            previous = idx;
        }
        if (previous != Long.MIN_VALUE) {
            rowRanges.add(new RowRange(currentStart, previous));
        }
        return rowRanges.iterator();
    }

    void resetForNewBatch(int batchSize) {
        this.offset = 0;
        this.valuesToReadInBatch = batchSize;
    }

    void resetForNewPage(int totalValuesInPage, long pageFirstRowIndex) {
        this.valuesToReadInPage = totalValuesInPage;
        this.rowId = pageFirstRowIndex;
    }

    long currentRangeStart() {
        return this.currentRange.start;
    }

    long currentRangeEnd() {
        return this.currentRange.end;
    }

    void advanceOffsetAndRowId(int newOffset, long newRowId) {
        this.valuesToReadInBatch -= newOffset - this.offset;
        this.valuesToReadInPage = (int)((long)this.valuesToReadInPage - (newRowId - this.rowId));
        this.offset = newOffset;
        this.rowId = newRowId;
    }

    void nextRange() {
        this.currentRange = this.rowRanges == null ? MAX_ROW_RANGE : (!this.rowRanges.hasNext() ? END_ROW_RANGE : this.rowRanges.next());
    }

    private static class RowRange {
        final long start;
        final long end;

        RowRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

