/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.json.JsonDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005Z\u0001\tE\t\u0015!\u0003H\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Y\u0007\u0001\"\u0003m\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r\u001dI\u0011QO\r\u0002\u0002#\u0005\u0011q\u000f\u0004\t1e\t\t\u0011#\u0001\u0002z!1!L\u0005C\u0001\u0003\u000fC\u0011\"!#\u0013\u0003\u0003%)%a#\t\u0013\u00055%#!A\u0005\u0002\u0006=\u0005\"CAK%\u0005\u0005I\u0011QAL\u0011%\tIKEA\u0001\n\u0013\tYKA\u000eBYR,'\u000fV1cY\u0016\fE\rZ\"pYVlgn]\"p[6\fg\u000e\u001a\u0006\u00035m\tqaY8n[\u0006tGM\u0003\u0002\u001d;\u0005IQ\r_3dkRLwN\u001c\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001d\nTg\u000f\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nq\u0001\\8hS\u000e\fGN\u0003\u0002-[\u0005)\u0001\u000f\\1og*\u0011a&H\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001'\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00023g5\t\u0011$\u0003\u000253\t\u0019B*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t9\u0001K]8ek\u000e$\bC\u0001\u001c=\u0013\titG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003uC\ndW-F\u0001A!\t\t%)D\u0001.\u0013\t\u0019UFA\bUC\ndW-\u00133f]RLg-[3s\u0003\u0019!\u0018M\u00197fA\u0005I1m\u001c7t)>\fE\rZ\u000b\u0002\u000fB\u0019\u0001\nU*\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'&\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Po\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001f^\u0002\"\u0001V,\u000e\u0003US!AV\u000f\u0002\u000bQL\b/Z:\n\u0005a+&aC*ueV\u001cGOR5fY\u0012\f!bY8mgR{\u0017\t\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019A,\u00180\u0011\u0005I\u0002\u0001\"\u0002 \u0006\u0001\u0004\u0001\u0005\"B#\u0006\u0001\u00049\u0015a\u0001:v]R\u0011\u0011M\u001a\t\u0004\u0011B\u0013\u0007CA2e\u001b\u0005i\u0012BA3\u001e\u0005\r\u0011vn\u001e\u0005\u0006O\u001a\u0001\r\u0001[\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003G&L!A[\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u00023Y,'/\u001b4z\u00032$XM\u001d+bE2,\u0017\t\u001a3D_2,XN\u001c\u000b\u0005[N\\x\u0010\u0005\u0002oc6\tqN\u0003\u0002q[\u000591-\u0019;bY><\u0017B\u0001:p\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u0015!x\u00011\u0001v\u0003\u0011\u0019wN\u001c4\u0011\u0005YLX\"A<\u000b\u0005al\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005i<(aB*R\u0019\u000e{gN\u001a\u0005\u0006a\u001e\u0001\r\u0001 \t\u0003]vL!A`8\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\")ah\u0002a\u0001\u0001\u0006!1m\u001c9z)\u0015a\u0016QAA\u0004\u0011\u001dq\u0004\u0002%AA\u0002\u0001Cq!\u0012\u0005\u0011\u0002\u0003\u0007q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055!f\u0001!\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c]\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015\"fA$\u0002\u0010\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!A.\u00198h\u0015\t\t)$\u0001\u0003kCZ\f\u0017\u0002BA\u001d\u0003_\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA !\r1\u0014\u0011I\u0005\u0004\u0003\u0007:$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA%\u0003\u001f\u00022ANA&\u0013\r\tie\u000e\u0002\u0004\u0003:L\b\"CA)\u001b\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000b\t\u0007\u00033\ny&!\u0013\u000e\u0005\u0005m#bAA/o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00141\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\u00055\u0004c\u0001\u001c\u0002j%\u0019\u00111N\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011K\b\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u00141\u000f\u0005\n\u0003#\u0002\u0012\u0011!a\u0001\u0003\u0013\n1$\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:\u001c8i\\7nC:$\u0007C\u0001\u001a\u0013'\u0011\u0011\u00121P\u001e\u0011\u000f\u0005u\u00141\u0011!H96\u0011\u0011q\u0010\u0006\u0004\u0003\u0003;\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\u000byHA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bq\u000b\t*a%\t\u000by*\u0002\u0019\u0001!\t\u000b\u0015+\u0002\u0019A$\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011TAS!\u00151\u00141TAP\u0013\r\tij\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bY\n\t\u000bQ$\n\u0007\u0005\rvG\u0001\u0004UkBdWM\r\u0005\t\u0003O3\u0012\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0003B!!\f\u00020&!\u0011\u0011WA\u0018\u0005\u0019y%M[3di\u0002")
public class AlterTableAddColumnsCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand alterTableAddColumnsCommand) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(alterTableAddColumnsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = this;
        synchronized (alterTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(sparkSession.sessionState().conf(), catalog, this.table());
        CommandUtils$.MODULE$.uncacheTableOrView(sparkSession, this.table().quotedString());
        catalog.refreshTable(this.table());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)((TraversableLike)this.colsToAdd().$plus$plus((GenTraversableOnce)catalogTable.schema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom()), new StringBuilder(27).append("in the table definition of ").append(this.table().identifier()).toString(), this.conf().caseSensitiveAnalysis());
        DDLUtils$.MODULE$.checkDataColNames(catalogTable, StructType$.MODULE$.apply(this.colsToAdd()));
        StructType existingSchema = CharVarcharUtils$.MODULE$.getRawSchema(catalogTable.dataSchema());
        catalog.alterTableDataSchema(this.table(), StructType$.MODULE$.apply((Seq)existingSchema.$plus$plus(this.colsToAdd(), Seq$.MODULE$.canBuildFrom())));
        return (Seq)Nil$.MODULE$;
    }

    private CatalogTable verifyAlterTableAddColumn(SQLConf conf, SessionCatalog catalog, TableIdentifier table) {
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportViewError(table);
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get(), conf).getConstructor(new Class[0]).newInstance(new Object[0]);
            boolean bl = obj instanceof CSVFileFormat ? true : (obj instanceof JsonFileFormat ? true : obj instanceof ParquetFileFormat);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = obj instanceof JsonDataSourceV2 ? true : (obj instanceof CSVDataSourceV2 ? true : (obj instanceof OrcDataSourceV2 ? true : obj instanceof ParquetDataSourceV2));
                if (bl2) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (obj.getClass().getCanonicalName().endsWith("OrcFileFormat")) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportDatasourceTableError(obj, table);
                }
            }
        }
        return catalogTable;
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<StructField> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.table();
                break;
            }
            case 1: {
                seq = this.colsToAdd();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

