/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0010!\u0001EBQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001A\u0002\u0013%\u0001\u000bC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0019\u0004\u0001\u0015)\u0003R\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\"I\u0011\u000f\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\ne\u0002\u0001\r\u00111A\u0005\nMD\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\t\u0013q\u0004\u0001\u0019!A!B\u0013!\b\"B?\u0001\t\u0003r\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!a#\u0001\t\u0003\ni\tC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011q\u0015\u0001\u0005B\u00055\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\t\t\r\u0001C!\u0003\u0007Dq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002X\u0002!I!!7\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0002\u0011\u0015\u0012\u00135\tV1cY\u0016\u001c\u0015\r^1m_\u001eT!!\t\u0012\u0002\t)$'m\u0019\u0006\u0003G\u0011\n!A\u001e\u001a\u000b\u0005\u00152\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!a\n\u0015\u0002\u0013\u0015DXmY;uS>t'BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011#\u0002\u00013u\t+\u0005CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aB2bi\u0006dwn\u001a\u0006\u0003\u007f!\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005\u0005c$\u0001\u0004+bE2,7)\u0019;bY><\u0007CA\u001eD\u0013\t!EH\u0001\nTkB\u0004xN\u001d;t\u001d\u0006lWm\u001d9bG\u0016\u001c\bC\u0001$J\u001b\u00059%B\u0001%+\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001&H\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"\u0001\u0011\u0002\u0017\r\fG/\u00197pO:\u000bW.Z\u000b\u0002#B\u0011!k\u0017\b\u0003'f\u0003\"\u0001V,\u000e\u0003US!A\u0016\u0019\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i;\u0016aD2bi\u0006dwn\u001a(b[\u0016|F%Z9\u0015\u0005\u0001$\u0007CA1c\u001b\u00059\u0016BA2X\u0005\u0011)f.\u001b;\t\u000f\u0015\u001c\u0011\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\r\fG/\u00197pO:\u000bW.\u001a\u0011\u0002\u000f=\u0004H/[8ogV\t\u0011\u000e\u0005\u0002kY6\t1N\u0003\u0002\"I%\u0011Qn\u001b\u0002\f\u0015\u0012\u00135i\u00149uS>t7/A\u0006paRLwN\\:`I\u0015\fHC\u00011q\u0011\u001d)g!!AA\u0002%\f\u0001b\u001c9uS>t7\u000fI\u0001\bI&\fG.Z2u+\u0005!\bCA;x\u001b\u00051(BA\u0011)\u0013\tAhOA\u0006KI\n\u001cG)[1mK\u000e$\u0018a\u00033jC2,7\r^0%KF$\"\u0001Y>\t\u000f\u0015L\u0011\u0011!a\u0001i\u0006AA-[1mK\u000e$\b%\u0001\u0003oC6,G#A)\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0003a\u0003\u0007\t)\u0001C\u0003~\u0019\u0001\u0007\u0011\u000b\u0003\u0004h\u0019\u0001\u0007\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\tYA\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\f!\u0002\\5tiR\u000b'\r\\3t)\u0011\t9\"a\t\u0011\u000b\u0005\fI\"!\b\n\u0007\u0005mqKA\u0003BeJ\f\u0017\u0010E\u0002<\u0003?I1!!\t=\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\b\u0003Ki\u0001\u0019AA\u0014\u0003%q\u0017-\\3ta\u0006\u001cW\r\u0005\u0003b\u00033\t\u0016a\u0003;bE2,W\t_5tiN$B!!\f\u00024A\u0019\u0011-a\f\n\u0007\u0005ErKA\u0004C_>dW-\u00198\t\u000f\u0005Ub\u00021\u0001\u0002\u001e\u0005)\u0011\u000eZ3oi\u0006IAM]8q)\u0006\u0014G.\u001a\u000b\u0005\u0003[\tY\u0004C\u0004\u00026=\u0001\r!!\b\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0006A\u0006\u0005\u0013Q\t\u0005\b\u0003\u0007\u0002\u0002\u0019AA\u000f\u0003!yG\u000eZ%eK:$\bbBA$!\u0001\u0007\u0011QD\u0001\t]\u0016<\u0018\nZ3oi\u0006IAn\\1e)\u0006\u0014G.\u001a\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002<\u0003\u001fJ1!!\u0015=\u0005\u0015!\u0016M\u00197f\u0011\u001d\t)$\u0005a\u0001\u0003;\t1b\u0019:fCR,G+\u00192mKRQ\u0011QJA-\u00037\nY'! \t\u000f\u0005U\"\u00031\u0001\u0002\u001e!9\u0011Q\f\nA\u0002\u0005}\u0013AB:dQ\u0016l\u0017\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007K\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\n\u0019G\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!\u001c\u0013\u0001\u0004\ty'\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!YA\r\u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003or\u0014aC3yaJ,7o]5p]NLA!a\u001f\u0002v\tIAK]1og\u001a|'/\u001c\u0005\b\u0003\u007f\u0012\u0002\u0019AAA\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0007\u0003\u0007\u000b9)U)\u000e\u0005\u0005\u0015%bAA\u0007m%!\u0011\u0011RAC\u0005\ri\u0015\r]\u0001\u000bC2$XM\u001d+bE2,GCBA'\u0003\u001f\u000b\t\nC\u0004\u00026M\u0001\r!!\b\t\u000f\u0005M5\u00031\u0001\u0002\u0016\u000691\r[1oO\u0016\u001c\b#B1\u0002\u0018\u0006m\u0015bAAM/\nQAH]3qK\u0006$X\r\u001a \u0011\u0007m\ni*C\u0002\u0002 r\u00121\u0002V1cY\u0016\u001c\u0005.\u00198hK\u0006ya.Y7fgB\f7-Z#ySN$8\u000f\u0006\u0003\u0002.\u0005\u0015\u0006bBA\u0013)\u0001\u0007\u0011qE\u0001\u000fY&\u001cHOT1nKN\u0004\u0018mY3t)\t\tY\u000bE\u0003b\u00033\t9\u0003\u0006\u0003\u0002,\u0006=\u0006bBA\u0013-\u0001\u0007\u0011qE\u0001\u0016Y>\fGMT1nKN\u0004\u0018mY3NKR\fG-\u0019;b)\u0011\t\t)!.\t\u000f\u0005\u0015r\u00031\u0001\u0002(\u0005y1M]3bi\u0016t\u0015-\\3ta\u0006\u001cW\rF\u0003a\u0003w\u000bi\fC\u0004\u0002&a\u0001\r!a\n\t\u000f\u0005}\u0006\u00041\u0001\u0002\u0002\u0006AQ.\u001a;bI\u0006$\u0018-\u0001\bbYR,'OT1nKN\u0004\u0018mY3\u0015\u000b\u0001\f)-a2\t\u000f\u0005\u0015\u0012\u00041\u0001\u0002(!9\u00111S\rA\u0002\u0005%\u0007#B1\u0002\u0018\u0006-\u0007cA\u001e\u0002N&\u0019\u0011q\u001a\u001f\u0003\u001f9\u000bW.Z:qC\u000e,7\t[1oO\u0016\fQ\u0002\u001a:pa:\u000bW.Z:qC\u000e,G\u0003BA\u0017\u0003+Dq!!\n\u001b\u0001\u0004\t9#\u0001\bdQ\u0016\u001c7NT1nKN\u0004\u0018mY3\u0015\u0007\u0001\fY\u000eC\u0004\u0002&m\u0001\r!a\n\u0002\u001d]LG\u000f[\"p]:,7\r^5p]V!\u0011\u0011]At)\u0011\t\u0019/!?\u0011\t\u0005\u0015\u0018q\u001d\u0007\u0001\t\u001d\tI\u000f\bb\u0001\u0003W\u0014\u0011\u0001V\t\u0005\u0003[\f\u0019\u0010E\u0002b\u0003_L1!!=X\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!YA{\u0013\r\t9p\u0016\u0002\u0004\u0003:L\bbBA~9\u0001\u0007\u0011Q`\u0001\u0002MB9\u0011-a@\u0003\u0004\u0005\r\u0018b\u0001B\u0001/\nIa)\u001e8di&|g.\r\t\u0005\u0005\u000b\u0011I!\u0004\u0002\u0003\b)\u0011\u0011FN\u0005\u0005\u0005\u0017\u00119A\u0001\u0006D_:tWm\u0019;j_:\fAbZ3u)\u0006\u0014G.\u001a(b[\u0016$2!\u0015B\t\u0011\u001d\t)$\ba\u0001\u0003;\t\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o+\u0011\u00119B!\b\u0015\t\te!q\u0005\u000b\u0005\u00057\u0011y\u0002\u0005\u0003\u0002f\nuAaBAu=\t\u0007\u00111\u001e\u0005\t\u0003wtB\u00111\u0001\u0003\"A)\u0011Ma\t\u0003\u001c%\u0019!QE,\u0003\u0011q\u0012\u0017P\\1nKzBaA!\u000b\u001f\u0001\u0004\t\u0016aB7fgN\fw-\u001a")
public class JDBCTableCatalog
implements TableCatalog,
SupportsNamespaces,
Logging {
    private String catalogName;
    private JDBCOptions options;
    private JdbcDialect dialect;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private JDBCOptions options() {
        return this.options;
    }

    private void options_$eq(JDBCOptions x$1) {
        this.options = x$1;
    }

    private JdbcDialect dialect() {
        return this.dialect;
    }

    private void dialect_$eq(JdbcDialect x$1) {
        this.dialect = x$1;
    }

    public String name() {
        Predef$.MODULE$.require(this.catalogName() != null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is not initialed");
        return this.catalogName();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Predef$.MODULE$.assert(this.catalogName() == null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is already initialed");
        this.catalogName_$eq(name);
        scala.collection.immutable.Map map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options.asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.options_$eq(new JDBCOptions((scala.collection.immutable.Map<String, String>)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)"__invalid_dbtable"))));
        this.dialect_$eq(JdbcDialects$.MODULE$.get(this.options().url()));
    }

    public Identifier[] listTables(String[] namespace) {
        this.checkNamespace(namespace);
        return (Identifier[])this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
            String schemaPattern = namespace.length == 1 ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head() : null;
            ResultSet rs = conn.getMetaData().getTables(null, schemaPattern, "%", (String[])((Object[])new String[]{"TABLE"}));
            return (Identifier[])new Iterator<Identifier>(null, rs, namespace){
                private final ResultSet rs$1;
                private final String[] namespace$1;

                public Iterator<Identifier> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Identifier> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Identifier> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Identifier, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Identifier, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Identifier> filter(Function1<Identifier, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Identifier, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Identifier> withFilter(Function1<Identifier, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Identifier> filterNot(Function1<Identifier, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Identifier, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Identifier, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Identifier, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Identifier> takeWhile(Function1<Identifier, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> partition(Function1<Identifier, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> span(Function1<Identifier, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Identifier> dropWhile(Function1<Identifier, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Identifier, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Identifier, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Identifier, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Identifier, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Identifier, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Identifier> find(Function1<Identifier, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Identifier> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Identifier> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Identifier> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Identifier> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Identifier> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Identifier, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Identifier, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Identifier, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Identifier, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Identifier, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Identifier> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Identifier> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Identifier> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Identifier> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Identifier> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Identifier, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Identifier, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.rs$1.next();
                }

                public Identifier next() {
                    return Identifier.of((String[])this.namespace$1, (String)this.rs$1.getString("TABLE_NAME"));
                }
                {
                    this.rs$1 = rs$1;
                    this.namespace$1 = namespace$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toArray(ClassTag$.MODULE$.apply(Identifier.class));
        });
    }

    public boolean tableExists(Identifier ident) {
        this.checkNamespace(ident.namespace());
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        return BoxesRunTime.unboxToBoolean(this.classifyException(new java.lang.StringBuilder(30).append("Failed table existence check: ").append(ident).toString(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean(this.withConnection((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.tableExists(x$1, writeOptions))))));
    }

    public boolean dropTable(Identifier ident) {
        this.checkNamespace(ident.namespace());
        return BoxesRunTime.unboxToBoolean(this.withConnection((Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropTable$1(this, ident, conn))));
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        this.checkNamespace(oldIdent.namespace());
        this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
            this.classifyException(new java.lang.StringBuilder(31).append("Failed table renaming from ").append(oldIdent).append(" to ").append(newIdent).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.renameTable(conn, this.getTableName(oldIdent), this.getTableName(newIdent), this.options()));
            return BoxedUnit.UNIT;
        });
    }

    public Table loadTable(Identifier ident) {
        JDBCTable jDBCTable;
        this.checkNamespace(ident.namespace());
        JDBCOptions optionsWithTableName = new JDBCOptions((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        try {
            StructType schema = JDBCRDD$.MODULE$.resolveTable(optionsWithTableName);
            jDBCTable = new JDBCTable(ident, schema, optionsWithTableName);
        }
        catch (SQLException sQLException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return jDBCTable;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.checkNamespace(ident.namespace());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).nonEmpty()) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateJDBCTableWithPartitionsError();
        }
        CaseInsensitiveMap tableOptions = this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident)));
        ObjectRef tableComment = ObjectRef.create((Object)"");
        ObjectRef tableProperties = ObjectRef.create((Object)"");
        if (!properties.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JDBCTableCatalog.$anonfun$createTable$1(tableComment, tableProperties, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        String string = (String)tableComment.elem;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_COMMENT()), (Object)((String)tableComment.elem)));
        }
        String string3 = (String)tableProperties.elem;
        String string4 = "";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_CREATE_TABLE_OPTIONS()), (Object)((String)tableProperties.elem)));
        }
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)tableOptions);
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
            this.classifyException(new java.lang.StringBuilder(23).append("Failed table creation: ").append(ident).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createTable(conn, this.getTableName(ident), schema, caseSensitive, writeOptions));
            return BoxedUnit.UNIT;
        });
        return new JDBCTable(ident, schema, writeOptions);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        this.checkNamespace(ident.namespace());
        return (Table)this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
            this.classifyException(new java.lang.StringBuilder(23).append("Failed table altering: ").append(ident).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.alterTable((Connection)conn, this.getTableName(ident), changes, this.options()));
            return this.loadTable(ident);
        });
    }

    public boolean namespaceExists(String[] namespace) {
        boolean bl;
        Object object = new Object();
        try {
            boolean bl2;
            String[] stringArray = namespace;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                String db = (String)((SeqLike)option.get()).apply(0);
                bl2 = BoxesRunTime.unboxToBoolean(this.withConnection((Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$namespaceExists$1(db, object, conn))));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public String[][] listNamespaces() {
        return (String[][])this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
            ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            ResultSet rs = conn.getMetaData().getSchemas();
            while (rs.next()) {
                schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
            }
            return (String[][])schemaBuilder.result();
        });
    }

    public String[][] listNamespaces(String[] namespace) {
        String[][] stringArray;
        String[] stringArray2 = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            stringArray = this.listNamespaces();
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && this.namespaceExists(namespace)) {
                stringArray = (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            } else {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
        }
        return stringArray;
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])((Object[])new String[]{db}));
            }
        } else {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        Map map = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava();
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        Option option;
        String[] stringArray = namespace;
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option2.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                ObjectRef comment = ObjectRef.create((Object)"");
                if (!metadata.isEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        JDBCTableCatalog.$anonfun$createNamespace$1(comment, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                BoxedUnit boxedUnit = (BoxedUnit)this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
                    this.classifyException(new java.lang.StringBuilder(26).append("Failed create name space: ").append(db).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createNamespace(conn, this.options(), db, (String)comment$1.elem));
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (option.get() == null) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (((SeqLike)option.get()).lengthCompare(1) != 0) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        throw QueryCompilationErrors$.MODULE$.namespaceAlreadyExistsError(namespace);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        String db = (String)((SeqLike)option.get()).apply(0);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCTableCatalog.$anonfun$alterNamespace$1(this, db, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dropNamespace(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty()) throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        if (option.get() == null) throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        if (((SeqLike)option.get()).lengthCompare(1) != 0) throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        String db = (String)((SeqLike)option.get()).apply(0);
        if (!this.namespaceExists(namespace)) throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listTables((String[])((Object[])new String[]{db})))).nonEmpty()) return BoxesRunTime.unboxToBoolean(this.withConnection((Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropNamespace$1(this, db, conn))));
        throw QueryExecutionErrors$.MODULE$.namespaceNotEmptyError(namespace);
    }

    private void checkNamespace(String[] namespace) {
        if (namespace.length > 1) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
    }

    private <T> T withConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory(this.options()).apply();){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    private String getTableName(Identifier ident) {
        JdbcDialect jdbcDialect = this.dialect();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> jdbcDialect.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    private <T> T classifyException(String message, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable e) {
            throw this.dialect().classifyException(message, e);
        }
        return (T)object;
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$1(JDBCTableCatalog $this, Identifier ident$1, Connection conn) {
        boolean bl;
        try {
            JdbcUtils$.MODULE$.dropTable(conn, $this.getTableName(ident$1), $this.options());
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createTable$1(ObjectRef tableComment$1, ObjectRef tableProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            if ("comment".equals(string)) {
                tableComment$1.elem = v;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if ("provider".equals(string)) {
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingProviderError();
                }
                if ("owner".equals(string)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if ("location".equals(string)) {
                        throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingLocationError();
                    }
                    tableProperties$1.elem = new java.lang.StringBuilder(2).append((String)tableProperties$1.elem).append(" ").append(k).append(" ").append(v).toString();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$namespaceExists$1(String db$1, Object nonLocalReturnKey1$1, Connection conn) {
        ResultSet rs = conn.getMetaData().getSchemas(null, db$1);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = db$1;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$createNamespace$1(ObjectRef comment$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        String string = k;
        if ("comment".equals(string)) {
            comment$1.elem = v;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("owner".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!"location".equals(string)) throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceWithPropertyError(k);
            throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceUsingProviderError();
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$alterNamespace$1(JDBCTableCatalog $this, String db$3, Seq changes$2, NamespaceChange x0$1) {
        block8: {
            block9: {
                block11: {
                    NamespaceChange.RemoveProperty removeProperty;
                    block12: {
                        String string;
                        String string2;
                        block10: {
                            NamespaceChange namespaceChange;
                            block4: {
                                NamespaceChange.SetProperty setProperty;
                                block6: {
                                    block7: {
                                        String string3;
                                        String string4;
                                        block5: {
                                            namespaceChange = x0$1;
                                            if (!(namespaceChange instanceof NamespaceChange.SetProperty)) break block4;
                                            setProperty = (NamespaceChange.SetProperty)namespaceChange;
                                            string4 = setProperty.property();
                                            string3 = "comment";
                                            if (string4 != null) break block5;
                                            if (string3 == null) break block6;
                                            break block7;
                                        }
                                        if (string4.equals(string3)) break block6;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.cannotSetJDBCNamespaceWithPropertyError(setProperty.property());
                                }
                                BoxedUnit boxedUnit = (BoxedUnit)$this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
                                    JdbcUtils$.MODULE$.createNamespaceComment(conn, $this.options(), db$3, setProperty.value());
                                    return BoxedUnit.UNIT;
                                });
                                break block8;
                            }
                            if (!(namespaceChange instanceof NamespaceChange.RemoveProperty)) break block9;
                            removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
                            string2 = removeProperty.property();
                            string = "comment";
                            if (string2 != null) break block10;
                            if (string == null) break block11;
                            break block12;
                        }
                        if (string2.equals(string)) break block11;
                    }
                    throw QueryCompilationErrors$.MODULE$.cannotUnsetJDBCNamespaceWithPropertyError(removeProperty.property());
                }
                BoxedUnit boxedUnit = (BoxedUnit)$this.withConnection((Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcUtils$.MODULE$.removeNamespaceComment(conn, $this.options(), db$3);
                    return BoxedUnit.UNIT;
                });
                break block8;
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedJDBCNamespaceChangeInCatalogError(changes$2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$dropNamespace$1(JDBCTableCatalog $this, String db$4, Connection conn) {
        return BoxesRunTime.unboxToBoolean($this.classifyException(new java.lang.StringBuilder(24).append("Failed drop name space: ").append(db$4).toString(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            JdbcUtils$.MODULE$.dropNamespace(conn, $this.options(), db$4);
            return true;
        }));
    }

    public JDBCTableCatalog() {
        Logging.$init$((Logging)this);
        this.catalogName = null;
    }
}

