/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tMb!\u0002\u000e\u001c\u0003\u00031\u0003\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002\u001e\u0001\r\u0003Y\u0004\"\u0002'\u0001\t\u0003i\u0005\"B3\u0001\t\u00031\u0007\"B7\u0001\t\u0003q\u0007\"B9\u0001\t\u0003\u0011\b\"B;\u0001\t\u00031\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u0007\u0001A\u0011AA\b\u0011%\ty\u0002AI\u0001\n\u0003\t\t\u0003C\u0004\u00026\u0001!\t!a\u000e\t\u0011\u0005m\u0003\u0001\"\u0005\u001c\u0003;Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005-QEMY2ES\u0006dWm\u0019;\u000b\u0005qi\u0012\u0001\u00026eE\u000eT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0014.aA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"\u0001\u000b\u0018\n\u0005=J#\u0001D*fe&\fG.\u001b>bE2,\u0007CA\u00195\u001b\u0005\u0011$BA\u001a \u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b3\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"A\u000e\u0002\u0013\r\fg\u000eS1oI2,GC\u0001\u001f@!\tAS(\u0003\u0002?S\t9!i\\8mK\u0006t\u0007\"\u0002!\u0003\u0001\u0004\t\u0015aA;sYB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001R\u0015\u000e\u0003\u0015S!AR\u0013\u0002\rq\u0012xn\u001c;?\u0013\tA\u0015&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%*\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,G#\u0002(X9z\u0003\u0007c\u0001\u0015P#&\u0011\u0001+\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005I+V\"A*\u000b\u0005Qk\u0012!\u0002;za\u0016\u001c\u0018B\u0001,T\u0005!!\u0015\r^1UsB,\u0007\"\u0002-\u0004\u0001\u0004I\u0016aB:rYRK\b/\u001a\t\u0003QiK!aW\u0015\u0003\u0007%sG\u000fC\u0003^\u0007\u0001\u0007\u0011)\u0001\u0005usB,g*Y7f\u0011\u0015y6\u00011\u0001Z\u0003\u0011\u0019\u0018N_3\t\u000b\u0005\u001c\u0001\u0019\u00012\u0002\u00055$\u0007C\u0001*d\u0013\t!7KA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\u0005\u001d\\\u0007c\u0001\u0015PQB\u0011\u0011([\u0005\u0003Un\u0011\u0001B\u00133cGRK\b/\u001a\u0005\u0006Y\u0012\u0001\r!U\u0001\u0003IR\fq\"];pi\u0016LE-\u001a8uS\u001aLWM\u001d\u000b\u0003\u0003>DQ\u0001]\u0003A\u0002\u0005\u000bqaY8m\u001d\u0006lW-A\nhKR$\u0016M\u00197f\u000bbL7\u000f^:Rk\u0016\u0014\u0018\u0010\u0006\u0002Bg\")AO\u0002a\u0001\u0003\u0006)A/\u00192mK\u0006qq-\u001a;TG\",W.Y)vKJLHCA!x\u0011\u0015!x\u00011\u0001BQ\r9\u0011p \t\u0003uvl\u0011a\u001f\u0006\u0003y~\t!\"\u00198o_R\fG/[8o\u0013\tq8PA\u0003TS:\u001cW-\t\u0002\u0002\u0002\u0005)!GL\u0019/a\u0005\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0004\u0003\u0006\u001d\u0001\"\u0002;\t\u0001\u0004\t\u0005\u0006\u0002\u0005z\u0003\u0017\t#!!\u0004\u0002\u000bIr3G\f\u0019\u0015\u000b\u0005\u000b\t\"a\u0005\t\u000bQL\u0001\u0019A!\t\u0013\u0005U\u0011\u0002%AA\u0002\u0005]\u0011aB2bg\u000e\fG-\u001a\t\u0004Q=c\u0004\u0006B\u0005z\u00037\t#!!\b\u0002\u000bIrCG\f\u0019\u00025\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"\u0006BA\f\u0003KY#!a\n\u0011\t\u0005%\u0012\u0011G\u0007\u0003\u0003WQA!!\f\u00020\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003y&JA!a\r\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017\t,gm\u001c:f\r\u0016$8\r\u001b\u000b\u0007\u0003s\ty$!\u0015\u0011\u0007!\nY$C\u0002\u0002>%\u0012A!\u00168ji\"9\u0011\u0011I\u0006A\u0002\u0005\r\u0013AC2p]:,7\r^5p]B!\u0011QIA'\u001b\t\t9EC\u0002\u001f\u0003\u0013R!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n9E\u0001\u0006D_:tWm\u0019;j_:Dq!a\u0015\f\u0001\u0004\t)&\u0001\u0006qe>\u0004XM\u001d;jKN\u0004RAQA,\u0003\u0006K1!!\u0017L\u0005\ri\u0015\r]\u0001\nKN\u001c\u0017\r]3Tc2$2!QA0\u0011\u0019\t\t\u0007\u0004a\u0001\u0003\u0006)a/\u00197vK\"\"A\"_A\u0006\u00031\u0019w.\u001c9jY\u00164\u0016\r\\;f)\u0011\tI'a\u001c\u0011\u0007!\nY'C\u0002\u0002n%\u00121!\u00118z\u0011\u001d\t\t'\u0004a\u0001\u0003SBC!D=\u0002\f\u0005A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\u0005]\u0011a\u0003:f]\u0006lW\rV1cY\u0016$R!QA>\u0003\u007fBa!! \u0010\u0001\u0004\t\u0015\u0001C8mIR\u000b'\r\\3\t\r\u0005\u0005u\u00021\u0001B\u0003!qWm\u001e+bE2,\u0017AC1mi\u0016\u0014H+\u00192mKRA\u0011qQAG\u0003#\u000b9\f\u0005\u0003)\u0003\u0013\u000b\u0015bAAFS\t)\u0011I\u001d:bs\"1\u0011q\u0012\tA\u0002\u0005\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\u0005M\u0005\u00031\u0001\u0002\u0016\u000691\r[1oO\u0016\u001c\bCBAL\u0003C\u000b9K\u0004\u0003\u0002\u001a\u0006ueb\u0001#\u0002\u001c&\t!&C\u0002\u0002 &\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006\u0015&aA*fc*\u0019\u0011qT\u0015\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u000691-\u0019;bY><'bAAY;\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003k\u000bYKA\u0006UC\ndWm\u00115b]\u001e,\u0007BBA]!\u0001\u0007\u0011,\u0001\beE6\u000b'n\u001c:WKJ\u001c\u0018n\u001c8\u0002#\u001d,G/\u00113e\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0004B\u0003\u007f\u000b\t-!2\t\r\u0005=\u0015\u00031\u0001B\u0011\u0019\t\u0019-\u0005a\u0001\u0003\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\u0005\u001d\u0017\u00031\u0001B\u0003!!\u0017\r^1UsB,\u0017\u0001F4fiJ+g.Y7f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0005B\u0003\u001b\fy-!5\u0002V\"1\u0011q\u0012\nA\u0002\u0005Ca!a1\u0013\u0001\u0004\t\u0005BBAj%\u0001\u0007\u0011)A\u0004oK^t\u0015-\\3\t\r\u0005e&\u00031\u0001Z\u0003Q9W\r\u001e#fY\u0016$XmQ8mk6t\u0017+^3ssR)\u0011)a7\u0002^\"1\u0011qR\nA\u0002\u0005Ca!a1\u0014\u0001\u0004\t\u0015\u0001G4fiV\u0003H-\u0019;f\u0007>dW/\u001c8UsB,\u0017+^3ssR9\u0011)a9\u0002f\u0006\u001d\bBBAH)\u0001\u0007\u0011\t\u0003\u0004\u0002DR\u0001\r!\u0011\u0005\u0007\u0003S$\u0002\u0019A!\u0002\u00179,w\u000fR1uCRK\b/Z\u0001 O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]:+H\u000e\\1cS2LG/_)vKJLHcB!\u0002p\u0006E\u00181\u001f\u0005\u0007\u0003\u001f+\u0002\u0019A!\t\r\u0005\rW\u00031\u0001B\u0011\u0019\t)0\u0006a\u0001y\u0005Q\u0011n\u001d(vY2\f'\r\\3\u0002)\u001d,G\u000fV1cY\u0016\u001cu.\\7f]R\fV/\u001a:z)\u0015\t\u00151`A\u007f\u0011\u0015!h\u00031\u0001B\u0011\u0019\tyP\u0006a\u0001\u0003\u000691m\\7nK:$\u0018!F4fiN\u001b\u0007.Z7b\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0006\u0003\n\u0015!\u0011\u0002\u0005\u0007\u0005\u000f9\u0002\u0019A!\u0002\rM\u001c\u0007.Z7b\u0011\u0019\typ\u0006a\u0001\u0003\u0006A\"/Z7pm\u0016\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u0007\u0005\u0013y\u0001\u0003\u0004\u0003\ba\u0001\r!Q\u0001\u0012G2\f7o]5gs\u0016C8-\u001a9uS>tGC\u0002B\u000b\u0005;\u0011\t\u0003\u0005\u0003\u0003\u0018\teQ\"A\u000f\n\u0007\tmQDA\tB]\u0006d\u0017p]5t\u000bb\u001cW\r\u001d;j_:DaAa\b\u001a\u0001\u0004\t\u0015aB7fgN\fw-\u001a\u0005\b\u0005GI\u0002\u0019\u0001B\u0013\u0003\u0005)\u0007\u0003BAL\u0005OIAA!\u000b\u0002&\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0015\u0004\u0001\t5\u0002c\u0001>\u00030%\u0019!\u0011G>\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public abstract class JdbcDialect
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable & scala.Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw new AnalysisException(new StringBuilder(41).append("Unsupported TableChange ").append(change).append(" in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2);
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }
}

