/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class PartitioningUtils$ {
    public static PartitioningUtils$ MODULE$;
    private final String timestampPartitionPattern;
    private final Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn;

    static {
        new PartitioningUtils$();
    }

    public String timestampPartitionPattern() {
        return this.timestampPartitionPattern;
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, String timeZoneId) {
        return this.parsePartitions(paths, typeInference, basePaths, userSpecifiedSchema, caseSensitive, validatePartitionColumns, DateTimeUtils$.MODULE$.getZoneId(timeZoneId));
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, ZoneId zoneId) {
        PartitionSpec partitionSpec;
        Object object;
        if (userSpecifiedSchema.isDefined()) {
            Map nameToDataType = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            object = !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(nameToDataType) : nameToDataType;
        } else {
            object = Predef$.MODULE$.Map().empty();
        }
        Map userSpecifiedDataTypes = object;
        Map userSpecifiedNames = userSpecifiedSchema.isDefined() && !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())) : Predef$.MODULE$.Map().empty();
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply(zoneId);
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), zoneId, true);
        Tuple2 tuple2 = ((GenericTraversableTemplate)paths.map((Function1 & Serializable & scala.Serializable)path -> MODULE$.parsePartition((Path)path, typeInference, basePaths, (Map<String, DataType>)userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionValues = (Seq)tuple2._1();
        Seq optDiscoveredBasePaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionValues, (Object)optDiscoveredBasePaths);
        Tuple2 tuple23 = tuple22;
        Seq partitionValues2 = (Seq)tuple23._1();
        Seq optDiscoveredBasePaths2 = (Seq)tuple23._2();
        Seq pathsWithPartitionValues = (Seq)((TraversableLike)paths.zip((GenIterable)partitionValues2, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(((Option)x._2()).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), x$2))), Seq$.MODULE$.canBuildFrom());
        if (pathsWithPartitionValues.isEmpty()) {
            partitionSpec = PartitionSpec$.MODULE$.emptySpec();
        } else {
            Seq discoveredBasePaths = (Seq)((TraversableLike)optDiscoveredBasePaths2.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString().toLowerCase(), Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(((SeqLike)discoveredBasePaths.distinct()).size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(294).append("Conflicting directory structures detected. Suspicious paths:\b").append(((TraversableOnce)discoveredBasePaths.distinct()).mkString("\n\t", "\n\t", "\n\n")).append("If provided paths are partition directories, please set ").append("\"basePath\" in the options of the data source to specify the ").append("root directory of the table. If there are multiple root directories, ").append("please load them separately and then union them.").toString());
            Seq<PartitioningUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)pathsWithPartitionValues, caseSensitive, zoneId);
            PartitioningUtils.PartitionValues partitionValues3 = (PartitioningUtils.PartitionValues)resolvedPartitionValues.head();
            if (partitionValues3 == null) {
                throw new MatchError((Object)partitionValues3);
            }
            Seq<String> columnNames = partitionValues3.columnNames();
            Seq<Literal> literals = partitionValues3.literals();
            Tuple2 tuple24 = new Tuple2(columnNames, literals);
            Tuple2 tuple25 = tuple24;
            Seq columnNames2 = (Seq)tuple25._1();
            Seq literals2 = (Seq)tuple25._2();
            Seq fields = (Seq)((TraversableLike)columnNames2.zip((GenIterable)literals2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Literal literal;
                String name;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        name = (String)tuple2._1();
                        literal = (Literal)tuple2._2();
                        if (literal != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                DataType dataType = literal.dataType();
                String resultName = (String)userSpecifiedNames.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> name);
                DataType resultDataType = (DataType)userSpecifiedDataTypes.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> dataType);
                StructField structField = new StructField(resultName, resultDataType, true, StructField$.MODULE$.apply$default$4());
                return structField;
            }, Seq$.MODULE$.canBuildFrom());
            Seq partitions = (Seq)((TraversableLike)resolvedPartitionValues.zip((GenIterable)pathsWithPartitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq<Literal> literals;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        PartitioningUtils.PartitionValues partitionValues = (PartitioningUtils.PartitionValues)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (partitionValues == null) break block2;
                        literals = partitionValues.literals();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Path path = (Path)tuple2._1();
                PartitionPath partitionPath = new PartitionPath(InternalRow$.MODULE$.fromSeq((Seq)literals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value(), Seq$.MODULE$.canBuildFrom())), path);
                return partitionPath;
            }, Seq$.MODULE$.canBuildFrom());
            partitionSpec = new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<PartitionPath>)partitions);
        }
        return partitionSpec;
    }

    public Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Tuple2 tuple2;
        ArrayBuffer columns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, Literal>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable & scala.Serializable)x$6 -> columns.$plus$eq(x$6));
            finished = maybeColumn.isEmpty() && !columns.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        } else {
            Tuple2 tuple22 = ((GenericTraversableTemplate)columns.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            ArrayBuffer columnNames = (ArrayBuffer)tuple22._1();
            ArrayBuffer values = (ArrayBuffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)columnNames, (Object)values);
            Tuple2 tuple24 = tuple23;
            ArrayBuffer columnNames2 = (ArrayBuffer)tuple24._1();
            ArrayBuffer values2 = (ArrayBuffer)tuple24._2();
            tuple2 = new Tuple2((Object)new Some((Object)new PartitioningUtils.PartitionValues((Seq<String>)columnNames2.toSeq(), (Seq<Literal>)values2.toSeq())), (Object)new Some((Object)currentPath));
        }
        return tuple2;
    }

    private Option<Tuple2<String, Literal>> parsePartitionColumn(String columnSpec, boolean typeInference, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            Literal literal;
            String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName((String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex));
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Empty partition column name in '").append(columnSpec).append("'").toString());
            String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Empty partition column value in '").append(columnSpec).append("'").toString());
            if (userSpecifiedDataTypes.contains((Object)columnName)) {
                DataType dataType = (DataType)userSpecifiedDataTypes.apply((Object)columnName);
                Literal columnValueLiteral = this.inferPartitionColumnValue(rawColumnValue, false, zoneId, dateFormatter, timestampFormatter);
                Object columnValue = columnValueLiteral.eval(columnValueLiteral.eval$default$1());
                Cast qual$1 = new Cast((Expression)columnValueLiteral, dataType, Option$.MODULE$.apply((Object)zoneId.getId()));
                InternalRow x$1 = qual$1.eval$default$1();
                Object castedValue = qual$1.eval(x$1);
                if (validatePartitionColumns && columnValue != null && castedValue == null) {
                    throw new RuntimeException(new StringBuilder(53).append("Failed to cast value `").append(columnValue).append("` to `").append(dataType).append("` ").append("for partition column `").append(columnName).append("`").toString());
                }
                literal = Literal$.MODULE$.create(castedValue, dataType);
            } else {
                literal = this.inferPartitionColumnValue(rawColumnValue, typeInference, zoneId, dateFormatter, timestampFormatter);
            }
            Literal literal2 = literal;
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)literal2));
        }
        return none$;
    }

    public Map<String, String> parsePathFragment(String pathFragment) {
        return this.parsePathFragmentAsSeq(pathFragment).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<String, String>> parsePathFragmentAsSeq(String pathFragment) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathFragment.split("/"))).map((Function1 & Serializable & scala.Serializable)kv -> {
            String[] pair = kv.split("=", 2);
            return new Tuple2((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[0]), (Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[1]));
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String getPathFragment(Map<String, String> spec, StructType partitionSchema) {
        return ((TraversableOnce)partitionSchema.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName(field.name())).append("=").append(ExternalCatalogUtils$.MODULE$.escapePathName((String)spec.apply((Object)field.name()))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public String getPathFragment(Map<String, String> spec, Seq<Attribute> partitionColumns) {
        return this.getPathFragment(spec, StructType$.MODULE$.fromAttributes(partitionColumns));
    }

    public Seq<PartitioningUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathsWithPartitionValues, boolean caseSensitive, ZoneId zoneId) {
        Seq seq;
        if (pathsWithPartitionValues.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq partColNames = caseSensitive ? (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$8 -> ((PartitioningUtils.PartitionValues)x$8._2()).columnNames(), Seq$.MODULE$.canBuildFrom()) : (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$9 -> (Seq)((PartitioningUtils.PartitionValues)x$9._2()).columnNames().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toLowerCase(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(((SeqLike)partColNames.distinct()).size() == 1, (Function0 & Serializable & scala.Serializable)() -> MODULE$.listConflictingPartitionColumns(pathsWithPartitionValues));
            Seq values = (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$11 -> (PartitioningUtils.PartitionValues)x$11._2(), Seq$.MODULE$.canBuildFrom());
            int columnCount = ((PartitioningUtils.PartitionValues)values.head()).columnNames().size();
            IndexedSeq resolvedValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1 & Serializable & scala.Serializable)i -> PartitioningUtils$.MODULE$.resolveTypeConflicts((Seq<Literal>)((Seq)values.map((Function1 & Serializable & scala.Serializable)x$12 -> (Literal)x$12.literals().apply(i), Seq$.MODULE$.canBuildFrom())), zoneId), IndexedSeq$.MODULE$.canBuildFrom());
            seq = (Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PartitioningUtils.PartitionValues d = (PartitioningUtils.PartitionValues)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Seq x$1 = (Seq)resolvedValues.map((Function1 & Serializable & scala.Serializable)x$13 -> (Literal)x$13.apply(index), IndexedSeq$.MODULE$.canBuildFrom());
                Seq<String> x$2 = d.copy$default$1();
                PartitioningUtils.PartitionValues partitionValues = d.copy(x$2, (Seq<Literal>)x$1);
                return partitionValues;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqLike)pathWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$14 -> ((PartitioningUtils.PartitionValues)x$14._2()).columnNames(), Seq$.MODULE$.canBuildFrom())).distinct();
        Map partColNamesToPaths = PartitioningUtils$.groupByKey$1((Seq)pathWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            PartitioningUtils.PartitionValues partValues = (PartitioningUtils.PartitionValues)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()));
        Seq distinctPartColLists = (Seq)((TraversableLike)((IterableLike)distinctPartColNames.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.mkString(", "), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String names = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(30).append("Partition column name list #").append(index).append(": ").append(names).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        Seq suspiciousPaths = (Seq)((TraversableLike)distinctPartColNames.sortBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.length()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(307).append("Conflicting partition column names detected:\n").append(distinctPartColLists.mkString("\n\t", "\n\t", "\n\n")).append("For partitioned table directories, data files should only live in leaf directories.\n").append("And directories at the same level should have the same partition column name.\n").append("Please check the following directories for unexpected files or ").append("inconsistent partition column names:\n").append(((TraversableOnce)suspiciousPaths.map((Function1 & Serializable & scala.Serializable)x$18 -> new StringBuilder(1).append("\t").append(x$18).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).toString();
    }

    public Literal inferPartitionColumnValue(String raw, boolean typeInference, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Literal literal;
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return Literal$.MODULE$.apply((Object)bigDecimal);
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return Literal$.MODULE$.create(dateValue, (DataType)DateType$.MODULE$);
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            timestampFormatter.parse(unescapedRaw);
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)TimestampType$.MODULE$, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return Literal$.MODULE$.create(timestampValue, (DataType)TimestampType$.MODULE$);
        });
        if (typeInference) {
            literal = (Literal)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(raw)), (DataType)IntegerType$.MODULE$)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)Long.parseLong(raw)), (DataType)LongType$.MODULE$))).orElse((Function0 & Serializable & scala.Serializable)() -> decimalTry).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(raw)), (DataType)DoubleType$.MODULE$))).orElse((Function0 & Serializable & scala.Serializable)() -> timestampTry).orElse((Function0 & Serializable & scala.Serializable)() -> dateTry).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String string = raw;
                String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
                return !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
            });
        } else {
            String string = raw;
            String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
            literal = !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
        }
        return literal;
    }

    public void validatePartitionColumn(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        SchemaUtils$.MODULE$.checkColumnNameDuplication(partitionColumns, partitionColumns.mkString(", "), caseSensitive);
        this.partitionColumnsSchema(schema, partitionColumns, caseSensitive).foreach((Function1 & Serializable & scala.Serializable)field -> {
            PartitioningUtils$.$anonfun$validatePartitionColumn$1(field);
            return BoxedUnit.UNIT;
        });
        if (partitionColumns.nonEmpty() && partitionColumns.size() == schema.fields().length) {
            throw new AnalysisException("Cannot use all columns for partition columns", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public StructType partitionColumnsSchema(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        Function2<String, String, Object> equality = this.columnNameEquality(caseSensitive);
        return StructType$.MODULE$.apply((Seq)partitionColumns.map((Function1 & Serializable & scala.Serializable)col -> (StructField)schema.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningUtils$.$anonfun$partitionColumnsSchema$2(equality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String schemaCatalog = schema.catalogString();
            throw new AnalysisException(new StringBuilder(40).append("Partition column `").append((String)col).append("` not found in schema ").append(schemaCatalog).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }), Seq$.MODULE$.canBuildFrom())).asNullable();
    }

    public Tuple2<StructType, Map<String, StructField>> mergeDataAndPartitionSchema(StructType dataSchema, StructType partitionSchema, boolean caseSensitive) {
        scala.collection.mutable.Map overlappedPartCols = Map$.MODULE$.empty();
        partitionSchema.foreach((Function1 & Serializable & scala.Serializable)partitionField -> {
            String partitionFieldName = MODULE$.getColName((StructField)partitionField, caseSensitive);
            return dataSchema.exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)PartitioningUtils$.$anonfun$mergeDataAndPartitionSchema$2(caseSensitive, partitionFieldName, x$19))) ? overlappedPartCols.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionFieldName), partitionField)) : BoxedUnit.UNIT;
        });
        StructType fullSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)dataSchema.map((Function1 & Serializable & scala.Serializable)f -> (StructField)overlappedPartCols.getOrElse((Object)MODULE$.getColName((StructField)f, caseSensitive), (Function0 & Serializable & scala.Serializable)() -> f), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionSchema.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)overlappedPartCols.contains((Object)PartitioningUtils$.MODULE$.getColName(f, caseSensitive)))), Seq$.MODULE$.canBuildFrom()));
        return new Tuple2((Object)fullSchema, (Object)overlappedPartCols.toMap(Predef$.MODULE$.$conforms()));
    }

    public String getColName(StructField f, boolean caseSensitive) {
        return caseSensitive ? f.name() : f.name().toLowerCase(Locale.ROOT);
    }

    private Function2<String, String, Object> columnNameEquality(boolean caseSensitive) {
        return caseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
    }

    private Seq<Literal> resolveTypeConflicts(Seq<Literal> literals, ZoneId zoneId) {
        Seq litTypes = (Seq)literals.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.dataType(), Seq$.MODULE$.canBuildFrom());
        DataType desiredType = (DataType)litTypes.reduce(this.findWiderTypeForPartitionColumn());
        return (Seq)literals.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Literal literal = x0$1;
            if (literal == null) {
                throw new MatchError((Object)literal);
            }
            Cast qual$1 = new Cast((Expression)literal, desiredType, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$1 = qual$1.eval$default$1();
            Literal literal2 = Literal$.MODULE$.create(qual$1.eval(x$1), desiredType);
            return literal2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn() {
        return this.findWiderTypeForPartitionColumn;
    }

    private static final Map groupByKey$1(Seq seq) {
        return seq.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object object = key = tuple2._1();
            return object;
        }).mapValues((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)x$15.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object value;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object object = value = tuple2._2();
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$validatePartitionColumn$1(StructField field) {
        DataType dataType = field.dataType();
        if (!(dataType instanceof AtomicType)) {
            throw new AnalysisException(new StringBuilder(32).append("Cannot use ").append(field.dataType()).append(" for partition column").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$partitionColumnsSchema$2(Function2 equality$1, String col$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)equality$1.apply((Object)f.name(), (Object)col$1));
    }

    public static final /* synthetic */ boolean $anonfun$mergeDataAndPartitionSchema$2(boolean caseSensitive$1, String partitionFieldName$1, StructField x$19) {
        String string = MODULE$.getColName(x$19, caseSensitive$1);
        String string2 = partitionFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StringType$ $anonfun$findWiderTypeForPartitionColumn$2() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ DataType $anonfun$findWiderTypeForPartitionColumn$1(DataType x0$1, DataType x1$1) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        block9: {
                            block8: {
                                var5_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                                if (var5_2 == null || !DoubleType$.MODULE$.equals(var6_3 = (DataType)var5_2._1()) || !(var5_2._2() instanceof DecimalType)) break block8;
                                var4_4 = true;
                                break block9;
                            }
                            if (var5_2 == null) ** GOTO lbl-1000
                            var7_5 = (DataType)var5_2._2();
                            if (var5_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var7_5)) {
                                var4_4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var4_4 = false;
                            }
                        }
                        if (!var4_4) break block10;
                        var2_6 = StringType$.MODULE$;
                        break block11;
                    }
                    if (var5_2 == null) break block12;
                    var8_7 = (DataType)var5_2._1();
                    var9_8 = (DataType)var5_2._2();
                    if (!DoubleType$.MODULE$.equals(var8_7) || !LongType$.MODULE$.equals(var9_8)) break block12;
                    var3_9 = true;
                    break block13;
                }
                if (var5_2 == null) ** GOTO lbl-1000
                var10_10 = (DataType)var5_2._1();
                var11_11 = (DataType)var5_2._2();
                if (LongType$.MODULE$.equals(var10_10) && DoubleType$.MODULE$.equals(var11_11)) {
                    var3_9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var3_9 = false;
                }
            }
            if (var3_9) {
                var2_6 = StringType$.MODULE$;
            } else if (var5_2 != null) {
                t1 = (DataType)var5_2._1();
                t2 = (DataType)var5_2._2();
                var2_6 = (DataType)TypeCoercion$.MODULE$.findWiderTypeForTwo(t1, t2).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$findWiderTypeForPartitionColumn$2(), ()Lorg/apache/spark/sql/types/StringType$;)());
            } else {
                throw new MatchError((Object)var5_2);
            }
        }
        return var2_6;
    }

    private PartitioningUtils$() {
        MODULE$ = this;
        this.timestampPartitionPattern = "yyyy-MM-dd HH:mm:ss[.S]";
        this.findWiderTypeForPartitionColumn = PartitioningUtils$::$anonfun$findWiderTypeForPartitionColumn$1;
    }
}

