/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.InsertIntoDataSourceDirCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\r\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005[\u0001\tE\t\u0015!\u0003P\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B\u0017\t\u0011y\u0003!Q3A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006m\u0002!\te\u001e\u0005\n\u0003\u000b\u0001\u0011\u0011!C\u0001\u0003\u000fA\u0011\"!\u0005\u0001#\u0003%\t!a\u0005\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u001a\u0001\u0003\u0003%\t%a\u001a\t\u0013\u0005U\u0004!!A\u0005\u0002\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u000f%\t\tiHA\u0001\u0012\u0003\t\u0019I\u0002\u0005\u001f?\u0005\u0005\t\u0012AAC\u0011\u0019!\u0007\u0004\"\u0001\u0002\u0014\"I\u0011Q\u0013\r\u0002\u0002\u0013\u0015\u0013q\u0013\u0005\n\u00033C\u0012\u0011!CA\u00037C\u0011\"!*\u0019\u0003\u0003%\t)a*\t\u0013\u0005e\u0006$!A\u0005\n\u0005m&AH%og\u0016\u0014H/\u00138u_\u0012\u000bG/Y*pkJ\u001cW\rR5s\u0007>lW.\u00198e\u0015\t\u0001\u0013%A\u0004d_6l\u0017M\u001c3\u000b\u0005\t\u001a\u0013!C3yK\u000e,H/[8o\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0015\u0001QfN\u001eB!\tqS'D\u00010\u0015\t\u0001\u0014'A\u0004m_\u001eL7-\u00197\u000b\u0005I\u001a\u0014!\u00029mC:\u001c(B\u0001\u001b$\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001c0\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005aJT\"A\u0010\n\u0005iz\"a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011AHQ\u0005\u0003\u0007v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fqa\u001d;pe\u0006<W-F\u0001G!\t9%*D\u0001I\u0015\tI5'A\u0004dCR\fGn\\4\n\u0005-C%\u0001F\"bi\u0006dwnZ*u_J\fw-\u001a$pe6\fG/\u0001\u0005ti>\u0014\u0018mZ3!\u0003!\u0001(o\u001c<jI\u0016\u0014X#A(\u0011\u0005A;fBA)V!\t\u0011V(D\u0001T\u0015\t!6&\u0001\u0004=e>|GOP\u0005\u0003-v\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011a+P\u0001\naJ|g/\u001b3fe\u0002\nQ!];fef,\u0012!L\u0001\u0007cV,'/\u001f\u0011\u0002\u0013=4XM]<sSR,W#\u00011\u0011\u0005q\n\u0017B\u00012>\u0005\u001d\u0011un\u001c7fC:\f!b\u001c<fe^\u0014\u0018\u000e^3!\u0003\u0019a\u0014N\\5u}Q)am\u001a5jUB\u0011\u0001\b\u0001\u0005\u0006\t&\u0001\rA\u0012\u0005\u0006\u001b&\u0001\ra\u0014\u0005\u00067&\u0001\r!\f\u0005\u0006=&\u0001\r\u0001Y\u0001\u000eS:tWM]\"iS2$'/\u001a8\u0016\u00035\u00042A\\:.\u001d\ty\u0017O\u0004\u0002Sa&\ta(\u0003\u0002s{\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\r\u0019V-\u001d\u0006\u0003ev\n1A];o)\tAX\u0010E\u0002ogf\u0004\"A_>\u000e\u0003\rJ!\u0001`\u0012\u0003\u0007I{w\u000fC\u0003\u007f\u0017\u0001\u0007q0\u0001\u0007ta\u0006\u00148nU3tg&|g\u000eE\u0002{\u0003\u0003I1!a\u0001$\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0013\u0019\fI!a\u0003\u0002\u000e\u0005=\u0001b\u0002#\r!\u0003\u0005\rA\u0012\u0005\b\u001b2\u0001\n\u00111\u0001P\u0011\u001dYF\u0002%AA\u00025BqA\u0018\u0007\u0011\u0002\u0003\u0007\u0001-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U!f\u0001$\u0002\u0018-\u0012\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%)hn\u00195fG.,GMC\u0002\u0002$u\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9#!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055\"fA(\u0002\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u001aU\ri\u0013qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tIDK\u0002a\u0003/\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-C\u0002Y\u0003\u0007\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0015\u0011\u0007q\n\u0019&C\u0002\u0002Vu\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0017\u0002bA\u0019A(!\u0018\n\u0007\u0005}SHA\u0002B]fD\u0011\"a\u0019\u0014\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0007\u0005\u0004\u0002l\u0005E\u00141L\u0007\u0003\u0003[R1!a\u001c>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\niG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00011\u0002z!I\u00111M\u000b\u0002\u0002\u0003\u0007\u00111L\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0001\fy\bC\u0005\u0002dY\t\t\u00111\u0001\u0002\\\u0005q\u0012J\\:feRLe\u000e^8ECR\f7k\\;sG\u0016$\u0015N]\"p[6\fg\u000e\u001a\t\u0003qa\u0019B\u0001GAD\u0003BI\u0011\u0011RAH\r>k\u0003MZ\u0007\u0003\u0003\u0017S1!!$>\u0003\u001d\u0011XO\u001c;j[\u0016LA!!%\u0002\f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0012!B1qa2LH#\u00034\u0002\u001e\u0006}\u0015\u0011UAR\u0011\u0015!5\u00041\u0001G\u0011\u0015i5\u00041\u0001P\u0011\u0015Y6\u00041\u0001.\u0011\u0015q6\u00041\u0001a\u0003\u001d)h.\u00199qYf$B!!+\u00026B)A(a+\u00020&\u0019\u0011QV\u001f\u0003\r=\u0003H/[8o!\u001da\u0014\u0011\u0017$P[\u0001L1!a->\u0005\u0019!V\u000f\u001d7fi!A\u0011q\u0017\u000f\u0002\u0002\u0003\u0007a-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0018\t\u0005\u0003\u0003\ny,\u0003\u0003\u0002B\u0006\r#AB(cU\u0016\u001cG\u000f")
public class InsertIntoDataSourceDirCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final CatalogStorageFormat storage;
    private final String provider;
    private final LogicalPlan query;
    private final boolean overwrite;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<CatalogStorageFormat, String, LogicalPlan, Object>> unapply(InsertIntoDataSourceDirCommand insertIntoDataSourceDirCommand) {
        return InsertIntoDataSourceDirCommand$.MODULE$.unapply(insertIntoDataSourceDirCommand);
    }

    public static Function1<Tuple4<CatalogStorageFormat, String, LogicalPlan, Object>, InsertIntoDataSourceDirCommand> tupled() {
        return InsertIntoDataSourceDirCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogStorageFormat, Function1<String, Function1<LogicalPlan, Function1<Object, InsertIntoDataSourceDirCommand>>>> curried() {
        return InsertIntoDataSourceDirCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        InsertIntoDataSourceDirCommand insertIntoDataSourceDirCommand = this;
        synchronized (insertIntoDataSourceDirCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public CatalogStorageFormat storage() {
        return this.storage;
    }

    public String provider() {
        return this.provider;
    }

    public LogicalPlan query() {
        return this.query;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public Seq<LogicalPlan> innerChildren() {
        LogicalPlan logicalPlan2 = this.query();
        return Nil$.MODULE$.$colon$colon((Object)logicalPlan2);
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Predef$.MODULE$.assert(this.storage().locationUri().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Directory path is required");
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(this.provider())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Data source is required");
        Option pathOption = this.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$2)));
        SparkSession x$1 = sparkSession;
        String x$22 = this.provider();
        Map x$3 = this.storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        None$ x$4 = None$.MODULE$;
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Seq<String> x$7 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$8 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$1, x$22, x$5, x$6, x$7, x$8, (Map<String, String>)x$3, (Option<CatalogTable>)x$4);
        boolean isFileFormat = FileFormat.class.isAssignableFrom(dataSource.providingClass());
        if (!isFileFormat) {
            throw new SparkException(new StringBuilder(54).append("Only Data Sources providing FileFormat are supported: ").append(dataSource.providingClass()).toString());
        }
        SaveMode saveMode = this.overwrite() ? SaveMode.Overwrite : SaveMode.ErrorIfExists;
        try {
            sparkSession.sessionState().executePlan(dataSource.planForWriting(saveMode, this.query())).toRdd();
        }
        catch (AnalysisException ex) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Failed to write to directory ").append(this.storage().locationUri().toString()).toString(), ex);
            throw ex;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public InsertIntoDataSourceDirCommand copy(CatalogStorageFormat storage, String provider, LogicalPlan query, boolean overwrite) {
        return new InsertIntoDataSourceDirCommand(storage, provider, query, overwrite);
    }

    public CatalogStorageFormat copy$default$1() {
        return this.storage();
    }

    public String copy$default$2() {
        return this.provider();
    }

    public LogicalPlan copy$default$3() {
        return this.query();
    }

    public boolean copy$default$4() {
        return this.overwrite();
    }

    public String productPrefix() {
        return "InsertIntoDataSourceDirCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.storage();
                break;
            }
            case 1: {
                object = this.provider();
                break;
            }
            case 2: {
                object = this.query();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InsertIntoDataSourceDirCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InsertIntoDataSourceDirCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        InsertIntoDataSourceDirCommand insertIntoDataSourceDirCommand = (InsertIntoDataSourceDirCommand)x$1;
        CatalogStorageFormat catalogStorageFormat = this.storage();
        CatalogStorageFormat catalogStorageFormat2 = insertIntoDataSourceDirCommand.storage();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        String string = this.provider();
        String string2 = insertIntoDataSourceDirCommand.provider();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        LogicalPlan logicalPlan2 = this.query();
        LogicalPlan logicalPlan3 = insertIntoDataSourceDirCommand.query();
        if (logicalPlan2 == null) {
            if (logicalPlan3 != null) {
                return false;
            }
        } else if (!logicalPlan2.equals(logicalPlan3)) return false;
        if (this.overwrite() != insertIntoDataSourceDirCommand.overwrite()) return false;
        if (!insertIntoDataSourceDirCommand.canEqual(this)) return false;
        return true;
    }

    public InsertIntoDataSourceDirCommand(CatalogStorageFormat storage, String provider, LogicalPlan query, boolean overwrite) {
        this.storage = storage;
        this.provider = provider;
        this.query = query;
        this.overwrite = overwrite;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

