/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0011\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005g\u0001\tE\t\u0015!\u0003P\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B5\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\t;\t\r}\u0004A\u0011BA\u0001\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0005\u00024\u0001\t\n\u0011\"\u0003\u00026!9\u00111\n\u0001\u0005\n\u00055\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005]\u0004\"CA>\u0001E\u0005I\u0011AA\u001b\u0011%\ti\bAA\u0001\n\u0003\ny\bC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003O\u0003\u0011\u0011!C!\u0003SC\u0011\"a.\u0001\u0003\u0003%\t!!/\t\u0013\u0005u\u0006!!A\u0005B\u0005}v!CAbC\u0005\u0005\t\u0012AAc\r!\u0001\u0013%!A\t\u0002\u0005\u001d\u0007BB7\u001b\t\u0003\t)\u000eC\u0005\u0002Xj\t\t\u0011\"\u0012\u0002Z\"I\u00111\u001c\u000e\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003KT\u0012\u0011!CA\u0003OD\u0011\"!>\u001b\u0003\u0003%I!a>\u0003)\u0005s\u0017\r\\={K\u000e{G.^7o\u0007>lW.\u00198e\u0015\t\u00113%A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0011*\u0013!C3yK\u000e,H/[8o\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0015\u0001q&O\u001fD!\t\u0001t'D\u00012\u0015\t\u00114'A\u0004m_\u001eL7-\u00197\u000b\u0005Q*\u0014!\u00029mC:\u001c(B\u0001\u001c&\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001d2\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005iZT\"A\u0011\n\u0005q\n#a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\u000fA\u0013x\u000eZ;diB\u0011a\bR\u0005\u0003\u000b~\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0002^1cY\u0016LE-\u001a8u+\u0005A\u0005CA%K\u001b\u0005)\u0014BA&6\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018a\u0003;bE2,\u0017\nZ3oi\u0002\n1bY8mk6tg*Y7fgV\tq\nE\u0002?!JK!!U \u0003\r=\u0003H/[8o!\r\u00196L\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!aV\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015B\u0001.@\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[\u007fA\u0011ql\u0019\b\u0003A\u0006\u0004\"!V \n\u0005\t|\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!AY \u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\u0002\u0015\u0005dGnQ8mk6t7/F\u0001j!\tq$.\u0003\u0002l\u007f\t9!i\\8mK\u0006t\u0017aC1mY\u000e{G.^7og\u0002\na\u0001P5oSRtD\u0003B8qcJ\u0004\"A\u000f\u0001\t\u000b\u0019;\u0001\u0019\u0001%\t\u000b5;\u0001\u0019A(\t\u000b\u001d<\u0001\u0019A5\u0002\u0007I,h\u000e\u0006\u0002vuB\u00191k\u0017<\u0011\u0005]DX\"A\u0013\n\u0005e,#a\u0001*po\")1\u0010\u0003a\u0001y\u0006a1\u000f]1sWN+7o]5p]B\u0011q/`\u0005\u0003}\u0016\u0012Ab\u00159be.\u001cVm]:j_:\f\u0011$\u00198bYfTXmQ8mk6t\u0017J\\\"bG\",G\rR1uCR)\u0011.a\u0001\u0002\b!1\u0011QA\u0005A\u0002=\nA\u0001\u001d7b]\")10\u0003a\u0001y\u00069\u0012M\\1msj,7i\u001c7v[:Le\u000eV3naZKWm\u001e\u000b\u0007\u0003\u001b\t\u0019\"!\u0006\u0011\u0007y\ny!C\u0002\u0002\u0012}\u0012A!\u00168ji\"1\u0011Q\u0001\u0006A\u0002=BQa\u001f\u0006A\u0002q\f1cZ3u\u0007>dW/\u001c8t)>\fe.\u00197zu\u0016$\"\"a\u0007\u0002*\u0005-\u0012qFA\u0019!\u0011\u00196,!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t6\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\n\u0003R$(/\u001b2vi\u0016DQAR\u0006A\u0002!Ca!!\f\f\u0001\u0004y\u0013\u0001\u0003:fY\u0006$\u0018n\u001c8\t\u000b5[\u0001\u0019A(\t\u000f\u001d\\\u0001\u0013!a\u0001S\u0006ir-\u001a;D_2,XN\\:U_\u0006s\u0017\r\\={K\u0012\"WMZ1vYR$C'\u0006\u0002\u00028)\u001a\u0011.!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0012@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa#\u00198bYfTXmQ8mk6t\u0017J\\\"bi\u0006dwn\u001a\u000b\u0005\u0003\u001b\ty\u0005C\u0003|\u001b\u0001\u0007A0\u0001\u0007tkB\u0004xN\u001d;t)f\u0004X\rF\u0002j\u0003+Bq!a\u0016\u000f\u0001\u0004\tI&\u0001\u0005eCR\fG+\u001f9f!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0K\u0005)A/\u001f9fg&!\u00111MA/\u0005!!\u0015\r^1UsB,\u0017\u0001B2paf$ra\\A5\u0003W\ni\u0007C\u0004G\u001fA\u0005\t\u0019\u0001%\t\u000f5{\u0001\u0013!a\u0001\u001f\"9qm\u0004I\u0001\u0002\u0004I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003gR3\u0001SA\u001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u001f+\u0007=\u000bI$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\u000bAA[1wC&\u0019A-!\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0005c\u0001 \u0002\u0016&\u0019\u0011qS \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00151\u0015\t\u0004}\u0005}\u0015bAAQ\u007f\t\u0019\u0011I\\=\t\u0013\u0005\u0015V#!AA\u0002\u0005M\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002,B1\u0011QVAZ\u0003;k!!a,\u000b\u0007\u0005Ev(\u0001\u0006d_2dWm\u0019;j_:LA!!.\u00020\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u00171\u0018\u0005\n\u0003K;\u0012\u0011!a\u0001\u0003;\u000ba!Z9vC2\u001cHcA5\u0002B\"I\u0011Q\u0015\r\u0002\u0002\u0003\u0007\u0011QT\u0001\u0015\u0003:\fG.\u001f>f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u0011\u0005iR2\u0003\u0002\u000e\u0002J\u000e\u0003\u0002\"a3\u0002R\"{\u0015n\\\u0007\u0003\u0003\u001bT1!a4@\u0003\u001d\u0011XO\u001c;j[\u0016LA!a5\u0002N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005\u0015\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0015!B1qa2LHcB8\u0002`\u0006\u0005\u00181\u001d\u0005\u0006\rv\u0001\r\u0001\u0013\u0005\u0006\u001bv\u0001\ra\u0014\u0005\u0006Ov\u0001\r![\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI/!=\u0011\ty\u0002\u00161\u001e\t\u0007}\u00055\bjT5\n\u0007\u0005=xH\u0001\u0004UkBdWm\r\u0005\t\u0003gt\u0012\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u0004B!a!\u0002|&!\u0011Q`AC\u0005\u0019y%M[3di\u0002")
public class AnalyzeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdent;
    private final Option<Seq<String>> columnNames;
    private final boolean allColumns;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Option<Seq<String>>, Object>> unapply(AnalyzeColumnCommand analyzeColumnCommand) {
        return AnalyzeColumnCommand$.MODULE$.unapply(analyzeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Option<Seq<String>>, Object>, AnalyzeColumnCommand> tupled() {
        return AnalyzeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Seq<String>>, Function1<Object, AnalyzeColumnCommand>>> curried() {
        return AnalyzeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AnalyzeColumnCommand analyzeColumnCommand = this;
        synchronized (analyzeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public Option<Seq<String>> columnNames() {
        return this.columnNames;
    }

    public boolean allColumns() {
        return this.allColumns;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Predef$.MODULE$.require(this.columnNames().isDefined() ^ this.allColumns(), (Function0 & Serializable & scala.Serializable)() -> "Parameter `columnNames` or `allColumns` are mutually exclusive. Only one of them should be specified.");
        SessionState sessionState = sparkSession.sessionState();
        boolean bl = false;
        Some some = null;
        Option option = this.tableIdent().database();
        if (option instanceof Some) {
            String db;
            bl = true;
            some = (Some)option;
            String string = db = (String)some.value();
            String string2 = sparkSession.sharedState().globalTempViewManager().database();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                LogicalPlan plan = (LogicalPlan)sessionState.catalog().getGlobalTempView(this.tableIdent().identifier()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NoSuchTableException(db, this.tableIdent().identifier());
                });
                this.analyzeColumnInTempView(plan, sparkSession);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (Seq)Seq$.MODULE$.empty();
            }
        }
        if (bl) {
            this.analyzeColumnInCatalog(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Seq)Seq$.MODULE$.empty();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        Option option2 = sessionState.catalog().getTempView(this.tableIdent().identifier());
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            LogicalPlan tempView = (LogicalPlan)some2.value();
            this.analyzeColumnInTempView(tempView, sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.analyzeColumnInCatalog(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean analyzeColumnInCachedData(LogicalPlan plan, SparkSession sparkSession) {
        CacheManager cacheManager = sparkSession.sharedState().cacheManager();
        LogicalPlan planToLookup = sparkSession.sessionState().executePlan(plan).analyzed();
        return cacheManager.lookupCachedData(planToLookup).map((Function1 & Serializable & scala.Serializable)cachedData -> {
            Seq<Attribute> columnsToAnalyze = this.getColumnsToAnalyze(this.tableIdent(), (LogicalPlan)cachedData.cachedRepresentation(), this.columnNames(), this.allColumns());
            cacheManager.analyzeColumnCacheQuery(sparkSession, (CachedData)cachedData, columnsToAnalyze);
            return cachedData;
        }).isDefined();
    }

    private void analyzeColumnInTempView(LogicalPlan plan, SparkSession sparkSession) {
        if (!this.analyzeColumnInCachedData(plan, sparkSession)) {
            throw new AnalysisException(new StringBuilder(52).append("Temporary view ").append(this.tableIdent()).append(" is not cached for analyzing columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private Seq<Attribute> getColumnsToAnalyze(TableIdentifier tableIdent, LogicalPlan relation, Option<Seq<String>> columnNames, boolean allColumns) {
        Seq columnsToAnalyze = allColumns ? relation.output() : (Seq)((TraversableLike)columnNames.get()).map((Function1 & Serializable & scala.Serializable)col -> {
            Option exprOption = relation.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)AnalyzeColumnCommand.$anonfun$getColumnsToAnalyze$2(this, col, attr)));
            return (Attribute)exprOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new AnalysisException(new StringBuilder(23).append("Column ").append((String)col).append(" does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            });
        }, Seq$.MODULE$.canBuildFrom());
        columnsToAnalyze.foreach((Function1 & Serializable & scala.Serializable)attr -> {
            AnalyzeColumnCommand.$anonfun$getColumnsToAnalyze$4(this, tableIdent, attr);
            return BoxedUnit.UNIT;
        });
        return columnsToAnalyze;
    }

    private boolean getColumnsToAnalyze$default$4() {
        return false;
    }

    private void analyzeColumnInCatalog(SparkSession sparkSession) {
        SessionState sessionState = sparkSession.sessionState();
        CatalogTable tableMeta = sessionState.catalog().getTableMetadata(this.tableIdent());
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            LogicalPlan plan = sparkSession.table(this.tableIdent().quotedString()).logicalPlan();
            if (!this.analyzeColumnInCachedData(plan, sparkSession)) {
                throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        } else {
            Seq<Attribute> columnsToAnalyze;
            BigInt sizeInBytes = CommandUtils$.MODULE$.calculateTotalSize(sparkSession, tableMeta);
            LogicalPlan relation = sparkSession.table(this.tableIdent()).logicalPlan();
            Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, columnsToAnalyze = this.getColumnsToAnalyze(this.tableIdent(), relation, this.columnNames(), this.allColumns()));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long rowCount = tuple2._1$mcJ$sp();
            Map newColStats = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
            Tuple2 tuple23 = tuple22;
            long rowCount2 = tuple23._1$mcJ$sp();
            Map newColStats2 = (Map)tuple23._2();
            Map newColCatalogStats = (Map)newColStats2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                ColumnStat columnStat = (ColumnStat)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr.name()), (Object)columnStat.toCatalogColumnStat(attr.name(), attr.dataType()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            CatalogStatistics statistics = new CatalogStatistics(sizeInBytes, (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(rowCount2)), ((MapLike)tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.colStats()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)newColCatalogStats));
            sessionState.catalog().alterTableStats(this.tableIdent(), (Option)new Some((Object)statistics));
        }
    }

    private boolean supportsType(DataType dataType) {
        boolean bl;
        boolean bl2;
        DataType dataType2 = dataType;
        boolean bl3 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl2 = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (bl = BinaryType$.MODULE$.equals(dataType2) ? true : StringType$.MODULE$.equals(dataType2)))))));
        return bl3;
    }

    public AnalyzeColumnCommand copy(TableIdentifier tableIdent, Option<Seq<String>> columnNames, boolean allColumns) {
        return new AnalyzeColumnCommand(tableIdent, columnNames, allColumns);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public Option<Seq<String>> copy$default$2() {
        return this.columnNames();
    }

    public boolean copy$default$3() {
        return this.allColumns();
    }

    public String productPrefix() {
        return "AnalyzeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdent();
                break;
            }
            case 1: {
                object = this.columnNames();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.allColumns());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeColumnCommand analyzeColumnCommand = (AnalyzeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeColumnCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Seq<String>> option = this.columnNames();
        Option<Seq<String>> option2 = analyzeColumnCommand.columnNames();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.allColumns() != analyzeColumnCommand.allColumns()) return false;
        if (!analyzeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsToAnalyze$2(AnalyzeColumnCommand $this, String col$1, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)$this.conf().resolver().apply((Object)attr.name(), (Object)col$1));
    }

    public static final /* synthetic */ void $anonfun$getColumnsToAnalyze$4(AnalyzeColumnCommand $this, TableIdentifier tableIdent$1, Attribute attr) {
        if (!$this.supportsType(attr.dataType())) {
            throw new AnalysisException(new StringBuilder(100).append("Column ").append(attr.name()).append(" in table ").append(tableIdent$1).append(" is of type ").append(attr.dataType()).append(", ").append("and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public AnalyzeColumnCommand(TableIdentifier tableIdent, Option<Seq<String>> columnNames, boolean allColumns) {
        this.tableIdent = tableIdent;
        this.columnNames = columnNames;
        this.allColumns = allColumns;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

