/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\r\u001b\u0001\u0015BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001A\u0002\u0013%Q\bC\u0004J\u0001\u0001\u0007I\u0011\u0002&\t\rA\u0003\u0001\u0015)\u0003?\u0011\u001dI\u0006A1A\u0005\niCa\u0001\u001d\u0001!\u0002\u0013Y\u0006\"B9\u0001\t\u0003\u0011\b\"B:\u0001\t\u0003!\b\"B;\u0001\t\u00031\b\"CA\u001f\u0001E\u0005I\u0011AA \u0011%\t)\u0006AI\u0001\n\u0003\t9\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005m\u0003\u0001\"\u0001\u0002p!I\u0011q\u0013\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0014\u0005\t\u0003;\u0003A\u0011\u0001\u000f\u0002 \"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAa\u0001\u0011%\u00111\u0019\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\t\t\u000e\u0001C\u0001\u0003GDq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u00055\b\u0001\"\u0001\u0002x\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0002\r\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0006\u00037q\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011CF\r\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=r\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Er#a\u0002'pO\u001eLgn\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ki\t\u0001\"\u00193baRLg/Z\u0005\u0003oQ\u0012q#\u00113baRLg/Z*qCJ\\\u0007\u000b\\1o\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005Q\u0004CA\u001e\u0001\u001b\u0005Q\u0012AC2bG\",G\rR1uCV\ta\bE\u0002@\t\u001ak\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\rC\u0013AC2pY2,7\r^5p]&\u0011Q\t\u0011\u0002\u000b\u0013:$W\r_3e'\u0016\f\bCA\u001eH\u0013\tA%D\u0001\u0006DC\u000eDW\r\u001a#bi\u0006\fabY1dQ\u0016$G)\u0019;b?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011q\u0005T\u0005\u0003\u001b\"\u0012A!\u00168ji\"9qjAA\u0001\u0002\u0004q\u0014a\u0001=%c\u0005Y1-Y2iK\u0012$\u0015\r^1!Q\t!!\u000b\u0005\u0002('&\u0011A\u000b\u000b\u0002\tm>d\u0017\r^5mK\"\u0012AA\u0016\t\u0003O]K!\u0001\u0017\u0015\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00054pe\u000e,G)[:bE2,7i\u001c8gS\u001e\u001cX#A.\u0011\u0007q#wM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001\rJ\u0001\u0007yI|w\u000e\u001e \n\u0003%J!a\u0019\u0015\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0004'\u0016\f(BA2)!\rA7.\\\u0007\u0002S*\u0011!NL\u0001\u0007G>tg-[4\n\u00051L'aC\"p]\u001aLw-\u00128uef\u0004\"a\n8\n\u0005=D#a\u0002\"p_2,\u0017M\\\u0001\u0015M>\u00148-\u001a#jg\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u0015\rdW-\u0019:DC\u000eDW\rF\u0001L\u0003\u001dI7/R7qif,\u0012!\\\u0001\u000bG\u0006\u001c\u0007.Z)vKJLHCB&x\u0003'\ti\u0003C\u0003y\u0013\u0001\u0007\u00110A\u0003rk\u0016\u0014\u0018\u0010M\u0002{\u0003\u0003\u00012a\u001f?\u007f\u001b\u0005a\u0012BA?\u001d\u0005\u001d!\u0015\r^1tKR\u00042a`A\u0001\u0019\u0001!1\"a\u0001x\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\t\u0019q\fJ\u0019\u0012\t\u0005\u001d\u0011Q\u0002\t\u0004O\u0005%\u0011bAA\u0006Q\t9aj\u001c;iS:<\u0007cA\u0014\u0002\u0010%\u0019\u0011\u0011\u0003\u0015\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0016%\u0001\n\u00111\u0001\u0002\u0018\u0005IA/\u00192mK:\u000bW.\u001a\t\u0006O\u0005e\u0011QD\u0005\u0004\u00037A#AB(qi&|g\u000e\u0005\u0003\u0002 \u0005\u001db\u0002BA\u0011\u0003G\u0001\"A\u0018\u0015\n\u0007\u0005\u0015\u0002&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\tYC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003KA\u0003\"CA\u0018\u0013A\u0005\t\u0019AA\u0019\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c=\u000591\u000f^8sC\u001e,\u0017\u0002BA\u001e\u0003k\u0011Ab\u0015;pe\u0006<W\rT3wK2\fAcY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAA!U\u0011\t9\"a\u0011,\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0014)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\nIEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTCAA-U\u0011\t\t$a\u0011\u0002\u0019Ut7-Y2iKF+XM]=\u0015\u000b-\u000by&a\u001b\t\rad\u0001\u0019AA1a\u0011\t\u0019'a\u001a\u0011\tmd\u0018Q\r\t\u0004\u007f\u0006\u001dD\u0001DA5\u0003?\n\t\u0011!A\u0003\u0002\u0005\u0015!aA0%e!1\u0011Q\u000e\u0007A\u00025\fqaY1tG\u0006$W\rF\u0005L\u0003c\nI(!%\u0002\u0014\"1q$\u0004a\u0001\u0003g\u00022a_A;\u0013\r\t9\b\b\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003wj\u0001\u0019AA?\u0003\u0011\u0001H.\u00198\u0011\t\u0005}\u0014QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u00069An\\4jG\u0006d'\u0002BAD\u0003\u0013\u000bQ\u0001\u001d7b]NT1!a#\u001d\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAH\u0003\u0003\u00131\u0002T8hS\u000e\fG\u000e\u00157b]\"1\u0011QN\u0007A\u00025D\u0001\"!&\u000e!\u0003\u0005\r!\\\u0001\tE2|7m[5oO\u00061RO\\2bG\",\u0017+^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001c*\u001aQ.a\u0011\u0002/\u0005t\u0017\r\\={K\u000e{G.^7o\u0007\u0006\u001c\u0007.Z)vKJLHcB&\u0002\"\u0006\u0015\u0016q\u0015\u0005\b\u0003G{\u0001\u0019AA:\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u0015at\u00021\u0001G\u0011\u001d\tIk\u0004a\u0001\u0003W\u000baaY8mk6t\u0007\u0003\u0002/e\u0003[\u0003B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000bI)A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\\\u0003c\u0013\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u001bI,7-Y2iK\nK\b\u000b\\1o)\u0015Y\u0015QXA`\u0011\u0019y\u0002\u00031\u0001\u0002t!9\u00111\u0010\tA\u0002\u0005u\u0014A\u0005:fG\u0006\u001c\u0007.\u001a\"z\u0007>tG-\u001b;j_:$RaSAc\u0003\u000fDaaH\tA\u0002\u0005M\u0004bBAe#\u0001\u0007\u00111Z\u0001\nG>tG-\u001b;j_:\u0004RaJAg\r6L1!a4)\u0005%1UO\\2uS>t\u0017'\u0001\tm_>\\W\u000f]\"bG\",G\rR1uCR!\u0011Q[Al!\u00119\u0013\u0011\u0004$\t\ra\u0014\u0002\u0019AAma\u0011\tY.a8\u0011\tmd\u0018Q\u001c\t\u0004\u007f\u0006}G\u0001DAq\u0003/\f\t\u0011!A\u0003\u0002\u0005\u0015!aA0%gQ!\u0011Q[As\u0011\u001d\tYh\u0005a\u0001\u0003{\nQ\"^:f\u0007\u0006\u001c\u0007.\u001a3ECR\fG\u0003BA?\u0003WDq!a\u001f\u0015\u0001\u0004\ti(A\u0007sK\u000e\f7\r[3CsB\u000bG\u000f\u001b\u000b\u0006\u0017\u0006E\u00181\u001f\u0005\u0007?U\u0001\r!a\u001d\t\u000f\u0005UX\u00031\u0001\u0002\u001e\u0005a!/Z:pkJ\u001cW\rU1uQR91*!?\u0002|\n5\u0001BB\u0010\u0017\u0001\u0004\t\u0019\bC\u0004\u0002vZ\u0001\r!!@\u0011\t\u0005}(\u0011B\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005\u0011am\u001d\u0006\u0004\u0005\u000f\u0001\u0013A\u00025bI>|\u0007/\u0003\u0003\u0003\f\t\u0005!\u0001\u0002)bi\"DqAa\u0001\u0017\u0001\u0004\u0011y\u0001\u0005\u0003\u0002\u0000\nE\u0011\u0002\u0002B\n\u0005\u0003\u0011!BR5mKNK8\u000f^3n\u0003Aawn\\6va\u0006sGMU3ge\u0016\u001c\b\u000eF\u0004n\u00053\u0011YB!\b\t\u000f\u0005mt\u00031\u0001\u0002~!9!1A\fA\u0002\t=\u0001b\u0002B\u0010/\u0001\u0007\u0011Q`\u0001\u000ecV\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5\u00027I,gM]3tQ\u001aKG.Z%oI\u0016D\u0018J\u001a(fG\u0016\u001c8/\u0019:z)\u001di'Q\u0005B\u001b\u0005oAqAa\n\u0019\u0001\u0004\u0011I#A\u0005gS2,\u0017J\u001c3fqB!!1\u0006B\u0019\u001b\t\u0011iCC\u0002\u00030i\t1\u0002Z1uCN|WO]2fg&!!1\u0007B\u0017\u0005%1\u0015\u000e\\3J]\u0012,\u0007\u0010C\u0004\u0003\u0004a\u0001\rAa\u0004\t\u000f\t}\u0001\u00041\u0001\u0002~\u0002")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private final Seq<ConfigEntry<Object>> forceDisableConfigs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    private Seq<ConfigEntry<Object>> forceDisableConfigs() {
        return this.forceDisableConfigs;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan planToCache = query.logicalPlan();
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
        } else {
            SparkSession sessionWithConfigsOff = SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(query.sparkSession(), this.forceDisableConfigs());
            InMemoryRelation inMemoryRelation = (InMemoryRelation)((Object)sessionWithConfigsOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
                QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(planToCache);
                return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
            }));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.lookupCachedData(planToCache).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Data has already been cached.");
                } else {
                    CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                    this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
                }
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        block3: {
            Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$1(plan, x$3)) : (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameResult((QueryPlan)plan));
            IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$4(shouldRemove, cd)));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(cd, x$6)))))));
            }
            plansToUncache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                CacheManager.$anonfun$uncacheQuery$7(blocking, x$7);
                return BoxedUnit.UNIT;
            });
            if (cascade) break block3;
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$8(plan, cd)));
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, (LogicalPlan)relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$10)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.map((Function1 & Serializable & scala.Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.logicalPlan());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IgnoreCachedData ignoreCachedData;
                A1 A1 = x1;
                Object object = A1 instanceof IgnoreCachedData ? (ignoreCachedData = (IgnoreCachedData)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)((Object)cachedPlan), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        HintInfo hint = (HintInfo)tuple2._1();
                        LogicalPlan p = (LogicalPlan)tuple2._2();
                        ResolvedHint resolvedHint = new ResolvedHint(p, hint);
                        return resolvedHint;
                    });
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof IgnoreCachedData ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$14)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                bl2 = this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            bl = this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableLike)fileIndex.rootPaths().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$1(LogicalPlan plan$1, LogicalPlan x$3) {
        return x$3.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$4(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(CachedData cd$1, CachedData x$6) {
        return x$6 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$7(boolean blocking$1, CachedData x$7) {
        x$7.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$8(LogicalPlan plan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$1))).isDefined() && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$10) {
        return x$10.plan().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$12) {
        return x$12 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$1, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(spark$1, $this.forceDisableConfigs());
        InMemoryRelation x$1 = newCache = (InMemoryRelation)((Object)sessionWithConfigsOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        }));
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$14) {
        return x$14.plan().find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$15, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.forceDisableConfigs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED(), SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED()}));
    }
}

