/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001u3QAB\u0004\u0001\u000fMA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006K\u0001!\tA\n\u0005\u0006S\u0001!\tE\u000b\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u00065\u0002!Ia\u0017\u0002\u0013'R\u0014X-Y7j]\u001e\fV/\u001a:z!\u0006<WM\u0003\u0002\t\u0013\u0005\u0011Q/\u001b\u0006\u0003\u0015-\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xmE\u0002\u0001)e\u0001\"!F\f\u000e\u0003YQ!\u0001C\u0007\n\u0005a1\"!C,fEVK\u0005+Y4f!\tQR$D\u0001\u001c\u0015\taR\"\u0001\u0005j]R,'O\\1m\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\u0002\rA\f'/\u001a8u\u0007\u0001\u0001\"AI\u0012\u000e\u0003\u001dI!\u0001J\u0004\u0003#M#(/Z1nS:<\u0017+^3ssR\u000b'-\u0001\u0004=S:LGO\u0010\u000b\u0003O!\u0002\"A\t\u0001\t\u000b}\u0011\u0001\u0019A\u0011\u0002\rI,g\u000eZ3s)\tYs\bE\u0002-mer!!L\u001a\u000f\u00059\nT\"A\u0018\u000b\u0005A\u0002\u0013A\u0002\u001fs_>$h(C\u00013\u0003\u0015\u00198-\u00197b\u0013\t!T'A\u0004qC\u000e\\\u0017mZ3\u000b\u0003IJ!a\u000e\u001d\u0003\u0007M+\u0017O\u0003\u00025kA\u0011!(P\u0007\u0002w)\u0011A(N\u0001\u0004q6d\u0017B\u0001 <\u0005\u0011qu\u000eZ3\t\u000b\u0001\u001b\u0001\u0019A!\u0002\u000fI,\u0017/^3tiB\u0011!)S\u0007\u0002\u0007*\u0011A)R\u0001\u0005QR$\bO\u0003\u0002G\u000f\u000691/\u001a:wY\u0016$(\"\u0001%\u0002\u000b)\fg/\u0019=\n\u0005)\u001b%A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\fqbZ3oKJ\fG/\u001a#bi\u0006\u0014vn\u001e\u000b\u0004\u001bN#FCA\u0016O\u0011\u0015yE\u00011\u0001Q\u0003\u0015\tX/\u001a:z!\t\u0011\u0013+\u0003\u0002S\u000f\t!2\u000b\u001e:fC6LgnZ)vKJLX+\u0013#bi\u0006DQ\u0001\u0011\u0003A\u0002\u0005CQ!\u0016\u0003A\u0002Y\u000b1\"];fef\f5\r^5wKB\u0011q\u000bW\u0007\u0002k%\u0011\u0011,\u000e\u0002\b\u0005>|G.Z1o\u0003m9WM\\3sCR,7\u000b\u001e:fC6LgnZ)vKJLH+\u00192mKR\u00111\u0006\u0018\u0005\u0006\u0001\u0016\u0001\r!\u0011")
public class StreamingQueryPage
extends WebUIPage
implements Logging {
    private final StreamingQueryTab parent;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq<Node> content = this.generateStreamingQueryTable(request);
        return org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Streaming Query", (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public Seq<Node> generateDataRow(HttpServletRequest request, boolean queryActive, StreamingQueryUIData query) {
        String statisticsLink = new StringOps(Predef$.MODULE$.augmentString("%s/%s/statistics?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), this.parent.prefix(), query.runId()}));
        String name = UIUtils$.MODULE$.getQueryName(query);
        String status = UIUtils$.MODULE$.getQueryStatus(query);
        String duration = queryActive ? org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(System.currentTimeMillis() - query.startTimestamp()) : UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable & scala.Serializable)() -> {
            String endTimeMs = query.lastProgress().timestamp();
            return org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(UIUtils$.MODULE$.parseProgressTimestamp(endTimeMs) - query.startTimestamp());
        }, "-");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)name);
        $buf2.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text(" "));
        $buf3.$amp$plus((Object)status);
        $buf3.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text(" "));
        $buf4.$amp$plus((Object)query.id());
        $buf4.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text(" "));
        scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
        $md = new UnprefixedAttribute("href", statisticsLink, (MetaData)$md);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text(" "));
        $buf6.$amp$plus((Object)query.runId());
        $buf6.$amp$plus((Object)new Text(" "));
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text(" "));
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(query.startTimestamp()));
        $buf7.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text(" "));
        $buf8.$amp$plus((Object)duration);
        $buf8.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text(" "));
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable & scala.Serializable)() -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> p.inputRowsPerSecond())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)query.recentProgress().length))), "%.2f"), "NaN"));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text(" "));
        $buf10.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable & scala.Serializable)() -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> p.processedRowsPerSecond())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)query.recentProgress().length))), "%.2f"), "NaN"));
        $buf10.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text(" "));
        $buf11.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> query.lastProgress().batchId(), "NaN"));
        $buf11.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)StreamingQueryPage.details$1(query.exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-"), queryActive));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateStreamingQueryTable(HttpServletRequest request) {
        None$ none$;
        None$ activeQueryTables;
        None$ none$2;
        Tuple2 tuple2 = this.parent.statusListener().allQueryStatus().partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActive()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq activeQueries = (Seq)tuple2._1();
        Seq inactiveQueries = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)activeQueries, (Object)inactiveQueries);
        Tuple2 tuple23 = tuple22;
        Seq activeQueries2 = (Seq)tuple23._1();
        Seq inactiveQueries2 = (Seq)tuple23._2();
        if (activeQueries2.nonEmpty()) {
            Seq headerRow = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Name", "Status", "Id", "Run ID", "Start Time", "Duration", "Avg Input /sec", "Avg Process /sec", "Lastest Batch"}));
            none$2 = new Some((Object)org.apache.spark.ui.UIUtils$.MODULE$.listingTable(headerRow, (Function1 & Serializable & scala.Serializable)query -> this.generateDataRow(request, true, (StreamingQueryUIData)query), (Iterable)activeQueries2, true, (Option)new Some((Object)"activeQueries-table"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), false, org.apache.spark.ui.UIUtils$.MODULE$.listingTable$default$8(), org.apache.spark.ui.UIUtils$.MODULE$.listingTable$default$9()));
        } else {
            none$2 = activeQueryTables = None$.MODULE$;
        }
        if (inactiveQueries2.nonEmpty()) {
            Seq headerRow = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Name", "Status", "Id", "Run ID", "Start Time", "Duration", "Avg Input /sec", "Avg Process /sec", "Lastest Batch", "Error"}));
            none$ = new Some((Object)org.apache.spark.ui.UIUtils$.MODULE$.listingTable(headerRow, (Function1 & Serializable & scala.Serializable)query -> this.generateDataRow(request, false, (StreamingQueryUIData)query), (Iterable)inactiveQueries2, true, (Option)new Some((Object)"completedQueries-table"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), false, org.apache.spark.ui.UIUtils$.MODULE$.listingTable$default$8(), org.apache.spark.ui.UIUtils$.MODULE$.listingTable$default$9()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ inactiveQueryTables = none$;
        scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeQueries','aggregated-activeQueries')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeQueries collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        scala.xml.Null$ $md2 = scala.xml.Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("activequeries"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        scala.xml.Null$ $md3 = scala.xml.Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Active Streaming Queries ("));
        $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeQueries2.length()));
        $buf3.$amp$plus((Object)new Text(")"));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h5", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        scala.xml.Null$ $md4 = scala.xml.Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeQueries collapsible-table"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus(activeQueryTables.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        TraversableLike traversableLike = (TraversableLike)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4), NodeSeq$.MODULE$.canBuildFrom());
        scala.xml.Null$ $md5 = scala.xml.Null$.MODULE$;
        $md5 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedQueries','aggregated-completedQueries')"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedQueries collapse-table"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        scala.xml.Null$ $md6 = scala.xml.Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("completedqueries"), (MetaData)$md6);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        scala.xml.Null$ $md7 = scala.xml.Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md7);
        $buf7.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Completed Streaming Queries ("));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)inactiveQueries2.length()));
        $buf8.$amp$plus((Object)new Text(")"));
        $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "h5", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n      "));
        TraversableLike traversableLike2 = (TraversableLike)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "span", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6), NodeSeq$.MODULE$.canBuildFrom());
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        scala.xml.Null$ $md8 = scala.xml.Null$.MODULE$;
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedQueries collapsible-table"), (MetaData)$md8);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf10.$amp$plus(inactiveQueryTables.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()));
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n      "));
        NodeSeq content = (NodeSeq)traversableLike2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9), NodeSeq$.MODULE$.canBuildFrom());
        return content;
    }

    private static final Seq details$1(Object detail, boolean queryActive$1) {
        if (queryActive$1) {
            return (Seq)Seq$.MODULE$.empty();
        }
        String detailString = (String)detail;
        boolean isMultiline = detailString.indexOf(10) >= 0;
        String summary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? detailString.substring(0, detailString.indexOf(10)) : detailString));
        Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, detailString);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)summary);
        $buf.$amp$plus((Object)details);
        return new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public StreamingQueryPage(StreamingQueryTab parent) {
        this.parent = parent;
        super("");
        Logging.$init$((Logging)this);
    }
}

