/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetHolder;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeExecutor;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001\u0002\u0016,\u0001aB\u0011\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\"\t\u0013\r\u0003!\u0011!Q\u0001\n\u0011\u000b\u0006\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011M\u0003!\u0011!Q\u0001\nQC\u0011B\u0018\u0001\u0003\u0002\u0003\u0006IaX4\t\u0013!\u0004!\u0011!Q\u0001\n%t\u0007\"C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029w\u0011%9\bA!A!\u0002\u0013A8\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011%\t)\u0003\u0001a\u0001\n#\t9\u0003C\u0005\u0002J\u0001\u0001\r\u0011\"\u0005\u0002L!A\u0011q\u000b\u0001!B\u0013\tI\u0003C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u0011Q\u0010\u0001!\u0002\u0013\t)\u0007C\u0006\u0002\u0000\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0005bCAE\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017C1\"a$\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004\"Q\u0011\u0011\u0013\u0001\t\u0006\u0004%\t%a%\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0005\"CAM\u0001\u0001\u0007I\u0011BAN\u0011!\ty\n\u0001Q!\n\u0005\r\u0001bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003K\u0003A\u0011KAR\u0011\u001d\t9\u000b\u0001C\t\u0003SCq!a,\u0001\t\u0013\t\t\fC\u0004\u00028\u0002!I!a&\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007\u0002CAe\u0001\u0011\u0005q&a3\t\u001b\u0005=\b\u0001%A\u0002\u0002\u0003%I!!=C\u00115\t\u0019\u0010\u0001I\u0001\u0004\u0003\u0005I\u0011BA{]\"i\u0011q\u001f\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002zZDQ\"a?\u0001!\u0003\r\t\u0011!C\u0005\u0003{\\\b\"DA\u0000\u0001A\u0005\u0019\u0011!A\u0005\n\t\u0005qmB\u0004\u0003\u0004-B\tA!\u0002\u0007\r)Z\u0003\u0012\u0001B\u0004\u0011\u001d\tYA\nC\u0001\u0005\u001fA\u0011B!\u0005'\u0005\u0004%\tAa\u0005\t\u0011\t\rb\u0005)A\u0005\u0005+\u00111#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:T!\u0001L\u0017\u0002\u0013M$(/Z1nS:<'B\u0001\u00180\u0003%)\u00070Z2vi&|gN\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001sA\u0011!hO\u0007\u0002W%\u0011Ah\u000b\u0002\u0010'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0006a1\u000f]1sWN+7o]5p]B\u0011q\bQ\u0007\u0002_%\u0011\u0011i\f\u0002\r'B\f'o[*fgNLwN\\\u0005\u0003{m\nAA\\1nKB\u0011QI\u0014\b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S!!S\u001c\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055S\u0015BA\"<\u00039\u0019\u0007.Z2la>Lg\u000e\u001e*p_R\fA\"\u00198bYfTX\r\u001a)mC:\u0004\"!\u0016/\u000e\u0003YS!a\u0016-\u0002\u000f1|w-[2bY*\u0011\u0011LW\u0001\u0006a2\fgn\u001d\u0006\u00037>\n\u0001bY1uC2L8\u000f^\u0005\u0003;Z\u00131\u0002T8hS\u000e\fG\u000e\u00157b]\u0006!1/\u001b8l!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0004dCR\fGn\\4\u000b\u0005\u0011|\u0013!C2p]:,7\r^8s\u0013\t1\u0017MA\u0003UC\ndW-\u0003\u0002_w\u00059AO]5hO\u0016\u0014\bC\u00016m\u001b\u0005Y'B\u0001\u00170\u0013\ti7NA\u0004Ue&<w-\u001a:\n\u0005!\\\u0014\u0001\u0004;sS\u001e<WM]\"m_\u000e\\\u0007CA9u\u001b\u0005\u0011(BA:2\u0003\u0011)H/\u001b7\n\u0005U\u0014(!B\"m_\u000e\\\u0017BA8<\u0003)yW\u000f\u001e9vi6{G-\u001a\t\u0003UfL!A_6\u0003\u0015=+H\u000f];u\u001b>$W-\u0003\u0002xw\u0005aQ\r\u001f;sC>\u0003H/[8ogB!QI #E\u0013\ty\bKA\u0002NCB\fa\u0003Z3mKR,7\t[3dWB|\u0017N\u001c;P]N#x\u000e\u001d\t\u0005\u0003\u000b\t9!D\u0001K\u0013\r\tIA\u0013\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q1\u0012qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003\u0005\u0002;\u0001!)Qh\u0003a\u0001}!)1i\u0003a\u0001\t\")!k\u0003a\u0001\t\")1k\u0003a\u0001)\")al\u0003a\u0001?\")\u0001n\u0003a\u0001S\")qn\u0003a\u0001a\")qo\u0003a\u0001q\")Ap\u0003a\u0001{\"9\u0011\u0011A\u0006A\u0002\u0005\r\u0011aB:pkJ\u001cWm]\u000b\u0003\u0003S\u0001b!a\u000b\u00026\u0005mb\u0002BA\u0017\u0003cq1aRA\u0018\u0013\u0005Y\u0015bAA\u001a\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001c\u0003s\u00111aU3r\u0015\r\t\u0019D\u0013\t\u0005\u0003{\t)%\u0004\u0002\u0002@)\u0019A&!\u0011\u000b\u0007\u0005\r3-\u0001\u0003sK\u0006$\u0017\u0002BA$\u0003\u007f\u0011qb\u00159be.$\u0015\r^1TiJ,\u0017-\\\u0001\fg>,(oY3t?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005M\u0003\u0003BA\u0003\u0003\u001fJ1!!\u0015K\u0005\u0011)f.\u001b;\t\u0013\u0005US\"!AA\u0002\u0005%\u0012a\u0001=%c\u0005A1o\\;sG\u0016\u001c\b\u0005K\u0002\u000f\u00037\u0002B!!\u0002\u0002^%\u0019\u0011q\f&\u0003\u0011Y|G.\u0019;jY\u0016\fq\u0002\u001e:jO\u001e,'/\u0012=fGV$xN]\u000b\u0003\u0003K\u0012\u0002\"a\u001a\u0002l\u0005E\u0014q\u000f\u0004\u0007\u0003S\u0002\u0001!!\u001a\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005\u0015\u0011QN\u0005\u0004\u0003_R%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000b\t\u0019(C\u0002\u0002v)\u0013AbU3sS\u0006d\u0017N_1cY\u0016\u00042AOA=\u0013\r\tYh\u000b\u0002\u0010)JLwmZ3s\u000bb,7-\u001e;pe\u0006\u0001BO]5hO\u0016\u0014X\t_3dkR|'\u000fI\u0001\u0011o\u0006$XM]7be.$&/Y2lKJ,\"!a!\u0011\u0007i\n))C\u0002\u0002\b.\u0012\u0001cV1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u0002)]\fG/\u001a:nCJ\\GK]1dW\u0016\u0014x\fJ3r)\u0011\ti%!$\t\u0013\u0005U##!AA\u0002\u0005\r\u0015!E<bi\u0016\u0014X.\u0019:l)J\f7m[3sA\u0005YAn\\4jG\u0006d\u0007\u000b\\1o+\u0005!\u0016!G5t\u0007V\u0014(/\u001a8u\u0005\u0006$8\r[\"p]N$(/^2uK\u0012,\"!a\u0001\u0002;%\u001c8)\u001e:sK:$()\u0019;dQ\u000e{gn\u001d;sk\u000e$X\rZ0%KF$B!!\u0014\u0002\u001e\"I\u0011Q\u000b\f\u0002\u0002\u0003\u0007\u00111A\u0001\u001bSN\u001cUO\u001d:f]R\u0014\u0015\r^2i\u0007>t7\u000f\u001e:vGR,G\rI\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002N\u0005a1\u000f^1siR\u0013\u0018nZ4fe\u0006\u0011\"/\u001e8BGRLg/\u0019;fIN#(/Z1n)\u0011\ti%a+\t\r\u00055&\u00041\u0001?\u0003U\u0019\b/\u0019:l'\u0016\u001c8/[8o\r>\u00148\u000b\u001e:fC6\fA\u0003]8qk2\fG/Z*uCJ$xJ\u001a4tKR\u001cH\u0003BA'\u0003gCa!!.\u001c\u0001\u0004q\u0014\u0001G:qCJ\\7+Z:tS>tGk\u001c*v]\n\u000bGo\u00195fg\u0006\u0011\u0012n\u001d(fo\u0012\u000bG/Y!wC&d\u0017M\u00197f\u0003I\u0019wN\\:ueV\u001cGOT3yi\n\u000bGo\u00195\u0015\t\u0005\r\u0011Q\u0018\u0005\b\u0003\u007fk\u0002\u0019AA\u0002\u0003Qqw\u000eR1uC\n\u000bGo\u00195fg\u0016s\u0017M\u00197fI\u0006A!/\u001e8CCR\u001c\u0007\u000e\u0006\u0003\u0002N\u0005\u0015\u0007BBAd=\u0001\u0007a(\u0001\fta\u0006\u00148nU3tg&|g\u000eV8Sk:\u0014\u0015\r^2i\u0003I9\u0018\u000e\u001e5Qe><'/Z:t\u0019>\u001c7.\u001a3\u0016\t\u00055\u00171\u001b\u000b\u0005\u0003\u001f\f)\u000f\u0005\u0003\u0002R\u0006MG\u0002\u0001\u0003\b\u0003+|\"\u0019AAl\u0005\u0005!\u0016\u0003BAm\u0003?\u0004B!!\u0002\u0002\\&\u0019\u0011Q\u001c&\u0003\u000f9{G\u000f[5oOB!\u0011QAAq\u0013\r\t\u0019O\u0013\u0002\u0004\u0003:L\b\u0002CAt?\u0011\u0005\r!!;\u0002\u0003\u0019\u0004b!!\u0002\u0002l\u0006=\u0017bAAw\u0015\nAAHY=oC6,g(\u0001\ntkB,'\u000fJ:qCJ\\7+Z:tS>tW#\u0001 \u0002\u001bM,\b/\u001a:%iJLwmZ3s+\u0005I\u0017AE:va\u0016\u0014H\u0005\u001e:jO\u001e,'o\u00117pG.,\u0012\u0001]\u0001\u0011gV\u0004XM\u001d\u0013pkR\u0004X\u000f^'pI\u0016,\u0012\u0001_\u0001\u000bgV\u0004XM\u001d\u0013tS:\\W#A0\u0002'5K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0011\u0005i23c\u0001\u0014\u0003\nA!\u0011Q\u0001B\u0006\u0013\r\u0011iA\u0013\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0015\u0011\u0001\u0004\"B)\u000eCu,\u0013#`\u0017\u0016KVC\u0001B\u000b!\u0011\u00119B!\t\u000e\u0005\te!\u0002\u0002B\u000e\u0005;\tA\u0001\\1oO*\u0011!qD\u0001\u0005U\u00064\u0018-C\u0002P\u00053\tQBQ!U\u0007\"{\u0016\nR0L\u000bf\u0003\u0003")
public class MicroBatchExecution
extends StreamExecution {
    private LogicalPlan logicalPlan;
    private final LogicalPlan analyzedPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private volatile Seq<SparkDataStream> sources;
    private final Product triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private volatile boolean bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Trigger super$trigger() {
        return super.trigger();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    private /* synthetic */ OutputMode super$outputMode() {
        return super.outputMode();
    }

    private /* synthetic */ Table super$sink() {
        return super.sink();
    }

    @Override
    public Seq<SparkDataStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<SparkDataStream> x$1) {
        this.sources = x$1;
    }

    private Product triggerExecutor() {
        return this.triggerExecutor;
    }

    private WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    private void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if (!this.bitmap$0) {
                LogicalPlan logicalPlan2;
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("logicalPlan must be initialized in QueryExecutionThread ").append("but the current thread was ").append(Thread.currentThread()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                Map toExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                String[] disabledSources = super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders().split(",");
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan.transform((PartialFunction)new scala.Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToRelationMap, v2ToExecutionRelationMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final String[] disabledSources$1;
                    private final Map v2ToRelationMap$1;
                    private final Map v2ToExecutionRelationMap$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            object = this.toExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelation), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                            TableProvider src = streamingRelationV2.source();
                            String srcName = streamingRelationV2.sourceName();
                            Table table = streamingRelationV2.table();
                            CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                            Seq<Attribute> output = streamingRelationV2.output();
                            Option<StreamingRelation> v1 = streamingRelationV2.v1Relation();
                            if (table instanceof SupportsRead) {
                                Object object2;
                                SupportsRead supportsRead = (SupportsRead)table;
                                boolean v2Disabled = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)src.getClass().getCanonicalName());
                                if (!v2Disabled && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.MICRO_BATCH_READ)) {
                                    object2 = this.v2ToRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Reading table [").append(supportsRead).append("] from DataSourceV2 named '").append(srcName).append("' [").append(src).append("]").toString());
                                        Scan scan = supportsRead.newScanBuilder(options).build();
                                        MicroBatchStream stream = scan.toMicroBatchStream(metadataPath);
                                        return new StreamingDataSourceV2Relation(output, scan, (SparkDataStream)stream, StreamingDataSourceV2Relation$.MODULE$.apply$default$4(), StreamingDataSourceV2Relation$.MODULE$.apply$default$5());
                                    });
                                } else {
                                    if (v1.isEmpty()) {
                                        throw new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(srcName).append(" does not support microbatch processing.").toString());
                                    }
                                    object2 = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        Source source = ((StreamingRelation)((Object)((Object)v1.get()))).dataSource().createSource(metadataPath);
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(srcName).append("' [").append(src).append("]").toString());
                                        return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                    });
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        StreamingRelationV2 streamingRelationV2;
                        Table table;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof StreamingRelation ? true : logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToRelationMap$1 = v2ToRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$3(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String org.apache.spark.sql.connector.catalog.TableProvider org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.Seq ), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String org.apache.spark.sql.connector.catalog.TableProvider scala.collection.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$4(org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String org.apache.spark.sql.connector.catalog.TableProvider ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.connector.catalog.TableProvider )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<SparkDataStream>)_logicalPlan.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            object = streamingExecutionRelation.source();
                        } else if (A1 instanceof StreamingDataSourceV2Relation) {
                            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                            object = streamingDataSourceV2Relation.stream();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                        return bl;
                    }
                }));
                this.uniqueSources_$eq((scala.collection.immutable.Map<SparkDataStream, ReadLimit>)((TraversableOnce)((TraversableLike)this.sources().distinct()).map(arg_0 -> MicroBatchExecution.$anonfun$logicalPlan$2(this, arg_0), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                Table table = super.sink();
                if (table instanceof SupportsWrite) {
                    SupportsWrite supportsWrite = (SupportsWrite)table;
                    StreamingWrite streamingWrite = this.createStreamingWrite(supportsWrite, this.extraOptions, _logicalPlan);
                    logicalPlan2 = new WriteToMicroBatchDataSource(streamingWrite, _logicalPlan);
                } else {
                    logicalPlan2 = _logicalPlan;
                }
                this.logicalPlan = logicalPlan2;
                this.bitmap$0 = true;
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return !this.bitmap$0 ? this.logicalPlan$lzycompute() : this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.interruptAndAwaitExecutionThreadTermination();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    @Override
    public void startTrigger() {
        ProgressReporter.startTrigger$(this);
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        ((TriggerExecutor)this.triggerExecutor()).execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (this.isActive()) {
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$1 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$1, x$3));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                    } else {
                        this.updateStatusMessage("Waiting for data to arrive");
                    }
                });
                this.finishTrigger(currentBatchHasNewData.elem, this.isCurrentBatchConstructed());
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)None$.MODULE$);
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            if (latestBatchId != 0L) {
                OffsetSeq secondLatestOffsets = (OffsetSeq)this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
                });
                this.committedOffsets_$eq(secondLatestOffsets.toStreamProgress(this.sources()));
            }
            nextOffsets.metadata().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                BoxedUnit boxedUnit;
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_10;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$1 -> (Offset)((Object)((Object)x$1)));
                                    Dataset<Row> dataset = source2.getBatch((Option<Offset>)start, offset);
                                    return var2_10;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var2_10;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Batch completion log latest batch id is ").append(latestCommittedBatchId).append(", which is not trailing ").append("batchid ").append(latestBatchId).append(" by one").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "no commit log present");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                scala.collection.immutable.Map latestOffsets = (scala.collection.immutable.Map)this.uniqueSources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SparkDataStream s;
                    SparkDataStream s2;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        SparkDataStream s3 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s3 instanceof SupportsAdmissionControl) {
                            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)s3;
                            this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(supportsAdmissionControl).toString());
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset offset2;
                                Option<org.apache.spark.sql.connector.read.streaming.Offset> startOffsetOpt = this.availableOffsets().get((SparkDataStream)supportsAdmissionControl);
                                SupportsAdmissionControl supportsAdmissionControl = supportsAdmissionControl;
                                if (supportsAdmissionControl instanceof Source) {
                                    offset2 = (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.orNull(Predef$.MODULE$.$conforms());
                                } else if (supportsAdmissionControl instanceof MicroBatchStream) {
                                    SupportsAdmissionControl supportsAdmissionControl2 = supportsAdmissionControl;
                                    offset2 = (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.map((Function1 & Serializable & scala.Serializable)offset -> supportsAdmissionControl2.deserializeOffset(offset.json())).getOrElse((Function0 & Serializable & scala.Serializable)() -> supportsAdmissionControl2.initialOffset());
                                } else {
                                    throw new MatchError((Object)supportsAdmissionControl);
                                }
                                org.apache.spark.sql.connector.read.streaming.Offset startOffset = offset2;
                                return new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)supportsAdmissionControl.latestOffset(startOffset, limit)));
                            });
                        }
                    }
                    if (tuple2 != null && (s2 = (SparkDataStream)tuple2._1()) instanceof Source) {
                        Source source = (Source)s2;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        return (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)source, source.getOffset()));
                    }
                    if (tuple2 != null && (s = (SparkDataStream)tuple2._1()) instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)s;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchStream).toString());
                        return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)microBatchStream.latestOffset())));
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    SparkDataStream s4 = (SparkDataStream)tuple2._1();
                    throw new IllegalStateException(new StringBuilder(19).append("Unexpected source: ").append(s4).toString());
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                this.availableOffsets_$eq(this.availableOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)((MapLike)latestOffsets.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$8(x0$2)))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (org.apache.spark.sql.connector.read.streaming.Offset)x$2.get())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$22 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$32 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$22, x$32));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block3: {
                            Predef$.MODULE$.assert(this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").append("Metadata ").append(this.offsetSeqMetadata().toString()).toString());
                            if (this.currentBatchId() != 0L) {
                                Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
                                if (prevBatchOff.isDefined()) {
                                    ((OffsetSeq)prevBatchOff.get()).toStreamProgress(this.sources()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                        MicroBatchExecution.$anonfun$constructNextBatch$15(x0$3);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
                                }
                            }
                            if ((long)this.minLogEntriesToMaintain() >= this.currentBatchId()) break block3;
                            this.purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        this.newData_$eq((scala.collection.immutable.Map<SparkDataStream, LogicalPlan>)((scala.collection.immutable.Map)this.reportTimeTaken("getBatch", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            org.apache.spark.sql.connector.read.streaming.Offset offset;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkDataStream source = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (available instanceof Offset) {
                        Offset offset2 = (Offset)available;
                        if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(offset2, x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                            Option current = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$5 -> (Offset)((Object)((Object)((Object)x$5))));
                            Dataset<Row> batch = source2.getBatch((Option<Offset>)current, offset2);
                            Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").append(batch.queryExecution().logical()).toString());
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append((Object)offset2).toString());
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan())));
                        }
                    }
                }
            }
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (!(stream instanceof MicroBatchStream)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            MicroBatchStream microBatchStream = (MicroBatchStream)stream;
            if (!BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$9(available, x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Option current = this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)off -> microBatchStream.deserializeOffset(off.json()));
            org.apache.spark.sql.connector.read.streaming.Offset offset3 = available;
            if (offset3 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset3;
                offset = microBatchStream.deserializeOffset(serializedOffset.json());
            } else {
                org.apache.spark.sql.connector.read.streaming.Offset offset4;
                if (offset3 == null) throw new MatchError((Object)offset3);
                offset = offset4 = offset3;
            }
            org.apache.spark.sql.connector.read.streaming.Offset endOffset = offset;
            org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)current.getOrElse((Function0 & Serializable & scala.Serializable)() -> microBatchStream.initialOffset());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchStream).append(": ").append(current).append(" -> ").append(endOffset).toString());
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchStream), (Object)new OffsetHolder(startOffset, endOffset))));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()))));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    SparkDataStream source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    object = this.$outer.newData().get((Object)source).map((Function1 & Serializable & scala.Serializable)dataPlan -> {
                        int maxFields = SQLConf$.MODULE$.get().maxToStringFields();
                        Predef$.MODULE$.assert(output.size() == dataPlan.output().size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid batch: ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(output, ",", maxFields)).append(" != ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(dataPlan.output(), ",", maxFields)).toString());
                        Seq aliases = (Seq)((TraversableLike)output.zip((GenIterable)dataPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Attribute from;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Attribute to = (Attribute)tuple2._1();
                            Attribute x$1 = from = (Attribute)tuple2._2();
                            String x$2 = to.name();
                            ExprId x$3 = to.exprId();
                            Some x$4 = new Some((Object)from.metadata());
                            Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Alias alias = new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4);
                            return alias;
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Project(aliases, dataPlan);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$6 = output;
                        boolean x$7 = true;
                        Seq x$8 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$6, x$8, x$7);
                    });
                } else if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    object = this.$outer.newData().get((Object)streamingDataSourceV2Relation.stream()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        LogicalPlan logicalPlan2 = x0$2;
                        if (!(logicalPlan2 instanceof OffsetHolder)) {
                            throw new MatchError((Object)logicalPlan2);
                        }
                        OffsetHolder offsetHolder = (OffsetHolder)logicalPlan2;
                        org.apache.spark.sql.connector.read.streaming.Offset start = offsetHolder.start();
                        org.apache.spark.sql.connector.read.streaming.Offset end = offsetHolder.end();
                        Some x$9 = new Some((Object)start);
                        Some x$10 = new Some((Object)end);
                        Seq x$11 = streamingDataSourceV2Relation.copy$default$1();
                        Scan x$12 = streamingDataSourceV2Relation.copy$default$2();
                        SparkDataStream x$13 = streamingDataSourceV2Relation.copy$default$3();
                        StreamingDataSourceV2Relation streamingDataSourceV2Relation = streamingDataSourceV2Relation.copy(x$11, x$12, x$13, (Option)x$9, (Option)x$10);
                        return streamingDataSourceV2Relation;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$14 = streamingDataSourceV2Relation.output();
                        boolean x$15 = true;
                        Seq x$16 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$14, x$16, x$15);
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$10(scala.collection.Seq ), $anonfun$applyOrElse$11(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation ), $anonfun$applyOrElse$8(scala.collection.Seq int org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9(scala.Tuple2 )}, serializedLambda);
            }
        });
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                } else if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof CurrentTimestamp ? true : expression instanceof CurrentDate;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Table table = super.sink();
        if (table instanceof Sink) {
            logicalPlan2 = newAttributePlan;
        } else if (table instanceof SupportsWrite) {
            logicalPlan2 = ((WriteToMicroBatchDataSource)newAttributePlan).createPlan(this.currentBatchId());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(super.sink()).toString());
        }
        LogicalPlan triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.currentBatchId())).toString());
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable & scala.Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.super$outputMode(), this.checkpointFile("state"), this.id(), this.runId(), this.currentBatchId(), this.offsetSeqMetadata()));
            return this.lastExecution().executedPlan();
        });
        Dataset nextBatch = new Dataset(this.lastExecution(), RowEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        Option batchSinkProgress = (Option)this.reportTimeTaken("addBatch", (Function0 & Serializable & scala.Serializable)() -> (Option)SQLExecution$.MODULE$.withNewExecutionId(this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Option<StreamWriterCommitProgress> option;
            Object object;
            Table table = this.super$sink();
            if (table instanceof Sink) {
                Sink sink = (Sink)table;
                sink.addBatch(this.currentBatchId(), nextBatch);
                object = BoxedUnit.UNIT;
            } else if (table instanceof SupportsWrite) {
                object = nextBatch.collect();
            } else {
                throw new MatchError((Object)table);
            }
            SparkPlan sparkPlan = this.lastExecution().executedPlan();
            if (sparkPlan instanceof WriteToDataSourceV2Exec) {
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = (WriteToDataSourceV2Exec)sparkPlan;
                option = writeToDataSourceV2Exec.commitProgress();
            } else {
                option = None$.MODULE$;
            }
            return option;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)batchSinkProgress);
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()));
            this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    public static final /* synthetic */ String $anonfun$logicalPlan$3(ReadLimit limit$1, SupportsAdmissionControl x2$1) {
        return new StringBuilder(60).append("The read limit ").append(limit$1).append(" for ").append(x2$1).append(" is ignored when Trigger.Once() is used.").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$logicalPlan$2(MicroBatchExecution $this, SparkDataStream x0$1) {
        block3: {
            block2: {
                var3_2 = x0$1;
                if (!(var3_2 instanceof SupportsAdmissionControl)) break block2;
                var4_3 = (SupportsAdmissionControl)var3_2;
                limit = var4_3.getDefaultReadLimit();
                v0 = $this.super$trigger();
                var6_5 = OneTimeTrigger$.MODULE$;
                if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                v1 = limit;
                var7_6 = ReadLimit.allAvailable();
                if (v1 == null ? var7_6 != null : v1.equals(var7_6) == false) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$logicalPlan$3(org.apache.spark.sql.connector.read.streaming.ReadLimit org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl ), ()Ljava/lang/String;)((ReadLimit)limit, (SupportsAdmissionControl)var4_3));
                    v2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_3), (Object)ReadLimit.allAvailable());
                } else lbl-1000:
                // 2 sources

                {
                    v2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_3), (Object)limit);
                }
                var2_7 = v2;
                break block3;
            }
            var2_7 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_2), (Object)ReadLimit.allAvailable());
        }
        return var2_7;
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(org.apache.spark.sql.connector.read.streaming.Offset available$1, org.apache.spark.sql.connector.read.streaming.Offset committed) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = committed;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$1;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SparkDataStream source = (SparkDataStream)tuple2._1();
        org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable & scala.Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$8(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$constructNextBatch$15(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                if (off instanceof Offset) {
                    Offset offset = (Offset)off;
                    source.commit(offset);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (stream instanceof MicroBatchStream) {
                MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                microBatchStream.commit(microBatchStream.deserializeOffset(off.json()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SparkDataStream src = (SparkDataStream)tuple2._1();
        throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset x3$2, org.apache.spark.sql.connector.read.streaming.Offset x$4) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$4;
        Offset offset2 = x3$2;
        return offset == null ? offset2 != null : !offset.equals((Object)offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$9(org.apache.spark.sql.connector.read.streaming.Offset available$2, org.apache.spark.sql.connector.read.streaming.Offset x$6) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$6;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$2;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public MicroBatchExecution(SparkSession sparkSession, String name, String checkpointRoot, LogicalPlan analyzedPlan, Table sink, Trigger trigger, Clock triggerClock, OutputMode outputMode, scala.collection.immutable.Map<String, String> extraOptions, boolean deleteCheckpointOnStop) {
        Product product;
        this.analyzedPlan = analyzedPlan;
        this.extraOptions = extraOptions;
        super(sparkSession, name, checkpointRoot, analyzedPlan, sink, trigger, triggerClock, outputMode, deleteCheckpointOnStop);
        this.sources = (Seq)Seq$.MODULE$.empty();
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            product = new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new OneTimeExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
    }
}

