/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.FileFormatException;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class OrcUtils$
implements Logging {
    public static OrcUtils$ MODULE$;
    private final Map<String, String> extensionsForCompressionCodecNames;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<String, String> extensionsForCompressionCodecNames() {
        return this.extensionsForCompressionCodecNames;
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$listOrcFiles$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$listOrcFiles$4(x$4)));
        return paths;
    }

    public Option<TypeDescription> readSchema(Path file, Configuration conf, boolean ignoreCorruptFiles) {
        Object object;
        FileSystem fs = file.getFileSystem(conf);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
        try {
            TypeDescription schema = (TypeDescription)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable & scala.Serializable)reader -> reader.getSchema());
            object = schema.getFieldNames().size() == 0 ? None$.MODULE$ : new Some((Object)schema);
        }
        catch (FileFormatException e) {
            if (ignoreCorruptFiles) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(file).toString(), e);
                object = None$.MODULE$;
            }
            throw new SparkException(new StringBuilder(32).append("Could not read footer for file: ").append(file).toString(), (Throwable)e);
        }
        return object;
    }

    public Option<StructType> readSchema(SparkSession sparkSession, Seq<FileStatus> files) {
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return files.toIterator().map((Function1 & Serializable & scala.Serializable)file -> MODULE$.readSchema(file.getPath(), conf, ignoreCorruptFiles)).collectFirst((PartialFunction)new scala.Serializable(files){
            public static final long serialVersionUID = 0L;
            private final Seq files$1;

            public final <A1 extends Option<TypeDescription>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    TypeDescription schema = (TypeDescription)some.value();
                    OrcUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reading schema from file ").append($this.files$1).append(", got Hive schema string: ").append(schema).toString());
                    object = (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema.toString());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<TypeDescription> x1) {
                Option<TypeDescription> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
            {
                this.files$1 = files$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.orc.OrcUtils$$anonfun$readSchema$5 org.apache.orc.TypeDescription )}, serializedLambda);
            }
        });
    }

    public Seq<StructType> readOrcSchemasInParallel(Seq<FileStatus> files, Configuration conf, boolean ignoreCorruptFiles) {
        return (Seq)ThreadUtils$.MODULE$.parmap(files, "readingOrcSchemas", 8, (Function1 & Serializable & scala.Serializable)currentFile -> MODULE$.readSchema(currentFile.getPath(), conf, ignoreCorruptFiles).map((Function1 & Serializable & scala.Serializable)s -> (StructType)CatalystSqlParser$.MODULE$.parseDataType(s.toString()))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Seq<FileStatus> files2, Map<String, String> options) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        return orcOptions.mergeSchema() ? SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, files2, (Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>>)(Function3 & Serializable & scala.Serializable)(files, conf, ignoreCorruptFiles) -> OrcUtils$.MODULE$.readOrcSchemasInParallel((Seq<FileStatus>)files, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles))) : this.readSchema(sparkSession, files2);
    }

    public Option<int[]> requestedColumnIds(boolean isCaseSensitive, StructType dataSchema, StructType requiredSchema, Reader reader, Configuration conf) {
        None$ none$;
        Buffer orcFieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(reader.getSchema().getFieldNames()).asScala();
        if (orcFieldNames.isEmpty()) {
            none$ = None$.MODULE$;
        } else if (orcFieldNames.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("_col")))) {
            Predef$.MODULE$.assert(orcFieldNames.length() <= dataSchema.length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("The given data schema ").append(dataSchema.catalogString()).append(" has less fields than the actual ORC physical schema, ").append("no idea which columns were dropped, fail to read.").toString());
            none$ = new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames())).map((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$3(dataSchema, orcFieldNames, name)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else if (isCaseSensitive) {
            none$ = new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$4(orcFieldNames, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else {
            Map caseInsensitiveOrcFieldMap = orcFieldNames.groupBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT));
            none$ = new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$7(caseInsensitiveOrcFieldMap, reader, x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        }
        return none$;
    }

    public void addSparkVersionMetadata(Writer writer) {
        writer.addUserMetadata(package$.MODULE$.SPARK_VERSION_METADATA_KEY(), StandardCharsets.UTF_8.encode(org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()));
    }

    public String orcTypeDescriptionString(DataType dt) {
        String string;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            String[] fieldTypes = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(org.apache.spark.sql.catalyst.util.package$.MODULE$.quoteIdentifier(f.name())).append(":").append(MODULE$.orcTypeDescriptionString(f.dataType())).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            string = new StringBuilder(8).append("struct<").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).mkString(",")).append(">").toString();
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            string = new StringBuilder(7).append("array<").append(this.orcTypeDescriptionString(arrayType.elementType())).append(">").toString();
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            string = new StringBuilder(6).append("map<").append(this.orcTypeDescriptionString(mapType.keyType())).append(",").append(this.orcTypeDescriptionString(mapType.valueType())).append(">").toString();
        } else {
            string = dt.catalogString();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$3(Path x$3) {
        return x$3.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$4(Path x$4) {
        return x$4.getName().startsWith(".");
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$3(StructType dataSchema$1, Buffer orcFieldNames$1, String name) {
        int index = dataSchema$1.fieldIndex(name);
        return index < orcFieldNames$1.length() ? index : -1;
    }

    public static final /* synthetic */ boolean $anonfun$requestedColumnIds$5(String name$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseSensitiveResolution().apply((Object)x$6, (Object)name$1));
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$4(Buffer orcFieldNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        int n = orcFieldNames$1.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$requestedColumnIds$5(name, x$6))) != -1 ? idx : -1;
        return n;
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$8(Reader reader$1, String requiredFieldName$1, int idx$1, Buffer matchedOrcFields) {
        if (matchedOrcFields.size() > 1) {
            String matchedOrcFieldsString = matchedOrcFields.mkString("[", ", ", "]");
            reader$1.close();
            throw new RuntimeException(new StringBuilder(54).append("Found duplicate field(s) \"").append(requiredFieldName$1).append("\": ").append(matchedOrcFieldsString).append(" in case-insensitive mode").toString());
        }
        return idx$1;
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$7(Map caseInsensitiveOrcFieldMap$1, Reader reader$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String requiredFieldName = (String)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        int n = BoxesRunTime.unboxToInt((Object)caseInsensitiveOrcFieldMap$1.get((Object)requiredFieldName.toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)matchedOrcFields -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$8(reader$1, requiredFieldName, idx, matchedOrcFields))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        return n;
    }

    private OrcUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.extensionsForCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NONE"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SNAPPY"), (Object)".snappy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ZLIB"), (Object)".zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LZO"), (Object)".lzo")}));
    }
}

