/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public final class MutableColumnarRow
extends InternalRow {
    public int rowId;
    private final ColumnVector[] columns;
    private final WritableColumnVector[] writableColumns;

    public MutableColumnarRow(ColumnVector[] columns) {
        this.columns = columns;
        this.writableColumns = null;
    }

    public MutableColumnarRow(WritableColumnVector[] writableColumns) {
        this.columns = writableColumns;
        this.writableColumns = writableColumns;
    }

    public int numFields() {
        return this.columns.length;
    }

    public InternalRow copy() {
        GenericInternalRow row = new GenericInternalRow(this.columns.length);
        for (int i = 0; i < this.numFields(); ++i) {
            if (this.isNullAt(i)) {
                row.setNullAt(i);
                continue;
            }
            DataType dt = this.columns[i].dataType();
            if (dt instanceof BooleanType) {
                row.setBoolean(i, this.getBoolean(i));
                continue;
            }
            if (dt instanceof ByteType) {
                row.setByte(i, this.getByte(i));
                continue;
            }
            if (dt instanceof ShortType) {
                row.setShort(i, this.getShort(i));
                continue;
            }
            if (dt instanceof IntegerType) {
                row.setInt(i, this.getInt(i));
                continue;
            }
            if (dt instanceof LongType) {
                row.setLong(i, this.getLong(i));
                continue;
            }
            if (dt instanceof FloatType) {
                row.setFloat(i, this.getFloat(i));
                continue;
            }
            if (dt instanceof DoubleType) {
                row.setDouble(i, this.getDouble(i));
                continue;
            }
            if (dt instanceof StringType) {
                row.update(i, (Object)this.getUTF8String(i).copy());
                continue;
            }
            if (dt instanceof BinaryType) {
                row.update(i, (Object)this.getBinary(i));
                continue;
            }
            if (dt instanceof DecimalType) {
                DecimalType t = (DecimalType)dt;
                row.setDecimal(i, this.getDecimal(i, t.precision(), t.scale()), t.precision());
                continue;
            }
            if (dt instanceof DateType) {
                row.setInt(i, this.getInt(i));
                continue;
            }
            if (dt instanceof TimestampType) {
                row.setLong(i, this.getLong(i));
                continue;
            }
            throw new RuntimeException("Not implemented. " + dt);
        }
        return row;
    }

    public boolean anyNull() {
        throw new UnsupportedOperationException();
    }

    public boolean isNullAt(int ordinal) {
        return this.columns[ordinal].isNullAt(this.rowId);
    }

    public boolean getBoolean(int ordinal) {
        return this.columns[ordinal].getBoolean(this.rowId);
    }

    public byte getByte(int ordinal) {
        return this.columns[ordinal].getByte(this.rowId);
    }

    public short getShort(int ordinal) {
        return this.columns[ordinal].getShort(this.rowId);
    }

    public int getInt(int ordinal) {
        return this.columns[ordinal].getInt(this.rowId);
    }

    public long getLong(int ordinal) {
        return this.columns[ordinal].getLong(this.rowId);
    }

    public float getFloat(int ordinal) {
        return this.columns[ordinal].getFloat(this.rowId);
    }

    public double getDouble(int ordinal) {
        return this.columns[ordinal].getDouble(this.rowId);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.columns[ordinal].getDecimal(this.rowId, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        return this.columns[ordinal].getUTF8String(this.rowId);
    }

    public byte[] getBinary(int ordinal) {
        return this.columns[ordinal].getBinary(this.rowId);
    }

    public CalendarInterval getInterval(int ordinal) {
        return this.columns[ordinal].getInterval(this.rowId);
    }

    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.columns[ordinal].getStruct(this.rowId);
    }

    public ColumnarArray getArray(int ordinal) {
        return this.columns[ordinal].getArray(this.rowId);
    }

    public ColumnarMap getMap(int ordinal) {
        return this.columns[ordinal].getMap(this.rowId);
    }

    public Object get(int ordinal, DataType dataType) {
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType t = (DecimalType)dataType;
            return this.getDecimal(ordinal, t.precision(), t.scale());
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType).fields().length);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        throw new UnsupportedOperationException("Datatype not supported " + dataType);
    }

    public void update(int ordinal, Object value) {
        if (value == null) {
            this.setNullAt(ordinal);
        } else {
            DataType dt = this.columns[ordinal].dataType();
            if (dt instanceof BooleanType) {
                this.setBoolean(ordinal, (Boolean)value);
            } else if (dt instanceof IntegerType) {
                this.setInt(ordinal, (Integer)value);
            } else if (dt instanceof ShortType) {
                this.setShort(ordinal, (Short)value);
            } else if (dt instanceof LongType) {
                this.setLong(ordinal, (Long)value);
            } else if (dt instanceof FloatType) {
                this.setFloat(ordinal, ((Float)value).floatValue());
            } else if (dt instanceof DoubleType) {
                this.setDouble(ordinal, (Double)value);
            } else if (dt instanceof DecimalType) {
                DecimalType t = (DecimalType)dt;
                Decimal d = Decimal.apply((BigDecimal)((BigDecimal)value), (int)t.precision(), (int)t.scale());
                this.setDecimal(ordinal, d, t.precision());
            } else {
                throw new UnsupportedOperationException("Datatype not supported " + dt);
            }
        }
    }

    public void setNullAt(int ordinal) {
        this.writableColumns[ordinal].putNull(this.rowId);
    }

    public void setBoolean(int ordinal, boolean value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putBoolean(this.rowId, value);
    }

    public void setByte(int ordinal, byte value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putByte(this.rowId, value);
    }

    public void setShort(int ordinal, short value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putShort(this.rowId, value);
    }

    public void setInt(int ordinal, int value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putInt(this.rowId, value);
    }

    public void setLong(int ordinal, long value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putLong(this.rowId, value);
    }

    public void setFloat(int ordinal, float value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putFloat(this.rowId, value);
    }

    public void setDouble(int ordinal, double value) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putDouble(this.rowId, value);
    }

    public void setDecimal(int ordinal, Decimal value, int precision) {
        this.writableColumns[ordinal].putNotNull(this.rowId);
        this.writableColumns[ordinal].putDecimal(this.rowId, value, precision);
    }
}

