/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousDataSourceRDDPartition;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousQueuedDataReader;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.util.NextIterator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\b\u0011\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0003>\u0011!!\u0006A!A!\u0002\u0013q\u0004\"B+\u0001\t\u00031\u0006\"B/\u0001\t#r\u0006\"B3\u0001\t\u00032\u0007\"B9\u0001\t\u0003\u0012x!B?\u0011\u0011\u0003qh!B\b\u0011\u0011\u0003y\bBB+\f\t\u0003\ti\u0001\u0003\u0005\u0002\u0010-!\t\u0001EA\t\u0011%\tidCA\u0001\n\u0013\tyDA\fD_:$\u0018N\\;pkN$\u0015\r^1T_V\u00148-\u001a*E\t*\u0011\u0011CE\u0001\u000bG>tG/\u001b8v_V\u001c(BA\n\u0015\u0003%\u0019HO]3b[&twM\u0003\u0002\u0016-\u0005IQ\r_3dkRLwN\u001c\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0001\u00022!\t\u0013'\u001b\u0005\u0011#BA\u0012\u0019\u0003\r\u0011H\rZ\u0005\u0003K\t\u00121A\u0015#E!\t9#&D\u0001)\u0015\tIc#\u0001\u0005dCR\fG._:u\u0013\tY\u0003FA\u0006J]R,'O\\1m%><\u0018AA:d!\tqs&D\u0001\u0019\u0013\t\u0001\u0004D\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0007eCR\f\u0017+^3vKNK'0\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0004\u0013:$\u0018aE3q_\u000eD\u0007k\u001c7m\u0013:$XM\u001d<bY6\u001b\bCA\u001a;\u0013\tYDG\u0001\u0003M_:<\u0017!\u0006:fC\u0012,'/\u00138qkR\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}A\u0019qh\u0012&\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u001f\u0003\u0019a$o\\8u}%\tQ'\u0003\u0002Gi\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rR\u00022a\u0013*'\u001b\u0005a%BA'O\u0003\u0019\u0011X-\u00193fe*\u0011q\nU\u0001\u0003mJR!!\u0015\f\u0002\u000fM|WO]2fg&\u00111\u000b\u0014\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0003Y\u0011X-\u00193fe&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N\u0004\u0013A\u0002\u001fj]&$h\bF\u0003X3j[F\f\u0005\u0002Y\u00015\t\u0001\u0003C\u0003-\r\u0001\u0007Q\u0006C\u00032\r\u0001\u0007!\u0007C\u00039\r\u0001\u0007\u0011\bC\u0003=\r\u0001\u0007a(A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0002?B\u00191\u0007\u00192\n\u0005\u0005$$!B!se\u0006L\bC\u0001\u0018d\u0013\t!\u0007DA\u0005QCJ$\u0018\u000e^5p]\u000691m\\7qkR,GcA4kYB\u0019q\b\u001b\u0014\n\u0005%L%\u0001C%uKJ\fGo\u001c:\t\u000b-D\u0001\u0019\u00012\u0002\u000bM\u0004H.\u001b;\t\u000b5D\u0001\u0019\u00018\u0002\u000f\r|g\u000e^3yiB\u0011af\\\u0005\u0003ab\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006)r-\u001a;Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cHCA:}!\ryt\t\u001e\t\u0003kft!A^<\u0011\u0005\u0005#\u0014B\u0001=5\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a$\u0004\"B6\n\u0001\u0004\u0011\u0017aF\"p]RLg.^8vg\u0012\u000bG/Y*pkJ\u001cWM\u0015#E!\tA6bE\u0003\f\u0003\u0003\t9\u0001E\u00024\u0003\u0007I1!!\u00025\u0005\u0019\te.\u001f*fMB\u00191'!\u0003\n\u0007\u0005-AG\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001\u007f\u0003M9W\r^\"p]RLg.^8vgJ+\u0017\rZ3s)\u0011\t\u0019\"!\u000e1\t\u0005U\u00111\u0005\t\u0007\u0003/\tY\"a\b\u000e\u0005\u0005e!BA\nM\u0013\u0011\ti\"!\u0007\u0003=\r{g\u000e^5ok>,8/\u00138qkR\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014\b\u0003BA\u0011\u0003Ga\u0001\u0001B\u0006\u0002&5\t\t\u0011!A\u0003\u0002\u0005\u001d\"aA0%cE!\u0011\u0011FA\u0018!\r\u0019\u00141F\u0005\u0004\u0003[!$a\u0002(pi\"Lgn\u001a\t\u0004g\u0005E\u0012bAA\u001ai\t\u0019\u0011I\\=\t\r5k\u0001\u0019AA\u001c!\u0011Y\u0015\u0011\b\u0014\n\u0007\u0005mBJ\u0001\u000bJ]B,H\u000fU1si&$\u0018n\u001c8SK\u0006$WM]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0004PE*,7\r\u001e")
public class ContinuousDataSourceRDD
extends RDD<InternalRow> {
    private final int dataQueueSize;
    private final long epochPollIntervalMs;
    private final Seq<InputPartition<InternalRow>> readerInputPartitions;

    private Seq<InputPartition<InternalRow>> readerInputPartitions() {
        return this.readerInputPartitions;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.readerInputPartitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPartition inputPartition = (InputPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ContinuousDataSourceRDDPartition continuousDataSourceRDDPartition = new ContinuousDataSourceRDDPartition(index, inputPartition);
            return continuousDataSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        if (context.attemptNumber() != 0) {
            throw new ContinuousTaskRetryException();
        }
        ContinuousDataSourceRDDPartition partition = (ContinuousDataSourceRDDPartition)split;
        if (partition.queueReader() == null) {
            partition.queueReader_$eq(new ContinuousQueuedDataReader(partition, context, this.dataQueueSize, this.epochPollIntervalMs));
        }
        ContinuousQueuedDataReader readerForPartition = partition.queueReader();
        return new NextIterator<InternalRow>(null, readerForPartition){
            private final ContinuousQueuedDataReader readerForPartition$1;

            public InternalRow getNext() {
                InternalRow internalRow;
                InternalRow internalRow2 = this.readerForPartition$1.next();
                if (internalRow2 == null) {
                    this.finished_$eq(true);
                    internalRow = null;
                } else {
                    internalRow = internalRow2;
                }
                return internalRow;
            }

            public void close() {
            }
            {
                this.readerForPartition$1 = readerForPartition$1;
            }
        };
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((ContinuousDataSourceRDDPartition)split).inputPartition().preferredLocations());
    }

    public ContinuousDataSourceRDD(SparkContext sc, int dataQueueSize, long epochPollIntervalMs, Seq<InputPartition<InternalRow>> readerInputPartitions) {
        this.dataQueueSize = dataQueueSize;
        this.epochPollIntervalMs = epochPollIntervalMs;
        this.readerInputPartitions = readerInputPartitions;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

