/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.WrappedString;
import scala.runtime.BoxesRunTime;

public final class CSVUtils$ {
    public static CSVUtils$ MODULE$;

    static {
        new CSVUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        void var3_3;
        Dataset<String> nonEmptyLines = lines.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        return options.isCommentSet() ? nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$).startsWith(((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString()).unary_$bang()) : var3_3;
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return iter.filter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$filterCommentAndEmpty$1(options, line)));
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        return options.headerFlag() ? iter.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$filterHeaderLine$1(firstLine, x$1))) : iter;
    }

    public Iterator<String> skipComments(Iterator<String> iter, CSVOptions options) {
        Iterator iterator;
        if (options.isCommentSet()) {
            String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            iterator = iter.dropWhile((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$skipComments$1(commentPrefix, line)));
        } else {
            iterator = iter.dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$skipComments$2(x$2)));
        }
        return iterator;
    }

    public Option<String> extractHeader(Iterator<String> iter, CSVOptions options) {
        Iterator<String> nonEmptyLines = this.skipComments(iter, options);
        return nonEmptyLines.hasNext() ? new Some(nonEmptyLines.next()) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char toChar(String str) throws IllegalArgumentException {
        Some some;
        Some some2;
        Some some3;
        Some some4;
        Some some5;
        Some some6;
        char c;
        WrappedString wrappedString = Predef$.MODULE$.wrapString(str);
        Some some7 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(0) == 0) {
            throw new IllegalArgumentException("Delimiter cannot be empty string");
        }
        Some some8 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some8.isEmpty() && some8.get() != null && ((SeqLike)some8.get()).lengthCompare(1) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)((SeqLike)some8.get()).apply(0)))) {
            throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
        }
        Some some9 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some9.isEmpty() && some9.get() != null && ((SeqLike)some9.get()).lengthCompare(1) == 0) {
            int c2 = BoxesRunTime.unboxToChar((Object)((SeqLike)some9.get()).apply(0));
            return (char)c2;
        }
        Some some10 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some10.isEmpty() && some10.get() != null && ((SeqLike)some10.get()).lengthCompare(2) == 0) {
            char c3 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(0));
            char c4 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(1));
            if ('\\' == c3 && 't' == c4) {
                return (char)9;
            }
        }
        if (!(some6 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some6.get() != null && ((SeqLike)some6.get()).lengthCompare(2) == 0) {
            char c5 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(0));
            char c6 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(1));
            if ('\\' == c5 && 'r' == c6) {
                return (char)13;
            }
        }
        if (!(some5 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some5.get() != null && ((SeqLike)some5.get()).lengthCompare(2) == 0) {
            char c7 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(0));
            char c8 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(1));
            if ('\\' == c7 && 'b' == c8) {
                return (char)8;
            }
        }
        if (!(some4 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(2) == 0) {
            char c9 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(0));
            char c10 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(1));
            if ('\\' == c9 && 'f' == c10) {
                return (char)12;
            }
        }
        if (!(some3 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
            char c11 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(0));
            char c12 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(1));
            if ('\\' == c11 && '\"' == c12) {
                return (char)34;
            }
        }
        if (!(some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            char c13 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(0));
            char c14 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(1));
            if ('\\' == c13 && '\'' == c14) {
                return (char)39;
            }
        }
        if (!(some = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            char c15 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0));
            char c16 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(1));
            if ('\\' == c15 && '\\' == c16) {
                return (char)92;
            }
        }
        String string = str;
        String string2 = "\u0000";
        if (string == null) {
            if (string2 == null) return (char)0;
        } else if (string.equals(string2)) {
            return (char)0;
        }
        Some some11 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (some11.isEmpty()) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (some11.get() == null) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (((SeqLike)some11.get()).lengthCompare(2) != 0) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        char c17 = BoxesRunTime.unboxToChar((Object)((SeqLike)some11.get()).apply(0));
        if ('\\' != c17) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        throw new IllegalArgumentException(new StringBuilder(45).append("Unsupported special character for delimiter: ").append(str).toString());
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("samplingRatio (").append(options.samplingRatio()).append(") should be greater than 0").toString());
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("samplingRatio (").append(options.samplingRatio()).append(") should be greater than 0").toString());
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    public static final /* synthetic */ boolean $anonfun$filterCommentAndEmpty$1(CSVOptions options$1, String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(((Object)BoxesRunTime.boxToCharacter((char)options$1.comment())).toString());
    }

    public static final /* synthetic */ boolean $anonfun$filterHeaderLine$1(String firstLine$1, String x$1) {
        String string = x$1;
        String string2 = firstLine$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$1(String commentPrefix$1, String line) {
        return line.trim().isEmpty() || line.trim().startsWith(commentPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$2(String x$2) {
        return x$2.trim().isEmpty();
    }

    private CSVUtils$() {
        MODULE$ = this;
    }
}

