/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001E\t\u0001=!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00039\u0001\u0011\u0005\u0011\b\u0003\u0004=\u0001\u0001\u0006K!\u0010\u0005\u0007\u0001\u0002\u0001\u000b\u0015B\u001f\t\r\u0005\u0003\u0001\u0015)\u0003>\u0011\u0019\u0011\u0005\u0001)Q\u0005\u0007\"1a\t\u0001Q!\n\rCaa\u0012\u0001!B\u0013A\u0005\"\u0002,\u0001\t\u00139\u0006\"B.\u0001\t\u0003b\u0006\"\u00025\u0001\t\u0003J\u0007\"\u00027\u0001\t\u0003j\u0007\"B8\u0001\t\u0013\u0001\b\"B9\u0001\t\u0003\u0012\b\"B;\u0001\t\u00032(A\u0007\"bg&\u001cwK]5uKR\u000b7o[*uCR\u001cHK]1dW\u0016\u0014(B\u0001\n\u0014\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005Q)\u0012!C3yK\u000e,H/[8o\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\u0011\u0001q$J\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0012\u0013\tA\u0013CA\u000bXe&$X\rV1tWN#\u0018\r^:Ue\u0006\u001c7.\u001a:\u0011\u0005)jS\"A\u0016\u000b\u00051:\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0011\u0019wN\u001c4\u000b\u0005UJ\u0012A\u00025bI>|\u0007/\u0003\u00028e\ti1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDC\u0001\u001e<!\t1\u0003\u0001C\u00030\u0005\u0001\u0007\u0001'A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003AyJ!aP\u0011\u0003\u0007%sG/\u0001\u0005ok64\u0015\u000e\\3t\u00039\u0019XOY7jiR,GMR5mKN\f\u0001B\\;n\u0005f$Xm\u001d\t\u0003A\u0011K!!R\u0011\u0003\t1{gnZ\u0001\b]Vl'k\\<t\u0003\u001d\u0019WO\u001d$jY\u0016\u00042\u0001I%L\u0013\tQ\u0015E\u0001\u0004PaRLwN\u001c\t\u0003\u0019Ns!!T)\u0011\u00059\u000bS\"A(\u000b\u0005Ak\u0012A\u0002\u001fs_>$h(\u0003\u0002SC\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011\u0016%A\u0006hKR4\u0015\u000e\\3TSj,GC\u0001-Z!\r\u0001\u0013j\u0011\u0005\u00065&\u0001\raS\u0001\tM&dW\rU1uQ\u0006aa.Z<QCJ$\u0018\u000e^5p]R\u0011Q\f\u0019\t\u0003AyK!aX\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006C*\u0001\rAY\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgB\u00111MZ\u0007\u0002I*\u0011Q-F\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\r\u001a\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005oK^\u0014UoY6fiR\u0011QL\u001b\u0005\u0006W.\u0001\r!P\u0001\tEV\u001c7.\u001a;JI\u00069a.Z<GS2,GCA/o\u0011\u0015QF\u00021\u0001L\u0003=\u0019H/\u0019;DkJ\u0014XM\u001c;GS2,G#A/\u0002\r9,wOU8x)\ti6\u000fC\u0003u\u001d\u0001\u0007!-A\u0002s_^\fQbZ3u\r&t\u0017\r\\*uCR\u001cH#A<\u0011\u0005\u0019B\u0018BA=\u0012\u000599&/\u001b;f)\u0006\u001c8n\u0015;biN\u0004")
public class BasicWriteTaskStatsTracker
implements WriteTaskStatsTracker,
Logging {
    private final Configuration hadoopConf;
    private int numPartitions;
    private int numFiles;
    private int submittedFiles;
    private long numBytes;
    private long numRows;
    private Option<String> curFile;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> getFileSize(String filePath) {
        Some some;
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        try {
            some = new Some((Object)BoxesRunTime.boxToLong((long)fs.getFileStatus(path).getLen()));
        }
        catch (FileNotFoundException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("File ").append(path).append(" is not yet visible").toString(), e);
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public void newPartition(InternalRow partitionValues) {
        ++this.numPartitions;
    }

    @Override
    public void newBucket(int bucketId) {
    }

    @Override
    public void newFile(String filePath) {
        this.statCurrentFile();
        this.curFile = new Some((Object)filePath);
        ++this.submittedFiles;
    }

    private void statCurrentFile() {
        this.curFile.foreach((Function1 & Serializable & scala.Serializable)path -> {
            BasicWriteTaskStatsTracker.$anonfun$statCurrentFile$1(this, path);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void newRow(InternalRow row) {
        ++this.numRows;
    }

    @Override
    public WriteTaskStats getFinalStats() {
        this.statCurrentFile();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.taskMetrics().outputMetrics()).foreach((Function1 & Serializable & scala.Serializable)outputMetrics -> {
            BasicWriteTaskStatsTracker.$anonfun$getFinalStats$2(this, outputMetrics);
            return BoxedUnit.UNIT;
        });
        if (this.submittedFiles != this.numFiles) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(153).append("Expected ").append($this.submittedFiles).append(" files, but only saw ").append($this.numFiles).append(". ").append("This could be due to the output format not writing empty files, ").append("or files being not immediately visible in the filesystem.").toString());
        }
        return new BasicWriteTaskStats(this.numPartitions, this.numFiles, this.numBytes, this.numRows);
    }

    public static final /* synthetic */ void $anonfun$statCurrentFile$1(BasicWriteTaskStatsTracker $this, String path) {
        $this.getFileSize(path).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> {
            $this.numBytes += len;
            ++$this.numFiles;
        });
        $this.curFile = None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$getFinalStats$2(BasicWriteTaskStatsTracker $this, OutputMetrics outputMetrics) {
        outputMetrics.setBytesWritten($this.numBytes);
        outputMetrics.setRecordsWritten($this.numRows);
    }

    public BasicWriteTaskStatsTracker(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.numPartitions = 0;
        this.numFiles = 0;
        this.submittedFiles = 0;
        this.numBytes = 0L;
        this.numRows = 0L;
        this.curFile = None$.MODULE$;
    }
}

