/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=wA\u0002\u001f>\u0011\u0003{4J\u0002\u0004N{!\u0005uH\u0014\u0005\u0006=\u0006!\t\u0001\u0019\u0005\bC\u0006\u0011\r\u0011\"\u0011c\u0011\u00191\u0017\u0001)A\u0005G\")q-\u0001C!Q\"9\u0011qQ\u0001\u0005B\u0005%\u0005b\u0002B:\u0003\u0011\u0005#Q\u000f\u0004\u0005Y\u0006\u0001Q\u000eC\u0005\u0000\u0011\t\u0005\t\u0015!\u0003\u0002\u0002!1a\f\u0003C\u0001\u0003\u0013A\u0001\"a\u0004\t\u0001\u0004%IA\u0019\u0005\n\u0003#A\u0001\u0019!C\u0005\u0003'Aq!a\b\tA\u0003&1\r\u0003\u0005\u0002\"!\u0001\r\u0011\"\u0003c\u0011%\t\u0019\u0003\u0003a\u0001\n\u0013\t)\u0003C\u0004\u0002*!\u0001\u000b\u0015B2\t\u0013\u0005-\u0002B1A\u0005\n\u00055\u0002\u0002CA \u0011\u0001\u0006I!a\f\t\u0011\u0005\u0005\u0003\u00021A\u0005\n\tD\u0011\"a\u0011\t\u0001\u0004%I!!\u0012\t\u000f\u0005%\u0003\u0002)Q\u0005G\"1\u00111\n\u0005\u0005B\tDa!!\u0014\t\t\u0003\u0012\u0007bBA(\u0011\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003GBA\u0011IA3\r\u0019\ty)\u0001\u0001\u0002\u0012\"Q\u0011Q\u0014\u000e\u0003\u0002\u0003\u0006I!a\u001a\t\u0013}T\"\u0011!Q\u0001\n\u0005}\u0005B\u00020\u001b\t\u0003\t\t\u000b\u0003\u0005\u0002*j\u0001\r\u0011\"\u0003c\u0011%\tYK\u0007a\u0001\n\u0013\ti\u000bC\u0004\u00022j\u0001\u000b\u0015B2\t\u0011\u0005M&\u00041A\u0005\n\tD\u0011\"!.\u001b\u0001\u0004%I!a.\t\u000f\u0005m&\u0004)Q\u0005G\"Y\u0011Q\u0018\u000eA\u0002\u0003\u0007I\u0011BA`\u0011-\t9M\u0007a\u0001\u0002\u0004%I!!3\t\u0017\u00055'\u00041A\u0001B\u0003&\u0011\u0011\u0019\u0005\b\u0003\u001fTB\u0011IAi\u0011\u001d\t9N\u0007C!\u00033Dq!!9\u001b\t\u0013\t\u0019\u000fC\u0004\u0003\u0004i!IA!\u0002\t\u000f\t%!\u0004\"\u0003\u0003\f!9!1\u0003\u000e\u0005\n\tU\u0001b\u0002B\r5\u0011%!1\u0004\u0005\b\u0005GQB\u0011\u0002B\u0013\u0011\u001d\u0011IC\u0007C\u0005\u0005WAqAa\r\u001b\t\u0013\u0011)\u0004C\u0004\u0003:i!IAa\u000f\t\u000f\t\r#\u0004\"\u0003\u0003F!9!\u0011\r\u000e\u0005B\t\r\u0004\"\u0003BH\u0003\u0005\u0005I\u0011\tBI\u0011!\u0011y*AA\u0001\n\u0003\u0011\u0007\"\u0003BQ\u0003\u0005\u0005I\u0011\u0001BR\u0011%\u00119+AA\u0001\n\u0003\u0012I\u000bC\u0005\u00038\u0006\t\t\u0011\"\u0001\u0003:\"I!QX\u0001\u0002\u0002\u0013\u0005#q\u0018\u0005\n\u0005\u0003\f\u0011\u0011!C!\u0005\u0007D\u0011B!2\u0002\u0003\u0003%IAa2\u0002#I+h\u000eT3oORDWI\\2pI&twM\u0003\u0002?\u007f\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t\u0001\u0015)\u0001\u0005d_2,XN\\1s\u0015\t\u00115)A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A)R\u0001\u0004gFd'B\u0001$H\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\u0011\u00051\u000bQ\"A\u001f\u0003#I+h\u000eT3oORDWI\\2pI&twmE\u0003\u0002\u001fVC6\f\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019ZK!aV\u001f\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002Q3&\u0011!,\u0015\u0002\b!J|G-^2u!\t\u0001F,\u0003\u0002^#\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001L\u0003\u0019!\u0018\u0010]3JIV\t1\r\u0005\u0002QI&\u0011Q-\u0015\u0002\u0004\u0013:$\u0018a\u0002;za\u0016LE\rI\u0001\bK:\u001cw\u000eZ3s+\rI\u0017\u0011\u0011\u000b\u0004U\u0006\r\u0005\u0003B6\t\u0003\u007fj\u0011!\u0001\u0002\b\u000b:\u001cw\u000eZ3s+\tq7oE\u0002\t\u001f>\u00042\u0001\u00149r\u0013\taW\b\u0005\u0002sg2\u0001A!\u0002;\t\u0005\u0004)(!\u0001+\u0012\u0005YL\bC\u0001)x\u0013\tA\u0018KA\u0004O_RD\u0017N\\4\u0011\u0005ilX\"A>\u000b\u0005q\u001c\u0015!\u0002;za\u0016\u001c\u0018B\u0001@|\u0005)\tEo\\7jGRK\b/Z\u0001\u000bG>dW/\u001c8UsB,\u0007#BA\u0002\u0003\u000b\tX\"A \n\u0007\u0005\u001dqH\u0001\tOCRLg/Z\"pYVlg\u000eV=qKR!\u00111BA\u0007!\rY\u0007\"\u001d\u0005\u0007\u007f*\u0001\r!!\u0001\u0002#}+hnY8naJ,7o]3e'&TX-A\u000b`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016|F%Z9\u0015\t\u0005U\u00111\u0004\t\u0004!\u0006]\u0011bAA\r#\n!QK\\5u\u0011!\ti\u0002DA\u0001\u0002\u0004\u0019\u0017a\u0001=%c\u0005\u0011r,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3!\u0003=y6m\\7qe\u0016\u001c8/\u001a3TSj,\u0017aE0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3`I\u0015\fH\u0003BA\u000b\u0003OA\u0001\"!\b\u0010\u0003\u0003\u0005\raY\u0001\u0011?\u000e|W\u000e\u001d:fgN,GmU5{K\u0002\n\u0011\u0002\\1tiZ\u000bG.^3\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\fKb\u0004(/Z:tS>t7OC\u0002\u0002:\r\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0003{\t\u0019DA\nTa\u0016\u001c\u0017NZ5d\u0013:$XM\u001d8bYJ{w/\u0001\u0006mCN$h+\u00197vK\u0002\nq\u0001\\1tiJ+h.A\u0006mCN$(+\u001e8`I\u0015\fH\u0003BA\u000b\u0003\u000fB\u0001\"!\b\u0015\u0003\u0003\u0005\raY\u0001\tY\u0006\u001cHOU;oA\u0005\u0001RO\\2p[B\u0014Xm]:fINK'0Z\u0001\u000fG>l\u0007O]3tg\u0016$7+\u001b>f\u0003i9\u0017\r\u001e5fe\u000e{W\u000e\u001d:fgNL'-\u001b7jif\u001cF/\u0019;t)\u0019\t)\"a\u0015\u0002`!9\u0011Q\u000b\rA\u0002\u0005]\u0013a\u0001:poB!\u0011\u0011LA.\u001b\t\t9$\u0003\u0003\u0002^\u0005]\"aC%oi\u0016\u0014h.\u00197S_^Da!!\u0019\u0019\u0001\u0004\u0019\u0017aB8sI&t\u0017\r\\\u0001\tG>l\u0007O]3tgR1\u0011qMA<\u0003w\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0002oS>T!!!\u001d\u0002\t)\fg/Y\u0005\u0005\u0003k\nYG\u0001\u0006CsR,')\u001e4gKJDq!!\u001f\u001a\u0001\u0004\t9'\u0001\u0003ge>l\u0007bBA?3\u0001\u0007\u0011qM\u0001\u0003i>\u00042A]AA\t\u0015!XA1\u0001v\u0011\u0019yX\u00011\u0001\u0002\u0006B1\u00111AA\u0003\u0003\u007f\nq\u0001Z3d_\u0012,'/\u0006\u0003\u0002\f\n-DCBAG\u0005[\u0012y\u0007\u0005\u0003l5\t%$a\u0002#fG>$WM]\u000b\u0005\u0003'\u000bYj\u0005\u0003\u001b\u001f\u0006U\u0005#\u0002'\u0002\u0018\u0006e\u0015bAAH{A\u0019!/a'\u0005\u000bQT\"\u0019A;\u0002\r\t,hMZ3s!\u0019\t\u0019!!\u0002\u0002\u001aR1\u00111UAS\u0003O\u0003Ba\u001b\u000e\u0002\u001a\"9\u0011QT\u000fA\u0002\u0005\u001d\u0004BB@\u001e\u0001\u0004\ty*A\u0002sk:\fqA];o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005=\u0006\u0002CA\u000f?\u0005\u0005\t\u0019A2\u0002\tI,h\u000eI\u0001\u000bm\u0006dW/Z\"pk:$\u0018A\u0004<bYV,7i\\;oi~#S-\u001d\u000b\u0005\u0003+\tI\f\u0003\u0005\u0002\u001e\t\n\t\u00111\u0001d\u0003-1\u0018\r\\;f\u0007>,h\u000e\u001e\u0011\u0002\u0019\r,(O]3oiZ\u000bG.^3\u0016\u0005\u0005\u0005\u0007\u0003BAM\u0003\u0007L1!!2~\u00051Ie\u000e^3s]\u0006dG+\u001f9f\u0003A\u0019WO\u001d:f]R4\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005-\u0007\"CA\u000fK\u0005\u0005\t\u0019AAa\u00035\u0019WO\u001d:f]R4\u0016\r\\;fA\u0005!a.\u001a=u)\u0019\t)\"a5\u0002V\"9\u0011QK\u0014A\u0002\u0005]\u0003BBA1O\u0001\u00071-A\u0004iCNtU\r\u001f;\u0016\u0005\u0005m\u0007c\u0001)\u0002^&\u0019\u0011q\\)\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001/\u001e;C_>dW-\u00198\u0015\u0011\u0005U\u0011Q]A{\u0003sDq!a:*\u0001\u0004\tI/\u0001\u0007d_2,XN\u001c,fGR|'\u000f\u0005\u0003\u0002l\u0006EXBAAw\u0015\r\ty/Q\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BAz\u0003[\u0014Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\bBBA|S\u0001\u00071-A\u0002q_NDq!a?*\u0001\u0004\ti0A\u0003wC2,X\rE\u0002Q\u0003\u007fL1A!\u0001R\u0005\u0011auN\\4\u0002\u000f\u001d,GOQ=uKR!\u0011Q B\u0004\u0011\u001d\tiJ\u000ba\u0001\u0003O\nq\u0001];u\u0005f$X\r\u0006\u0005\u0002\u0016\t5!q\u0002B\t\u0011\u001d\t9o\u000ba\u0001\u0003SDa!a>,\u0001\u0004\u0019\u0007bBA~W\u0001\u0007\u0011Q`\u0001\tO\u0016$8\u000b[8siR!\u0011Q B\f\u0011\u001d\ti\n\fa\u0001\u0003O\n\u0001\u0002];u'\"|'\u000f\u001e\u000b\t\u0003+\u0011iBa\b\u0003\"!9\u0011q]\u0017A\u0002\u0005%\bBBA|[\u0001\u00071\rC\u0004\u0002|6\u0002\r!!@\u0002\r\u001d,G/\u00138u)\u0011\tiPa\n\t\u000f\u0005ue\u00061\u0001\u0002h\u00051\u0001/\u001e;J]R$\u0002\"!\u0006\u0003.\t=\"\u0011\u0007\u0005\b\u0003O|\u0003\u0019AAu\u0011\u0019\t9p\fa\u0001G\"9\u00111`\u0018A\u0002\u0005u\u0018aB4fi2{gn\u001a\u000b\u0005\u0003{\u00149\u0004C\u0004\u0002\u001eB\u0002\r!a\u001a\u0002\u000fA,H\u000fT8oORA\u0011Q\u0003B\u001f\u0005\u007f\u0011\t\u0005C\u0004\u0002hF\u0002\r!!;\t\r\u0005]\u0018\u00071\u0001d\u0011\u001d\tY0\ra\u0001\u0003{\f1\u0002Z3d_6\u0004(/Z:taQQ\u0011Q\u0003B$\u0005\u0013\u0012iEa\u0016\t\u000f\u0005\u001d(\u00071\u0001\u0002j\"1!1\n\u001aA\u0002\r\f\u0001bY1qC\u000eLG/\u001f\u0005\b\u0005\u001f\u0012\u0004\u0019\u0001B)\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0011\u000fA\u0013\u0019&a\u001a\u0002~&\u0019!QK)\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002B-e\u0001\u0007!1L\u0001\faV$h)\u001e8di&|g\u000e\u0005\u0006Q\u0005;\nIoYA\u007f\u0003+I1Aa\u0018R\u0005%1UO\\2uS>t7'\u0001\u0006eK\u000e|W\u000e\u001d:fgN$b!!\u0006\u0003f\t\u001d\u0004bBAtg\u0001\u0007\u0011\u0011\u001e\u0005\u0007\u0005\u0017\u001a\u0004\u0019A2\u0011\u0007I\u0014Y\u0007B\u0003u\r\t\u0007Q\u000fC\u0004\u0002\u001e\u001a\u0001\r!a\u001a\t\r}4\u0001\u0019\u0001B9!\u0019\t\u0019!!\u0002\u0003j\u0005A1/\u001e9q_J$8\u000f\u0006\u0003\u0002\\\n]\u0004BB@\b\u0001\u0004\u0011I\b\r\u0003\u0003|\t\r\u0005CBA\u0002\u0005{\u0012\t)C\u0002\u0003\u0000}\u0012!bQ8mk6tG+\u001f9f!\r\u0011(1\u0011\u0003\r\u0005\u000b\u00139(!A\u0001\u0002\u000b\u0005!q\u0011\u0002\u0004?\u0012\u0012\u0014c\u0001<\u0003\nB\u0019\u0001Ka#\n\u0007\t5\u0015KA\u0002B]f\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BJ!\u0011\u0011)Ja'\u000e\u0005\t]%\u0002\u0002BM\u0003_\nA\u0001\\1oO&!!Q\u0014BL\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BE\u0005KC\u0001\"!\b7\u0003\u0003\u0005\raY\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0016\t\u0007\u0005[\u0013\u0019L!#\u000e\u0005\t=&b\u0001BY#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU&q\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\\\nm\u0006\"CA\u000fq\u0005\u0005\t\u0019\u0001BE\u0003!A\u0017m\u001d5D_\u0012,G#A2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa%\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0013\u0004BA!&\u0003L&!!Q\u001aBL\u0005\u0019y%M[3di\u0002")
public final class RunLengthEncoding {
    public static String toString() {
        return RunLengthEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RunLengthEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RunLengthEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RunLengthEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RunLengthEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RunLengthEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RunLengthEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return RunLengthEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static int typeId() {
        return RunLengthEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private int run;
        private int valueCount;
        private Object currentValue;

        private int run() {
            return this.run;
        }

        private void run_$eq(int x$1) {
            this.run = x$1;
        }

        private int valueCount() {
            return this.valueCount;
        }

        private void valueCount_$eq(int x$1) {
            this.valueCount = x$1;
        }

        private Object currentValue() {
            return this.currentValue;
        }

        private void currentValue_$eq(Object x$1) {
            this.currentValue = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            if (this.valueCount() == this.run()) {
                this.currentValue_$eq(this.columnType.extract(this.buffer));
                this.run_$eq(ByteBufferHelper$.MODULE$.getInt(this.buffer));
                this.valueCount_$eq(1);
            } else {
                this.valueCount_$eq(this.valueCount() + 1);
            }
            this.columnType.setField(row, ordinal, this.currentValue());
        }

        @Override
        public boolean hasNext() {
            return this.valueCount() < this.run() || this.buffer.hasRemaining();
        }

        private void putBoolean(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putBoolean(pos, value == 1L);
        }

        private long getByte(ByteBuffer buffer) {
            return buffer.get();
        }

        private void putByte(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putByte(pos, (byte)value);
        }

        private long getShort(ByteBuffer buffer) {
            return buffer.getShort();
        }

        private void putShort(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putShort(pos, (short)value);
        }

        private long getInt(ByteBuffer buffer) {
            return buffer.getInt();
        }

        private void putInt(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putInt(pos, (int)value);
        }

        private long getLong(ByteBuffer buffer) {
            return buffer.getLong();
        }

        private void putLong(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putLong(pos, value);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, Function1<ByteBuffer, Object> getFunction, Function3<WritableColumnVector, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            int runLocal = 0;
            int valueCountLocal = 0;
            long currentValueLocal = 0L;
            for (int pos = 0; valueCountLocal < runLocal || pos < capacity; ++pos) {
                Object object;
                if (pos != nextNullIndex) {
                    if (valueCountLocal == runLocal) {
                        currentValueLocal = BoxesRunTime.unboxToLong((Object)getFunction.apply((Object)this.buffer));
                        runLocal = ByteBufferHelper$.MODULE$.getInt(this.buffer);
                        valueCountLocal = 1;
                    } else {
                        ++valueCountLocal;
                    }
                    object = putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToLong((long)currentValueLocal));
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
                object = BoxedUnit.UNIT;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putBoolean(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ByteType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putByte(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ShortType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getShort(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putShort(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof IntegerType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getInt(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putInt(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getLong(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putLong(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in RunLengthEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.run = 0;
            this.valueCount = 0;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private int _compressedSize;
        private final SpecificInternalRow lastValue;
        private int lastRun;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private int _compressedSize() {
            return this._compressedSize;
        }

        private void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        private SpecificInternalRow lastValue() {
            return this.lastValue;
        }

        private int lastRun() {
            return this.lastRun;
        }

        private void lastRun_$eq(int x$1) {
            this.lastRun = x$1;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            int actualSize = this.columnType.actualSize(row, ordinal);
            this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
            if (this.lastValue().isNullAt(0)) {
                this.columnType.copyField(row, ordinal, (InternalRow)this.lastValue(), 0);
                this.lastRun_$eq(1);
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
            } else if (BoxesRunTime.equals(this.columnType.getField((InternalRow)this.lastValue(), 0), value)) {
                this.lastRun_$eq(this.lastRun() + 1);
            } else {
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
                this.columnType.copyField(row, ordinal, (InternalRow)this.lastValue(), 0);
                this.lastRun_$eq(1);
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(RunLengthEncoding$.MODULE$.typeId());
            if (from.hasRemaining()) {
                SpecificInternalRow currentValue = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{this.columnType.dataType()})));
                int currentRun = 1;
                SpecificInternalRow value = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{this.columnType.dataType()})));
                this.columnType.extract(from, (InternalRow)currentValue, 0);
                while (from.hasRemaining()) {
                    this.columnType.extract(from, (InternalRow)value, 0);
                    if (BoxesRunTime.equals((Object)value.get(0, this.columnType.dataType()), (Object)currentValue.get(0, this.columnType.dataType()))) {
                        ++currentRun;
                        continue;
                    }
                    this.columnType.append((InternalRow)currentValue, 0, to);
                    to.putInt(currentRun);
                    this.columnType.copyField((InternalRow)value, 0, (InternalRow)currentValue, 0);
                    currentRun = 1;
                }
                this.columnType.append((InternalRow)currentValue, 0, to);
                object = to.putInt(currentRun);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this._compressedSize = 0;
            this.lastValue = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{columnType.dataType()})));
            this.lastRun = 0;
        }
    }
}

