/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.continuous.ContinuousSuiteBase;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a1A!\u0001\u0002\u0001\u001f\ty1i\u001c8uS:,x.^:Tk&$XM\u0003\u0002\u0004\t\u0005Q1m\u001c8uS:,x.^:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u00192i\u001c8uS:,x.^:Tk&$XMQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u0003#\u0001\u0001")
public class ContinuousSuite
extends ContinuousSuiteBase {
    public static final /* synthetic */ int $anonfun$new$3(Row x$1) {
        return x$1.getInt(0) * 2;
    }

    public static final /* synthetic */ Seq $anonfun$new$6(int n) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, n, n * 2}));
    }

    public static final /* synthetic */ Seq $anonfun$new$7(int n) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, n, n * 2}));
    }

    public static final /* synthetic */ boolean $anonfun$new$16(ContinuousSuite $this, LongRef taskId$1, StreamExecution x$2) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            long $org_scalatest_assert_macro_left = taskId$1.elem;
            int $org_scalatest_assert_macro_right = -1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, $this.patienceConfig(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        SparkContext qual$1 = $this.spark().sparkContext();
        long x$9 = taskId$1.elem;
        boolean x$10 = qual$1.killTaskAttempt$default$2();
        String x$11 = qual$1.killTaskAttempt$default$3();
        return qual$1.killTaskAttempt(x$9, x$10, x$11);
    }

    public ContinuousSuite() {
        this.test("basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            this.testStream(input.toDF(), this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ContinuousSuite.$anonfun$new$3(x$1)), this.testImplicits().newIntEncoder());
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 8}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("flatMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().flatMap((Function1 & Serializable & scala.Serializable)r -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, r.getInt(0), r.getInt(0) * 2})), this.testImplicits().newIntEncoder());
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).flatMap((Function1 & Serializable & scala.Serializable)n -> ContinuousSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).flatMap((Function1 & Serializable & scala.Serializable)n -> ContinuousSuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().where(this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$greater((Object)BoxesRunTime.boxToInteger((int)2)));
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("deduplicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().dropDuplicates();
            AnalysisException except = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4())})), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            String $org_scalatest_assert_macro_left = except.message();
            String $org_scalatest_assert_macro_right = "Continuous processing does not support Deduplicate operations.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.current_timestamp()}));
            AnalysisException except = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4())})), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            String $org_scalatest_assert_macro_left = except.message();
            String $org_scalatest_assert_macro_right = "Continuous processing does not support current time operations.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("subquery alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            input.toDF().createOrReplaceTempView("memory");
            Dataset test = this.spark().sql("select value from memory where value > 2");
            this.testStream(test, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("repeatedly restart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF();
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), this.testImplicits().newIntEncoder()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}), this.testImplicits().newIntEncoder()), this.StopStream()}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("task failure kills the query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF();
            LongRef taskId = LongRef.create((long)-1L);
            SparkListener listener = new SparkListener(null, taskId){
                private final LongRef taskId$1;

                public void onTaskStart(SparkListenerTaskStart start) {
                    this.taskId$1.elem = start.taskInfo().taskId();
                }
                {
                    this.taskId$1 = taskId$1;
                }
            };
            this.spark().sparkContext().addSparkListener((SparkListenerInterface)listener);
            try {
                this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, Trigger.Continuous((long)100L), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ContinuousSuite.$anonfun$new$16(this, taskId, x$2))), new StreamTest.ExpectFailure(this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    bl = e.getCause() != null && e.getCause().getCause() instanceof ContinuousTaskRetryException;
                    return BoxedUnit.UNIT;
                }, this.ExpectFailure().apply$default$2(), ClassTag$.MODULE$.apply(SparkException.class))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().sparkContext().removeSparkListener((SparkListenerInterface)listener);
            }
            return boxedUnit;
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("query without test harness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().readStream().format("rate").option("numPartitions", "2").option("rowsPerSecond", "2").load().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))}));
            StreamingQuery query = df.writeStream().format("memory").queryName("noharness").trigger(Trigger.Continuous((long)100L)).start();
            ContinuousExecution continuousExecution = (ContinuousExecution)((StreamingQueryWrapper)query).streamingQuery();
            continuousExecution.awaitEpoch(0L);
            this.waitForRateSourceTriggers((StreamExecution)continuousExecution, 2);
            query.stop();
            Row[] results = (Row[])this.spark().read().table("noharness").collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((GenSetLike)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)x$3 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$3))})), Set$.MODULE$.canBuildFrom())).subsetOf((GenSet)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).toSet()), "scala.Predef.Set.apply[Int](0, 1, 2, 3).map[org.apache.spark.sql.Row, scala.collection.immutable.Set[org.apache.spark.sql.Row]](((x$3: Int) => org.apache.spark.sql.Row.apply(x$3)))(immutable.this.Set.canBuildFrom[org.apache.spark.sql.Row]).subsetOf(scala.Predef.refArrayOps[org.apache.spark.sql.Row](results).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }
}

