/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.continuous.ContinuousSuiteBase;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a1A!\u0001\u0002\u0001\u001f\tQ2i\u001c8uS:,x.^:BO\u001e\u0014XmZ1uS>t7+^5uK*\u00111\u0001B\u0001\u000bG>tG/\u001b8v_V\u001c(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0014\u0007>tG/\u001b8v_V\u001c8+^5uK\n\u000b7/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"!\u0005\u0001")
public class ContinuousAggregationSuite
extends ContinuousSuiteBase {
    public ContinuousAggregationSuite() {
        this.test("not enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException ex = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.singlePartition(this.testImplicits().newIntEncoder(), this.sqlContext());
                this.testStream(input.toDF().agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])), OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Nil$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "In continuous processing mode, coalesce(1) must be called before aggregate operation";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.sql.streaming.unsupportedOperationCheck", (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.singlePartition(this.testImplicits().newIntEncoder(), this.sqlContext());
            this.testStream(input.toDF().agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])), OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{-1, -2, -3})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder())}));
        }), new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("multiple partitions with coalesce", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().coalesce(1).agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            this.testStream(df, OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{-1, -2, -3})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("multiple partitions with coalesce - multiple transformations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = this.logicalPlanToSparkQuery(input.toDF().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as((Symbol)SymbolLiteral.bootstrap("apply", "copy")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))})).where(this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "copy")).$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))).logicalPlan()).coalesce(1).where(this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "copy")).$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)2))).agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            this.testStream(df, OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{-1, -2, -3})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("multiple partitions with multiple coalesce", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = this.logicalPlanToSparkQuery(input.toDF().coalesce(1).logicalPlan()).coalesce(1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as((Symbol)SymbolLiteral.bootstrap("apply", "copy")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))})).agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            this.testStream(df, OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{-1, -2, -3})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("repeated restart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.sql.streaming.unsupportedOperationCheck", (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.singlePartition(this.testImplicits().newIntEncoder(), this.sqlContext());
            this.testStream(input.toDF().agg(functions$.MODULE$.max((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])), OutputMode.Complete(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{2}), this.testImplicits().newIntEncoder()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{0})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{2}), this.testImplicits().newIntEncoder()), this.AddData().apply(input, Predef$.MODULE$.wrapIntArray(new int[]{5})), this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{5}), this.testImplicits().newIntEncoder())}));
        }), new Position("ContinuousAggregationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }
}

