/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MemorySink;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem$;
import org.apache.spark.sql.streaming.FileStreamSourceSuite$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Tag;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011QCR5mKN#(/Z1n'>,(oY3Tk&$XM\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003)\u0019KG.Z*ue\u0016\fWnU8ve\u000e,G+Z:u\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001!9q\u0003\u0001b\u0001\n\u0003B\u0012\u0001E:ue\u0016\fW.\u001b8h)&lWm\\;u+\u0005I\u0002C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011!\u0018.\\3\u000b\u0005yQ\u0011!C:dC2\fG/Z:u\u0013\t\u00013D\u0001\u0003Ta\u0006t\u0007B\u0002\u0012\u0001A\u0003%\u0011$A\ttiJ,\u0017-\\5oORKW.Z8vi\u0002BQ\u0001\n\u0001\u0005\n\u0015\nac\u0019:fCR,g)\u001b7f'R\u0014X-Y7T_V\u00148-\u001a\u000b\u0005M5bd\b\u0005\u0002(W5\t\u0001F\u0003\u0002\u0004S)\u0011!\u0006B\u0001\nKb,7-\u001e;j_:L!\u0001\f\u0015\u0003!\u0019KG.Z*ue\u0016\fWnU8ve\u000e,\u0007\"\u0002\u0018$\u0001\u0004y\u0013A\u00024pe6\fG\u000f\u0005\u00021s9\u0011\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0003i1\ta\u0001\u0010:p_Rt$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*\u0014A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u001b\t\u000bu\u001a\u0003\u0019A\u0018\u0002\tA\fG\u000f\u001b\u0005\b\u007f\r\u0002\n\u00111\u0001A\u0003\u0019\u00198\r[3nCB\u0019\u0011I\u0011#\u000e\u0003UJ!aQ\u001b\u0003\r=\u0003H/[8o!\t)\u0005*D\u0001G\u0015\t9E!A\u0003usB,7/\u0003\u0002J\r\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b-\u0003A\u0011\u0002'\u0002E\r\u0014X-\u0019;f\r&dWm\u0015;sK\u0006l7k\\;sG\u0016\fe\u000eZ$fiN\u001b\u0007.Z7b)\u0011!Uj\u0014)\t\u000b9R\u0005\u0019\u0001(\u0011\u0007\u0005\u0013u\u0006C\u0003>\u0015\u0002\u0007a\nC\u0004@\u0015B\u0005\t\u0019\u0001!\t\u000bI\u0003A\u0011I*\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001+\u0011\u0005\u0005+\u0016B\u0001,6\u0005\u0011)f.\u001b;\t\u000ba\u0003A\u0011I*\u0002\u0011\u00054G/\u001a:BY2DQA\u0017\u0001\u0005\nm\u000b1C]3bI2{wM\u0012:p[J+7o\\;sG\u0016$\"\u0001\u0018=\u0011\u0007u\u0013WM\u0004\u0002_A:\u0011!gX\u0005\u0002m%\u0011\u0011-N\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0002TKFT!!Y\u001b\u0011\u0005\u0019,hBA4t\u001d\tA'O\u0004\u0002jc:\u0011!\u000e\u001d\b\u0003W>t!\u0001\u001c8\u000f\u0005Ij\u0017\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002+\t%\u00111!K\u0005\u0003i\"\n\u0001CR5mKN#(/Z1n'>,(oY3\n\u0005Y<(!\u0003$jY\u0016,e\u000e\u001e:z\u0015\t!\b\u0006C\u0003z3\u0002\u0007q&A\u0002eSJDQa\u001f\u0001\u0005\nq\faC]3bI>3gm]3u\rJ|WNU3t_V\u00148-\u001a\u000b\u0004{\u0006\u0005\u0001CA\u0014\u007f\u0013\ty\bF\u0001\tTKJL\u0017\r\\5{K\u0012|eMZ:fi\"1\u00111\u0001>A\u0002=\nAAZ5mK\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0011!\b:v]R;xNQ1uG\",7/\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e^:\u0015\u0017Q\u000bY!a\b\u0002*\u00055\u0012\u0011\u0007\u0005\t\u0003\u001b\t)\u00011\u0001\u0002\u0010\u0005\u00191O]2\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005\u0011\u0011n\u001c\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005\u00111\u0015\u000e\\3\t\u0011\u0005\u0005\u0012Q\u0001a\u0001\u0003G\t1\u0002\\1uKN$h)\u001b:tiB\u0019\u0011)!\n\n\u0007\u0005\u001dRGA\u0004C_>dW-\u00198\t\u000f\u0005-\u0012Q\u0001a\u0001_\u0005Qa-\u001b:ti\n\u000bGo\u00195\t\u000f\u0005=\u0012Q\u0001a\u0001_\u0005Y1/Z2p]\u0012\u0014\u0015\r^2i\u0011%\t\u0019$!\u0002\u0011\u0002\u0003\u0007a*\u0001\u0006nCb4\u0015\u000e\\3BO\u0016D\u0011\"a\u000e\u0001#\u0003%I!!\u000f\u0002A\r\u0014X-\u0019;f\r&dWm\u0015;sK\u0006l7k\\;sG\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003wQ3\u0001QA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA)\u0001E\u0005I\u0011BA\u001d\u00031\u001a'/Z1uK\u001aKG.Z*ue\u0016\fWnU8ve\u000e,\u0017I\u001c3HKR\u001c6\r[3nC\u0012\"WMZ1vYR$3\u0007C\u0005\u0002V\u0001\t\n\u0011\"\u0003\u0002X\u00059#/\u001e8Uo>\u0014\u0015\r^2iKN\fe\u000e\u001a,fe&4\u0017PU3tk2$8\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tIFK\u0002O\u0003{\u0001")
public class FileStreamSourceSuite
extends FileStreamSourceTest {
    private final Span streamingTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(20).seconds();

    @Override
    public Span streamingTimeout() {
        return this.streamingTimeout;
    }

    private FileStreamSource createFileStreamSource(String format, String path, Option<StructType> schema) {
        return this.getSourceFromFileStream(this.createFileStream(format, path, schema, this.createFileStream$default$4()));
    }

    private Option<StructType> createFileStreamSource$default$3() {
        return None$.MODULE$;
    }

    private StructType createFileStreamSourceAndGetSchema(Option<String> format, Option<String> path, Option<StructType> schema2) {
        DataStreamReader reader = this.spark().readStream();
        format.foreach((Function1 & Serializable & scala.Serializable)source -> reader.format(source));
        schema2.foreach((Function1 & Serializable & scala.Serializable)schema -> reader.schema(schema));
        Dataset df = path.isDefined() ? reader.load((String)path.get()) : reader.load();
        return (StructType)df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof StreamingRelation) {
                    StreamingRelation streamingRelation = (StreamingRelation)A1;
                    object = streamingRelation.schema();
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x3) {
                LogicalPlan logicalPlan = x3;
                boolean bl = logicalPlan instanceof StreamingRelation;
                return bl;
            }
        }).head();
    }

    private Option<StructType> createFileStreamSourceAndGetSchema$default$3() {
        return None$.MODULE$;
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
        this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION(), (Object)"native");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().sessionState().conf().unsetConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
        }
        finally {
            StreamTest.afterAll$(this);
        }
    }

    private Seq<FileStreamSource.FileEntry> readLogFromResource(String dir) {
        URL input = this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(dir).toString());
        FileStreamSourceLog log = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return Predef$.MODULE$.wrapRefArray(log.allFiles());
    }

    private SerializedOffset readOffsetFromResource(String file) {
        String str = Source$.MODULE$.fromFile(this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(file).toString()).toURI(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return new SerializedOffset(str.trim());
    }

    private void runTwoBatchesAndVerifyResults(File src, boolean latestFirst, String firstBatch, String secondBatch, Option<String> maxFileAge) {
        Map srcOptions = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)latestFirst)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maxFileAge.map((Function1 & Serializable & scala.Serializable)x$24 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), x$24))));
        String x$46 = "text";
        String x$47 = src.getCanonicalPath();
        Map x$48 = srcOptions;
        Option<StructType> x$49 = this.createFileStream$default$3();
        Dataset<Row> fileStream = this.createFileStream(x$46, x$47, x$49, (Map<String, String>)x$48);
        StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
        this.testStream(fileStream, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, (Trigger)new ProcessingTime(10L), (Clock)clock, this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$2(this, clock, x$25)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{firstBatch}), this.testImplicits().newStringEncoder()), new StreamTest.AdvanceManualClock(this, 10L), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$4(this, clock, x$26)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{secondBatch}), this.testImplicits().newStringEncoder())}));
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$5() {
        return None$.MODULE$;
    }

    private final void testError$1() {
        IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "path";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
    }

    public static final /* synthetic */ void $anonfun$new$12(FileStreamSourceSuite $this, File src) {
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
    }

    public static final /* synthetic */ void $anonfun$new$14(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$new$16(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
    }

    public static final /* synthetic */ void $anonfun$new$18(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).orc(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().orc(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }

    public static final /* synthetic */ void $anonfun$new$25(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).parquet(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().parquet(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
    }

    public static final /* synthetic */ void $anonfun$new$36(FileStreamSourceSuite $this, File src) {
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c': '3'}");
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("c", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c', '3'}");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }

    public static final /* synthetic */ void $anonfun$new$43(FileStreamSourceSuite $this, File x0$1, File x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$45(FileStreamSourceSuite $this, File x0$2, File x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, "text text"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$48(FileStreamSourceSuite $this, String testTableName$1, File x0$3, File x1$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File checkpoint = (File)tuple2._2();
            File output = new File(src, "text text");
            MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            Dataset ds = inputData.toDS();
            StreamingQuery query = ds.writeStream().option("checkpointLocation", checkpoint.getCanonicalPath()).format("text").start(output.getCanonicalPath());
            try {
                inputData.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}));
                $this.failAfter($this.streamingTimeout(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.processAllAvailable(), $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451), Timed$.MODULE$.timed());
            }
            finally {
                query.stop();
            }
            Dataset df2 = $this.spark().readStream().format("text").load(output.getCanonicalPath());
            StreamingQuery query2 = df2.writeStream().format("memory").queryName(testTableName$1).start();
            try {
                query2.processAllAvailable();
                $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$1).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                query2.stop();
            }
        }
        throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$52(FileStreamSourceSuite $this, File x0$4, File x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset textStream = $this.spark().readStream().textFile(src.getCanonicalPath());
        Dataset filtered = textStream.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("keep")));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$56(StreamExecution x$2) {
        Thread.sleep(1000L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$57(FileStreamSourceSuite $this, StreamExecution streamExecution) {
        FileStreamSource source = (FileStreamSource)$this.getSourcesFromStreamingQuery(streamExecution).head();
        FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = source.seenFiles();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$55(FileStreamSourceSuite $this, File x0$5, File x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        String x$34 = "text";
        String x$35 = src.getCanonicalPath();
        Map x$36 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), (Object)"5ms")}));
        Option<StructType> x$37 = $this.createFileStream$default$3();
        Dataset<Row> textStream = $this.createFileStream(x$34, x$35, x$37, (Map<String, String>)x$36);
        $this.testStream(textStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "a\nb", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$56(x$2)), $this.AssertOnQuery().apply$default$2()), new FileStreamSourceTest.AddTextFileData($this, "c\nd", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("seen files should contain only one entry", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)streamExecution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$57($this, streamExecution)))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$59(FileStreamSourceSuite $this, File x0$6, File x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}\n{'value': 'keep3'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop4'}\n{'value': 'keep5'}\n{'value': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop7'}\n{'value': 'keep8'}\n{'value': 'keep9'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$61(FileStreamSourceSuite $this, File x0$7, File x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$64(FileStreamSourceSuite $this, File x0$8, File x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)x1$8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File baseSrc = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File src = new File(baseSrc, "type=X");
            src.mkdirs();
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$67(FileStreamSourceSuite $this, File x0$9, File x1$9) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)x1$9);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'k': 'value0'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing2"), "{'k': 'value1', 'v': 'new'}");
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value2'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value3', 'v': 'new'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'v': 'value4'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$70(FileStreamSourceSuite $this, File x0$10, File x1$10) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)x1$10);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$72(FileStreamSourceSuite $this, File x0$11, File x1$11) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)x1$11);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator113$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator113$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator113$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator130$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator130$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator130$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$75(FileStreamSourceSuite $this, File x0$12, File x1$12) {
        Tuple2 tuple2 = new Tuple2((Object)x0$12, (Object)x1$12);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$77(FileStreamSourceSuite $this, File x0$13, File x1$13) {
        Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)x1$13);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator165$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator165$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator165$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator182$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator182$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator182$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$80(FileStreamSourceSuite $this, File x0$14, File x1$14) {
        Tuple2 tuple2 = new Tuple2((Object)x0$14, (Object)x1$14);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        File subDir = new File(dir, "subdir");
        File subSubDir = new File(subDir, "subsubdir");
        File subSubSubDir = new File(subSubDir, "subsubsubdir");
        Predef$.MODULE$.require(!subDir.exists());
        Predef$.MODULE$.require(!subSubDir.exists());
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep4", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep5", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep6", dir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep7", subSubSubDir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep8", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5", "keep8"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$82(FileStreamSourceSuite $this, File x0$15, File x1$15) {
        Tuple2 tuple2 = new Tuple2((Object)x0$15, (Object)x1$15);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        Object nullStr = null;
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr), new Tuple2((Object)"keep5", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$84(FileStreamSourceSuite $this, File x0$16, File x1$16) {
        Tuple2 tuple2 = new Tuple2((Object)x0$16, (Object)x1$16);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator233$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator233$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator233$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator237$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator237$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator237$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator241$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator241$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator241$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$88(MemoryStream q1Source$1, StreamingQuery q1$1, Seq data$1, StreamExecution x$3) {
        q1Source$1.addData((TraversableOnce)data$1);
        q1$1.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$1(Seq data, MemoryStream q1Source$1, StreamingQuery q1$1) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> {
            FileStreamSourceSuite.$anonfun$new$88(q1Source$1, q1$1, data, x$3);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$1() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$87(FileStreamSourceSuite $this, File x0$17, File x1$17) {
        Tuple2 tuple2 = new Tuple2((Object)x0$17, (Object)x1$17);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            File shouldNotKeep = new File(outputDir, "should_not_keep.txt");
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(shouldNotKeep, "should_not_keep!!!");
            return shouldNotKeep.exists();
        }, $this.Assert().apply$default$2()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(outputDir, new StringBuilder(10).append(FileStreamSink$.MODULE$.metadataDir()).append("/2.compact").toString()).exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$95(FileStreamSourceSuite $this, StreamExecution q2) {
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)None$.MODULE$, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$96(File outputDir$2, MemoryStream q1Source$2, DataStreamWriter q1Write$1, ObjectRef q1$2, StreamExecution x$5) {
        q1$2.elem = q1Write$1.start(outputDir$2.getCanonicalPath());
        q1Source$2.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}));
        ((StreamingQuery)q1$2.elem).processAllAvailable();
    }

    public static final /* synthetic */ boolean $anonfun$new$97(FileStreamSourceSuite $this, StreamExecution q2) {
        q2.processAllAvailable();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$98(ObjectRef q1$2, StreamExecution x$6) {
        ((StreamingQuery)q1$2.elem).stop();
    }

    public static final /* synthetic */ void $anonfun$new$94(FileStreamSourceSuite $this, File x0$18, File x1$18) {
        Tuple2 tuple2 = new Tuple2((Object)x0$18, (Object)x1$18);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        DataStreamWriter q1Write = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text");
        ObjectRef q1 = ObjectRef.create(null);
        Dataset q22 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q22, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$95($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            FileStreamSourceSuite.$anonfun$new$96(outputDir, q1Source, q1Write, q1, x$5);
            return BoxedUnit.UNIT;
        }), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$97($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            FileStreamSourceSuite.$anonfun$new$98(q1, x$6);
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void createFile$1(String content, File src, File tmp) {
        File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
        File finalFile = new File(src, tempFile.getName());
        Predef$.MODULE$.require(!src.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(src).append(" exists, dir: ").append(src.isDirectory()).append(", file: ").append(src.isFile()).toString());
        Predef$.MODULE$.require(src.mkdirs(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Cannot create ").append(src).toString());
        Predef$.MODULE$.require(src.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(src).append(" is not a directory").toString());
        Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, content).renameTo(finalFile));
    }

    public static final /* synthetic */ void $anonfun$new$104(FileStreamSourceSuite $this, File x0$19, File x1$19) {
        Tuple2 tuple2 = new Tuple2((Object)x0$19, (Object)x1$19);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        FileStreamSourceSuite.createFile$1("{'value': 'drop0'}", partitionFooSubDir, tmp);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[10];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator271$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator271$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator271$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator275$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator275$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator275$1(null))));
        streamActionArray[8] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep6'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator279$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator279$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[9] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar"), new Tuple2((Object)"keep6", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator279$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$106(FileStreamSourceSuite $this, File x0$20, File x1$20) {
        Tuple2 tuple2 = new Tuple2((Object)x0$20, (Object)x1$20);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$2(int data, ObjectRef lastFileModTime$1, File x1$26) {
        void var3_3;
        File file = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(x1$26, new StringBuilder(4).append(data).append(".txt").toString()), ((Object)BoxesRunTime.boxToInteger((int)data)).toString());
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$new$110(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    private final void checkLastBatchData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$38 = memorySink$1.latestBatchData();
        int x$39 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$38, x$39, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$7 -> FileStreamSourceSuite.$anonfun$new$110(BoxesRunTime.unboxToInt((Object)x$7)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    public static final /* synthetic */ String $anonfun$new$112(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    private final void checkAllData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$2 = this.spark().sparkContext();
        Seq x$40 = memorySink$1.allData();
        int x$41 = qual$2.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$2.makeRDD(x$40, x$41, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$8 -> FileStreamSourceSuite.$anonfun$new$112(BoxesRunTime.unboxToInt((Object)x$8)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    private final void checkNumBatchesSinceLastCheck$1(int numBatches, MemorySink memorySink$1, LongRef lastBatchId$1) {
        Predef$.MODULE$.require(lastBatchId$1.elem >= 0L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(memorySink$1.latestBatchId().get());
        long $org_scalatest_assert_macro_right = lastBatchId$1.elem + (long)numBatches;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1048));
        lastBatchId$1.elem = BoxesRunTime.unboxToLong((Object)memorySink$1.latestBatchId().get());
    }

    public static final /* synthetic */ void $anonfun$new$108(FileStreamSourceSuite $this, File x0$21) {
        File file = x0$21;
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$2(1, lastFileModTime, file);
        FileStreamSourceSuite.createFile$2(2, lastFileModTime, file);
        FileStreamSourceSuite.createFile$2(3, lastFileModTime, file);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 2L).text(file.getCanonicalPath());
        StreamExecution q = ((StreamingQueryWrapper)df.writeStream().format("memory").queryName("file_data").start()).streamingQuery();
        q.processAllAvailable();
        MemorySink memorySink = (MemorySink)q.sink();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q).head();
        LongRef lastBatchId = LongRef.create((long)-1L);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3), memorySink);
        lastBatchId.elem = BoxesRunTime.unboxToLong((Object)memorySink.latestBatchId().get());
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(4, lastFileModTime, file);
            FileStreamSourceSuite.createFile$2(5, lastFileModTime, file);
            FileStreamSourceSuite.createFile$2(6, lastFileModTime, file);
            return FileStreamSourceSuite.createFile$2(7, lastFileModTime, file);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(2, memorySink, lastBatchId);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7), memorySink);
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(8, lastFileModTime, file);
            FileStreamSourceSuite.createFile$2(9, lastFileModTime, file);
            FileStreamSourceSuite.createFile$2(10, lastFileModTime, file);
            FileStreamSourceSuite.createFile$2(11, lastFileModTime, file);
            return FileStreamSourceSuite.createFile$2(12, lastFileModTime, file);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(3, memorySink, lastBatchId);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 12), memorySink);
        q.stop();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void testMaxFilePerTriggerValue$1(String value, String testTable$1, File x1$27) {
        Dataset df = this.spark().readStream().option("maxFilesPerTrigger", value).text(x1$27.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$1).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1098));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerTrigger", value, "positive integer"}))).foreach((Function1 & Serializable & scala.Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100));
        });
    }

    public static final /* synthetic */ void $anonfun$new$117(FileStreamSourceSuite $this, String testTable$1, File x0$22) {
        File file = x0$22;
        $this.testMaxFilePerTriggerValue$1("not-a-integer", testTable$1, file);
        $this.testMaxFilePerTriggerValue$1("-1", testTable$1, file);
        $this.testMaxFilePerTriggerValue$1("0", testTable$1, file);
        $this.testMaxFilePerTriggerValue$1("10.1", testTable$1, file);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$121(FileStreamSourceSuite $this, File x0$23, File x1$21) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$23, (Object)x1$21);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            src.mkdirs();
            Dataset df = $this.spark().readStream().format("text").load(src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$9 -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x$9), "-x"), $this.testImplicits().newStringEncoder());
            df.explain();
            StreamExecution q = ((StreamingQueryWrapper)df.writeStream().queryName("file_explain").format("memory").start()).streamingQuery();
            try {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right = q.explainInternal(false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right2 = q.explainInternal(true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, "foo").renameTo(finalFile));
                q.processAllAvailable();
                String explainWithoutExtended = q.explainInternal(false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1135));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136));
                String explainWithExtended = q.explainInternal(true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1141));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$new$125(int x$10) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$10)).toString();
    }

    public static final /* synthetic */ void $anonfun$new$124(FileStreamSourceSuite $this, int numFiles$1, File x0$24, File x1$22) {
        Tuple2 tuple2 = new Tuple2((Object)x0$24, (Object)x1$22);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File root = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File src = new File(root, "a=1");
        src.mkdirs();
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFiles$1).map((Function1 & Serializable & scala.Serializable)x$10 -> FileStreamSourceSuite.$anonfun$new$125(BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)i -> {
            File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
            File finalFile = new File(src, tempFile.getName());
            return org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(finalFile, i);
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])src.listFiles())).size()));
        int $org_scalatest_assert_macro_right = numFiles$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1170));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator307$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator307$1(FileStreamSourceSuite $outer) {
            }
        }
        Dataset files = $this.spark().readStream().text(root.getCanonicalPath()).as($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator307$1(null))));
        Dataset df = files.filter("1 == 0").groupBy((Seq)Nil$.MODULE$).count();
        $this.testStream(df, OutputMode.Complete(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "0", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), $this.testImplicits().newIntEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean verify$1(StreamExecution execution, long batchId, int expectedBatches, int expectedCompactInterval, PrivateMethodTester.PrivateMethod _metadataLog$1) {
        BoxedUnit boxedUnit;
        FileStreamSource fileSource = (FileStreamSource)this.getSourcesFromStreamingQuery(execution).head();
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)this.anyRefToInvoker(fileSource).invokePrivate(_metadataLog$1.apply((Seq)Nil$.MODULE$));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, expectedCompactInterval)) {
            Path path = metadataLog.batchIdToPath(batchId);
            String $org_scalatest_assert_macro_left = path.getName();
            String $org_scalatest_assert_macro_right = CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path does not end with compact file suffix", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1203));
            Option entries = metadataLog.get(batchId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(entries.isDefined(), "entries.isDefined", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Entries not defined", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1208));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])entries.get()).length));
            int $org_scalatest_assert_macro_right2 = ((FileStreamSource.FileEntry[])metadataLog.allFiles()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"clean up check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1209));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$11._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length));
            int $org_scalatest_assert_macro_right3 = ((FileStreamSource.FileEntry[])entries.get()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Length check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1210));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metadataLog.allFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.batchId()), (Ordering)Ordering.Long$.MODULE$));
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = (FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$13._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.batchId()), (Ordering)Ordering.Long$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch id mismatch", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1214));
        return this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$15._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expectedBatches), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$133(FileStreamSourceSuite $this, PrivateMethodTester.PrivateMethod _metadataLog$1, File x0$25, File x1$23) {
        Tuple2 tuple2 = new Tuple2((Object)x0$25, (Object)x1$23);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            Map updateConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[18];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[2] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$16, 0L, 1, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[3] = new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[4] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder());
            streamActionArray[5] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$17, 1L, 2, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder());
            streamActionArray[8] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$18, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[9] = $this.StopStream();
            Map x$42 = updateConf;
            Trigger x$43 = $this.StartStream().apply$default$1();
            Clock x$44 = $this.StartStream().apply$default$2();
            String x$45 = $this.StartStream().apply$default$4();
            streamActionArray[10] = new StreamTest.StartStream($this, x$43, x$44, (Map<String, String>)x$42, x$45);
            streamActionArray[11] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$19, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[12] = new FileStreamSourceTest.AddTextFileData($this, "drop10\nkeep11", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[13] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11"}), $this.testImplicits().newStringEncoder());
            streamActionArray[14] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$20, 3L, 4, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[15] = new FileStreamSourceTest.AddTextFileData($this, "drop12\nkeep13", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[16] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11", "keep13"}), $this.testImplicits().newStringEncoder());
            streamActionArray[17] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$21, 4L, 5, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ FileStreamSourceOffset $anonfun$new$145(int x$22) {
        return new FileStreamSourceOffset((long)x$22);
    }

    private final void verify$2(Option startId, int endId, Seq expected, FileStreamSource fileSource$1) {
        Option start = startId.map((Function1 & Serializable & scala.Serializable)x$22 -> FileStreamSourceSuite.$anonfun$new$145(BoxesRunTime.unboxToInt((Object)x$22)));
        FileStreamSourceOffset end = new FileStreamSourceOffset((long)endId);
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.streaming.unsupportedOperationCheck"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSource$1.getBatch(start, (Offset)end).as(this.testImplicits().newStringEncoder()).collect())).toSeq());
            Seq $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$144(FileStreamSourceSuite $this, StreamExecution execution) {
        PrivateMethodTester.PrivateMethod _sources = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(execution).head();
        $this.verify$2((Option)None$.MODULE$, 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), fileSource);
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$142(FileStreamSourceSuite $this, File x0$26, File x1$24) {
        Tuple2 tuple2 = new Tuple2((Object)x0$26, (Object)x1$24);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("check getBatch", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)execution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$144($this, execution)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$150(StreamingQueryProgress x$23) {
        return x$23.numInputRows() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$149(FileStreamSourceSuite $this, StreamExecution query) {
        StreamingQueryProgress actualProgress = (StreamingQueryProgress)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).find((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$150(x$23))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Could not find records with data."));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actualProgress.numInputRows()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
        double $org_scalatest_assert_macro_left2 = actualProgress.sources()[0].processedRowsPerSecond();
        double $org_scalatest_assert_macro_right2 = 0.0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1305));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$148(FileStreamSourceSuite $this, File x0$27, File x1$25) {
        Tuple2 tuple2 = new Tuple2((Object)x0$27, (Object)x1$25);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset input = $this.spark().readStream().format("text").load(src.getCanonicalPath());
        $this.testStream(input, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "100", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)query -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$149($this, query)), $this.AssertOnQuery().apply$default$2())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$2(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$25) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1366));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$4(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$26) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(10L), "clock.isStreamWaitingAt(10L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$157(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 1000L);
        $this.runTwoBatchesAndVerifyResults(src, false, "1", "2", $this.runTwoBatchesAndVerifyResults$default$5());
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", $this.runTwoBatchesAndVerifyResults$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$159(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", (Option<String>)new Some((Object)"1m"));
    }

    public static final /* synthetic */ void $anonfun$new$164(FileStreamSourceSuite $this, File temp) {
        $this.spark().conf().set(new StringBuilder(8).append("fs.").append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(".impl").toString(), ExistsThrowsExceptionFileSystem.class.getName());
        File dir = new File(temp, "dir");
        FileStreamSourceLog metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), dir.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadataLog.add(0L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file1").toString(), 100L, 0L)})), "metadataLog.add(0L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file1\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 100L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1488));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadataLog.add(1L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file2").toString(), 200L, 0L)})), "metadataLog.add(1L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file2\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 200L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1489));
        FileStreamSource newSource = new FileStreamSource($this.spark(), new StringBuilder(4).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///").toString(), "parquet", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, dir.getAbsolutePath(), Predef$.MODULE$.Map().empty());
        newSource.getBatch((Option)None$.MODULE$, (Offset)new FileStreamSourceOffset(1L));
    }

    public FileStreamSourceSuite() {
        this.test("FileStreamSource schema: no path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("FileStreamSource schema: path doesn't exist (without schema) should throw exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)None$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("FileStreamSource schema: path doesn't exist (with schema) should throw exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)new Some((Object)userSchema));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("FileStreamSource schema: text, no existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$12(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("FileStreamSource schema: text, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$14(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("FileStreamSource schema: text, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$16(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("FileStreamSource schema: orc, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$18(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("FileStreamSource schema: orc, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$23(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("FileStreamSource schema: parquet, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$25(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("FileStreamSource schema: parquet, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$30(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("FileStreamSource schema: json, no existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("Unable to infer schema for JSON. It must be specified manually.;");
                String $org_scalatest_assert_macro_right = e.getMessage();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("FileStreamSource schema: json, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$36(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("FileStreamSource schema: json, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$41(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("read from text files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            FileStreamSourceSuite.$anonfun$new$43(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("SPARK-21996 read from text files -- file name has space", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            FileStreamSourceSuite.$anonfun$new$45(this, x0$2, x1$2);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("SPARK-21996 read from text files generated by file sink -- file name has space", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                FileStreamSourceSuite.$anonfun$new$48(this, testTableName, x0$3, x1$3);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("read from textfile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
            FileStreamSourceSuite.$anonfun$new$52(this, x0$4, x1$4);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        this.test("SPARK-17165 should not track the list of seen files indefinitely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
            FileStreamSourceSuite.$anonfun$new$55(this, x0$5, x1$5);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("read from json files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
            FileStreamSourceSuite.$anonfun$new$59(this, x0$6, x1$6);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        this.test("read from json files with inferring schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$7, x1$7) -> {
            FileStreamSourceSuite.$anonfun$new$61(this, x0$7, x1$7);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        this.test("reading from json files inside partitioned directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$8, x1$8) -> {
            FileStreamSourceSuite.$anonfun$new$64(this, x0$8, x1$8);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        this.test("reading from json files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$9, x1$9) -> {
            FileStreamSourceSuite.$anonfun$new$67(this, x0$9, x1$9);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("read from orc files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$10, x1$10) -> {
            FileStreamSourceSuite.$anonfun$new$70(this, x0$10, x1$10);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        this.test("read from orc files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$11, x1$11) -> {
            FileStreamSourceSuite.$anonfun$new$72(this, x0$11, x1$11);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("read from parquet files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$12, x1$12) -> {
            FileStreamSourceSuite.$anonfun$new$75(this, x0$12, x1$12);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.test("read from parquet files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$13, x1$13) -> {
            FileStreamSourceSuite.$anonfun$new$77(this, x0$13, x1$13);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        this.test("read new files in nested directories with globbing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$14, x1$14) -> {
            FileStreamSourceSuite.$anonfun$new$80(this, x0$14, x1$14);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        this.test("read new files in partitioned table with globbing, should not read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$15, x1$15) -> {
            FileStreamSourceSuite.$anonfun$new$82(this, x0$15, x1$15);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.test("read new files in partitioned table without globbing, should read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$16, x1$16) -> {
            FileStreamSourceSuite.$anonfun$new$84(this, x0$16, x1$16);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("read data from outputs of another streaming query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$17, x1$17) -> {
            FileStreamSourceSuite.$anonfun$new$87(this, x0$17, x1$17);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        this.test("start before another streaming query, and read its output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$18, x1$18) -> {
            FileStreamSourceSuite.$anonfun$new$94(this, x0$18, x1$18);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        this.test("when schema inference is turned on, should read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$19, x1$19) -> {
            FileStreamSourceSuite.$anonfun$new$104(this, x0$19, x1$19);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
        this.test("fault tolerance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$20, x1$20) -> {
            FileStreamSourceSuite.$anonfun$new$106(this, x0$20, x1$20);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
        this.test("max files per trigger", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$21 -> {
            FileStreamSourceSuite.$anonfun$new$108(this, x0$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 997));
        this.testQuietly("max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTable = "maxFilesPerTrigger_test";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$22 -> {
                FileStreamSourceSuite.$anonfun$new$117(this, testTable, x0$22);
                return BoxedUnit.UNIT;
            }));
        });
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$23, x1$21) -> {
            FileStreamSourceSuite.$anonfun$new$121(this, x0$23, x1$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
        this.test("SPARK-17372 - write file names to WAL as Array[String]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numFiles = 10000;
            this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)(numFiles * 2)));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$24, x1$22) -> {
                FileStreamSourceSuite.$anonfun$new$124(this, numFiles, x0$24, x1$22);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1149));
        this.test("compact interval metadata log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.PrivateMethod _sources = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
            PrivateMethodTester.PrivateMethod _metadataLog = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$25, x1$23) -> {
                FileStreamSourceSuite.$anonfun$new$133(this, _metadataLog, x0$25, x1$23);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1185));
        this.test("get arbitrary batch from FileStreamSource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$26, x1$24) -> {
            FileStreamSourceSuite.$anonfun$new$142(this, x0$26, x1$24);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1253));
        this.test("input row metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$27, x1$25) -> {
            FileStreamSourceSuite.$anonfun$new$148(this, x0$27, x1$25);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamOptions options = new FileStreamOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxfilespertrigger"), (Object)"1")})));
            Option $org_scalatest_assert_macro_left = options.maxFilesPerTrigger();
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1314));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1312));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset json format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-json.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1319));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1317));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset long format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-long.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1324));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1322));
        this.test("FileStreamSourceLog - read Spark 2.1.0 log format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readLogFromResource("file-source-log-version-2.1.0"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry("/a/b/0", 1480730949000L, 0L), new FileStreamSource.FileEntry("/a/b/1", 1480730950000L, 1L), new FileStreamSource.FileEntry("/a/b/2", 1480730950000L, 2L), new FileStreamSource.FileEntry("/a/b/3", 1480730950000L, 3L), new FileStreamSource.FileEntry("/a/b/4", 1480730951000L, 4L)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1328));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1327));
        this.test("FileStreamSource - latestFirst", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$157(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
        this.test("SPARK-19813: Ignore maxFileAge when maxFilesPerTrigger and latestFirst is used", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$159(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
        this.test("SeenFilesMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 5L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left2 = map;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
            map.add("b", 15L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left3 = map;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1421));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left4 = map;
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1423));
            map.add("c", 16L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left5 = map;
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left6 = map;
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1429));
            map.add("c", 25L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left7 = map;
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1433));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("c", 20L), "map.isNewFile(\"c\", 20L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1436));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1439));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("e", 20L), "map.isNewFile(\"e\", 20L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1442));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
        this.test("SeenFilesMap with fileNameOnly = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, true);
            map.add("file:///a/b/c/d", 5L);
            map.add("file:///a/b/c/e", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1450));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1452));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///d", 5L), "map.isNewFile(\"file:///d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/d", 5L), "map.isNewFile(\"file:///x/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1454));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/y/d", 5L), "map.isNewFile(\"file:///x/y/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1455));
            map.add("s3:///bucket/d", 5L);
            map.add("s3n:///bucket/d", 5L);
            map.add("s3a:///bucket/d", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1445));
        this.test("SeenFilesMap should only consider a file old if it is earlier than last purge time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 20L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1467));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1470));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1471));
            map.purge();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1475));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1476));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1463));
        this.test("do not recheck that files exist during getBatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$164(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
    }
}

