/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.CSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.apache.spark.sql.sources.v2.SimpleCSVInputPartitionReader;
import org.apache.spark.sql.sources.v2.SimpleCounter$;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001=\u0011\u0001dU5na2,wK]5uC\ndW\rR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0002we)\u0011QAB\u0001\bg>,(oY3t\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003\u0007\u000f EA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\taA)\u0019;b'>,(oY3WeA\u0011\u0011$H\u0005\u0003=\t\u00111BU3bIN+\b\u000f]8siB\u0011\u0011\u0004I\u0005\u0003C\t\u0011Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"!G\u0012\n\u0005\u0011\u0012!\u0001F*fgNLwN\\\"p]\u001aLwmU;qa>\u0014H\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0004\u0001\u0005\u0006U\u0001!\tbK\u0001\u000bMVdGnU2iK6\fG#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0011!\u0002;za\u0016\u001c\u0018BA\u0019/\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006g\u0001!\t\u0005N\u0001\nW\u0016L\bK]3gSb$\u0012!\u000e\t\u0003m}r!aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0005ir\u0011A\u0002\u001fs_>$hHC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 <\r\u0011\u0019\u0005\u0001\u0001#\u0003\rI+\u0017\rZ3s'\r\u0011\u0005#\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\n\taA]3bI\u0016\u0014\u0018B\u0001&H\u0005A!\u0015\r^1T_V\u00148-\u001a*fC\u0012,'\u000f\u0003\u0005M\u0005\n\u0005\t\u0015!\u00036\u0003\u0011\u0001\u0018\r\u001e5\t\u00119\u0013%\u0011!Q\u0001\n=\u000bAaY8oMB\u0011\u0001\u000bV\u0007\u0002#*\u0011aJ\u0015\u0006\u0003'*\ta\u0001[1e_>\u0004\u0018BA+R\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")aE\u0011C\u0001/R\u0019\u0001LW.\u0011\u0005e\u0013U\"\u0001\u0001\t\u000b13\u0006\u0019A\u001b\t\u000b93\u0006\u0019A(\t\u000bu\u0013E\u0011I\u0016\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rC\u0003`\u0005\u0012\u0005\u0003-A\nqY\u0006t\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000fF\u0001b!\r\u0011WmZ\u0007\u0002G*\u0011A\rF\u0001\u0005kRLG.\u0003\u0002gG\n!A*[:u!\r1\u0005N[\u0005\u0003S\u001e\u0013a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002l]6\tAN\u0003\u0002n\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002pY\nY\u0011J\u001c;fe:\fGNU8x\r\u0011\t\b\u0001\u0001:\u0003\r]\u0013\u0018\u000e^3s'\r\u0001\bc\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\n\taa\u001e:ji\u0016\u0014\u0018B\u0001=v\u0005A!\u0015\r^1T_V\u00148-Z,sSR,'\u000f\u0003\u0005{a\n\u0005\t\u0015!\u00036\u0003\u0015QwNY%e\u0011!a\u0005O!A!\u0002\u0013)\u0004\u0002\u0003(q\u0005\u0003\u0005\u000b\u0011B(\t\u000b\u0019\u0002H\u0011\u0001@\u0015\u000f}\f\t!a\u0001\u0002\u0006A\u0011\u0011\f\u001d\u0005\u0006uv\u0004\r!\u000e\u0005\u0006\u0019v\u0004\r!\u000e\u0005\u0006\u001dv\u0004\ra\u0014\u0005\b\u0003\u0013\u0001H\u0011IA\u0006\u0003M\u0019'/Z1uK^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z)\t\ti\u0001\u0005\u0003u\u0003\u001fQ\u0017bAA\tk\n\tB)\u0019;b/JLG/\u001a:GC\u000e$xN]=\t\u000f\u0005U\u0001\u000f\"\u0011\u0002\u0018\u0005\u0011rN\u001c#bi\u0006<&/\u001b;fe\u000e{W.\\5u)\u0011\tI\"!\t\u0011\t\u0005m\u0011QD\u0007\u0002w%\u0019\u0011qD\u001e\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003G\t\u0019\u00021\u0001\u0002&\u00059Q.Z:tC\u001e,\u0007c\u0001;\u0002(%\u0019\u0011\u0011F;\u0003']\u0013\u0018\u000e^3s\u0007>lW.\u001b;NKN\u001c\u0018mZ3\t\u000f\u00055\u0002\u000f\"\u0011\u00020\u000511m\\7nSR$B!!\u0007\u00022!A\u00111GA\u0016\u0001\u0004\t)$\u0001\u0005nKN\u001c\u0018mZ3t!\u0019\tY\"a\u000e\u0002&%\u0019\u0011\u0011H\u001e\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005u\u0002\u000f\"\u0011\u0002@\u0005)\u0011MY8siR!\u0011\u0011DA!\u0011!\t\u0019$a\u000fA\u0002\u0005U\u0002bBA#\u0001\u0011\u0005\u0013qI\u0001\rGJ,\u0017\r^3SK\u0006$WM\u001d\u000b\u0004\u000b\u0006%\u0003\u0002CA&\u0003\u0007\u0002\r!!\u0014\u0002\u000f=\u0004H/[8ogB\u0019\u0011$a\u0014\n\u0007\u0005E#AA\tECR\f7k\\;sG\u0016|\u0005\u000f^5p]NDq!!\u0016\u0001\t\u0003\n9&\u0001\u0007de\u0016\fG/Z,sSR,'\u000f\u0006\u0006\u0002Z\u0005}\u0013\u0011MA3\u0003c\u0002BAYA.g&\u0019\u0011QL2\u0003\u0011=\u0003H/[8oC2DaA_A*\u0001\u0004)\u0004bBA2\u0003'\u0002\r\u0001L\u0001\u0007g\u000eDW-\\1\t\u0011\u0005\u001d\u00141\u000ba\u0001\u0003S\nA!\\8eKB!\u00111NA7\u001b\u00051\u0011bAA8\r\tA1+\u0019<f\u001b>$W\r\u0003\u0005\u0002L\u0005M\u0003\u0019AA'\u0001")
public class SimpleWritableDataSource
implements ReadSupport,
WriteSupport,
SessionConfigSupport {
    public DataSourceReader createReader(StructType x$1, DataSourceOptions x$2) {
        return super.createReader(x$1, x$2);
    }

    public StructType fullSchema() {
        return new StructType().add("i", "long").add("j", "long");
    }

    public String keyPrefix() {
        return "simpleWritableDataSource";
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        return new Reader(this, path.toUri().toString(), conf);
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType schema, SaveMode mode, DataSourceOptions options) {
        Predef$.MODULE$.assert(!((SparkContext)SparkContext$.MODULE$.getActive().get()).conf().getBoolean("spark.speculation", false));
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        FileSystem fs = path.getFileSystem(conf);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && fs.exists(path)) {
            throw new RuntimeException("data already exists.");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && fs.exists(path)) {
            return Optional.empty();
        }
        SaveMode saveMode5 = mode;
        SaveMode saveMode6 = SaveMode.Overwrite;
        Object object = !(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true)) : BoxedUnit.UNIT;
        String pathStr = path.toUri().toString();
        return Optional.of(new Writer(this, jobId, pathStr, conf));
    }

    public class Reader
    implements DataSourceReader {
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public StructType readSchema() {
            return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer().fullSchema();
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            Path dataPath = new Path(this.path);
            FileSystem fs = dataPath.getFileSystem(this.conf);
            return fs.exists(dataPath) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(dataPath))).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)Reader.$anonfun$planInputPartitions$1(status))))).map((Function1 & Serializable & scala.Serializable)f -> {
                SerializableConfiguration serializableConf = new SerializableConfiguration($this.conf);
                return new SimpleCSVInputPartitionReader(f.getPath().toUri().toString(), serializableConf);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputPartition.class))))).toList()).asJava() : Collections.emptyList();
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$planInputPartitions$1(FileStatus status) {
            String name = status.getPath().getName();
            return name.startsWith("_") || name.startsWith(".");
        }

        public Reader(SimpleWritableDataSource $outer, String path, Configuration conf) {
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class Writer
    implements DataSourceWriter {
        private final String jobId;
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public boolean useCommitCoordinator() {
            return super.useCommitCoordinator();
        }

        public DataWriterFactory<InternalRow> createWriterFactory() {
            SimpleCounter$.MODULE$.resetCounter();
            return new CSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        public void onDataWriterCommit(WriterCommitMessage message) {
            SimpleCounter$.MODULE$.increaseCounter();
        }

        public void commit(WriterCommitMessage[] messages) {
            Path finalPath = new Path(this.path);
            Path jobPath = new Path(new Path(finalPath, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            try {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(jobPath))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    Writer.$anonfun$commit$2(finalPath, fs, file);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                fs.delete(jobPath, true);
            }
        }

        public void abort(WriterCommitMessage[] messages) {
            Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            fs.delete(jobPath, true);
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Writer$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$commit$2(Path finalPath$1, FileSystem fs$1, Path file) {
            Path dest = new Path(finalPath$1, file.getName());
            if (!fs$1.rename(file, dest)) {
                throw new IOException(new StringBuilder(20).append("failed to rename(").append(file).append(", ").append(dest).append(")").toString());
            }
        }

        public Writer(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

