/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceTest;
import org.apache.spark.sql.sources.SaveLoadSuite$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011QbU1wK2{\u0017\rZ*vSR,'BA\u0002\u0005\u0003\u001d\u0019x.\u001e:dKNT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00131A\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000f\t\u0006$\u0018mU8ve\u000e,G+Z:u!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003uKN$\u0018BA\f\u0015\u0005A\u0019\u0006.\u0019:fIN\u000bFjQ8oi\u0016DH\u000f\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0015\u0005I1oY1mCR,7\u000f^\u0005\u0003;i\u0011aBQ3g_J,\u0017I\u001c3BMR,'\u000fC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011q\u0002\u0001\u0005\t\u000b\u0001A)\u0019!C)GU\tA\u0005\u0005\u0003&Q)*T\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u00163\u001d\ta\u0003\u0007\u0005\u0002.M5\taF\u0003\u00020\u0019\u00051AH]8pizJ!!\r\u0014\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c\u0019\u0002\"A\u000e\u001e\u000f\u0005]BT\"\u0001\u0003\n\u0005e\"\u0011a\u00029bG.\fw-Z\u0005\u0003wq\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005e\"\u0001b\u0002 \u0001\u0001\u0004%IaP\u0001\u0016_JLw-\u001b8bY\u0012+g-Y;miN{WO]2f+\u0005Q\u0003bB!\u0001\u0001\u0004%IAQ\u0001\u001a_JLw-\u001b8bY\u0012+g-Y;miN{WO]2f?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011Q\u0005R\u0005\u0003\u000b\u001a\u0012A!\u00168ji\"9q\tQA\u0001\u0002\u0004Q\u0013a\u0001=%c!1\u0011\n\u0001Q!\n)\nac\u001c:jO&t\u0017\r\u001c#fM\u0006,H\u000e^*pkJ\u001cW\r\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u0003\u0011\u0001\u0018\r\u001e5\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0005%|'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013AAR5mK\"9a\u000b\u0001a\u0001\n\u00139\u0016\u0001\u00039bi\"|F%Z9\u0015\u0005\rC\u0006bB$V\u0003\u0003\u0005\r!\u0014\u0005\u00075\u0002\u0001\u000b\u0015B'\u0002\u000bA\fG\u000f\u001b\u0011\t\u000fq\u0003\u0001\u0019!C\u0005;\u0006\u0011AMZ\u000b\u0002=B\u0011qL\u000f\b\u0003Abr!!Y4\u000f\u0005\t4gBA2f\u001d\tiC-C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QA\u0002\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003\u0019!gm\u0018\u0013fcR\u00111i\u001b\u0005\b\u000f\"\f\t\u00111\u0001_\u0011\u0019i\u0007\u0001)Q\u0005=\u0006\u0019AM\u001a\u0011\t\u000b=\u0004A\u0011\t9\u0002\u0013\t,gm\u001c:f\u00032dG#A\"\t\u000bI\u0004A\u0011\t9\u0002\u0011\u00054G/\u001a:BY2DQ\u0001\u001e\u0001\u0005\u0002U\f\u0011b\u00195fG.du.\u00193\u0015\u0007\r3\b\u0010C\u0004xgB\u0005\t\u0019\u00010\u0002\u0015\u0015D\b/Z2uK\u0012$e\tC\u0004zgB\u0005\t\u0019\u0001\u0016\u0002\u0007Q\u0014G\u000eC\u0004|\u0001E\u0005I\u0011\u0001?\u0002'\rDWmY6M_\u0006$G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003uT#A\u0018@,\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0002\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0005\r!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0003\u0001\u0012\u0002\u0013\u0005\u00111C\u0001\u0014G\",7m\u001b'pC\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003+Q#A\u000b@")
public class SaveLoadSuite
extends DataSourceTest
implements SharedSQLContext,
BeforeAndAfter {
    private Function1<String, Dataset<Row>> sql;
    private String originalDefaultSource;
    private File path;
    private Dataset<Row> df;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$(this, f);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$(this, f);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$(this, numPaths, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                SparkSession sparkSession = this.spark();
                this.sql = (Function1 & Serializable & scala.Serializable)sqlText -> sparkSession.sql(sqlText);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    private String originalDefaultSource() {
        return this.originalDefaultSource;
    }

    private void originalDefaultSource_$eq(String x$1) {
        this.originalDefaultSource = x$1;
    }

    private File path() {
        return this.path;
    }

    private void path_$eq(File x$1) {
        this.path = x$1;
    }

    private Dataset<Row> df() {
        return this.df;
    }

    private void df_$eq(Dataset<Row> x$1) {
        this.df = x$1;
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
        this.originalDefaultSource_$eq(this.spark().sessionState().conf().defaultDataSourceName());
        this.path_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.path().delete();
        Dataset ds = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> SaveLoadSuite.$anonfun$beforeAll$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDS();
        this.df_$eq((Dataset<Row>)this.spark().read().json(ds));
        this.df().createOrReplaceTempView("jsonTable");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), this.originalDefaultSource());
        }
        finally {
            SharedSQLContext.afterAll$(this);
        }
    }

    public void checkLoad(Dataset<Row> expectedDF, String tbl) {
        this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "org.apache.spark.sql.json");
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().read().load(this.path().toString()), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedDF.collect()));
        this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "not a source name");
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("json").load(this.path().toString()), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedDF.collect()));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("json").load(this.path().toString()), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedDF.collect()));
        StructField structField = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("json").schema(schema).load(this.path().toString()), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT b FROM ").append(tbl).toString())).collect()));
    }

    public Dataset<Row> checkLoad$default$1() {
        return this.df();
    }

    public String checkLoad$default$2() {
        return "jsonTable";
    }

    private final void testImplicits$lzycompute$1() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        SaveLoadSuite saveLoadSuite = this;
        synchronized (saveLoadSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$beforeAll$1(int i) {
        return new StringBuilder(17).append("{\"a\":").append(i).append(", \"b\":\"str").append(i).append("\"}").toString();
    }

    public static final /* synthetic */ void $anonfun$new$9(SaveLoadSuite $this, File dir) {
        String e;
        String path = dir.getCanonicalPath();
        String unknown = "unknownColumn";
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SaveLoadSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_sources_SaveLoadSuite$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_sources_SaveLoadSuite$$typecreator11$1(SaveLoadSuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)"a")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_SaveLoadSuite$$typecreator11$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
        String schemaCatalog = df.schema().catalogString();
        String $org_scalatest_assert_macro_left = e = ((AnalysisException)((Object)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{unknown})).save(path), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136)))).getMessage();
        String $org_scalatest_assert_macro_right = new StringBuilder(40).append("Partition column `").append(unknown).append("` not found in schema ").append(schemaCatalog).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    public SaveLoadSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.originalDefaultSource = null;
        this.path = null;
        this.df = null;
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.deleteRecursively(this.path()), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("save with path and load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "org.apache.spark.sql.json");
            this.df().write().save(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
        }, new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("save with string mode and path, and load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "org.apache.spark.sql.json");
            this.path().createNewFile();
            this.df().write().mode("overwrite").save(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
        }, new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("save with path and datasource, and load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "not a source name");
            this.df().write().json(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
        }, new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("save with data source and options, and load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "not a source name");
            this.df().write().mode(SaveMode.ErrorIfExists).json(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
        }, new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("save and save again", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message;
            this.df().write().json(this.path().toString());
            String $org_scalatest_assert_macro_left = message = ((AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().json(this.path().toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106))))).getMessage();
            String $org_scalatest_assert_macro_right = "already exists";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"We should complain that the path already exists.", Prettifier$.MODULE$.default(), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            if (this.path().exists()) {
                Utils$.MODULE$.deleteRecursively(this.path());
            }
            this.df().write().json(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
            this.df().write().mode(SaveMode.Overwrite).json(this.path().toString());
            this.checkLoad(this.checkLoad$default$1(), this.checkLoad$default$2());
            this.df().write().mode(SaveMode.Append).json(this.path().toString());
            Dataset df2 = this.df().union(this.df());
            df2.createOrReplaceTempView("jsonTable2");
            this.checkLoad((Dataset<Row>)df2, "jsonTable2");
        }, new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("SPARK-23459: Improve error message when specified unknown column in partition columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            SaveLoadSuite.$anonfun$new$9(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("SaveLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }
}

