/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.DataSourceAnalysis;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001b\t9B)\u0019;b'>,(oY3B]\u0006d\u0017p]5t'VLG/\u001a\u0006\u0003\u0007\u0011\tqa]8ve\u000e,7O\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)\"\"A\u0005tG\u0006d\u0017\r^3ti&\u0011q\u0003\u0006\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011%q\u0002\u00011AA\u0002\u0013%q$\u0001\tuCJ<W\r^!uiJL'-\u001e;fgV\t\u0001\u0005E\u0002\"W9r!A\t\u0015\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015b\u0011A\u0002\u001fs_>$h(C\u0001(\u0003\u0015\u00198-\u00197b\u0013\tI#&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u001dJ!\u0001L\u0017\u0003\u0007M+\u0017O\u0003\u0002*UA\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00024\t\u0005A1-\u0019;bYf\u001cH/\u0003\u00026a\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\no\u0001\u0001\r\u00111A\u0005\na\nA\u0003^1sO\u0016$\u0018\t\u001e;sS\n,H/Z:`I\u0015\fHCA\u001d>!\tQ4(D\u0001+\u0013\ta$F\u0001\u0003V]&$\bb\u0002 7\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u0003!\u0003E!\u0018M]4fi\u0006#HO]5ckR,7\u000f\t\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\n\r\u000bQ\u0003^1sO\u0016$\b+\u0019:uSRLwN\\*dQ\u0016l\u0017-F\u0001E!\t)\u0005*D\u0001G\u0015\t9E!A\u0003usB,7/\u0003\u0002J\r\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0013a\u0015!\u0007;be\u001e,G\u000fU1si&$\u0018n\u001c8TG\",W.Y0%KF$\"!O'\t\u000fyR\u0015\u0011!a\u0001\t\"Iq\n\u0001a\u0001\u0002\u0003\u0006K\u0001R\u0001\u0017i\u0006\u0014x-\u001a;QCJ$\u0018\u000e^5p]N\u001b\u0007.Z7bA!)\u0011\u000b\u0001C!%\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002s!)A\u000b\u0001C\u0005+\u0006\u00012\r[3dWB\u0013xN[3di2K7\u000f\u001e\u000b\u0004sYc\u0006\"B,T\u0001\u0004A\u0016AB1diV\fG\u000eE\u0002\"We\u0003\"a\f.\n\u0005m\u0003$AC#yaJ,7o]5p]\")Ql\u0015a\u00011\u0006AQ\r\u001f9fGR,G\r")
public class DataSourceAnalysisSuite
extends SparkFunSuite {
    private Seq<Attribute> targetAttributes;
    private StructType targetPartitionSchema;

    private Seq<Attribute> targetAttributes() {
        return this.targetAttributes;
    }

    private void targetAttributes_$eq(Seq<Attribute> x$1) {
        this.targetAttributes = x$1;
    }

    private StructType targetPartitionSchema() {
        return this.targetPartitionSchema;
    }

    private void targetPartitionSchema_$eq(StructType x$1) {
        this.targetPartitionSchema = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.targetAttributes_$eq((Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))));
        this.targetPartitionSchema_$eq(new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$));
    }

    private void checkProjectList(Seq<Expression> actual, Seq<Expression> expected) {
        Seq withoutAliases = (Seq)actual.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression;
            Expression expression2 = x0$1;
            if (expression2 instanceof Alias) {
                Alias alias = (Alias)expression2;
                expression = alias.child();
            } else {
                expression = expression2;
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(withoutAliases);
        Seq<Expression> $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    private static final Expression cast$1(Expression e, DataType dt, SQLConf conf$1) {
        return new Cast(e, dt, Option$.MODULE$.apply((Object)conf$1.sessionLocalTimeZone()));
    }

    public static final /* synthetic */ void $anonfun$new$1(DataSourceAnalysisSuite $this, boolean caseSensitive) {
        SQLConf conf = new SQLConf().copy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE()), (Object)BoxesRunTime.boxToBoolean((boolean)caseSensitive))}));
        DataSourceAnalysis rule = new DataSourceAnalysis(conf);
        $this.test(new StringBuilder(77).append("convertStaticPartitions only handle INSERT having at least static partitions ").append(new StringBuilder(17).append("(caseSensitive: ").append(caseSensitive).append(")").toString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AssertionError)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61)), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        $this.test(new StringBuilder(33).append("Missing columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72)), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        $this.test(new StringBuilder(46).append("Missing partitioning columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            return (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        $this.test(new StringBuilder(44).append("Wrong partitioning columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            return caseSensitive ? $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131)) : BoxedUnit.UNIT;
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        $this.test(new StringBuilder(58).append("Static partitions need to appear before dynamic partitions").append(new StringBuilder(18).append(" (caseSensitive: ").append(caseSensitive).append(")").toString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145)), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        $this.test(new StringBuilder(39).append("All static partitions (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!caseSensitive) {
                Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
                Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
                Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
                $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            }
            Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            Seq nonPartitionedAttributes2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected2 = (Seq)nonPartitionedAttributes2.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
            Seq actual2 = rule.convertStaticPartitions(nonPartitionedAttributes2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()})), new StructType().add("b", (DataType)IntegerType$.MODULE$));
            $this.checkProjectList((Seq<Expression>)actual2, (Seq<Expression>)expected2);
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        $this.test(new StringBuilder(56).append("Static partition and dynamic partition (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq dynamicPartitionAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()}));
            Seq expected = (Seq)((TraversableLike)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions((Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public DataSourceAnalysisSuite() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)caseSensitive -> {
            DataSourceAnalysisSuite.$anonfun$new$1(this, BoxesRunTime.unboxToBoolean((Object)caseSensitive));
            return BoxedUnit.UNIT;
        });
    }
}

