/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.VariableSubstitution;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r2A!\u0001\u0002\u0001\u001b\tIb+\u0019:jC\ndWmU;cgRLG/\u001e;j_:\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u0011a\u0001\u0001R1A\u0005\ne\tAaY8oMV\t!\u0004\u0005\u0002\u00177%\u0011AD\u0001\u0002\b'Fc5i\u001c8g\u0011!q\u0002\u0001#b\u0001\n\u0013y\u0012aA:vEV\t\u0001\u0005\u0005\u0002\u0017C%\u0011!E\u0001\u0002\u0015-\u0006\u0014\u0018.\u00192mKN+(m\u001d;jiV$\u0018n\u001c8")
public class VariableSubstitutionSuite
extends SparkFunSuite {
    private SQLConf conf;
    private VariableSubstitution sub;
    private volatile byte bitmap$0;

    private SQLConf conf$lzycompute() {
        VariableSubstitutionSuite variableSubstitutionSuite = this;
        synchronized (variableSubstitutionSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.conf = new SQLConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.conf;
    }

    private SQLConf conf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.conf$lzycompute() : this.conf;
    }

    private VariableSubstitution sub$lzycompute() {
        VariableSubstitutionSuite variableSubstitutionSuite = this;
        synchronized (variableSubstitutionSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sub = new VariableSubstitution(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sub;
    }

    private VariableSubstitution sub() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sub$lzycompute() : this.sub;
    }

    public VariableSubstitutionSuite() {
        this.test("system property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            System.setProperty("varSubSuite.var", "abcd");
            String $org_scalatest_assert_macro_left = this.sub().substitute("${system:varSubSuite.var}");
            String $org_scalatest_assert_macro_right = "abcd";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        }, new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("environmental variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.sub().substitute("${env:SPARK_TESTING}");
            String $org_scalatest_assert_macro_right = "1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Spark configuration variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            this.conf().setConfString("some-random-string-abcd", "1234abcd");
            String $org_scalatest_assert_macro_left = this.sub().substitute("${hiveconf:some-random-string-abcd}");
            String $org_scalatest_assert_macro_right = "1234abcd";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            String $org_scalatest_assert_macro_left2 = this.sub().substitute("${sparkconf:some-random-string-abcd}");
            String $org_scalatest_assert_macro_right2 = "1234abcd";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            String $org_scalatest_assert_macro_left3 = this.sub().substitute("${spark:some-random-string-abcd}");
            String $org_scalatest_assert_macro_right3 = "1234abcd";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            String $org_scalatest_assert_macro_left4 = this.sub().substitute("${some-random-string-abcd}");
            String $org_scalatest_assert_macro_right4 = "1234abcd";
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        }, new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("multiple substitutes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String q = "select ${bar} ${foo} ${doo} this is great";
            this.conf().setConfString("bar", "1");
            this.conf().setConfString("foo", "2");
            this.conf().setConfString("doo", "3");
            String $org_scalatest_assert_macro_left = this.sub().substitute(q);
            String $org_scalatest_assert_macro_right = "select 1 2 3 this is great";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("test nested substitutes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String q = "select ${bar} ${foo} this is great";
            this.conf().setConfString("bar", "1");
            this.conf().setConfString("foo", "${bar}");
            String $org_scalatest_assert_macro_left = this.sub().substitute(q);
            String $org_scalatest_assert_macro_right = "select 1 1 this is great";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("VariableSubstitutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
    }
}

