/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001E\u0011qb\u0015;bi\u0016\u001cFo\u001c:f'VLG/\u001a\u0006\u0003\u0007\u0011\tQa\u001d;bi\u0016T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%ey\u0002cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\t\u00192\u000b^1uKN#xN]3Tk&$XMQ1tKB\u00111cF\u0005\u00031\t\u0011A\u0004\u0013#G'\n\u000b7m[3e'R\fG/Z*u_J,\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u001d\u0005I1oY1mCR,7\u000f^\u0005\u0003=m\u0011aBQ3g_J,\u0017I\u001c3BMR,'\u000f\u0005\u0002\u001bA%\u0011\u0011e\u0007\u0002\u0014!JLg/\u0019;f\u001b\u0016$\bn\u001c3UKN$XM\u001d\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"a\u0005\u0001\u0006\t\u001d\u0002\u0001\u0001\u000b\u0002\b\u001b\u0006\u0004H+\u001f9f!\u0011I\u0003G\r\u001a\u000e\u0003)R!a\u000b\u0017\u0002\u000f5,H/\u00192mK*\u0011QFL\u0001\u000bG>dG.Z2uS>t'\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005ER#a\u0002%bg\"l\u0015\r\u001d\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0007C\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011\b\u000e\u0002\n+:\u001c\u0018MZ3S_^,Aa\u000f\u0001\u0001y\ty\u0001K]8wS\u0012,'/T1q)f\u0004X\r\u0005\u0003>\tJ\u0012T\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['ba\"9q\t\u0001b\u0001\n\u0003A\u0015!C6fsN\u001b\u0007.Z7b+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\t\u0003\u0015!\u0018\u0010]3t\u0013\tq5J\u0001\u0006TiJ,8\r\u001e+za\u0016Da\u0001\u0015\u0001!\u0002\u0013I\u0015AC6fsN\u001b\u0007.Z7bA!9!\u000b\u0001b\u0001\n\u0003A\u0015a\u0003<bYV,7k\u00195f[\u0006Da\u0001\u0016\u0001!\u0002\u0013I\u0015\u0001\u0004<bYV,7k\u00195f[\u0006\u0004\u0003\"\u0002,\u0001\t\u00039\u0016aD;qI\u0006$XMV3sg&|g\u000eV8\u0015\tac\u0016m\u0019\t\u00033jk\u0011AL\u0005\u00037:\u00121!\u00138u\u0011\u0015iV\u000b1\u0001_\u0003!\u0001(o\u001c<jI\u0016\u0014\bCA\n`\u0013\t\u0001'A\u0001\nTi\u0006$Xm\u0015;pe\u0016\u0004&o\u001c<jI\u0016\u0014\b\"\u00022V\u0001\u0004A\u0016AD2veJ,g\u000e\u001e,feNLwN\u001c\u0005\u0006IV\u0003\r\u0001W\u0001\u000ei\u0006\u0014x-\u001a;WKJ\u001c\u0018n\u001c8\t\u000b\u0019\u0004A\u0011A4\u0002!%t7M]3nK:$h+\u001a:tS>tGc\u0001-iS\")Q,\u001aa\u0001=\")!-\u001aa\u00011\")1\u000e\u0001C\u0001Y\u0006\u00192\r[3dW2{\u0017\rZ3e-\u0016\u00148/[8ogR)Q\u000e]>~\u007fB\u0011\u0011L\\\u0005\u0003_:\u0012A!\u00168ji\")\u0011O\u001ba\u0001e\u0006QAn\\1eK\u0012l\u0015\r]:\u0011\tM$h/_\u0007\u0002\u0001&\u0011Q\u000f\u0011\u0002\n'>\u0014H/\u001a3NCB\u0004\"!W<\n\u0005at#\u0001\u0002'p]\u001e\u0004\"A\u001f\u001e\u000e\u0003\u0001AQ\u0001 6A\u0002a\u000bQaY8v]RDQA 6A\u0002Y\f1\"Z1sY&,7\u000f^&fs\"1\u0011\u0011\u00016A\u0002Y\f\u0011\u0002\\1uKN$8*Z=\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005a1\r[3dWZ+'o]5p]R9Q.!\u0003\u0002\f\u0005=\u0001BB9\u0002\u0004\u0001\u0007!\u000fC\u0004\u0002\u000e\u0005\r\u0001\u0019\u0001<\u0002\u000fY,'o]5p]\"A\u0011\u0011CA\u0002\u0001\u0004\t\u0019\"\u0001\u0007fqB,7\r^3e\t\u0006$\u0018\rE\u0004\u0002\u0016\u0005\r\u0012\u0011\u0006-\u000f\t\u0005]\u0011q\u0004\t\u0004\u00033qSBAA\u000e\u0015\r\ti\u0002E\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005b&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9CA\u0002NCBT1!!\t/!\u0011\t)\"a\u000b\n\t\u00055\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005\u0001b.Z<Ti>\u0014X\r\u0015:pm&$WM\u001d\u000b\u0002-!9\u0011\u0011\u0007\u0001\u0005B\u0005]Bc\u0001\f\u0002:!A\u00111HA\u001b\u0001\u0004\ti$A\u0004ti>\u0014X-\u00133\u0011\u0007M\ty$C\u0002\u0002B\t\u0011Ab\u0015;bi\u0016\u001cFo\u001c:f\u0013\u0012Dq!!\u0012\u0001\t\u0003\n9%A\u0007hKRd\u0015\r^3ti\u0012\u000bG/\u0019\u000b\u0005\u0003\u0013\n)\u0006\u0005\u0004\u0002\u0016\u0005-\u0013qJ\u0005\u0005\u0003\u001b\n9CA\u0002TKR\u0004b!WA)\u0003SA\u0016bAA*]\t1A+\u001e9mKJBq!a\u0016\u0002D\u0001\u0007a#A\u0007ti>\u0014X\r\u0015:pm&$WM\u001d\u0005\b\u00037\u0002A\u0011IA/\u0003\u001d9W\r\u001e#bi\u0006$b!!\u0013\u0002`\u0005\u0005\u0004BB/\u0002Z\u0001\u0007a\u0003C\u0005\u0002\u000e\u0005e\u0003\u0013!a\u00011\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u0015D#\u0004\f\u0002h\u0005-\u0014qNA:\u0003o\nY\bC\u0004\u0002j\u0005\r\u0004\u0019\u0001<\u0002\t=\u0004\u0018\n\u001a\u0005\b\u0003[\n\u0019\u00071\u0001Y\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0006\u0002r\u0005\r\u0004\u0013!a\u0001\u0003S\t1\u0001Z5s\u0011%\t)(a\u0019\u0011\u0002\u0003\u0007\u0001,\u0001\u000bnS:$U\r\u001c;bg\u001a{'o\u00158baNDw\u000e\u001e\u0005\n\u0003s\n\u0019\u0007%AA\u0002a\u000b\u0011D\\;n\u001f\u001a4VM]:U_J+G/Y5o\u0013:lU-\\8ss\"Q\u0011QPA2!\u0003\u0005\r!a \u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t\r|gN\u001a\u0006\u0004\u0003\u0013c\u0011A\u00025bI>|\u0007/\u0003\u0003\u0002\u000e\u0006\r%!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002\u0012\u0002!\t!a%\u0002\u0015\u0019LG.Z#ySN$8\u000f\u0006\u0005\u0002\u0016\u0006m\u0015QTAP!\rI\u0016qS\u0005\u0004\u00033s#a\u0002\"p_2,\u0017M\u001c\u0005\u0007;\u0006=\u0005\u0019\u0001\f\t\u000f\u00055\u0011q\u0012a\u0001m\"A\u0011\u0011UAH\u0001\u0004\t)*\u0001\u0006jgNs\u0017\r]:i_RDq!!*\u0001\t\u0003\t9+A\u000feK2,G/\u001a$jY\u0016\u001cX)\u0019:mS\u0016\u0014H\u000b[1o-\u0016\u00148/[8o)\u0015i\u0017\u0011VAV\u0011\u0019i\u00161\u0015a\u0001-!9\u0011QBAR\u0001\u00041\bbBAX\u0001\u0011\u0005\u0011\u0011W\u0001\fG>\u0014(/\u001e9u\r&dW\rF\u0004n\u0003g\u000b),a.\t\ru\u000bi\u000b1\u0001\u0017\u0011\u001d\ti!!,A\u0002YD\u0001\"!)\u0002.\u0002\u0007\u0011Q\u0013\u0005\n\u0003w\u0003\u0011\u0013!C\u0001\u0003{\u000b!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uIM*\"!a0+\t\u0005%\u0012\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001a\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u001b\u0001\u0012\u0002\u0013\u0005\u0011q[\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u00033T3\u0001WAa\u0011%\ti\u000eAI\u0001\n\u0003\t9.\u0001\u000eoK^\u001cFo\u001c:f!J|g/\u001b3fe\u0012\"WMZ1vYR$S\u0007C\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002d\u0006Qb.Z<Ti>\u0014X\r\u0015:pm&$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\u001d\u0016\u0005\u0003\u007f\n\t\rC\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002X\u0006\tr-\u001a;ECR\fG\u0005Z3gCVdG\u000f\n\u001a")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter,
PrivateMethodTester {
    private final StructType keySchema;
    private final StructType valueSchema;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public StructType keySchema() {
        return this.keySchema;
    }

    public StructType valueSchema() {
        return this.valueSchema;
    }

    public int updateVersionTo(StateStoreProvider provider, int currentVersion, int targetVersion) {
        IntRef newCurrentVersion = IntRef.create((int)currentVersion);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(newCurrentVersion.elem), targetVersion).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            newCurrentVersion$1.elem = this.incrementVersion(provider, i);
        });
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newCurrentVersion.elem)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)targetVersion), Equality$.MODULE$.default()));
        return newCurrentVersion.elem;
    }

    public int incrementVersion(StateStoreProvider provider, int currentVersion) {
        StateStore store = provider.getStore((long)currentVersion);
        StateStoreTestsHelper$.MODULE$.put(store, "a", currentVersion + 1);
        store.commit();
        return currentVersion + 1;
    }

    public void checkLoadedVersions(SortedMap<Object, ConcurrentHashMap<UnsafeRow, UnsafeRow>> loadedMaps, int count, long earliestKey, long latestKey) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(loadedMaps.firstKey());
        long $org_scalatest_assert_macro_right2 = earliestKey;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(loadedMaps.lastKey());
        long $org_scalatest_assert_macro_right3 = latestKey;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }

    public void checkVersion(SortedMap<Object, ConcurrentHashMap<UnsafeRow, UnsafeRow>> loadedMaps, long version, Map<String, Object> expectedData) {
        Map originValueMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)loadedMaps.get(BoxesRunTime.boxToLong((long)version))).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StateStoreTestsHelper$.MODULE$.rowToString((UnsafeRow)entry._1())), (Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt((UnsafeRow)entry._2()))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originValueMap);
        Map<String, Object> $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        return this.newStoreProvider(storeId.operatorId(), storeId.partitionId(), storeId.checkpointRootLocation(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6());
    }

    @Override
    public Set<Tuple2<String, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider) {
        return this.getData(storeProvider, this.getData$default$2());
    }

    @Override
    public Set<Tuple2<String, Object>> getData(HDFSBackedStateStoreProvider provider, int version) {
        HDFSBackedStateStoreProvider reloadedProvider = this.newStoreProvider(provider.stateStoreId());
        return version < 0 ? reloadedProvider.latestIterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet() : reloadedProvider.getStore((long)version).iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet();
    }

    public int getData$default$2() {
        return -1;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, String dir, int minDeltasForSnapshot, int numOfVersToRetainInMemory, Configuration hadoopConf) {
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY(), (Object)BoxesRunTime.boxToInteger((int)numOfVersToRetainInMemory));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, new StateStoreConf(sqlConf), hadoopConf);
        return provider;
    }

    public String newStoreProvider$default$3() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$4() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public int newStoreProvider$default$5() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get());
    }

    public Configuration newStoreProvider$default$6() {
        return new Configuration();
    }

    public boolean fileExists(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        return filePath.exists();
    }

    public void deleteFilesEarlierThanVersion(HDFSBackedStateStoreProvider provider, long version2) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)version2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)isSnapshot -> StateStoreSuite.$anonfun$deleteFilesEarlierThanVersion$2(basePath, version, BoxesRunTime.unboxToBoolean((Object)isSnapshot))));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    private final void PrivateMethod$lzycompute$1() {
        StateStoreSuite stateStoreSuite = this;
        synchronized (stateStoreSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$2, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$2, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$2, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }

    public static final /* synthetic */ boolean $anonfun$new$16(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    public static final /* synthetic */ boolean $anonfun$new$26(Tuple2 x$2) {
        String string = ((StateStoreCustomMetric)x$2._1()).name();
        String string2 = "stateOnCurrentVersionSizeBytes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final long getSizeOfStateForCurrentVersion$1(StateStoreMetrics metrics) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$26(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId$1, StateStoreConf storeConf$2, Configuration hadoopConf$2, IntRef latestStoreVersion$1) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId$1, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
            StateStoreTestsHelper$.MODULE$.put(store, "a", i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(StateStoreSuite $this, StateStoreProviderId storeProviderId$1, StateStoreConf storeConf$2, Configuration hadoopConf$2, HDFSBackedStateStoreProvider provider$5, IntRef latestStoreVersion$1, Span timeoutDuration$1, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable & scala.Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId$1, storeConf$2, hadoopConf$2, latestStoreVersion$1);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq snapshotVersions;
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            IndexedSeq $org_scalatest_assert_macro_left2 = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> $this.fileExists(provider$5, version, true));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        $this.generateStoreVersions$1(storeProviderId$1, storeConf$2, hadoopConf$2, latestStoreVersion$1);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$5, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        coordinatorRef.deactivateInstances(storeProviderId$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        coordinatorRef.reportActiveInstance(storeProviderId$1, "other-host", "other-exec");
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)n.endsWith(".tmp"))) : 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$49(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$49(n))) : 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$52(String x$5) {
        String string = x$5;
        String string2 = "a";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(File checkpointLocation$1, MemoryStream inputData$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg((Column)functions$.MODULE$.count("*"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$55(SparkSession spark) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ String $anonfun$new$59(long x$7) {
        return ((Object)BoxesRunTime.boxToLong((long)x$7)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$64(String name$1, Tuple2 x$8) {
        String string = ((StateStoreCustomMetric)x$8._1()).name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final long getCustomMetric$1(StateStoreMetrics metrics, String name) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$64(name, x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private static final long getLoadedMapSizeMetric$1(StateStoreMetrics metrics) {
        return metrics.memoryUsedBytes();
    }

    private final void assertCacheHitAndMiss$1(StateStoreMetrics metrics, long expectedCacheHitCount, long expectedCacheMissCount) {
        long cacheHitCount = this.getCustomMetric$1(metrics, "loadedMapCacheHitCount");
        long cacheMissCount = this.getCustomMetric$1(metrics, "loadedMapCacheMissCount");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheHitCount));
        long $org_scalatest_assert_macro_right = expectedCacheHitCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheMissCount));
        long $org_scalatest_assert_macro_right2 = expectedCacheMissCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
    }

    public static final /* synthetic */ Object $anonfun$deleteFilesEarlierThanVersion$2(Path basePath$1, int version$2, boolean isSnapshot) {
        String fileName = isSnapshot ? new StringBuilder(9).append(version$2).append(".snapshot").toString() : new StringBuilder(6).append(version$2).append(".delta").toString();
        File filePath = new File(basePath$1.toString(), fileName);
        return filePath.exists() ? BoxesRunTime.boxToBoolean((boolean)filePath.delete()) : BoxedUnit.UNIT;
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.keySchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.valueSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("retaining only two latest versions when MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$11 = Random$.MODULE$.nextInt();
            int x$12 = 0;
            int x$13 = 2;
            String x$14 = this.newStoreProvider$default$3();
            int x$15 = this.newStoreProvider$default$4();
            Configuration x$16 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$11, x$12, x$14, x$15, x$13, x$16);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            SortedMap loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 2, 2L, 1L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 2, 3L, 2L);
            this.checkVersion(loadedMaps, 3L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3))}))));
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("failure after committing with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$17 = Random$.MODULE$.nextInt();
            int x$18 = 0;
            int x$19 = 1;
            String x$20 = this.newStoreProvider$default$3();
            int x$21 = this.newStoreProvider$default$4();
            Configuration x$22 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$17, x$18, x$20, x$21, x$19, x$22);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            SortedMap loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
            this.checkVersion(loadedMaps, 1L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
            currentVersion = 1;
            StateStore store = provider.getStore((long)currentVersion);
            StateStoreTestsHelper$.MODULE$.put(store, "a", -2);
            store.commit();
            ++currentVersion;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)-2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            loadedMaps = provider.getLoadedMaps();
            this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
            this.checkVersion(loadedMaps, 2L, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)-2))}))));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("no cache data with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$23 = Random$.MODULE$.nextInt();
            int x$24 = 0;
            int x$25 = 0;
            String x$26 = this.newStoreProvider$default$3();
            int x$27 = this.newStoreProvider$default$4();
            Configuration x$28 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$23, x$24, x$26, x$27, x$25, x$28);
            int currentVersion = 0;
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            SortedMap loadedMaps = provider.getLoadedMaps();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            loadedMaps = provider.getLoadedMaps();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("snapshotting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            long x$29 = Random$.MODULE$.nextInt();
            int x$30 = 0;
            int x$31 = 5;
            String x$32 = this.newStoreProvider$default$3();
            int x$33 = this.newStoreProvider$default$5();
            Configuration x$34 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$29, x$30, x$32, x$31, x$33, x$34);
            int currentVersion = 0;
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 2);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentVersion).foreach((Function1 & Serializable & scala.Serializable)i -> StateStoreSuite.$anonfun$new$7(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 6);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get())));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 20);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("cleaning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$35 = Random$.MODULE$.nextInt();
            int x$36 = 0;
            int x$37 = 5;
            String x$38 = this.newStoreProvider$default$3();
            int x$39 = this.newStoreProvider$default$5();
            Configuration x$40 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$35, x$36, x$38, x$37, x$39, x$40);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, 20));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, 19));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)19))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.testQuietly("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Iterable tempFiles;
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$41 = Random$.MODULE$.nextInt();
            int x$42 = 0;
            Configuration x$43 = conf;
            String x$44 = this.newStoreProvider$default$3();
            int x$45 = this.newStoreProvider$default$4();
            int x$46 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$41, x$42, x$44, x$45, x$46, x$43);
            provider.getStore(0L).commit();
            provider.getStore(0L).commit();
            Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$16(x$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        });
        this.test("corrupted file handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$47 = Random$.MODULE$.nextInt();
            int x$48 = 0;
            int x$49 = 5;
            String x$50 = this.newStoreProvider$default$3();
            int x$51 = this.newStoreProvider$default$5();
            Configuration x$52 = this.newStoreProvider$default$6();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$47, x$48, x$50, x$49, x$51, x$52);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, snapshotVersion));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            this.corruptFile(provider, snapshotVersion, true);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, snapshotVersion - 1));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            this.corruptFile(provider, snapshotVersion - 1, false);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("reports memory usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = store.metrics().memoryUsedBytes();
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            store.commit();
            long $org_scalatest_assert_macro_left = store.metrics().memoryUsedBytes();
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("reports memory usage on current version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = this.getSizeOfStateForCurrentVersion$1(store.metrics());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            store.commit();
            long $org_scalatest_assert_macro_left = this.getSizeOfStateForCurrentVersion$1(store.metrics());
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("StateStore.get", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, -1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            StateStore store0 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0.version()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            store0.commit();
            StateStore store1 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1.version()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1.iterator()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            StateStore store0reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0reloaded.version()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store0reloaded.iterator()));
            Set $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            StateStore$.MODULE$.unload(storeId);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            StateStore store1reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.version()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            StateStoreTestsHelper$.MODULE$.put(store1reloaded, "a", 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.commit()));
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1reloaded.iterator()));
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("maintenance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test").set(StateStore$.MODULE$.MAINTENANCE_INTERVAL_CONFIG(), "10ms").set("spark.rpc.numRetries", "1");
            int opId = 0;
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId = new StateStoreProviderId(new StateStoreId(dir, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = new SQLConf();
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(storeProviderId.storeId());
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(new SparkContext(conf), (Function1 & Serializable & scala.Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable & scala.Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$35($this, storeProviderId$1, storeConf$2, hadoopConf$2, provider$5, latestStoreVersion$1, timeoutDuration$1, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable & scala.Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
                }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.testQuietly("SPARK-18342: commit fails when rename fails", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String dir = new StringBuilder(3).append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append("://").append(StateStoreTestsHelper$.MODULE$.newDir()).toString();
            Configuration conf = new Configuration();
            conf.set(new StringBuilder(8).append("fs.").append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append(".impl").toString(), RenameReturnsFalseFileSystem.class.getName());
            long x$53 = Random$.MODULE$.nextInt();
            int x$54 = 0;
            String x$55 = dir;
            Configuration x$56 = conf;
            int x$57 = this.newStoreProvider$default$4();
            int x$58 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$53, x$54, x$55, x$57, x$58, x$56);
            StateStore store = provider.getStore(0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0);
            IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> store.commit(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Failed to rename";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        });
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(new StringBuilder(5).append(dir).append("/0/0/").toString());
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$52(x$5)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 2L, storeConf, hadoopConf), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set("spark.sql.shuffle.partitions", "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(checkpointLocation, inputData);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(checkpointLocation, inputData);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable & scala.Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$55(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("error writing [version].delta cancels the output stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
            long x$59 = Random$.MODULE$.nextInt();
            int x$60 = 0;
            String x$61 = remoteDir;
            Configuration x$62 = hadoopConf;
            int x$63 = this.newStoreProvider$default$4();
            int x$64 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$59, x$60, x$61, x$63, x$64, x$62);
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)version -> {
                StateStore store = provider.getStore((long)(version - 1));
                StateStoreTestsHelper$.MODULE$.put(store, ((Object)BoxesRunTime.boxToInteger((int)version)).toString(), version);
                return store.commit();
            });
            Set version10Data = ((TraversableOnce)((TraversableLike)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable & scala.Serializable)x$7 -> StateStoreSuite.$anonfun$new$59(BoxesRunTime.unboxToLong((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
            StateStore store = provider.getStore(10L);
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
            StateStoreTestsHelper$.MODULE$.put(store, "11", 11);
            IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> store.commit())), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
            CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
            StateStore store2 = provider.getStore(10L);
            StateStoreTestsHelper$.MODULE$.put(store2, "11", 11);
            store2.abort();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        this.test("expose metrics with custom metrics to StateStoreMetrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long loadedMapSizeForVersion1And2;
            long loadedMapSizeForVersion1;
            long initialLoadedMapSize;
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            Set<Tuple2<String, Object>> $org_scalatest_assert_macro_left = this.getLatestData(provider);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
            StateStore store = provider.getStore(0L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(store.hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            long $org_scalatest_assert_macro_left3 = initialLoadedMapSize = StateStoreSuite.getLoadedMapSizeMetric$1(store.metrics());
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            this.assertCacheHitAndMiss$1(store.metrics(), 0L, 0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            StateStoreTestsHelper$.MODULE$.put(store, "b", 2);
            StateStoreTestsHelper$.MODULE$.put(store, "aa", 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            StateStoreTestsHelper$.MODULE$.remove(store, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("a")));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.metrics().numKeys()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.commit()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(store.hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            long $org_scalatest_assert_macro_left8 = loadedMapSizeForVersion1 = StateStoreSuite.getLoadedMapSizeMetric$1(store.metrics());
            long $org_scalatest_assert_macro_right7 = initialLoadedMapSize;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            this.assertCacheHitAndMiss$1(store.metrics(), 0L, 0L);
            StateStore storeV2 = provider.getStore(1L);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            StateStoreTestsHelper$.MODULE$.put(storeV2, "cc", 4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.commit()));
            int $org_scalatest_assert_macro_right10 = 2;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            long $org_scalatest_assert_macro_left12 = loadedMapSizeForVersion1And2 = StateStoreSuite.getLoadedMapSizeMetric$1(storeV2.metrics());
            long $org_scalatest_assert_macro_right11 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            this.assertCacheHitAndMiss$1(storeV2.metrics(), 1L, 0L);
            HDFSBackedStateStoreProvider reloadedProvider = this.newStoreProvider(store.id());
            StateStore reloadedStore = reloadedProvider.getStore(1L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStore.metrics().numKeys()));
            int $org_scalatest_assert_macro_right12 = 1;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStore.metrics())));
            long $org_scalatest_assert_macro_right13 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            this.assertCacheHitAndMiss$1(reloadedStore.metrics(), 0L, 1L);
            StateStore reloadedStoreV2 = reloadedProvider.getStore(2L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStoreV2.metrics().numKeys()));
            int $org_scalatest_assert_macro_right14 = 2;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            long $org_scalatest_assert_macro_left16 = StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStoreV2.metrics());
            long $org_scalatest_assert_macro_right15 = loadedMapSizeForVersion1;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left16), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left16 > $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            this.assertCacheHitAndMiss$1(reloadedStoreV2.metrics(), 0L, 2L);
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
    }
}

