/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.LocalSparkSession$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreRDD;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001E\u0011!c\u0015;bi\u0016\u001cFo\u001c:f%\u0012#5+^5uK*\u00111\u0001B\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!C\u0006\u000f\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u001d\u0005I1oY1mCR,7\u000f^\u0005\u00037a\u0011aBQ3g_J,\u0017I\u001c3BMR,'\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u001d)\u0003A1A\u0005\n\u0019\n\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0003\u001d\u0002\"a\u0005\u0015\n\u0005%R!!C*qCJ\\7i\u001c8g\u0011\u0019Y\u0003\u0001)A\u0005O\u0005Q1\u000f]1sW\u000e{gN\u001a\u0011\t\u000f5\u0002!\u0019!C\u0005]\u00059A/Z7q\t&\u0014X#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00027b]\u001eT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\t11\u000b\u001e:j]\u001eDa\u0001\u000f\u0001!\u0002\u0013y\u0013\u0001\u0003;f[B$\u0015N\u001d\u0011\t\u000fi\u0002!\u0019!C\u0005w\u0005I1.Z=TG\",W.Y\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q\bC\u0001\u0006if\u0004Xm]\u0005\u0003\u0003z\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019\u0019\u0005\u0001)A\u0005y\u0005Q1.Z=TG\",W.\u0019\u0011\t\u000f\u0015\u0003!\u0019!C\u0005w\u0005Ya/\u00197vKN\u001b\u0007.Z7b\u0011\u00199\u0005\u0001)A\u0005y\u0005aa/\u00197vKN\u001b\u0007.Z7bA!)\u0011\n\u0001C!\u0015\u0006A\u0011M\u001a;fe\u0006cG\u000eF\u0001L!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0011)f.\u001b;\t\u000bI\u0003A\u0011B*\u0002\u000f5\f7.\u001a*E\tR\u0019A\u000bZ5\u0011\u0007UC&,D\u0001W\u0015\t9&\"A\u0002sI\u0012L!!\u0017,\u0003\u0007I#E\t\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;6k\u0011A\u0018\u0006\u0003?B\ta\u0001\u0010:p_Rt\u0014BA1N\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u0019\u0006\u0003C6CQ!Z)A\u0002\u0019\f!a]2\u0011\u0005M9\u0017B\u00015\u000b\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015Q\u0017\u000b1\u0001l\u0003\r\u0019X-\u001d\t\u0004YFTfBA7p\u001d\tif.C\u0001O\u0013\t\u0001X*A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(aA*fc*\u0011\u0001/\u0014\u0005\u0006k\u0002!IA^\u0001\u0012_B,'/\u0019;peN#\u0018\r^3J]\u001a|G#B<|{\u0006-\u0001C\u0001=z\u001b\u0005!\u0011B\u0001>\u0005\u0005e\u0019F/\u0019;fMVdw\n]3sCR|'o\u0015;bi\u0016LeNZ8\t\u000bq$\b\u0019\u0001.\u0002\tA\fG\u000f\u001b\u0005\b}R\u0004\n\u00111\u0001\u0000\u0003)\tX/\u001a:z%Vt\u0017\n\u001a\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0003V+&#\u0005\"CA\u0007iB\u0005\t\u0019AA\b\u0003\u001d1XM]:j_:\u00042\u0001TA\t\u0013\r\t\u0019\"\u0014\u0002\u0004\u0013:$\b\"CA\f\u0001\t\u0007I\u0011BA\r\u0003%Ign\u0019:f[\u0016tG/\u0006\u0002\u0002\u001cAIA*!\b\u0002\"\u0005\u001d\u0012QF\u0005\u0004\u0003?i%!\u0003$v]\u000e$\u0018n\u001c83!\r\u0019\u00131E\u0005\u0004\u0003K\u0011!AC*uCR,7\u000b^8sKB!A.!\u000b[\u0013\r\tYc\u001d\u0002\t\u0013R,'/\u0019;peB1\u0011qFA\u001b\u0003oi!!!\r\u000b\u0007\u0005MR*\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u00022A1A*!\u000f[\u0003\u001fI1!a\u000fN\u0005\u0019!V\u000f\u001d7fe!A\u0011q\b\u0001!\u0002\u0013\tY\"\u0001\u0006j]\u000e\u0014X-\\3oi\u0002B\u0011\"a\u0011\u0001#\u0003%I!!\u0012\u00027=\u0004XM]1u_J\u001cF/\u0019;f\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t9EK\u0002\u0000\u0003\u0013Z#!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+j\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011LA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003;\u0002\u0011\u0013!C\u0005\u0003?\n1d\u001c9fe\u0006$xN]*uCR,\u0017J\u001c4pI\u0011,g-Y;mi\u0012\u001aTCAA1U\u0011\ty!!\u0013")
public class StateStoreRDDSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final String tempDir;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final Function2<StateStore, Iterator<String>, Iterator<Tuple2<String, Object>>> increment;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private String tempDir() {
        return this.tempDir;
    }

    private StructType keySchema() {
        return this.keySchema;
    }

    private StructType valueSchema() {
        return this.valueSchema;
    }

    public void afterAll() {
        super.afterAll();
        Utils$.MODULE$.deleteRecursively(new File(this.tempDir()));
    }

    private RDD<String> makeRDD(SparkContext sc, Seq<String> seq) {
        return sc.makeRDD(seq, 2, ClassTag$.MODULE$.apply(String.class)).groupBy((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1._2(), ClassTag$.MODULE$.apply(String.class));
    }

    private StatefulOperatorStateInfo operatorStateInfo(String path, UUID queryRunId, int version) {
        return new StatefulOperatorStateInfo(path, queryRunId, 0L, (long)version, 5);
    }

    private UUID operatorStateInfo$default$2() {
        return UUID.randomUUID();
    }

    private int operatorStateInfo$default$3() {
        return 0;
    }

    private Function2<StateStore, Iterator<String>, Iterator<Tuple2<String, Object>>> increment() {
        return this.increment;
    }

    private final RDD makeStoreRDD$1(SparkSession spark, Seq seq, int storeVersion, String path$1) {
        SQLContext sqlContext = spark.sqlContext();
        String x$8 = path$1;
        int x$9 = storeVersion;
        UUID x$10 = this.operatorStateInfo$default$2();
        return package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$8, x$10, x$9), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ void $anonfun$new$5(StateStoreRDDSuite $this, String path$1, SparkSession spark) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Predef$.MODULE$.require($this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.makeStoreRDD$1(spark, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), i - 1, path$1).collect())).toSet()).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)i))})), Equality$.MODULE$.default())));
    }

    private static final Iterator iteratorOfPuts$1(StateStore store, Iterator iter) {
        Iterator resIterator = iter.map((Function1 & Serializable & scala.Serializable)s -> {
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow((String)s);
            int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int newValue = oldValue + 1;
            store.put(key, StateStoreTestsHelper$.MODULE$.intToRow(newValue));
            return new Tuple2(s, (Object)BoxesRunTime.boxToInteger((int)newValue));
        });
        return CompletionIterator$.MODULE$.apply(resIterator, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> store.commit());
    }

    private static final Iterator iteratorOfGets$1(StateStore store, Iterator iter) {
        return iter.map((Function1 & Serializable & scala.Serializable)s -> {
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow((String)s);
            Option value = Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row)));
            return new Tuple2(s, (Object)value);
        });
    }

    public static final /* synthetic */ void $anonfun$increment$2(StateStore store$3, String s) {
        UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow(s);
        int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store$3.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        store$3.put(key, StateStoreTestsHelper$.MODULE$.intToRow(oldValue + 1));
    }

    public StateStoreRDDSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
        this.tempDir = ((Object)Files.createTempDirectory("StateStoreRDDSuite", new FileAttribute[0])).toString();
        this.keySchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.valueSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StateStore$.MODULE$.stop(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("versioning and immutability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            String x$2 = path;
            int x$3 = 0;
            UUID x$4 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$2, x$4, x$3), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            String x$5 = path;
            int x$6 = 1;
            UUID x$7 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$5, x$7, x$6), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("recovering from files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                StateStoreRDDSuite.$anonfun$new$5(this, path, spark);
                return BoxedUnit.UNIT;
            });
            return (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.makeStoreRDD$1((SparkSession)spark, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), 20, path).collect())).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)21))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            });
        }, new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("usage with iterators - only gets and only puts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            boolean opId = false;
            String x$11 = path;
            int x$12 = 0;
            UUID x$13 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$11, x$13, x$12), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            String x$14 = path;
            int x$15 = 0;
            UUID x$16 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfPuts = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$14, x$16, x$15), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfPuts$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfPuts.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            String x$17 = path;
            int x$18 = 1;
            UUID x$19 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$17, x$19, x$18), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets2.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("preferred locations using StateStoreCoordinator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Tuple2[])org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            UUID queryRunId = UUID.randomUUID();
            int opId = 0;
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            return (Tuple2[])LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                SQLContext sqlContext = spark.sqlContext();
                StateStoreCoordinatorRef coordinatorRef = sqlContext.streams().stateStoreCoordinator();
                StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                coordinatorRef.reportActiveInstance(storeProviderId1, "host1", "exec1");
                coordinatorRef.reportActiveInstance(storeProviderId2, "host2", "exec2");
                Predef$.MODULE$.require(this.convertToEqualizer(coordinatorRef.getLocation(storeProviderId1)).$eq$eq$eq((Object)new Some((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString()), Equality$.MODULE$.default()));
                StateStoreRDD rdd = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(path, queryRunId, this.operatorStateInfo$default$3()), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rdd.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[0]));
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new ExecutorCacheTaskLocation("host1", "exec1").toString()}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[1]));
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new ExecutorCacheTaskLocation("host2", "exec2").toString()}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                return (Tuple2[])rdd.collect();
            });
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("distributed test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf().setMaster("local-cluster[2, 1, 1024]")).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            boolean opId = false;
            String x$20 = path;
            int x$21 = 0;
            UUID x$22 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$20, x$22, x$21), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String x$23 = path;
            int x$24 = 1;
            UUID x$25 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$23, x$25, x$24), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        })), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.increment = (Function2 & Serializable & scala.Serializable)(store, iter) -> {
            iter.foreach((Function1 & Serializable & scala.Serializable)s -> {
                StateStoreRDDSuite.$anonfun$increment$2(store, s);
                return BoxedUnit.UNIT;
            });
            store.commit();
            return store.iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row));
        };
    }
}

