/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.ProcessingTime$;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.util.Clock;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Timed;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileLongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001f\tY\u0002K]8dKN\u001c\u0018N\\4US6,W\t_3dkR|'oU;ji\u0016T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0007\u0007\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000e\u0017\u0005)!\u0016.\\3MS6LGo\u001d\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAqA\t\u0001C\u0002\u0013\r1%A\beK\u001a\fW\u000f\u001c;TS\u001et\u0017\r\\3s+\u0005!\u0003CA\u000b&\u0013\t1cC\u0001\u0005TS\u001et\u0017\r\\3s\u0011\u0019A\u0003\u0001)A\u0005I\u0005\u0001B-\u001a4bk2$8+[4oC2,'\u000f\t\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_a\tA\u0001^5nK&\u0011\u0011G\f\u0002\u0005'B\fg\u000e\u0003\u00044\u0001\u0001\u0006I\u0001L\u0001\ti&lWm\\;uA!)Q\u0007\u0001C\u0005m\u0005!B/Z:u\u0005\u0006$8\r\u001b+fe6Lg.\u0019;j_:$\"aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006}Q\u0002\raP\u0001\u000bS:$XM\u001d<bY6\u001b\bC\u0001\u001dA\u0013\t\t\u0015H\u0001\u0003M_:<\u0007\"B\"\u0001\t\u0013!\u0015AC3wK:$X/\u00197msR\u0011q'\u0012\u0005\u0007\r\n#\t\u0019A$\u0002\t\t|G-\u001f\t\u0004q!;\u0014BA%:\u0005!a$-\u001f8b[\u0016t\u0004\"B&\u0001\t\u0013a\u0015!E<bSR4uN\u001d+ie\u0016\fGMS8j]R\u0011q'\u0014\u0005\u0006\u001d*\u0003\raT\u0001\u0007i\"\u0014X-\u00193\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\n1A\u000b\u001b:fC\u0012\u0004")
public class ProcessingTimeExecutorSuite
extends SparkFunSuite
implements TimeLimits {
    private final Signaler defaultSignaler;
    private final Span timeout;

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.failAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T failAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.failAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.cancelAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T cancelAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.cancelAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    public Span timeout() {
        return this.timeout;
    }

    private void testBatchTermination(long intervalMs) {
        IntRef batchCounts = IntRef.create((int)0);
        ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime(intervalMs), ProcessingTimeExecutor$.MODULE$.apply$default$2());
        processingTimeExecutor.execute((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ++batchCounts$1.elem;
            return batchCounts$1.elem < 3;
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounts.elem));
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    private void eventually(Function0<BoxedUnit> body) {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(this.timeout()), body, Eventually$.MODULE$.patienceConfig(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }

    private void waitForThreadJoin(Thread thread) {
        this.failAfter(this.timeout(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> thread.join(), this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160), (Timed)Timed$.MODULE$.timed());
    }

    public ProcessingTimeExecutorSuite() {
        TimeLimits.$init$((TimeLimits)this);
        this.defaultSignaler = ThreadSignaler$.MODULE$;
        this.timeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds();
        this.test("nextBatchTime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime(100L), ProcessingTimeExecutor$.MODULE$.apply$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(0L)));
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(1L)));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(99L)));
            int $org_scalatest_assert_macro_right3 = 100;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(100L)));
            int $org_scalatest_assert_macro_right4 = 200;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(101L)));
            int $org_scalatest_assert_macro_right5 = 200;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(150L)));
            int $org_scalatest_assert_macro_right6 = 200;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("trigger timing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ConcurrentHashSet triggerTimes = new ConcurrentHashSet();
            StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
            VolatileBooleanRef continueExecuting = VolatileBooleanRef.create((boolean)true);
            VolatileLongRef clockIncrementInTrigger = VolatileLongRef.create((long)0L);
            ProcessingTimeExecutor executor = new ProcessingTimeExecutor(ProcessingTime$.MODULE$.apply("1000 milliseconds"), (Clock)clock);
            Thread executorThread = new Thread(null, triggerTimes, clock, continueExecuting, clockIncrementInTrigger, executor){
                private final ConcurrentHashSet triggerTimes$1;
                private final StreamManualClock clock$1;
                private final VolatileBooleanRef continueExecuting$1;
                private final VolatileLongRef clockIncrementInTrigger$1;
                private final ProcessingTimeExecutor executor$1;

                public void run() {
                    this.executor$1.execute((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        $this.triggerTimes$1.add((Object)BoxesRunTime.boxToInteger((int)((int)$this.clock$1.getTimeMillis())));
                        $this.clock$1.advance($this.clockIncrementInTrigger$1.elem);
                        $this.clockIncrementInTrigger$1.elem = 0L;
                        return $this.continueExecuting$1.elem;
                    });
                }
                {
                    this.triggerTimes$1 = triggerTimes$1;
                    this.clock$1 = clock$1;
                    this.continueExecuting$1 = continueExecuting$1;
                    this.clockIncrementInTrigger$1 = clockIncrementInTrigger$1;
                    this.executor$1 = executor$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$$anon$2 )}, serializedLambda);
                }
            };
            executorThread.start();
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ConcurrentHashSet $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(1000L), "clock.isStreamWaitingFor(1000L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            });
            clockIncrementInTrigger.elem = 500L;
            clock.setTime(1000L);
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ConcurrentHashSet $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(1500L), "clock.isStreamWaitingAt(1500L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(2000L), "clock.isStreamWaitingFor(2000L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            });
            clockIncrementInTrigger.elem = 1500L;
            clock.setTime(2000L);
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                ConcurrentHashSet $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 2000;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    ConcurrentHashSet $org_scalatest_assert_macro_left3 = triggerTimes;
                    int $org_scalatest_assert_macro_right2 = 3500;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(3500L), "clock.isStreamWaitingAt(3500L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(4000L), "clock.isStreamWaitingFor(4000L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            });
            continueExecuting.elem = false;
            clock.advance(1000L);
            this.waitForThreadJoin(executorThread);
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("calling nextBatchTime with the result of a previous call should return the next interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int intervalMS = 100;
            ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTime((long)intervalMS), ProcessingTimeExecutor$.MODULE$.apply$default$2());
            int ITERATION = 10;
            LongRef nextBatchTime = LongRef.create((long)0L);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), ITERATION).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)it -> {
                nextBatchTime$1.elem = processingTimeExecutor.nextBatchTime(nextBatchTime$1.elem);
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nextBatchTime.elem));
            int $org_scalatest_assert_macro_right = intervalMS * ITERATION;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("batch termination", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testBatchTermination(0L);
            this.testBatchTermination(10L);
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("notifyBatchFallingBehind", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
            VolatileBooleanRef batchFallingBehindCalled = VolatileBooleanRef.create((boolean)false);
            Thread t = new Thread(null, clock, batchFallingBehindCalled){
                public final StreamManualClock clock$2;
                public final VolatileBooleanRef batchFallingBehindCalled$1;

                public void run() {
                    ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(this){
                        private final /* synthetic */ $anon$3 $outer;

                        public void notifyBatchFallingBehind(long realElapsedTimeMs) {
                            this.$outer.batchFallingBehindCalled$1.elem = true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            super(new ProcessingTime(100L), (Clock)$outer.clock$2);
                        }
                    };
                    processingTimeExecutor.execute((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        $this.clock$2.waitTillTime(200L);
                        return false;
                    });
                }
                {
                    this.clock$2 = clock$2;
                    this.batchFallingBehindCalled$1 = batchFallingBehindCalled$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$$anon$3 )}, serializedLambda);
                }
            };
            t.start();
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(200L), "clock.isStreamWaitingFor(200L)", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            });
            clock.advance(200L);
            this.waitForThreadJoin(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)batchFallingBehindCalled.elem));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }
}

