/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0001\u0003\u0003\u0003\t\"!\u0005)beF,X\r^*dQ\u0016l\u0017\rV3ti*\u00111\u0001B\u0001\ba\u0006\u0014\u0018/^3u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%YQ\u0002CA\n\u0015\u001b\u0005Q\u0011BA\u000b\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\f!\u0006\u0014\u0018/^3u)\u0016\u001cH\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005!A/Z:u\u0013\tyBD\u0001\tTQ\u0006\u0014X\rZ*R\u0019\u000e{g\u000e^3yi\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\u0012a\t\t\u0003/\u0001AQ!\n\u0001\u0005\u0012\u0019\n1\u0003^3tiN\u001b\u0007.Z7b\u0013:4WM]3oG\u0016,\"aJ\u001d\u0015\r!jv-\u001b8q)\rIsF\u0011\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000fC\u00041I\u0005\u0005\t9A\u0019\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u00023k]j\u0011a\r\u0006\u0003i-\nqA]3gY\u0016\u001cG/\u0003\u00027g\tA1\t\\1tgR\u000bw\r\u0005\u00029s1\u0001A!\u0002\u001e%\u0005\u0004Y$!\u0001+\u0012\u0005qz\u0004C\u0001\u0016>\u0013\tq4FA\u0004O_RD\u0017N\\4\u0011\u0005)\u0002\u0015BA!,\u0005\u001d\u0001&o\u001c3vGRDqa\u0011\u0013\u0002\u0002\u0003\u000fA)\u0001\u0006fm&$WM\\2fII\u00022!R,8\u001d\t1EK\u0004\u0002H#:\u0011\u0001j\u0014\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\t\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001\u001b,\u0013\t\u00016'A\u0004sk:$\u0018.\\3\n\u0005I\u001b\u0016a\u00029bG.\fw-\u001a\u0006\u0003!NJ!!\u0016,\u0002\u0011Ut\u0017N^3sg\u0016T!AU*\n\u0005aK&a\u0002+za\u0016$\u0016mZ\u0005\u00035n\u0013\u0001\u0002V=qKR\u000bwm\u001d\u0006\u00039N\n1!\u00199j\u0011\u0015qF\u00051\u0001`\u0003!!Xm\u001d;OC6,\u0007C\u00011e\u001d\t\t'\r\u0005\u0002KW%\u00111mK\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002dW!)\u0001\u000e\na\u0001?\u0006YQ.Z:tC\u001e,G+\u001f9f\u0011\u0015QG\u00051\u0001l\u00039\u0011\u0017N\\1ss\u0006\u001b8\u000b\u001e:j]\u001e\u0004\"A\u000b7\n\u00055\\#a\u0002\"p_2,\u0017M\u001c\u0005\u0006_\u0012\u0002\ra[\u0001\u0011S:$\u0018HN!t)&lWm\u001d;b[BDQ!\u001d\u0013A\u0002-\f\u0001d\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1u\u0011\u0015\u0019\b\u0001\"\u0005u\u0003U!Xm\u001d;QCJ\fX/\u001a;U_\u000e\u000bG/\u00197zgR$\u0002\"K;w}\u0006\u0005\u00111\u0001\u0005\u0006=J\u0004\ra\u0018\u0005\u0006oJ\u0004\r\u0001_\u0001\ngFd7k\u00195f[\u0006\u0004\"!\u001f?\u000e\u0003iT!a\u001f\u0005\u0002\u000bQL\b/Z:\n\u0005uT(AC*ueV\u001cG\u000fV=qK\")qP\u001da\u0001?\u0006i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006DQA\u001b:A\u0002-DQa\u001c:A\u0002-Dq!a\u0002\u0001\t#\tI!A\u000buKN$8)\u0019;bYf\u001cH\u000fV8QCJ\fX/\u001a;\u0015\u0017%\nY!!\u0004\u0002\u0010\u0005E\u00111\u0003\u0005\u0007=\u0006\u0015\u0001\u0019A0\t\r]\f)\u00011\u0001y\u0011\u0019y\u0018Q\u0001a\u0001?\"1\u0011/!\u0002A\u0002-D!\"!\u0006\u0002\u0006A\u0005\t\u0019AA\f\u0003MyW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f!\u0011\tI\"!\f\u000f\t\u0005m\u0011q\u0005\b\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005\u0005\u0002\u0011%tG/\u001a:oC2LA!!\n\u0002 \u000591+\u0015'D_:4\u0017\u0002BA\u0015\u0003W\t!\u0004U1scV,GoT;uaV$H+[7fgR\fW\u000e\u001d+za\u0016TA!!\n\u0002 %!\u0011qFA\u0019\u0005\u00151\u0016\r\\;f\u0013\r\t\u0019d\u000b\u0002\f\u000b:,X.\u001a:bi&|g\u000eC\u0004\u00028\u0001!\t\"!\u000f\u0002\u0015Q,7\u000f^*dQ\u0016l\u0017\rF\b*\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0011\u0019q\u0016Q\u0007a\u0001?\"1q/!\u000eA\u0002aDaa`A\u001b\u0001\u0004y\u0006B\u00026\u00026\u0001\u00071\u000e\u0003\u0004p\u0003k\u0001\ra\u001b\u0005\u0007c\u0006U\u0002\u0019A6\t\u0015\u0005U\u0011Q\u0007I\u0001\u0002\u0004\t9\u0002C\u0005\u0002L\u0001\t\n\u0011\"\u0005\u0002N\u0005!B/Z:u'\u000eDW-\\1%I\u00164\u0017-\u001e7uI]*\"!a\u0014+\t\u0005]\u0011\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011QL\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\r\u0001\u0012\u0002\u0013E\u0011QJ\u0001 i\u0016\u001cHoQ1uC2L8\u000f\u001e+p!\u0006\u0014\u0018/^3uI\u0011,g-Y;mi\u0012*\u0004")
public abstract class ParquetSchemaTest
extends SparkFunSuite
implements ParquetTest,
SharedSQLContext {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$(this, path, testVectorized, f);
    }

    @Override
    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$(this, data, f, evidence$1, evidence$2);
    }

    @Override
    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$(this, data, testVectorized, f, evidence$3, evidence$4);
    }

    @Override
    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$(this, data, tableName, testVectorized, f, evidence$5, evidence$6);
    }

    @Override
    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, path, evidence$7, evidence$8);
    }

    @Override
    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, path, evidence$9, evidence$10);
    }

    @Override
    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$(this, basePath, defaultPartitionName, partitionCols);
    }

    @Override
    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$(this, schema, path, configuration);
    }

    @Override
    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$(this, parquetSchema, path, configuration, extraMetadata);
    }

    @Override
    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$(this, path, configuration);
    }

    @Override
    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$(this, path, configuration);
    }

    @Override
    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$(this, testName, f);
    }

    @Override
    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$(this, name);
    }

    @Override
    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$(this);
    }

    @Override
    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$(this);
    }

    @Override
    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$(this);
    }

    @Override
    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$(this, f);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$(this, f);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$(this, numPaths, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public <T extends Product> void testSchemaInference(String testName, String messageType, boolean binaryAsString, boolean int96AsTimestamp, boolean writeLegacyParquetFormat, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        this.testSchema(testName, StructType$.MODULE$.fromAttributes(ScalaReflection$.MODULE$.attributesFor(evidence$2)), messageType, binaryAsString, int96AsTimestamp, writeLegacyParquetFormat, this.testSchema$default$7());
    }

    public void testParquetToCatalyst(String testName, StructType sqlSchema, String parquetSchema, boolean binaryAsString, boolean int96AsTimestamp) {
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(binaryAsString, int96AsTimestamp);
        this.test(new StringBuilder(16).append("sql <= parquet: ").append(testName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType actual = converter.convert(MessageTypeParser.parseMessageType((String)parquetSchema));
            StructType expected = sqlSchema;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
            StructType $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("Schema mismatch.\n           |Expected schema: ").append(expected.json()).append("\n           |Actual schema:   ").append(actual.json()).append("\n         ").toString())).stripMargin(), Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }

    public void testCatalystToParquet(String testName, StructType sqlSchema, String parquetSchema, boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        SparkToParquetSchemaConverter converter = new SparkToParquetSchemaConverter(writeLegacyParquetFormat, outputTimestampType);
        this.test(new StringBuilder(16).append("sql => parquet: ").append(testName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MessageType actual = converter.convert(sqlSchema);
            MessageType expected = MessageTypeParser.parseMessageType((String)parquetSchema);
            actual.checkContains((Type)expected);
            expected.checkContains((Type)actual);
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public Enumeration.Value testCatalystToParquet$default$5() {
        return SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
    }

    public void testSchema(String testName, StructType sqlSchema, String parquetSchema, boolean binaryAsString, boolean int96AsTimestamp, boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        this.testCatalystToParquet(testName, sqlSchema, parquetSchema, writeLegacyParquetFormat, outputTimestampType);
        this.testParquetToCatalyst(testName, sqlSchema, parquetSchema, binaryAsString, int96AsTimestamp);
    }

    public Enumeration.Value testSchema$default$7() {
        return SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
    }

    private final void testImplicits$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public ParquetSchemaTest() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        ParquetTest.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
    }
}

