/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaSuite$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaTest;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.SymbolLiteral;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001#\t\u0011\u0002+\u0019:rk\u0016$8k\u00195f[\u0006\u001cV/\u001b;f\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\tQCJ\fX/\u001a;TG\",W.\u0019+fgRDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0003a\u0012A\u0005;fgR\u001c6\r[3nC6K7/\\1uG\"$2!H\u00111!\tqr$D\u0001\u000b\u0013\t\u0001#B\u0001\bTa\u0006\u00148.\u0012=dKB$\u0018n\u001c8\t\u000b\tR\u0002\u0019A\u0012\u0002\tA\fG\u000f\u001b\t\u0003I5r!!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u0002\u0012A\u0002\u001fs_>$hHC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017*\u0011\u0015\t$\u00041\u00013\u0003]1Xm\u0019;pe&TX\r\u001a*fC\u0012,'/\u00128bE2,G\r\u0005\u00024i5\t\u0011&\u0003\u00026S\t9!i\\8mK\u0006t\u0007\"B\u001c\u0001\t\u0013A\u0014A\u0005;fgR\u001c6\r[3nC\u000ec\u0017\u000e\u001d9j]\u001e$b!\u000f\u001f?\u0001\"S\u0005CA\u001a;\u0013\tY\u0014F\u0001\u0003V]&$\b\"B\u001f7\u0001\u0004\u0019\u0013\u0001\u0003;fgRt\u0015-\\3\t\u000b}2\u0004\u0019A\u0012\u0002\u001bA\f'/];fiN\u001b\u0007.Z7b\u0011\u0015\te\u00071\u0001C\u00039\u0019\u0017\r^1msN$8k\u00195f[\u0006\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0005\u0002\u000bQL\b/Z:\n\u0005\u001d#%AC*ueV\u001cG\u000fV=qK\")\u0011J\u000ea\u0001G\u0005qQ\r\u001f9fGR,GmU2iK6\f\u0007bB&7!\u0003\u0005\rAM\u0001\u000eG\u0006\u001cXmU3og&$\u0018N^3\t\u000b]\u0002A\u0011B'\u0015\reru\nU)Z\u0011\u0015iD\n1\u0001$\u0011\u0015yD\n1\u0001$\u0011\u0015\tE\n1\u0001C\u0011\u0015IE\n1\u0001S!\t\u0019v+D\u0001U\u0015\t)f+\u0001\u0004tG\",W.\u0019\u0006\u0003\u00071I!\u0001\u0017+\u0003\u00175+7o]1hKRK\b/\u001a\u0005\u0006\u00172\u0003\rA\r\u0005\b7\u0002\t\n\u0011\"\u0003]\u0003q!Xm\u001d;TG\",W.Y\"mSB\u0004\u0018N\\4%I\u00164\u0017-\u001e7uIU*\u0012!\u0018\u0016\u0003ey[\u0013a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0011L\u0013AC1o]>$\u0018\r^5p]&\u0011a-\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ParquetSchemaSuite
extends ParquetSchemaTest {
    public SparkException testSchemaMismatch(String path, boolean vectorizedReaderEnabled) {
        ObjectRef e = ObjectRef.create(null);
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)vectorizedReaderEnabled)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator19$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator19$1(ParquetSchemaSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"bcd", (Object)BoxesRunTime.boxToInteger((int)2))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator19$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).coalesce(1).write().mode("overwrite").parquet(new StringBuilder(8).append(path).append("/parquet").toString());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator27$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator27$1(ParquetSchemaSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"abc")})), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator27$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).coalesce(1).write().mode("append").parquet(new StringBuilder(8).append(path).append("/parquet").toString());
            e$1.elem = (SparkException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().parquet(new StringBuilder(8).append(path).append("/parquet").toString()).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400))));
        });
        return (SparkException)((Object)e.elem);
    }

    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, String expectedSchema, boolean caseSensitive) {
        this.testSchemaClipping(testName, parquetSchema, catalystSchema, MessageTypeParser.parseMessageType((String)expectedSchema), caseSensitive);
    }

    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, MessageType expectedSchema, boolean caseSensitive) {
        this.test(new StringBuilder(11).append("Clipping - ").append(testName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            MessageType actual = ParquetReadSupport$.MODULE$.clipParquetSchema(MessageTypeParser.parseMessageType((String)parquetSchema), catalystSchema, caseSensitive);
            try {
                expectedSchema.checkContains((Type)actual);
                actual.checkContains((Type)expectedSchema);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable cause) {
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("Expected clipped schema:\n             |").append(expectedSchema).append("\n             |Actual clipped schema:\n             |").append(actual).append("\n           ").toString())).stripMargin(), cause, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
            }
            return boxedUnit;
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029));
    }

    private boolean testSchemaClipping$default$5() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$4(ParquetSchemaSuite $this, File dir) {
        String message;
        String path = dir.getCanonicalPath();
        $this.spark().range(3L).write().parquet(new StringBuilder(4).append(path).append("/p=1").toString());
        $this.spark().range(3L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).cast((DataType)IntegerType$.MODULE$).as((Symbol)SymbolLiteral.bootstrap("apply", "id"))})).write().parquet(new StringBuilder(4).append(path).append("/p=2").toString());
        String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().option("mergeSchema", "true").parquet(path).schema(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380))).getMessage();
        String $org_scalatest_assert_macro_right = "Failed merging schema";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
    }

    public static final /* synthetic */ void $anonfun$new$7(ParquetSchemaSuite $this, File dir) {
        SparkException e = $this.testSchemaMismatch(dir.getCanonicalPath(), false);
        String expectedMessage = "Encounter error while reading parquet files. One possible cause: Parquet column cannot be converted in the corresponding files. Details:";
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.QueryExecutionException", $org_scalatest_assert_macro_left instanceof QueryExecutionException, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        Throwable $org_scalatest_assert_macro_left2 = e.getCause().getCause();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.parquet.io.ParquetDecodingException", $org_scalatest_assert_macro_left2 instanceof ParquetDecodingException, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        String $org_scalatest_assert_macro_left3 = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = expectedMessage;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
    }

    public static final /* synthetic */ boolean $anonfun$new$10(StructField x$1) {
        String string = x$1.name();
        String string2 = "a";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$9(ParquetSchemaSuite $this, File dir) {
        StructField[] col;
        String errMsg;
        SparkException e = $this.testSchemaMismatch(dir.getCanonicalPath(), true);
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.QueryExecutionException", $org_scalatest_assert_macro_left instanceof QueryExecutionException, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        Throwable $org_scalatest_assert_macro_left2 = e.getCause().getCause();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException", $org_scalatest_assert_macro_left2 instanceof SchemaColumnConvertNotSupportedException, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        String $org_scalatest_assert_macro_left3 = errMsg = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Parquet column cannot be converted in file";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        String file = errMsg.substring("Parquet column cannot be converted in file ".length(), errMsg.indexOf(". "));
        StructField[] $org_scalatest_assert_macro_left4 = col = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().parquet(file).schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaSuite.$anonfun$new$10(x$1)));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        DataType dataType = col[0].dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            String $org_scalatest_assert_macro_left5 = errMsg;
            String $org_scalatest_assert_macro_right3 = "Column: [a], Expected: int, Found: BINARY";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        } else {
            String $org_scalatest_assert_macro_left6 = errMsg;
            String $org_scalatest_assert_macro_right4 = "Column: [a], Expected: string, Found: INT32";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "endsWith", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.endsWith($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }
    }

    public ParquetSchemaSuite() {
        this.test("DataType string parser compatibility", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String caseClassString = "StructType(List(StructField(c1,IntegerType,false), StructField(c2,BinaryType,true)))";
            String jsonString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"c1\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"c2\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}}]}";
            StructType fromCaseClassString = StructType$.MODULE$.fromString(caseClassString);
            StructType fromJson = StructType$.MODULE$.fromString(jsonString);
            Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)fromCaseClassString, (Object)fromJson)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(a, b) -> {
                String $org_scalatest_assert_macro_left = a.name();
                String $org_scalatest_assert_macro_right = b.name();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(a.dataType());
                DataType $org_scalatest_assert_macro_right2 = b.dataType();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)a.nullable()));
                boolean $org_scalatest_assert_macro_right3 = b.nullable();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            });
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        this.test("schema merging failure error message", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$4(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("schema mismatch failure error message for parquet reader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$7(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        this.test("schema mismatch failure error message for parquet vectorized reader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$9(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      optional int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 3", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 element;\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 4", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required binary str (UTF8);\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 5 - parquet-avro style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group array {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 6 - parquet-thrift style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group f1_tuple {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 7 - parquet-protobuf primitive lists", new StructType().add("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  repeated int32 f1;\n      |}\n    ")).stripMargin(), true, true);
        StructType elementType = new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false);
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 8 - parquet-protobuf non-primitive lists", new StructType().add("f1", (DataType)new ArrayType((DataType)elementType, false), false), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  repeated group f1 {\n      |    optional binary c1 (UTF8);\n      |    required int32 c2;\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testCatalystToParquet("Backwards-compatibility: LIST with nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), false, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: LIST with nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group bag {\n      |      optional int32 array;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: LIST with non-nullable element type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), false, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: LIST with non-nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 array;\n      |  }\n      |}\n    ")).stripMargin(), true, this.testCatalystToParquet$default$5());
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group map {\n      |      required int32 num;\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 3 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 2", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group map {\n      |      required int32 num;\n      |      optional binary str (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 3 - parquet-avro style", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, true);
        this.testCatalystToParquet("Backwards-compatibility: MAP with non-nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), false, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: MAP with non-nullable value type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: MAP with nullable value type - 1 - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), false, this.testCatalystToParquet$default$5());
        this.testCatalystToParquet("Backwards-compatibility: MAP with nullable value type - 3 - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group map (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")).stripMargin(), true, this.testCatalystToParquet$default$5());
        this.testSchema("DECIMAL(1, 0) - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(1, 0));\n      |}\n    ")).stripMargin(), true, true, false, this.testSchema$default$7());
        this.testSchema("DECIMAL(8, 3) - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(8, 3));\n      |}\n    ")).stripMargin(), true, true, false, this.testSchema$default$7());
        this.testSchema("DECIMAL(9, 3) - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(9, 3));\n      |}\n    ")).stripMargin(), true, true, false, this.testSchema$default$7());
        this.testSchema("DECIMAL(18, 3) - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional int64 f1 (DECIMAL(18, 3));\n      |}\n    ")).stripMargin(), true, true, false, this.testSchema$default$7());
        this.testSchema("DECIMAL(19, 3) - standard", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(19, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(9) f1 (DECIMAL(19, 3));\n      |}\n    ")).stripMargin(), true, true, false, this.testSchema$default$7());
        this.testSchema("DECIMAL(1, 0) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(1) f1 (DECIMAL(1, 0));\n      |}\n    ")).stripMargin(), true, true, true, this.testSchema$default$7());
        this.testSchema("DECIMAL(8, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(4) f1 (DECIMAL(8, 3));\n      |}\n    ")).stripMargin(), true, true, true, this.testSchema$default$7());
        this.testSchema("DECIMAL(9, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(5) f1 (DECIMAL(9, 3));\n      |}\n    ")).stripMargin(), true, true, true, this.testSchema$default$7());
        this.testSchema("DECIMAL(18, 3) - prior to 1.4.x", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(8) f1 (DECIMAL(18, 3));\n      |}\n    ")).stripMargin(), true, true, true, this.testSchema$default$7());
        this.testSchema("Timestamp written and read as INT64 with TIMESTAMP_MILLIS", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional INT64 f1 (TIMESTAMP_MILLIS);\n      |}\n    ")).stripMargin(), true, false, true, SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS());
        this.testSchema("Timestamp written and read as INT64 with TIMESTAMP_MICROS", StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("f1", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), new StringOps(Predef$.MODULE$.augmentString("message root {\n      |  optional INT64 f1 (TIMESTAMP_MICROS);\n      |}\n    ")).stripMargin(), true, false, true, SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS());
        StructType f0Type = new StructType().add("f00", (DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("simple nested struct", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |    optional int32 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type, false).add("f1", (DataType)IntegerType$.MODULE$, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |  }\n        |  optional int32 f1;\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        ArrayType f00Type = new ArrayType((DataType)StringType$.MODULE$, false);
        ArrayType f01Type = new ArrayType((DataType)new StructType().add("f011", (DataType)DoubleType$.MODULE$, true), false);
        StructType f0Type2 = new StructType().add("f00", (DataType)f00Type, false).add("f01", (DataType)f01Type, false);
        ArrayType f1Type = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("parquet-protobuf style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional int32 f010;\n        |      optional double f011;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type2, false).add("f1", (DataType)f1Type, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional double f011;\n        |    }\n        |  }\n        |\n        |  optional group f1 (LIST) {\n        |    repeated group list {\n        |      optional int32 element;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType f01ElementType = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type3 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType, false), true);
        this.testSchemaClipping("parquet-thrift style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type3, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType f01ElementType2 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type4 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType2, false), true);
        this.testSchemaClipping("parquet-avro style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type4, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType f01ElementType3 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type5 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType3, true), true);
        this.testSchemaClipping("parquet-hive style array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type5, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType f00ElementType = new StructType().add("f001", (DataType)LongType$.MODULE$, true).add("f002", (DataType)DoubleType$.MODULE$, false);
        ArrayType f00Type2 = new ArrayType((DataType)f00ElementType, false);
        StructType f0Type6 = new StructType().add("f00", (DataType)f00Type2, false);
        this.testSchemaClipping("2-level list of required struct", new StringOps(Predef$.MODULE$.augmentString("message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        required int32 f000;\n         |        optional int64 f001;\n         |      }\n         |    }\n         |  }\n         |}\n       ")).stripMargin(), new StructType().add("f0", (DataType)f0Type6, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        optional int64 f001;\n         |        required double f002;\n         |      }\n         |    }\n         |  }\n         |}\n       ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType f01ElementType4 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type7 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType4, false), true);
        this.testSchemaClipping("standard array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type7, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        this.testSchemaClipping("empty requested schema", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType(), ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE(), true);
        this.testSchemaClipping("disjoint field sets", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)new StructType().add("f02", (DataType)FloatType$.MODULE$, true).add("f03", (DataType)DoubleType$.MODULE$, true), true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional float f02;\n        |    optional double f03;\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType valueType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type8 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType, false);
        this.testSchemaClipping("parquet-avro style map", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group map (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type8, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group map (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType valueType2 = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type9 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType2, false);
        this.testSchemaClipping("standard map", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type9, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType keyType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type10 = new MapType((DataType)keyType, (DataType)IntegerType$.MODULE$, false);
        this.testSchemaClipping("standard map with complex key", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("f0", (DataType)f0Type10, false), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5());
        StructType nestedType = new StructType().add("b", (DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("case-insensitive resolution: no ambiguity", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group A {\n        |    optional int32 B;\n        |  }\n        |  optional int32 c;\n        |}\n      ")).stripMargin(), new StructType().add("a", (DataType)nestedType, true).add("c", (DataType)IntegerType$.MODULE$, true), new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group A {\n        |    optional int32 B;\n        |  }\n        |  optional int32 c;\n        |}\n      ")).stripMargin(), false);
        this.test("Clipping - case-insensitive resolution: more than one field is matched", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String parquetSchema = new StringOps(Predef$.MODULE$.augmentString("message root {\n          |  required group A {\n          |    optional int32 B;\n          |  }\n          |  optional int32 c;\n          |  optional int32 a;\n          |}\n        ")).stripMargin();
            StructType nestedType = new StructType().add("b", (DataType)IntegerType$.MODULE$, true);
            StructType catalystSchema = new StructType().add("a", (DataType)nestedType, true).add("c", (DataType)IntegerType$.MODULE$, true);
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> ParquetReadSupport$.MODULE$.clipParquetSchema(MessageTypeParser.parseMessageType((String)parquetSchema), catalystSchema, false), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1593));
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1577));
    }
}

