/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.datasources.orc.OrcData;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0002\u0002E\u0011\u0001b\u0014:d'VLG/\u001a\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u000f=\u00138\rV3tiB\u0011qCG\u0007\u00021)\u0011\u0011DD\u0001\ng\u000e\fG.\u0019;fgRL!a\u0007\r\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000eC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\bC\u0001\u0001\r\u0011\"\u0001#\u0003-y'o\u0019+bE2,G)\u001b:\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0005%|'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012AAR5mK\"9A\u0006\u0001a\u0001\n\u0003i\u0013aD8sGR\u000b'\r\\3ESJ|F%Z9\u0015\u00059\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$\u0001B+oSRDq!N\u0016\u0002\u0002\u0003\u00071%A\u0002yIEBaa\u000e\u0001!B\u0013\u0019\u0013\u0001D8sGR\u000b'\r\\3ESJ\u0004\u0003bB\u001d\u0001\u0001\u0004%\tAI\u0001\u000e_J\u001cG+\u00192mK\u0006\u001bH)\u001b:\t\u000fm\u0002\u0001\u0019!C\u0001y\u0005\trN]2UC\ndW-Q:ESJ|F%Z9\u0015\u00059j\u0004bB\u001b;\u0003\u0003\u0005\ra\t\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u0012\u0002\u001d=\u00148\rV1cY\u0016\f5\u000fR5sA!)\u0011\t\u0001C)\u0005\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002]!)A\t\u0001C\t\u000b\u00069B/Z:u\u00052|w.\u001c$jYR,'o\u0011:fCRLwN\u001c\u000b\u0003]\u0019CQaR\"A\u0002!\u000bqB\u00197p_64\u0015\u000e\u001c;fe.Kg\u000e\u001a\t\u0003\u0013js!AS,\u000f\u0005-#fB\u0001'T\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0001\u0007\n\u0005U3\u0016\u0001C(sGB\u0013x\u000e^8\u000b\u0005\ra\u0011B\u0001-Z\u0003\u0019\u0019FO]3b[*\u0011QKV\u0005\u00037r\u0013AaS5oI*\u0011\u0001,\u0017")
public abstract class OrcSuite
extends OrcTest {
    private File orcTableDir = null;
    private File orcTableAsDir = null;

    public File orcTableDir() {
        return this.orcTableDir;
    }

    public void orcTableDir_$eq(File x$1) {
        this.orcTableDir = x$1;
    }

    public File orcTableAsDir() {
        return this.orcTableAsDir;
    }

    public void orcTableAsDir_$eq(File x$1) {
        this.orcTableAsDir = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        String x$3 = "orctests";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableAsDir_$eq(Utils$.MODULE$.createTempDir(x$4, x$3));
        String x$5 = "orctests";
        String x$6 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableDir_$eq(Utils$.MODULE$.createTempDir(x$6, x$5));
        SparkContext qual$1 = this.sparkContext();
        Range.Inclusive x$7 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int x$8 = qual$1.makeRDD$default$2();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.OrcData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(OrcSuite $outer) {
            }
        }
        this.testImplicits().rddToDatasetHolder(qual$1.makeRDD((Seq)x$7, x$8, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> OrcSuite.$anonfun$beforeAll$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(OrcData.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(null)))).toDF().createOrReplaceTempView("orc_temp_table");
    }

    public void testBloomFilterCreation(OrcProto.Stream.Kind bloomFilterKind) {
        String tableName = "bloomFilter";
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String string;
                String string2 = $this.orcImp();
                if ("native".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("\n               |CREATE TABLE ").append(tableName$1).append(" (a INT, b STRING)\n               |USING ORC\n               |OPTIONS (\n               |  path '").append(dir.toURI()).append("',\n               |  orc.bloom.filter.columns '*',\n               |  orc.bloom.filter.fpp 0.1\n               |)\n            ").toString())).stripMargin();
                } else if ("hive".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(260).append("\n               |CREATE TABLE ").append(tableName$1).append(" (a INT, b STRING)\n               |STORED AS ORC\n               |LOCATION '").append(dir.toURI()).append("'\n               |TBLPROPERTIES (\n               |  orc.bloom.filter.columns='*',\n               |  orc.bloom.filter.fpp=0.1\n               |)\n            ").toString())).stripMargin();
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(28).append("Unknown ORC implementation: ").append(string2).toString());
                }
                String sqlStatement = string;
                $this.sql().apply((Object)sqlStatement);
                $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO ").append(tableName$1).append(" VALUES (1, 'str')").toString());
                File[] partFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$3(f)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                Path orcFilePath = new Path(((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFiles)).head()).getAbsolutePath());
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
                Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions);
                try (RecordReaderImpl recordReader = null;){
                    recordReader = (RecordReaderImpl)reader.rows();
                    boolean[] sargColumns = new boolean[]{true, true, true};
                    OrcIndex orcIndex = recordReader.readRowIndex(0, null, sargColumns);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterKinds())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$4($this, bloomFilterKind$1, x$1))), "scala.Predef.refArrayOps[org.apache.orc.OrcProto.Stream.Kind](orcIndex.getBloomFilterKinds()).forall(((x$1: org.apache.orc.OrcProto.Stream.Kind) => OrcSuite.this.convertToEqualizer[org.apache.orc.OrcProto.Stream.Kind](x$1).===(bloomFilterKind)(scalactic.this.Equality.default[org.apache.orc.OrcProto.Stream.Kind])))", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterIndex())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$5(x$2))), "scala.Predef.refArrayOps[org.apache.orc.OrcProto.BloomFilterIndex](orcIndex.getBloomFilterIndex()).forall(((x$2: org.apache.orc.OrcProto.BloomFilterIndex) => x$2.getBloomFilterCount().>(0)))", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ OrcData $anonfun$beforeAll$1(int i) {
        return new OrcData(i, new StringBuilder(5).append("part-").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$3(File f) {
        return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$4(OrcSuite $this, OrcProto.Stream.Kind bloomFilterKind$1, OrcProto.Stream.Kind x$1) {
        return $this.convertToEqualizer(x$1).$eq$eq$eq((Object)bloomFilterKind$1, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$5(OrcProto.BloomFilterIndex x$2) {
        return x$2.getBloomFilterCount() > 0;
    }

    public static final /* synthetic */ Seq $anonfun$new$20(int i) {
        return (Seq)Seq$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringBuilder(5).append("part-").append(i).toString()})));
    }

    public static final /* synthetic */ void $anonfun$new$35(OrcSuite $this, Dataset df$1, File path) {
        df$1.write().format("orc").save(path.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path.getCanonicalPath()), (Dataset<Row>)df$1);
    }

    public static final /* synthetic */ void $anonfun$new$38(OrcSuite $this, File path) {
        Timestamp ts = Timestamp.valueOf("1900-05-05 12:34:56.000789");
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{ts})), $this.testImplicits().newTimeStampEncoder()).toDF().write().orc(path.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path.getCanonicalPath()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts})));
    }

    public OrcSuite() {
        this.test("create temporary orc table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_source"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source where intField > 5"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("create temporary orc table as", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_as_source"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source WHERE intField > 5"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("appending insert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"INSERT INTO TABLE normal_orc_source SELECT * FROM orc_temp_table WHERE intField > 5");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> OrcSuite.$anonfun$new$20(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("overwrite insert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("INSERT OVERWRITE TABLE normal_orc_as_source\n        |SELECT * FROM orc_temp_table WHERE intField > 5\n      ")).stripMargin());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_as_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("write null values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
            Dataset df = (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  CAST(null as TINYINT) as c0,\n        |  CAST(null as SMALLINT) as c1,\n        |  CAST(null as INT) as c2,\n        |  CAST(null as BIGINT) as c3,\n        |  CAST(null as FLOAT) as c4,\n        |  CAST(null as DOUBLE) as c5,\n        |  CAST(null as DECIMAL(7,2)) as c6,\n        |  CAST(null as TIMESTAMP) as c7,\n        |  CAST(null as DATE) as c8,\n        |  CAST(null as STRING) as c9,\n        |  CAST(null as VARCHAR(10)) as c10\n        |FROM orc_temp_table limit 1\n      ")).stripMargin());
            df.write().format("orc").saveAsTable("orcNullValues");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM orcNullValues"), Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(11, (Function0 & Serializable & scala.Serializable)() -> null)));
            return (Dataset)this.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLConf conf = this.spark().sessionState().conf();
            OrcOptions option = new OrcOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute().toUpperCase(Locale.ROOT)), (Object)"NONE")})), conf);
            String $org_scalatest_assert_macro_left = option.compressionCodec();
            String $org_scalatest_assert_macro_right = "NONE";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("SPARK-21839: Add SQL config for ORC compression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLConf conf = this.spark().sessionState().conf();
            String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).compressionCodec();
            String $org_scalatest_assert_macro_right = "SNAPPY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)"uncompressed")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).compressionCodec();
                String $org_scalatest_assert_macro_right = "NONE";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
                Map map1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib")}));
                Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"lzo")}));
                String $org_scalatest_assert_macro_left2 = new OrcOptions(map1, conf).compressionCodec();
                String $org_scalatest_assert_macro_right2 = "ZLIB";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
                String $org_scalatest_assert_macro_left3 = new OrcOptions(map2, conf).compressionCodec();
                String $org_scalatest_assert_macro_right3 = "LZO";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NONE", "UNCOMPRESSED", "SNAPPY", "ZLIB", "LZO"}))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)c)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String string = c;
                    String string2 = "UNCOMPRESSED";
                    String expected = !(string != null ? !string.equals(string2) : string2 != null) ? "NONE" : c;
                    String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf$1).compressionCodec();
                    String $org_scalatest_assert_macro_right = expected;
                    String string3 = $org_scalatest_assert_macro_left;
                    String string4 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("SPARK-23340 Empty float/double array columns raise EOFException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][]{(float[])Array$.MODULE$.empty(ClassTag$.MODULE$.Float())})), this.testImplicits().newFloatArrayEncoder()).toDF(), this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())})), this.testImplicits().newDoubleArrayEncoder()).toDF()}))).foreach((Function1 & Serializable & scala.Serializable)df -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                OrcSuite.$anonfun$new$35($this, df, path);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("SPARK-24322 Fix incorrect workaround for bug in java.sql.Timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            OrcSuite.$anonfun$new$38(this, path);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
    }
}

