/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class CSVBenchmarks$ {
    public static CSVBenchmarks$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new CSVBenchmarks$();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void quotedValuesBenchmark(int rowsNum, int numIters) {
        Benchmark benchmark = new Benchmark("Parsing quoted values", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            CSVBenchmarks$.$anonfun$quotedValuesBenchmark$1(rowsNum, numIters, benchmark, path);
            return BoxedUnit.UNIT;
        });
    }

    public void multiColumnsBenchmark(int rowsNum) {
        int colsNum = 1000;
        Benchmark benchmark = new Benchmark(new StringBuilder(23).append("Wide rows with ").append(colsNum).append(" columns").toString(), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            CSVBenchmarks$.$anonfun$multiColumnsBenchmark$1(rowsNum, colsNum, benchmark, path);
            return BoxedUnit.UNIT;
        });
    }

    public void countBenchmark(int rowsNum) {
        int colsNum = 10;
        Benchmark benchmark = new Benchmark(new StringBuilder(29).append("Count a dataset with ").append(colsNum).append(" columns").toString(), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            CSVBenchmarks$.$anonfun$countBenchmark$1(rowsNum, colsNum, benchmark, path);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        this.quotedValuesBenchmark(50000, 3);
        this.multiColumnsBenchmark(1000000);
        this.countBenchmark(10000000);
    }

    public static final /* synthetic */ String $anonfun$quotedValuesBenchmark$2(int i) {
        return new StringBuilder(2).append("\"").append(i).append("\"").toString();
    }

    public static final /* synthetic */ boolean $anonfun$quotedValuesBenchmark$5(Row x$3) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$quotedValuesBenchmark$1(int rowsNum$1, int numIters$1, Benchmark benchmark$1, File path) {
        String str = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10000).map((Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$quotedValuesBenchmark$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        MODULE$.spark().range((long)rowsNum$1).map((Function1 & Serializable & scala.Serializable)x$1 -> str, MODULE$.spark().implicits().newStringEncoder()).write().option("header", true).csv(path.getAbsolutePath());
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$);
        Dataset ds = MODULE$.spark().read().option("header", true).schema(schema).csv(path.getAbsolutePath());
        benchmark$1.addCase("One quoted string", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> ds.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$quotedValuesBenchmark$5(x$3))).count());
        benchmark$1.run();
    }

    public static final /* synthetic */ StructField $anonfun$multiColumnsBenchmark$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ String $anonfun$multiColumnsBenchmark$3(int i) {
        return ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
    }

    public static final /* synthetic */ Column $anonfun$multiColumnsBenchmark$4(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$multiColumnsBenchmark$6(Row row) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$multiColumnsBenchmark$9(Row row) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$multiColumnsBenchmark$11(Row row) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$multiColumnsBenchmark$1(int rowsNum$2, int colsNum$1, Benchmark benchmark$2, File path) {
        Seq fields = (Seq)Seq$.MODULE$.tabulate(colsNum$1, (Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$multiColumnsBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        String values = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), colsNum$1).map((Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$multiColumnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        String[] columnNames = schema.fieldNames();
        MODULE$.spark().range((long)rowsNum$2).select((Seq)Seq$.MODULE$.tabulate(colsNum$1, (Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$multiColumnsBenchmark$4(BoxesRunTime.unboxToInt((Object)i)))).write().option("header", true).csv(path.getAbsolutePath());
        Dataset ds = MODULE$.spark().read().schema(schema).csv(path.getAbsolutePath());
        benchmark$2.addCase(new StringBuilder(15).append("Select ").append(colsNum$1).append(" columns").toString(), 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> ds.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$multiColumnsBenchmark$6(row))).count());
        Column[] cols100 = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnNames)).take(100))).map((Function1 & Serializable & scala.Serializable)x$5 -> Column$.MODULE$.apply(x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        benchmark$2.addCase("Select 100 columns", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])cols100)).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$multiColumnsBenchmark$9(row))).count());
        benchmark$2.addCase("Select one column", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$multiColumnsBenchmark$11(row))).count());
        benchmark$2.addCase("count()", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> ds.count());
        benchmark$2.run();
    }

    public static final /* synthetic */ StructField $anonfun$countBenchmark$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$countBenchmark$3(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$5(Row x$10) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$7(Row x$12) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$countBenchmark$1(int rowsNum$3, int colsNum$2, Benchmark benchmark$3, File path) {
        Seq fields = (Seq)Seq$.MODULE$.tabulate(colsNum$2, (Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$countBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        MODULE$.spark().range((long)rowsNum$3).select((Seq)Seq$.MODULE$.tabulate(colsNum$2, (Function1 & Serializable & scala.Serializable)i -> CSVBenchmarks$.$anonfun$countBenchmark$3(BoxesRunTime.unboxToInt((Object)i)))).write().csv(path.getAbsolutePath());
        Dataset ds = MODULE$.spark().read().schema(schema).csv(path.getAbsolutePath());
        benchmark$3.addCase(new StringBuilder(25).append("Select ").append(colsNum$2).append(" columns + count()").toString(), 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> ds.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$countBenchmark$5(x$10))).count());
        benchmark$3.addCase("Select 1 column + count()", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmarks$.$anonfun$countBenchmark$7(x$12))).count());
        benchmark$3.addCase("count()", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$13 -> ds.count());
        benchmark$3.run();
    }

    private CSVBenchmarks$() {
        MODULE$ = this;
        this.conf = new SparkConf();
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("benchmark-csv-datasource").config(this.conf()).getOrCreate();
    }
}

