/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\t1\"+\u001e8MK:<G\u000f[#oG>$\u0017N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t)a!\u0001\u0005d_2,XN\\1s\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\t\u0011B\\;mYZ\u000bG.^3\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u00121!\u00138u\u0011\u0019)\u0003\u0001)A\u0005=\u0005Qa.\u001e7m-\u0006dW/\u001a\u0011\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002+Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oOV\u0011\u0011F\u000f\u000b\u0005U5\u001ad\t\u0005\u0002 W%\u0011A\u0006\t\u0002\u0005+:LG\u000fC\u0003/M\u0001\u0007q&A\u0006d_2,XN\\*uCR\u001c\bC\u0001\u00192\u001b\u0005!\u0011B\u0001\u001a\u0005\u0005-\u0019u\u000e\\;n]N#\u0018\r^:\t\u000bQ2\u0003\u0019A\u001b\u0002\u0015\r|G.^7o)f\u0004X\rE\u00021maJ!a\u000e\u0003\u0003!9\u000bG/\u001b<f\u0007>dW/\u001c8UsB,\u0007CA\u001d;\u0019\u0001!Qa\u000f\u0014C\u0002q\u0012\u0011\u0001V\t\u0003{\u0001\u0003\"a\b \n\u0005}\u0002#a\u0002(pi\"Lgn\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\tQ\u0001^=qKNL!!\u0012\"\u0003\u0015\u0005#x.\\5d)f\u0004X\rC\u0004HMA\u0005\t\u0019\u0001%\u0002\u001dQ,7\u000f\u001e#fG>l\u0007O]3tgB\u0011q$S\u0005\u0003\u0015\u0002\u0012qAQ8pY\u0016\fg\u000eC\u0004M\u0001E\u0005I\u0011A'\u0002?Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oO\u0012\"WMZ1vYR$3'\u0006\u0002O3V\tqJ\u000b\u0002I!.\n\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003-\u0002\n!\"\u00198o_R\fG/[8o\u0013\tA6KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QaO&C\u0002q\u0002")
public class RunLengthEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testRunLengthEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringBuilder(20).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": empty column").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(0, (Seq)Seq$.MODULE$.empty(), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test(new StringBuilder(19).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringBuilder(23).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": run length == 1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringBuilder(23).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single long run").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test(new StringBuilder(37).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": empty column for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(0, (Seq)Seq$.MODULE$.empty(), columnStats, columnType, testDecompress), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(new StringBuilder(36).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), columnStats, columnType, testDecompress), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test(new StringBuilder(40).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single long run for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), columnStats, columnType, testDecompress), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test(new StringBuilder(46).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single case with null for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.nullValue())), (Object)BoxesRunTime.boxToInteger((int)2))})), columnStats, columnType, testDecompress), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    public <T extends AtomicType> boolean testRunLengthEncoding$default$3() {
        return true;
    }

    public static final /* synthetic */ int $anonfun$testRunLengthEncoding$4(NativeColumnType columnType$1, Seq rows$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int index = tuple2._1$mcI$sp();
        int n = columnType$1.actualSize((InternalRow)rows$1.apply(index), 0) + 4;
        return n;
    }

    public static final /* synthetic */ Assertion $anonfun$testRunLengthEncoding$6(RunLengthEncodingSuite $this, NativeColumnType columnType$1, Seq values$1, RunLengthEncoding.Decoder decoder$1, GenericInternalRow mutableRow$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        Object object = values$1.apply(i);
        decoder$1.next((InternalRow)mutableRow$1, 0);
        return $this.assertResult(object, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    private final void skeleton$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Tuple2 tuple23 = tuple22;
        Seq values2 = (Seq)tuple23._1();
        Seq rows2 = (Seq)tuple23._2();
        Seq inputSeq = (Seq)inputRuns.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._1$mcI$sp();
            int run = tuple2._2$mcI$sp();
            Seq seq = (Seq)Seq$.MODULE$.fill(run, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> index);
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> builder.appendFrom((InternalRow)rows2.apply(i), 0));
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int compressedSize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputRuns.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)RunLengthEncodingSuite.$anonfun$testRunLengthEncoding$4(columnType$1, rows2, x0$2)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        inputRuns.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._1$mcI$sp();
            int run = tuple2._2$mcI$sp();
            this.assertResult(values2.apply(index), "Wrong column element value", columnType$1.extract(buffer), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Assertion assertion = this.assertResult(BoxesRunTime.boxToInteger((int)run), "Wrong run length", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            return assertion;
        });
        buffer.rewind().position(headerSize + 4);
        RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (inputSeq.nonEmpty()) {
            inputSeq.foreach((Function1 & Serializable & scala.Serializable)i -> RunLengthEncodingSuite.$anonfun$testRunLengthEncoding$6(this, columnType$1, values2, decoder, mutableRow, BoxesRunTime.unboxToInt((Object)i)));
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }

    private final void skeletonForDecompress$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1, boolean testDecompress$1) {
        block2: {
            if (!testDecompress$1) {
                return;
            }
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
            Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
            Tuple2 tuple23 = tuple22;
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq inputSeq = (Seq)inputRuns.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int index = tuple2._1$mcI$sp();
                int run = tuple2._2$mcI$sp();
                Seq seq = (Seq)Seq$.MODULE$.fill(run, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> index);
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            GenericInternalRow nullRow = new GenericInternalRow(1);
            nullRow.setNullAt(0);
            inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (i == this.nullValue()) {
                    builder.appendFrom((InternalRow)nullRow, 0);
                } else {
                    builder.appendFrom((InternalRow)rows2.apply(i), 0);
                }
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
            OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), (DataType)columnType$1.dataType());
            decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
            if (!inputSeq.nonEmpty()) break block2;
            ((IterableLike)inputSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Assertion assertion;
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    int expected = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    int n = expected;
                    int n2 = index;
                    if (n == this.nullValue()) {
                        return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringBuilder(22).append("Wrong null ").append(n2).append("th-position").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n2)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                    }
                }
                if (tuple2 == null) throw this.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                int i = tuple2._1$mcI$sp();
                int index = tuple2._2$mcI$sp();
                int n = i;
                int n3 = index;
                NativeColumnType nativeColumnType = columnType$1;
                if (BOOLEAN$.MODULE$.equals(nativeColumnType)) {
                    assertion = this.assertResult(values2.apply(n), new StringBuilder(31).append("Wrong ").append(n3).append("-th decoded boolean value").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.getBoolean(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                    return assertion;
                } else if (BYTE$.MODULE$.equals(nativeColumnType)) {
                    assertion = this.assertResult(values2.apply(n), new StringBuilder(28).append("Wrong ").append(n3).append("-th decoded byte value").toString(), BoxesRunTime.boxToByte((byte)columnVector.getByte(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                    return assertion;
                } else if (SHORT$.MODULE$.equals(nativeColumnType)) {
                    assertion = this.assertResult(values2.apply(n), new StringBuilder(29).append("Wrong ").append(n3).append("-th decoded short value").toString(), BoxesRunTime.boxToShort((short)columnVector.getShort(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                    return assertion;
                } else if (INT$.MODULE$.equals(nativeColumnType)) {
                    assertion = this.assertResult(values2.apply(n), new StringBuilder(27).append("Wrong ").append(n3).append("-th decoded int value").toString(), BoxesRunTime.boxToInteger((int)columnVector.getInt(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                    return assertion;
                } else {
                    if (!LONG$.MODULE$.equals(nativeColumnType)) throw this.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                    assertion = this.assertResult(values2.apply(n), new StringBuilder(28).append("Wrong ").append(n3).append("-th decoded long value").toString(), BoxesRunTime.boxToLong((long)columnVector.getLong(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                }
                return assertion;
            });
        }
    }

    public RunLengthEncodingSuite() {
        this.nullValue = -1;
        this.testRunLengthEncoding((ColumnStats)new NoopColumnStats(), (NativeColumnType)BOOLEAN$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

