/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.PassThrough;
import org.apache.spark.sql.execution.columnar.compression.PassThrough$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001#\t\u0001\u0002+Y:t)\"\u0014x.^4i'VLG/\u001a\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\tG>dW/\u001c8be*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!9A\u0004\u0001b\u0001\n\u0003i\u0012!\u00038vY24\u0016\r\\;f+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\"1Q\u0005\u0001Q\u0001\ny\t!B\\;mYZ\u000bG.^3!\u0011\u00159\u0003\u0001\"\u0001)\u0003=!Xm\u001d;QCN\u001cH\u000b\u001b:pk\u001eDWCA\u0015;)\rQSf\r\t\u0003?-J!\u0001\f\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u0019\u0002\raL\u0001\fG>dW/\u001c8Ti\u0006$8\u000f\u0005\u00021c5\tA!\u0003\u00023\t\tY1i\u001c7v[:\u001cF/\u0019;t\u0011\u0015!d\u00051\u00016\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u0004aYB\u0014BA\u001c\u0005\u0005Aq\u0015\r^5wK\u000e{G.^7o)f\u0004X\r\u0005\u0002:u1\u0001A!B\u001e'\u0005\u0004a$!\u0001+\u0012\u0005u\u0002\u0005CA\u0010?\u0013\ty\u0004EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0011!\u0002;za\u0016\u001c\u0018BA#C\u0005)\tEo\\7jGRK\b/\u001a")
public class PassThroughSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testPassThrough(ColumnStats columnStats, NativeColumnType<T> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringBuilder(20).append(PassThrough$.MODULE$).append(" with ").append(typeName).append(": empty column").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1((Seq)Seq$.MODULE$.empty(), columnStats, columnType), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test(new StringBuilder(26).append(PassThrough$.MODULE$).append(" with ").append(typeName).append(": long random series").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomValue(columnType), ClassTag$.MODULE$.Any());
            this.skeleton$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), columnStats, columnType);
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test(new StringBuilder(37).append(PassThrough$.MODULE$).append(" with ").append(typeName).append(": empty column for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1((Seq)Seq$.MODULE$.empty(), columnStats, columnType), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test(new StringBuilder(43).append(PassThrough$.MODULE$).append(" with ").append(typeName).append(": long random series for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomValue(columnType), ClassTag$.MODULE$.Any());
            this.skeletonForDecompress$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), columnStats, columnType);
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringBuilder(46).append(PassThrough$.MODULE$).append(" with ").append(typeName).append(": simple case with null for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            NativeColumnType nativeColumnType = columnType;
            if (BYTE$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{2, 1, 2, (byte)this.nullValue(), 5}));
            } else if (SHORT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{2, 1, 2, (short)this.nullValue(), 5}));
            } else if (INT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, this.nullValue(), 5}));
            } else if (LONG$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, this.nullValue(), 5L}));
            } else if (FLOAT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{2.0f, 1.0f, 2.0f, this.nullValue(), 5.0f}));
            } else if (DOUBLE$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 2.0, this.nullValue(), 5.0}));
            } else {
                throw new MatchError((Object)nativeColumnType);
            }
            Seq input = seq;
            this.skeletonForDecompress$1((Seq)input.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4, Seq$.MODULE$.canBuildFrom()), columnStats, columnType);
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    public static final /* synthetic */ void $anonfun$testPassThrough$1(NativeColumnType columnType$1, TestCompressibleColumnBuilder builder$1, Object value) {
        GenericInternalRow row = new GenericInternalRow(1);
        columnType$1.setField((InternalRow)row, 0, value);
        builder$1.appendFrom((InternalRow)row, 0);
    }

    private final void skeleton$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)PassThrough$.MODULE$);
        input.map((Function1 & Serializable & scala.Serializable)value -> {
            PassThroughSuite.$anonfun$testPassThrough$1(columnType$1, builder, value);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int compressedSize = 4 + input.size() * columnType$1.defaultSize();
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)PassThrough$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        if (input.nonEmpty()) {
            input.foreach((Function1 & Serializable & scala.Serializable)value -> this.assertResult(value, "Wrong value", columnType$1.extract(buffer), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70)));
        }
        buffer.rewind().position(headerSize + 4);
        PassThrough.Decoder decoder = PassThrough$.MODULE$.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (input.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            input.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                decoder.next((InternalRow)mutableRow, 0);
                return this.assertResult(x$1, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow, 0), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ void $anonfun$testPassThrough$4(PassThroughSuite $this, NativeColumnType columnType$1, TestCompressibleColumnBuilder builder$2, GenericInternalRow row$1, GenericInternalRow nullRow$1, Object value) {
        if (BoxesRunTime.equals((Object)value, (Object)BoxesRunTime.boxToInteger((int)$this.nullValue()))) {
            builder$2.appendFrom((InternalRow)nullRow$1, 0);
        } else {
            columnType$1.setField((InternalRow)row$1, 0, value);
            builder$2.appendFrom((InternalRow)row$1, 0);
        }
    }

    private final void skeletonForDecompress$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        block0: {
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)PassThrough$.MODULE$);
            GenericInternalRow row = new GenericInternalRow(1);
            GenericInternalRow nullRow = new GenericInternalRow(1);
            nullRow.setNullAt(0);
            input.map((Function1 & Serializable & scala.Serializable)value -> {
                PassThroughSuite.$anonfun$testPassThrough$4(this, columnType$1, builder, row, nullRow, value);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)PassThrough$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            PassThrough.Decoder decoder = PassThrough$.MODULE$.decoder(buffer, columnType$1);
            OnHeapColumnVector columnVector = new OnHeapColumnVector(input.length(), (DataType)columnType$1.dataType());
            decoder.decompress((WritableColumnVector)columnVector, input.length());
            if (!input.nonEmpty()) break block0;
            ((IterableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Object) {
                        Object object = expected;
                        int n = index;
                        if (BoxesRunTime.equals((Object)object, (Object)BoxesRunTime.boxToInteger((int)this.nullValue()))) {
                            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringBuilder(22).append("Wrong null ").append(n).append("th-position").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                        }
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Byte) {
                        byte by = BoxesRunTime.unboxToByte((Object)expected);
                        int n = index;
                        return this.assertResult(BoxesRunTime.boxToByte((byte)by), new StringBuilder(28).append("Wrong ").append(n).append("-th decoded byte value").toString(), BoxesRunTime.boxToByte((byte)columnVector.getByte(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Short) {
                        short s = BoxesRunTime.unboxToShort((Object)expected);
                        int n = index;
                        return this.assertResult(BoxesRunTime.boxToShort((short)s), new StringBuilder(29).append("Wrong ").append(n).append("-th decoded short value").toString(), BoxesRunTime.boxToShort((short)columnVector.getShort(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)expected);
                        int n2 = index;
                        return this.assertResult(BoxesRunTime.boxToInteger((int)n), new StringBuilder(27).append("Wrong ").append(n2).append("-th decoded int value").toString(), BoxesRunTime.boxToInteger((int)columnVector.getInt(n2)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Long) {
                        long l = BoxesRunTime.unboxToLong((Object)expected);
                        int n = index;
                        return this.assertResult(BoxesRunTime.boxToLong((long)l), new StringBuilder(28).append("Wrong ").append(n).append("-th decoded long value").toString(), BoxesRunTime.boxToLong((long)columnVector.getLong(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)expected);
                        int n = index;
                        return this.assertResult(BoxesRunTime.boxToFloat((float)f), new StringBuilder(29).append("Wrong ").append(n).append("-th decoded float value").toString(), BoxesRunTime.boxToFloat((float)columnVector.getFloat(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                    }
                }
                if (tuple2 == null) throw this.fail("Unsupported type", new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                Object expected = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (!(expected instanceof Double)) throw this.fail("Unsupported type", new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                double d = BoxesRunTime.unboxToDouble((Object)expected);
                int n = index;
                return this.assertResult(BoxesRunTime.boxToDouble((double)d), new StringBuilder(30).append("Wrong ").append(n).append("-th decoded double value").toString(), BoxesRunTime.boxToDouble((double)columnVector.getDouble(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            });
        }
    }

    public PassThroughSuite() {
        this.nullValue = -1;
        this.testPassThrough((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$);
        this.testPassThrough((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$);
        this.testPassThrough((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$);
        this.testPassThrough((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$);
        this.testPassThrough((ColumnStats)new FloatColumnStats(), (NativeColumnType)FLOAT$.MODULE$);
        this.testPassThrough((ColumnStats)new DoubleColumnStats(), (NativeColumnType)DOUBLE$.MODULE$);
    }
}

