/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnType$;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001f\ty1i\u001c7v[:$\u0016\u0010]3Tk&$XM\u0003\u0002\u0004\t\u0005A1m\u001c7v[:\f'O\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002'\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011\u0019I\u0003\u0001)A\u0005E\u0005!B)\u0012$B+2#vLQ+G\r\u0016\u0013vlU%[\u000b\u0002Bqa\u000b\u0001C\u0002\u0013%A&\u0001\u0005N\u0003B{F+\u0017)F+\u0005i\u0003C\u0001\u0010/\u0013\ty#AA\u0002N\u0003BCa!\r\u0001!\u0002\u0013i\u0013!C'B!~#\u0016\fU#!\u0011\u001d\u0019\u0004A1A\u0005\nQ\n!\"\u0011*S\u0003f{F+\u0017)F+\u0005)\u0004C\u0001\u00107\u0013\t9$AA\u0003B%J\u000b\u0015\f\u0003\u0004:\u0001\u0001\u0006I!N\u0001\f\u0003J\u0013\u0016)W0U3B+\u0005\u0005C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\u0002\u0017M#&+V\"U?RK\u0006+R\u000b\u0002{A\u0011aDP\u0005\u0003\u007f\t\u0011aa\u0015+S+\u000e#\u0006BB!\u0001A\u0003%Q(\u0001\u0007T)J+6\tV0U3B+\u0005\u0005C\u0003D\u0001\u0011\u0005A)\u0001\u000buKN$h*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/Z\u000b\u0003\u000bB#\"AR%\u0011\u0005\r:\u0015B\u0001%%\u0005\u0011)f.\u001b;\t\u000b)\u0013\u0005\u0019A&\u0002\u0015\r|G.^7o)f\u0004X\rE\u0002\u001f\u0019:K!!\u0014\u0002\u0003!9\u000bG/\u001b<f\u0007>dW/\u001c8UsB,\u0007CA(Q\u0019\u0001!Q!\u0015\"C\u0002I\u0013\u0011\u0001V\t\u0003'Z\u0003\"a\t+\n\u0005U##a\u0002(pi\"Lgn\u001a\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u001a\tQ\u0001^=qKNL!a\u0017-\u0003\u0015\u0005#x.\\5d)f\u0004X\rC\u0003^\u0001\u0011\u0005a,\u0001\buKN$8i\u001c7v[:$\u0016\u0010]3\u0016\u0005}+GC\u0001$a\u0011\u0015QE\f1\u0001b!\rq\"\rZ\u0005\u0003G\n\u0011!bQ8mk6tG+\u001f9f!\tyU\rB\u0003g9\n\u0007qMA\u0004Km6$\u0016\u0010]3\u0012\u0005MC\u0007CA\u0012j\u0013\tQGEA\u0002B]fDQ\u0001\u001c\u0001\u0005\n5\f!\u0002Z;na\n+hMZ3s)\tAg\u000eC\u0003pW\u0002\u0007\u0001/\u0001\u0003ck\u001a4\u0007CA9w\u001b\u0005\u0011(BA:u\u0003\rq\u0017n\u001c\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0006CsR,')\u001e4gKJ\u0004")
public class ColumnTypeSuite
extends SparkFunSuite {
    private final int DEFAULT_BUFFER_SIZE;
    private final MAP MAP_TYPE = new MAP(MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
    private final ARRAY ARRAY_TYPE = new ARRAY(ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
    private final STRUCT STRUCT_TYPE;

    private int DEFAULT_BUFFER_SIZE() {
        return this.DEFAULT_BUFFER_SIZE;
    }

    private MAP MAP_TYPE() {
        return this.MAP_TYPE;
    }

    private ARRAY ARRAY_TYPE() {
        return this.ARRAY_TYPE;
    }

    private STRUCT STRUCT_TYPE() {
        return this.STRUCT_TYPE;
    }

    public <T extends AtomicType> void testNativeColumnType(NativeColumnType<T> columnType) {
        this.testColumnType((ColumnType)columnType);
    }

    public <JvmType> void testColumnType(ColumnType<JvmType> columnType) {
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{columnType.dataType()}));
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(columnType.dataType());
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$2 -> ColumnTypeSuite.$anonfun$testColumnType$1(columnType, proj, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        int totalSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getSizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int bufferSize = Math.max(this.DEFAULT_BUFFER_SIZE(), totalSize);
        this.test(new java.lang.StringBuilder(15).append(columnType).append(" append/extract").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.nativeOrder());
            seq.foreach((Function1 & Serializable & scala.Serializable)r -> {
                columnType.append(columnType.getField((InternalRow)r, 0), buffer);
                return BoxedUnit.UNIT;
            });
            buffer.rewind();
            seq.foreach((Function1 & Serializable & scala.Serializable)row -> {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(22).append("buffer = ").append(buffer).append(", expected = ").append(row).toString());
                Object expected = converter.apply(row.get(0, columnType.dataType()));
                Object extracted = converter.apply(columnType.extract(buffer));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
                Object $org_scalatest_assert_macro_right = extracted;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new java.lang.StringBuilder(64).append("Extracted value didn't equal to the original one. ").append(expected).append(" != ").append(extracted).append(", buffer =").append(this.dumpBuffer((ByteBuffer)buffer.duplicate().rewind())).toString(), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            });
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    private Object dumpBuffer(ByteBuffer buff) {
        StringBuilder sb;
        block1: {
            sb = new StringBuilder();
            while (buff.hasRemaining()) {
                byte b = buff.get();
                sb.append(Integer.toHexString(b & 0xFF)).append(' ');
            }
            if (!sb.nonEmpty()) break block1;
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private final void checkActualSize$1(ColumnType columnType, Object value, int expected) {
        Integer n = BoxesRunTime.boxToInteger((int)expected);
        String string = new java.lang.StringBuilder(21).append("Wrong actualSize for ").append(columnType).toString();
        GenericInternalRow row = new GenericInternalRow(1);
        row.update(0, CatalystTypeConverters$.MODULE$.convertToCatalyst(value));
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{columnType.dataType()}));
        this.assertResult(n, string, BoxesRunTime.boxToInteger((int)columnType.actualSize((InternalRow)proj.apply((InternalRow)row), 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }

    public static final /* synthetic */ UnsafeRow $anonfun$testColumnType$1(ColumnType columnType$1, UnsafeProjection proj$1, int x$2) {
        return proj$1.apply(ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]))).copy();
    }

    public ColumnTypeSuite() {
        this.DEFAULT_BUFFER_SIZE = 512;
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.STRUCT_TYPE = new STRUCT(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)));
        this.test("defaultSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map checks = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NULL$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BOOLEAN$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BYTE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SHORT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)INT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LONG$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FLOAT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DOUBLE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new COMPACT_DECIMAL(15, 10)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new LARGE_DECIMAL(20, 10)), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)STRING$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BINARY$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STRUCT_TYPE()), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ARRAY_TYPE()), (Object)BoxesRunTime.boxToInteger((int)28)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAP_TYPE()), (Object)BoxesRunTime.boxToInteger((int)68))}));
            checks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ColumnType columnType = (ColumnType)tuple2._1();
                int expectedSize = tuple2._2$mcI$sp();
                Assertion assertion = this.assertResult(BoxesRunTime.boxToInteger((int)expectedSize), new java.lang.StringBuilder(22).append("Wrong defaultSize for ").append(columnType).toString(), BoxesRunTime.boxToInteger((int)columnType.defaultSize()), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                return assertion;
            });
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("actualSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkActualSize$1((ColumnType)NULL$.MODULE$, null, 0);
            this.checkActualSize$1((ColumnType)BOOLEAN$.MODULE$, BoxesRunTime.boxToBoolean((boolean)true), 1);
            this.checkActualSize$1((ColumnType)BYTE$.MODULE$, BoxesRunTime.boxToByte((byte)127), 1);
            this.checkActualSize$1((ColumnType)SHORT$.MODULE$, BoxesRunTime.boxToShort((short)Short.MAX_VALUE), 2);
            this.checkActualSize$1((ColumnType)INT$.MODULE$, BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), 4);
            this.checkActualSize$1((ColumnType)LONG$.MODULE$, BoxesRunTime.boxToLong((long)Long.MAX_VALUE), 8);
            this.checkActualSize$1((ColumnType)FLOAT$.MODULE$, BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), 4);
            this.checkActualSize$1((ColumnType)DOUBLE$.MODULE$, BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), 8);
            this.checkActualSize$1((ColumnType)STRING$.MODULE$, "hello", 4 + "hello".getBytes(StandardCharsets.UTF_8).length);
            this.checkActualSize$1((ColumnType)BINARY$.MODULE$, Array$.MODULE$.fill(4, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)0, ClassTag$.MODULE$.Byte()), 8);
            this.checkActualSize$1((ColumnType)new COMPACT_DECIMAL(15, 10), Decimal$.MODULE$.apply(0L, 15, 10), 8);
            this.checkActualSize$1((ColumnType)new LARGE_DECIMAL(20, 10), Decimal$.MODULE$.apply(0L, 20, 10), 5);
            this.checkActualSize$1((ColumnType)this.ARRAY_TYPE(), Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}), ClassTag$.MODULE$.Any()), 28);
            this.checkActualSize$1((ColumnType)this.MAP_TYPE(), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})), 68);
            this.checkActualSize$1((ColumnType)this.STRUCT_TYPE(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello"})), 28);
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.testNativeColumnType((NativeColumnType)BOOLEAN$.MODULE$);
        this.testNativeColumnType((NativeColumnType)BYTE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)SHORT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)INT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)LONG$.MODULE$);
        this.testNativeColumnType((NativeColumnType)FLOAT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)DOUBLE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)new COMPACT_DECIMAL(15, 10));
        this.testNativeColumnType((NativeColumnType)STRING$.MODULE$);
        this.testColumnType((ColumnType)NULL$.MODULE$);
        this.testColumnType((ColumnType)BINARY$.MODULE$);
        this.testColumnType((ColumnType)new LARGE_DECIMAL(20, 10));
        this.testColumnType((ColumnType)this.STRUCT_TYPE());
        this.testColumnType((ColumnType)this.ARRAY_TYPE());
        this.testColumnType((ColumnType)this.MAP_TYPE());
        this.test("column type for decimal types with different precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 18).foreach((Function1 & Serializable & scala.Serializable)i -> this.assertResult(new COMPACT_DECIMAL(BoxesRunTime.unboxToInt((Object)i), 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(BoxesRunTime.unboxToInt((Object)i), 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138)));
            return this.assertResult(new LARGE_DECIMAL(19, 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(19, 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("show type name in type mismatch error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String message;
            DataType invalidType = new DataType(null){

                public int defaultSize() {
                    return 1;
                }

                public DataType asNullable() {
                    return this;
                }

                public String typeName() {
                    return "invalid type name";
                }
            };
            String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> ColumnType$.MODULE$.apply(invalidType), ClassTag$.MODULE$.apply(Exception.class), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155))).getMessage();
            String $org_scalatest_assert_macro_right = "Unsupported type: invalid type name";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
    }
}

