/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q1A!\u0001\u0002\u0001\u001f\ti!j\\5o\u0005\u0016t7\r[7be.T!a\u0001\u0003\u0002\u0013\t,gn\u00195nCJ\\'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)b#D\u0001\u0003\u0013\t9\"AA\u0007CK:\u001c\u0007.\\1sW\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001")
public class JoinBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase.runBenchmark$(this, name, cardinality, f);
    }

    private SparkSession sparkSession$lzycompute() {
        JoinBenchmark joinBenchmark = this;
        synchronized (joinBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase.sparkSession$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    @Override
    public SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    public static final /* synthetic */ boolean $anonfun$new$3(SparkPlan x$1) {
        return x$1 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$6(SparkPlan x$2) {
        return x$2 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(SparkPlan x$3) {
        return x$3 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$12(SparkPlan x$4) {
        return x$4 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$15(SparkPlan x$5) {
        return x$5 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(SparkPlan x$6) {
        return x$6 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(SparkPlan x$7) {
        return x$7 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$24(SparkPlan x$8) {
        return x$8 instanceof SortMergeJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$27(SparkPlan x$9) {
        return x$9 instanceof SortMergeJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(SparkPlan x$10) {
        return x$10 instanceof ShuffledHashJoinExec;
    }

    public JoinBenchmark() {
        BenchmarkBase.$init$(this);
        this.ignore("broadcast hash join, long key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
            this.runBenchmark("Join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$3(x$1))).isDefined(), "df.queryExecution.sparkPlan.find(((x$1: org.apache.spark.sql.execution.SparkPlan) => x$1.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.ignore("broadcast hash join, long key with duplicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
            this.runBenchmark("Join w long duplicated", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset dim = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id/10 as long) as k"})));
                Dataset df = this.sparkSession().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$6(x$2))).isDefined(), "df.queryExecution.sparkPlan.find(((x$2: org.apache.spark.sql.execution.SparkPlan) => x$2.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.ignore("broadcast hash join, two int key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim2 = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id as int) as k1", "cast(id as int) as k2", "cast(id as string) as v"})));
            this.runBenchmark("Join w 2 ints", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim2, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).cast((DataType)IntegerType$.MODULE$).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).cast((DataType)IntegerType$.MODULE$).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$9(x$3))).isDefined(), "df.queryExecution.sparkPlan.find(((x$3: org.apache.spark.sql.execution.SparkPlan) => x$3.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.ignore("broadcast hash join, two long key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim3 = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k1", "id as k2", "cast(id as string) as v"})));
            this.runBenchmark("Join w 2 longs", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim3, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$12(x$4))).isDefined(), "df.queryExecution.sparkPlan.find(((x$4: org.apache.spark.sql.execution.SparkPlan) => x$4.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.ignore("broadcast hash join, two long key with duplicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim4 = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id/10 as long) as k1", "cast(id/10 as long) as k2"})));
            this.runBenchmark("Join w 2 longs duplicated", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim4, functions$.MODULE$.col("id").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$15(x$5))).isDefined(), "df.queryExecution.sparkPlan.find(((x$5: org.apache.spark.sql.execution.SparkPlan) => x$5.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.ignore("broadcast hash join, outer join long key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
            this.runBenchmark("outer join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")), "left");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$18(x$6))).isDefined(), "df.queryExecution.sparkPlan.find(((x$6: org.apache.spark.sql.execution.SparkPlan) => x$6.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.ignore("broadcast hash join, semi join long key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            int M = 65536;
            Dataset dim = functions$.MODULE$.broadcast(this.sparkSession().range((long)M).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
            this.runBenchmark("semi join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.sparkSession().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")), "leftsemi");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$21(x$7))).isDefined(), "df.queryExecution.sparkPlan.find(((x$7: org.apache.spark.sql.execution.SparkPlan) => x$7.isInstanceOf[org.apache.spark.sql.execution.joins.BroadcastHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.ignore("sort merge join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x200000;
            this.runBenchmark("merge join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df1 = this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id * 2 as k1"}));
                Dataset df2 = this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id * 3 as k2"}));
                Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$24(x$8))).isDefined(), "df.queryExecution.sparkPlan.find(((x$8: org.apache.spark.sql.execution.SparkPlan) => x$8.isInstanceOf[org.apache.spark.sql.execution.joins.SortMergeJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.ignore("sort merge join with duplicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x200000;
            this.runBenchmark("sort merge join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df1 = this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(24).append("(id * 15485863) % ").append(N * 10).append(" as k1").toString()}));
                Dataset df2 = this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(24).append("(id * 15485867) % ").append(N * 10).append(" as k2").toString()}));
                Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$27(x$9))).isDefined(), "df.queryExecution.sparkPlan.find(((x$9: org.apache.spark.sql.execution.SparkPlan) => x$9.isInstanceOf[org.apache.spark.sql.execution.joins.SortMergeJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.ignore("shuffle hash join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x400000;
            this.sparkSession().conf().set("spark.sql.shuffle.partitions", "2");
            this.sparkSession().conf().set("spark.sql.autoBroadcastJoinThreshold", "10000000");
            this.sparkSession().conf().set("spark.sql.join.preferSortMergeJoin", "false");
            this.runBenchmark("shuffle hash join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df1 = this.sparkSession().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as k1"}));
                Dataset df2 = this.sparkSession().range((long)(N / 3)).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id * 3 as k2"}));
                Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(df.queryExecution().sparkPlan().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark.$anonfun$new$30(x$10))).isDefined(), "df.queryExecution.sparkPlan.find(((x$10: org.apache.spark.sql.execution.SparkPlan) => x$10.isInstanceOf[org.apache.spark.sql.execution.joins.ShuffledHashJoinExec])).isDefined", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
                df.count();
            });
        }, new Position("JoinBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
    }
}

