/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.benchmark.BenchmarkBeforeAndAfterEachTest;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEachTestData;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001=\u0011qCR5mi\u0016\u0014\b+^:iI><hNQ3oG\"l\u0017M]6\u000b\u0005\r!\u0011!\u00032f]\u000eDW.\u0019:l\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000b\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\ty\")\u001a8dQ6\f'o\u001b\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"$Vm\u001d;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u001di\u0002A1A\u0005\ny\tAaY8oMV\tq\u0004\u0005\u0002\u0012A%\u0011\u0011\u0005\u0003\u0002\n'B\f'o[\"p]\u001aDaa\t\u0001!\u0002\u0013y\u0012!B2p]\u001a\u0004\u0003bB\u0013\u0001\u0005\u0004%IAJ\u0001\b]Vl'k\\<t+\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\"1a\u0006\u0001Q\u0001\n\u001d\n\u0001B\\;n%><8\u000f\t\u0005\ba\u0001\u0011\r\u0011\"\u0003'\u0003\u00159\u0018\u000e\u001a;i\u0011\u0019\u0011\u0004\u0001)A\u0005O\u00051q/\u001b3uQ\u0002Bq\u0001\u000e\u0001C\u0002\u0013%a%A\u0002nS\u0012DaA\u000e\u0001!\u0002\u00139\u0013\u0001B7jI\u0002Bq\u0001\u000f\u0001C\u0002\u0013%a%A\u0005cY>\u001c7nU5{K\"1!\b\u0001Q\u0001\n\u001d\n!B\u00197pG.\u001c\u0016N_3!\u0011\u001dI\u0001A1A\u0005\nq*\u0012!\u0010\t\u0003}}j\u0011AB\u0005\u0003\u0001\u001a\u0011Ab\u00159be.\u001cVm]:j_:DaA\u0011\u0001!\u0002\u0013i\u0014AB:qCJ\\\u0007\u0005C\u0005E\u0001\u0001\u0007\t\u0019!C\u0005\u000b\u0006\u0019q.\u001e;\u0016\u0003\u0019\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0005%|'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013AbT;uaV$8\u000b\u001e:fC6D\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\u0002\u000f=,Ho\u0018\u0013fcR\u0011\u0011\u000b\u0016\t\u0003QIK!aU\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b+:\u000b\t\u00111\u0001G\u0003\rAH%\r\u0005\n/\u0002\u0001\r\u0011!Q!\n\u0019\u000bAa\\;uA!)\u0011\f\u0001C!5\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002#\")A\f\u0001C!;\u0006Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0005Es\u0006\"B0\\\u0001\u0004\u0001\u0017A\u0001;e!\t\tG-D\u0001c\u0015\t\u0019G\"A\u0005tG\u0006d\u0017\r^3ti&\u0011QM\u0019\u0002\t)\u0016\u001cH\u000fR1uC\")q\r\u0001C!Q\u0006I\u0011M\u001a;fe\u0016\u000b7\r\u001b\u000b\u0003#&DQa\u00184A\u0002\u0001DQa\u001b\u0001\u0005Bi\u000b\u0001\"\u00194uKJ\fE\u000e\u001c\u0005\u0006[\u0002!\tA\\\u0001\ro&$\b\u000eV3naB\u000bG\u000f\u001b\u000b\u0003#>DQ\u0001\u001d7A\u0002E\f\u0011A\u001a\t\u0005QI$\u0018+\u0003\u0002tS\tIa)\u001e8di&|g.\r\t\u0003\u000fVL!A\u001e%\u0003\t\u0019KG.\u001a\u0005\u0006q\u0002!\t!_\u0001\u000eo&$\b\u000eV3naR\u000b'\r\\3\u0015\u0005i|HCA)|\u0011\u0019\u0001x\u000f\"a\u0001yB\u0019\u0001&`)\n\u0005yL#\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005\u0005q\u000f1\u0001\u0002\u0004\u0005QA/\u00192mK:\u000bW.Z:\u0011\u000b!\n)!!\u0003\n\u0007\u0005\u001d\u0011F\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!a\u0003\u0002\u001a9!\u0011QBA\u000b!\r\ty!K\u0007\u0003\u0003#Q1!a\u0005\u000f\u0003\u0019a$o\\8u}%\u0019\u0011qC\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9\"\u000b\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003-9\u0018\u000e\u001e5T#2\u001buN\u001c4\u0015\t\u0005\u0015\u0012\u0011\u0006\u000b\u0004#\u0006\u001d\u0002b\u00029\u0002 \u0011\u0005\r\u0001 \u0005\t\u0003W\ty\u00021\u0001\u0002.\u0005)\u0001/Y5sgB)\u0001&!\u0002\u00020A9\u0001&!\r\u0002\n\u0005%\u0011bAA\u001aS\t1A+\u001e9mKJBq!a\u000e\u0001\t\u0013\tI$\u0001\u0007qe\u0016\u0004\u0018M]3UC\ndW\rF\u0005R\u0003w\ty$!\u0011\u0002D!9\u0011QHA\u001b\u0001\u0004!\u0018a\u00013je\"1Q%!\u000eA\u0002\u001dBa\u0001MA\u001b\u0001\u00049\u0003\u0002CA#\u0003k\u0001\r!a\u0012\u0002#U\u001cXm\u0015;sS:<gi\u001c:WC2,X\rE\u0002)\u0003\u0013J1!a\u0013*\u0005\u001d\u0011un\u001c7fC:Dq!a\u0014\u0001\t\u0013\t\t&\u0001\fqe\u0016\u0004\u0018M]3TiJLgn\u001a#jGR$\u0016M\u00197f)%\t\u00161KA+\u0003/\nY\u0006C\u0004\u0002>\u00055\u0003\u0019\u0001;\t\r\u0015\ni\u00051\u0001(\u0011\u001d\tI&!\u0014A\u0002\u001d\n\u0011C\\;n\t&\u001cH/\u001b8diZ\u000bG.^3t\u0011\u0019\u0001\u0014Q\na\u0001O!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014aC:bm\u0016\f5\u000fV1cY\u0016$r!UA2\u0003\u000b\u000b9\t\u0003\u0005\u0002f\u0005u\u0003\u0019AA4\u0003\t!g\r\u0005\u0003\u0002j\u0005}d\u0002BA6\u0003wrA!!\u001c\u0002z9!\u0011qNA<\u001d\u0011\t\t(!\u001e\u000f\t\u0005=\u00111O\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005ud!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00151\u0011\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!! \u0007\u0011\u001d\ti$!\u0018A\u0002QD!\"!#\u0002^A\u0005\t\u0019AA$\u00035)8/\u001a#jGRLwN\\1ss\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015a\u00064jYR,'\u000fU;tQ\u0012{wO\u001c\"f]\u000eDW.\u0019:l)%\t\u0016\u0011SAK\u00033\u000bi\nC\u0004\u0002\u0014\u0006-\u0005\u0019A\u0014\u0002\rY\fG.^3t\u0011!\t9*a#A\u0002\u0005%\u0011!\u0002;ji2,\u0007\u0002CAN\u0003\u0017\u0003\r!!\u0003\u0002\u0013]DWM]3FqB\u0014\bBCAP\u0003\u0017\u0003\n\u00111\u0001\u0002\n\u0005Q1/\u001a7fGR,\u0005\u0010\u001d:\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\u0006y!/\u001e8J]R\u0014UM\\2i[\u0006\u00148\u000eF\u0004R\u0003O\u000bI+a+\t\r\u0015\n\t\u000b1\u0001(\u0011\u0019\u0001\u0014\u0011\u0015a\u0001O!1A'!)A\u0002\u001dBq!a,\u0001\t\u0013\t\t,\u0001\nsk:\u001cFO]5oO\n+gn\u00195nCJ\\G#C)\u00024\u0006U\u0016qWA^\u0011\u0019)\u0013Q\u0016a\u0001O!1\u0001'!,A\u0002\u001dBq!!/\u0002.\u0002\u0007q%A\u0006tK\u0006\u00148\r\u001b,bYV,\u0007\u0002CA_\u0003[\u0003\r!!\u0003\u0002\u000f\r|G\u000eV=qK\"I\u0011\u0011\u0019\u0001\u0012\u0002\u0013%\u00111Y\u0001\u0016g\u00064X-Q:UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t)M\u000b\u0003\u0002H\u0005\u001d7FAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\u0017&\u0001\u0006b]:|G/\u0019;j_:LA!a6\u0002N\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005m\u0007!%A\u0005\u0002\u0005u\u0017!\t4jYR,'\u000fU;tQ\u0012{wO\u001c\"f]\u000eDW.\u0019:lI\u0011,g-Y;mi\u0012\"TCAApU\u0011\tI!a2")
public class FilterPushdownBenchmark
extends SparkFunSuite
implements BenchmarkBeforeAndAfterEachTest {
    private final SparkConf conf;
    private final int numRows;
    private final int width;
    private final int mid;
    private final int blockSize;
    private final SparkSession spark;
    private OutputStream out;

    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$benchmark$BenchmarkBeforeAndAfterEachTest$$super$beforeEach(TestData testData) {
        BeforeAndAfterEachTestData.beforeEach$((BeforeAndAfterEachTestData)this, (TestData)testData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$benchmark$BenchmarkBeforeAndAfterEachTest$$super$afterEach(TestData testData) {
        BeforeAndAfterEachTestData.afterEach$((BeforeAndAfterEachTestData)this, (TestData)testData);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEachTestData$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEachTestData.runTest$((BeforeAndAfterEachTestData)this, (String)testName, (Args)args);
    }

    private SparkConf conf() {
        return this.conf;
    }

    private int numRows() {
        return this.numRows;
    }

    private int width() {
        return this.width;
    }

    private int mid() {
        return this.mid;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private SparkSession spark() {
        return this.spark;
    }

    private OutputStream out() {
        return this.out;
    }

    private void out_$eq(OutputStream x$1) {
        this.out = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.out_$eq(new FileOutputStream(new File("benchmarks/FilterPushdownBenchmark-results.txt")));
    }

    @Override
    public void beforeEach(TestData td) {
        BenchmarkBeforeAndAfterEachTest.beforeEach$(this, td);
        String separator = new StringOps(Predef$.MODULE$.augmentString("=")).$times(96);
        byte[] testHeader = new StringBuilder(0).append(separator).append('\n').append(td.name()).append('\n').append(separator).append('\n').append('\n').toString().getBytes();
        this.out().write(testHeader);
    }

    @Override
    public void afterEach(TestData td) {
        this.out().write(10);
        BenchmarkBeforeAndAfterEachTest.afterEach$(this, td);
    }

    public void afterAll() {
        try {
            this.out().close();
        }
        finally {
            super.afterAll();
        }
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)FilterPushdownBenchmark.$anonfun$withTempTable$1(this, viewName)));
        }
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keys, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1 & Serializable & scala.Serializable)key -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.spark().conf().get(key)).toOption(), Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(key, value) -> {
            FilterPushdownBenchmark.$anonfun$withSQLConf$3(this, key, value);
            return BoxedUnit.UNIT;
        });
        try {
            f.apply$mcV$sp();
        }
        finally {
            ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FilterPushdownBenchmark.$anonfun$withSQLConf$4(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void prepareTable(File dir, int numRows, int width, boolean useStringForValue) {
        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$prepareTable$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Column valueCol = useStringForValue ? functions$.MODULE$.monotonically_increasing_id().cast("string") : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = this.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), this.spark().implicits().newLongEncoder()).selectExpr((Seq)selectExpr).withColumn("value", valueCol).sort("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.saveAsTable((Dataset<Row>)df, dir, this.saveAsTable$default$3());
    }

    private void prepareStringDictTable(File dir, int numRows, int numDistinctValues, int width) {
        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), width).map((Function1 & Serializable & scala.Serializable)x0$2 -> FilterPushdownBenchmark.$anonfun$prepareStringDictTable$1(numDistinctValues, BoxesRunTime.unboxToInt((Object)x0$2)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = this.spark().range((long)numRows).selectExpr((Seq)selectExpr).sort("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.saveAsTable((Dataset<Row>)df, dir, true);
    }

    private void saveAsTable(Dataset<Row> df, File dir, boolean useDictionary) {
        String orcPath = new StringBuilder(4).append(dir.getCanonicalPath()).append("/orc").toString();
        String parquetPath = new StringBuilder(8).append(dir.getCanonicalPath()).append("/parquet").toString();
        df.write().mode("overwrite").option("orc.dictionary.key.threshold", useDictionary ? 1.0 : 0.8).option("orc.compress.size", (long)this.blockSize()).option("orc.stripe.size", (long)this.blockSize()).orc(orcPath);
        this.spark().read().orc(orcPath).createOrReplaceTempView("orcTable");
        df.write().mode("overwrite").option("parquet.block.size", (long)this.blockSize()).parquet(parquetPath);
        this.spark().read().parquet(parquetPath).createOrReplaceTempView("parquetTable");
    }

    private boolean saveAsTable$default$3() {
        return false;
    }

    public void filterPushDownBenchmark(int values, String title, String whereExpr, String selectExpr) {
        String x$6 = title;
        long x$7 = values;
        int x$8 = 5;
        Some x$9 = new Some((Object)this.out());
        FiniteDuration x$10 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$11 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$12 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$6, x$7, x$8, x$10, x$11, x$12, (Option)x$9);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark.$anonfun$filterPushDownBenchmark$1(this, whereExpr, selectExpr, benchmark, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark.$anonfun$filterPushDownBenchmark$4(this, whereExpr, selectExpr, benchmark, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public String filterPushDownBenchmark$default$4() {
        return "*";
    }

    private void runIntBenchmark(int numRows, int width, int mid) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(21).append(mid).append(" < value AND value < ").append(mid).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runIntBenchmark$1(this, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append(mid).toString(), new StringBuilder(10).append("value <=> ").append(mid).toString(), new StringBuilder(23).append(mid).append(" <= value AND value <= ").append(mid).toString(), new StringBuilder(21).append(mid - 1).append(" < value AND value < ").append(mid + 1).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runIntBenchmark$2(this, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$runIntBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> this.filterPushDownBenchmark(numRows, new StringBuilder(28).append("Select ").append(percent).append("% int rows (value < ").append(numRows * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append(numRows * percent / 100).toString(), selectExpr));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL", "value > -1", "value != -1"}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            this.filterPushDownBenchmark(numRows, new StringBuilder(22).append("Select all int rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    private void runStringBenchmark(int numRows, int width, int searchValue, String colType) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(25).append("'").append(searchValue).append("' < value AND value < '").append(searchValue).append("'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runStringBenchmark$1(this, numRows, colType, whereExpr);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("value = '").append(searchValue).append("'").toString(), new StringBuilder(12).append("value <=> '").append(searchValue).append("'").toString(), new StringBuilder(27).append("'").append(searchValue).append("' <= value AND value <= '").append(searchValue).append("'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runStringBenchmark$2(this, numRows, colType, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$runStringBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL"}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            this.filterPushDownBenchmark(numRows, new StringBuilder(19).append("Select all ").append(colType).append(" rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(FilterPushdownBenchmark $this, String viewName) {
        return $this.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(FilterPushdownBenchmark $this, String key, String value) {
        $this.spark().conf().set(key, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$withSQLConf$4(FilterPushdownBenchmark $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                $this.spark().conf().set(key, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        $this.spark().conf().unset(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$prepareTable$1(int i) {
        return new StringBuilder(23).append("CAST(value AS STRING) c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$prepareStringDictTable$1(int numDistinctValues$1, int x0$2) {
        String string;
        int n = x0$2;
        switch (n) {
            case 0: {
                string = new StringBuilder(30).append("CAST(id % ").append(numDistinctValues$1).append(" AS STRING) AS value").toString();
                break;
            }
            default: {
                string = new StringBuilder(24).append("CAST(rand() AS STRING) c").append(n).toString();
                break;
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$1(FilterPushdownBenchmark $this, String whereExpr$1, String selectExpr$1, Benchmark benchmark$1, boolean pushDownEnabled) {
        String name = new StringBuilder(19).append("Parquet Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(32).append("SELECT ").append(selectExpr$1).append(" FROM parquetTable WHERE ").append(whereExpr$1).toString()).collect()));
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$4(FilterPushdownBenchmark $this, String whereExpr$1, String selectExpr$1, Benchmark benchmark$1, boolean pushDownEnabled) {
        String name = new StringBuilder(22).append("Native ORC Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(28).append("SELECT ").append(selectExpr$1).append(" FROM orcTable WHERE ").append(whereExpr$1).toString()).collect()));
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$1(FilterPushdownBenchmark $this, int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 0 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$1, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$2(FilterPushdownBenchmark $this, int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 1 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$1, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runIntBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$1(FilterPushdownBenchmark $this, int numRows$2, String colType$1, String whereExpr) {
        String title = new StringBuilder(16).append("Select 0 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$2, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$2(FilterPushdownBenchmark $this, int numRows$2, String colType$1, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$2, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runStringBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$4(FilterPushdownBenchmark $this, File dir$1, boolean useStringForValue) {
        $this.prepareTable(dir$1, $this.numRows(), $this.width(), useStringForValue);
        if (useStringForValue) {
            $this.runStringBenchmark($this.numRows(), $this.width(), $this.mid(), "string");
        } else {
            $this.runIntBenchmark($this.numRows(), $this.width(), $this.mid());
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(FilterPushdownBenchmark $this, File dir) {
        int numDistinctValues = 200;
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.prepareStringDictTable(dir, $this.numRows(), numDistinctValues, $this.width());
            $this.runStringBenchmark($this.numRows(), $this.width(), numDistinctValues / 2, "distinct string");
        });
    }

    public static final /* synthetic */ void $anonfun$new$11(FilterPushdownBenchmark $this, String whereExpr) {
        String title = new StringBuilder(27).append("StringStartsWith filter: (").append(whereExpr).append(")").toString();
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$15(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$17(FilterPushdownBenchmark $this, String dt$1, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(dt$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$18(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$14(FilterPushdownBenchmark $this, File dir$4, String dt) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$15(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Column valueCol = dt.equalsIgnoreCase(new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString()) ? functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToInteger((int)9999999)) : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", valueCol.cast(dt));
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir$4, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append($this.mid()).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                FilterPushdownBenchmark.$anonfun$new$17($this, dt, whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$18(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(25).append("Select ").append(percent).append("% ").append(dt).append(" rows (value < ").append($this.numRows() * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append($this.numRows() * percent / 100).toString(), selectExpr));
        });
    }

    public static final /* synthetic */ void $anonfun$new$13(FilterPushdownBenchmark $this, File dir) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_LONG_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(DecimalType$.MODULE$.MAX_PRECISION()).append(", 2)").toString()}))).foreach((Function1 & Serializable & scala.Serializable)dt -> {
            FilterPushdownBenchmark.$anonfun$new$14($this, dir, dt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$new$28(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$30(FilterPushdownBenchmark $this, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(ByteType$.MODULE$.simpleString()).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$31(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$27(FilterPushdownBenchmark $this, File dir) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$28(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToByte((byte)127)).cast((DataType)ByteType$.MODULE$)).orderBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("value = CAST(").append(63).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                FilterPushdownBenchmark.$anonfun$new$30($this, whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$31(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(15).append("Select ").append(percent).append("% ").append(ByteType$.MODULE$.simpleString()).append(" rows ").append(new StringBuilder(20).append("(value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append("))").toString()).toString(), new StringBuilder(18).append("value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString(), selectExpr));
        });
    }

    public static final /* synthetic */ String $anonfun$new$39(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$41(FilterPushdownBenchmark $this, String fileType$1, String whereExpr) {
        String title = new StringBuilder(36).append("Select 1 timestamp stored as ").append(fileType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$42(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$new$46(int i) {
        return new StringBuilder(4).append("id c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$new$49(int i) {
        return new StringBuilder(5).append("c").append(i).append(" = 0").toString();
    }

    public static final /* synthetic */ void $anonfun$new$45(FilterPushdownBenchmark $this, int numRows$3, int width$1, File dir) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$46(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().range(1L).selectExpr((Seq)columns);
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 250, 500}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numFilter -> {
                String whereExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFilter).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$49(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" and ");
                $this.filterPushDownBenchmark(numRows$3, new StringBuilder(26).append("Select 1 row with ").append(numFilter).append(" filters").toString(), whereExpr, $this.filterPushDownBenchmark$default$4());
            });
        });
    }

    public FilterPushdownBenchmark() {
        BeforeAndAfterEachTestData.$init$((BeforeAndAfterEachTestData)this);
        BenchmarkBeforeAndAfterEachTest.$init$(this);
        this.conf = new SparkConf().setAppName(this.getClass().getSimpleName()).set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g").setIfMissing("spark.ui.enabled", "false").setIfMissing("orc.compression", "snappy").setIfMissing("spark.sql.parquet.compression.codec", "snappy");
        this.numRows = 0xF00000;
        this.width = 5;
        this.mid = this.numRows() / 2;
        this.blockSize = 0x100000;
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.ignore("Pushdown for many distinct value case", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)useStringForValue -> {
                FilterPushdownBenchmark.$anonfun$new$4($this, dir, BoxesRunTime.unboxToBoolean((Object)useStringForValue));
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.ignore("Pushdown for few distinct value case (use dictionary encoding)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$6(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.ignore("Pushdown benchmark for StringStartsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.prepareTable(dir, $this.numRows(), $this.width(), true);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value like '10%'", "value like '1000%'", new StringBuilder(14).append("value like '").append(((Object)BoxesRunTime.boxToInteger((int)$this.mid())).toString().substring(0, ((Object)BoxesRunTime.boxToInteger((int)$this.mid())).toString().length() - 1)).append("%'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                    FilterPushdownBenchmark.$anonfun$new$11($this, whereExpr);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.ignore(new StringBuilder(23).append("Pushdown benchmark for ").append(DecimalType$.MODULE$.simpleString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$13(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.ignore("Pushdown benchmark for InSet -> InFilters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.prepareTable(dir, $this.numRows(), $this.width(), false);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 10, 50, 100}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)count -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)distribution -> {
                    IndexedSeq filter = (IndexedSeq)package$.MODULE$.Range().apply(0, count).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)r -> Random$.MODULE$.nextInt($this.numRows() * distribution / 100), IndexedSeq$.MODULE$.canBuildFrom());
                    String whereExpr = new StringBuilder(10).append("value in(").append(filter.mkString(",")).append(")").toString();
                    String title = new StringBuilder(51).append("InSet -> InFilters (values count: ").append(count).append(", distribution: ").append(distribution).append(")").toString();
                    $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
                }));
            });
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.ignore(new StringBuilder(23).append("Pushdown benchmark for ").append(ByteType$.MODULE$.simpleString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$27(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.ignore("Pushdown benchmark for Timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)SQLConf.ParquetOutputTimestampType$.MODULE$.values().toSeq().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)fileType -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key()), (Object)fileType)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$39(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                    Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.monotonically_increasing_id().cast((DataType)TimestampType$.MODULE$));
                    $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.saveAsTable((Dataset<Row>)df, dir$7, $this.saveAsTable$default$3());
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(27).append("value = CAST(").append($this.mid()).append(" AS timestamp)").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                            FilterPushdownBenchmark.$anonfun$new$41($this, fileType, whereExpr);
                            return BoxedUnit.UNIT;
                        });
                        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$42(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(35).append("Select ").append(percent).append("% timestamp stored as ").append(fileType).append(" rows ").append(new StringBuilder(29).append("(value < CAST(").append($this.numRows() * percent / 100).append(" AS timestamp))").toString()).toString(), new StringBuilder(27).append("value < CAST(").append($this.numRows() * percent / 100).append(" as timestamp)").toString(), selectExpr));
                    });
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.ignore("Pushdown benchmark with many filters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numRows = 1;
            int width = 500;
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                FilterPushdownBenchmark.$anonfun$new$45(this, numRows, width, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
    }
}

